/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Rlf;

import UI_Desktop.Cutter;
import UI_Script.Rlf.RlfXMLRsrc;
import UI_Script.ScriptParser.ProcDBItem;
import Utilities.TextUtils;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import kernal.Tokenizers.Tokenizer;

public class RlfXMLTokenizer
extends Tokenizer {
    private static ResourceBundle RlfStatementsXmlRes;
    public static Hashtable<String, String> language;
    public boolean payloadIsOpen = false;

    private static String getFunction(String nm) {
        String str;
        try {
            str = RlfStatementsXmlRes.getObject(nm).toString();
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    private static int numFunctions() {
        int num = 0;
        try {
            num = ((RlfXMLRsrc)RlfStatementsXmlRes).getNumItems();
        }
        catch (MissingResourceException mre) {
            System.out.println("cannot read RlfLanguageXmlRsrc");
        }
        return num;
    }

    private static void initHashTable() {
        for (int i = 0; i < RlfXMLTokenizer.numFunctions(); ++i) {
            language.put(((RlfXMLRsrc)RlfStatementsXmlRes).getKey(i), ((RlfXMLRsrc)RlfStatementsXmlRes).getContent(i));
        }
    }

    public RlfXMLTokenizer() {
        this.addComment("/*", "* /");
        this.addComment("//", "\n");
        String[] ext = new String[]{"rlf", "RLF"};
        Tokenizer.addToRegistry(RlfXMLTokenizer.class, ext, this.getComments(), this.getDelimitors());
        this.setDefaultDelimitors();
        this.appendDelimitor("*-+=/");
        this.appendDelimitor("/$&?@%~!");
        this.removeDelimitor(".-");
    }

    @Override
    public boolean isComment(String str) {
        return str.startsWith("<?xml");
    }

    @Override
    public boolean isUserVariable(String str) {
        return false;
    }

    @Override
    public boolean isLanguageType(String str) {
        return language.containsKey(str);
    }

    @Override
    public boolean isNamedSpace(String str) {
        if (!str.startsWith("\"") && !str.endsWith("\"")) {
            return false;
        }
        if (str.length() < 5) {
            return false;
        }
        if (!language.containsKey(str = str.substring(1, str.length() - 1))) {
            return false;
        }
        return language.get(str).equals("language");
    }

    @Override
    public String getNextStr() {
        boolean endOfPlainText = false;
        if (this.mEndOfBuffer) {
            return "";
        }
        char c = this.readChar();
        if (c == '\u0000') {
            return "";
        }
        this.outBuff.setLength(0);
        if (this.isSpace(c) && (c = this.removeSpace()) == '\u0000') {
            return "";
        }
        if (this.getCR_Newlines && c == '\n') {
            return "\n";
        }
        if (c == '<') {
            boolean tagOK = this.handleTag(c);
            if (!tagOK) {
                return "";
            }
            if (tagOK) {
                return this.outBuff.toString();
            }
            this.outBuff.setLength(0);
        } else if (c == '&') {
            if (this.handleEntity(c)) {
                this.outBuff.setLength(0);
                return this.getNextStr();
            }
        } else {
            this.outBuff.append(c);
        }
        block6: while (!endOfPlainText) {
            c = this.readChar();
            switch (c) {
                case '\u0000': {
                    return this.outBuff.toString();
                }
                case '&': {
                    this.removeEntity(c);
                    if (this.isSpace(this.peekNextChar())) continue block6;
                    this.outBuff.append(" ");
                    continue block6;
                }
                case '\n': 
                case '\r': {
                    if (!this.getCR_Newlines) {
                        this.ungetChar();
                        if (this.outBuff.length() == 0) {
                            return this.getNextStr();
                        }
                        return this.outBuff.toString();
                    }
                    if (this.outBuff.length() == 0) {
                        return this.getNextStr();
                    }
                    return this.outBuff.append(c).toString();
                }
                case '<': {
                    this.ungetChar();
                    if (this.outBuff.length() == 0) {
                        return this.getNextStr();
                    }
                    return this.outBuff.toString();
                }
            }
            this.outBuff.append(c);
        }
        return this.outBuff.toString();
    }

    private boolean removeEntity(char c) {
        StringBuffer buff = new StringBuffer();
        buff.append(c);
        while ((c = this.readChar()) != '\u0000') {
            if (this.isSpace(c)) {
                this.outBuff.append(buff);
                return false;
            }
            if (c == ';') {
                return true;
            }
            buff.append(c);
        }
        this.outBuff.append(buff);
        return false;
    }

    private boolean handleEntity(char c) {
        this.outBuff.append(c);
        while ((c = this.readChar()) != '\u0000') {
            if (this.isSpace(c)) {
                this.outBuff.append(c);
                return false;
            }
            if (c == ';') {
                return true;
            }
            this.outBuff.append(c);
        }
        return false;
    }

    private boolean handleTag(char c) {
        boolean isHtmlComment = false;
        this.outBuff.append(c);
        c = this.readChar();
        if (c == '\u0000') {
            Cutter.setLog("    Info: HtmlTokenizer.handleTag(char) readChar() == 0 at buffer index " + this.getBufferIndex());
            return false;
        }
        if (c == '!') {
            char[] next = this.peekNextChars(2);
            if (next == null) {
                return false;
            }
            if (next[0] == '-' && next[1] == '-') {
                isHtmlComment = true;
            }
        }
        while (c != '\u0000') {
            this.outBuff.append(c);
            char[] ahead2 = this.peekNextChars(2);
            if (isHtmlComment && c == '-' && ahead2 != null && ahead2[0] == '-' && ahead2[1] == '>') {
                this.outBuff.append(this.readChar()).append(this.readChar());
                return true;
            }
            if (!isHtmlComment && c == '>') {
                return true;
            }
            c = this.readChar();
        }
        return true;
    }

    @Override
    public ProcDBItem lpGrabProc(String instr) {
        ProcDBItem out = new ProcDBItem();
        int index = this.getBufferIndex();
        int rawStrLength = instr.length();
        String str = TextUtils.trimLeadingChar(instr, '<');
        str = str.trim();
        str = TextUtils.trimTrailingChar(str, '>');
        str = str.trim();
        String payload = null;
        int[] offsets = null;
        if (str.startsWith("Payload")) {
            String[] tok = TextUtils.tokenize(str);
            if (tok == null || tok.length != 5) {
                return null;
            }
            payload = tok[1];
            if ((tok = TextUtils.tokenize(payload, '\"')) == null || tok.length != 2) {
                return null;
            }
            payload = tok[1];
            if (payload.trim().length() == 0) {
                return null;
            }
            Tokenizer t = new Tokenizer();
            t.setBuffer(instr);
            offsets = t.charSearch(payload, false);
            if (offsets == null) {
                return null;
            }
        } else {
            return null;
        }
        int nameBegin = (index -= rawStrLength) + (offsets[0] - 1);
        int nameEnd = index + (offsets[1] + 1);
        out.procName = payload;
        out.procNameOffset = new int[2];
        out.procNameOffset[0] = nameBegin;
        out.procNameOffset[1] = nameEnd;
        return out;
    }

    static {
        language = new Hashtable();
        try {
            RlfStatementsXmlRes = ResourceBundle.getBundle("UI_Script.Rlf.RlfXMLRsrc");
        }
        catch (MissingResourceException mre) {
            Cutter.setLog("    Exception: RlfTokenizer = " + mre);
        }
        RlfXMLTokenizer.initHashTable();
    }
}

