/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Rman;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Script.Help.KAbstractHelp;
import UI_Script.Help.KCompletionManager;
import UI_Script.Rman.BlockDB;
import UI_Script.Rman.RmanHtmlWriter;
import UI_Script.Rman.RmanTokenizer;
import UI_Script.ScriptParser.ProcDBItem;
import UI_Script.ScriptParser.ScriptParser;
import UI_Script.ScriptParser.ScriptStructure;
import UI_Script.Tcl.TclHelp;
import UI_Text.KTextPane.KTextPane;
import Utilities.BrowserUtils;
import Utilities.DateTimeUtils;
import Utilities.DocumentUtils;
import Utilities.EnvUtils;
import Utilities.FileUtils;
import Utilities.TextUtils;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JSeparator;
import javax.swing.text.Document;

public class RmanHelp
extends TclHelp {
    private static Hashtable<String, String> languageTable = new Hashtable();
    private final String INT_STR = "_Int";
    int intCount = 1;
    final File int_slider = new File(FileUtils.getPWDFile(), "/Cutter_Help/rman/int_slider.rman");
    final File int_selector = new File(FileUtils.getPWDFile(), "/Cutter_Help/rman/int_selector.rman");
    final File int_switch = new File(FileUtils.getPWDFile(), "/Cutter_Help/rman/int_switch.rman");
    private final String FLOAT_STR = "_Float";
    int floatCount = 1;
    final File float_slider = new File(FileUtils.getPWDFile(), "/Cutter_Help/rman/float_slider.rman");
    final File float_selector = new File(FileUtils.getPWDFile(), "/Cutter_Help/rman/float_selector.rman");
    private final String STRING_STR = "_Str";
    int stringCount = 1;
    final File string_file = new File(FileUtils.getPWDFile(), "/Cutter_Help/rman/string_file.rman");
    final File string_plain = new File(FileUtils.getPWDFile(), "/Cutter_Help/rman/string_plain.rman");
    private final String COLOR_STR = "_Color";
    int colorCount = 1;
    final File color = new File(FileUtils.getPWDFile(), "/Cutter_Help/rman/color.rman");
    final File collection_file = new File(FileUtils.getPWDFile(), "/Cutter_Help/rman/collection.rman");
    final File nodeoptions_file = new File(FileUtils.getPWDFile(), "/Cutter_Help/rman/nodeoptions.rman");
    final File conn_txmake = new File(FileUtils.getPWDFile(), "/Cutter_Help/rman/connection_txmake.rman");
    final File conn_envlight = new File(FileUtils.getPWDFile(), "/Cutter_Help/rman/connection_envlight.rman");
    final File conn_traceset = new File(FileUtils.getPWDFile(), "/Cutter_Help/rman/connection_traceset.rman");
    final File conn_bake = new File(FileUtils.getPWDFile(), "/Cutter_Help/rman/connection_bake.rman");
    final File conn_caustic = new File(FileUtils.getPWDFile(), "/Cutter_Help/rman/connection_causticmap.rman");
    final String CONNECTIONS = "Misc Params";
    final String TXMAKE = "TxMake";
    final String ENVLIGHT = "EnvLight";
    final String TRACESET = "TraceSet";
    final String BAKE = "Bake";
    final String CAUSTICMAP = "CausticMap";
    final String RMAN_BLOCKS = "Geometric Settings";
    final String RMAN_COLLECTION = "Collection";
    final String RMAN_NODEOPTIONS = "NodeOptions";
    final String EXPORT_MEL_SUB_MENU = "RfM Mel Export";
    final String UI_POSTTRANSFORM_SCRIPT = "UI PostTransform Script";
    final String RI_POSTTRANSFORM_SCRIPT = "RI PostTransform Script";
    final String UI_PRESHAPE_SCRIPT = "UI PreShape Script";
    final String RI_PRESHAPE_SCRIPT = "RI PreShape Script";
    final String UI_POSTTRANSFORM_MEL_SCRIPT_PATH = "Cutter_Help/rman/uiPostTransformScript.mel";
    final String RI_POSTTRANSFORM_SCRIPT_PATH = "Cutter_Help/rman/riPostTransformScript.mel";
    final String UI_PRESHAPE_MEL_SCRIPT_PATH = "Cutter_Help/rman/uiPreShapeScript.mel";
    final String RI_PRESHAPE_SCRIPT_PATH = "Cutter_Help/rman/riPreShapeScript.mel";
    private int FOUND = 1;
    private int NOT_FOUND = 2;

    public static void initPaths() {
    }

    public RmanHelp(KTextPane textpane) {
        super(textpane);
        this.completer.completionActivate();
        this.completer.setWordStartDelims(null);
        this.completer.setListeners(textpane, this);
    }

    @Override
    public void setCompletorListeners() {
        this.completer.setListeners(this.textpane, this);
    }

    @Override
    public boolean completionTargetIsValid(String str) {
        if (str == null || str.trim().length() == 0) {
            return false;
        }
        return str.length() >= KCompletionManager.MIN_LEN;
    }

    @Override
    public String[] completionCandidates(String str) {
        return this.completionCandidates(str, languageTable);
    }

    @Override
    protected void lookup(String item) {
    }

    @Override
    public void popupTypingCompletion(Point pnt, String textToComplete, int insertAt, MouseEvent e) {
    }

    public void openPreViewInBrowser() {
        BlockDB[] blocks = this.getDeclaredBlocks();
        try {
            String title = BBxt.getWindowTitle();
            if (title.endsWith(" [NOT EDITABLE]")) {
                title = title.substring(0, title.length() - " [NOT EDITABLE]".length());
            }
            title = TextUtils.removeExtension(title);
            File d = new File(FileUtils.getPWDFile(), "previs_" + title);
            File f = new File(d, "index.html");
            RmanHtmlWriter.createHostDir(f);
            RmanHtmlWriter writer = new RmanHtmlWriter(f);
            writer.writeHeader();
            writer.writeParams(blocks);
            writer.writeTail();
            writer.writeSelf();
            boolean isFirefox = false;
            if (Preferences.get(Preferences.WEB_BROWSER_PREFERRED).equalsIgnoreCase("firefox")) {
                isFirefox = true;
            }
            if (EnvUtils.getOSName().equalsIgnoreCase("Windows 7") && isFirefox) {
                String str = "file:\\" + f.getPath();
                BrowserUtils.open(str, true);
            } else {
                BrowserUtils.open(f);
            }
        }
        catch (Exception ex) {
            Cutter.setLog("    Exception:RmanHelp.openPreViewInBrowser\n        " + ex.toString());
        }
    }

    @Override
    public void popupOnlineHelp(Point pnt, String selection, int insertAt, MouseEvent e) {
        KAbstractHelp.KPopupMenuItem mi;
        int begin = insertAt - selection.length();
        JMenu defaultMenu = new JMenu("General Options");
        JComponent[] items = this.getDefaultPopupItems(e, selection, insertAt - selection.length(), insertAt);
        for (int n = 0; n < items.length; ++n) {
            if (items[n] == null) continue;
            defaultMenu.add(items[n]);
        }
        KAbstractHelp.KPopupMenu popup = new KAbstractHelp.KPopupMenu();
        BlockDB[] blocks = this.getDeclaredBlocks();
        JMenu menu = this.addParam_Int(selection, insertAt);
        if (menu != null) {
            popup.add(menu);
        }
        if ((menu = this.addParam_Float(selection, insertAt)) != null) {
            popup.add(menu);
        }
        if ((menu = this.addParam_String(selection, insertAt)) != null) {
            popup.add(menu);
        }
        if ((mi = this.addParam_Color(selection, insertAt)) != null) {
            popup.add(mi);
        }
        if ((menu = this.addParam_Connection(selection, insertAt)) != null) {
            popup.add(menu);
        }
        if ((mi = this.addRmanSettingsBlocks(selection, insertAt)) != null) {
            popup.add(mi);
        }
        JMenu exportMenu = new JMenu("RfM Mel Export");
        mi = this.getUIPostTransformmenuItem(blocks);
        if (mi != null) {
            exportMenu.add(mi);
        }
        if ((mi = this.getRIPostTransformMenuItem("RI PostTransform Script", "Cutter_Help/rman/riPostTransformScript.mel", blocks)) != null) {
            exportMenu.add(mi);
        }
        exportMenu.add(new JSeparator());
        mi = this.getUIPreShapemenuItem(blocks);
        if (mi != null) {
            exportMenu.add(mi);
        }
        if ((mi = this.getRIPreShapeMenuItem("RI PreShape Script", "Cutter_Help/rman/riPreShapeScript.mel", blocks)) != null) {
            exportMenu.add(mi);
        }
        popup.add(new JSeparator());
        popup.add(exportMenu);
        popup.add(new JSeparator());
        popup.add(defaultMenu);
        if (popup != null) {
            popup.setRequestFocusEnabled(false);
            try {
                popup.show(this.textpane, e.getX(), e.getY());
            }
            catch (Exception ex) {
                Cutter.setLog("    Exception:RmanHelp.popupOnlineHelp()\n      " + ex.toString());
            }
        }
    }

    private JMenu addParam_Int(String sel, int at) {
        JMenu menu = new JMenu("Ints");
        final int begin = at - sel.length();
        final int end = at;
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem("slider");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmanHelp.this.insertIntParamStr(RmanHelp.this.replacePNAME(FileUtils.read(RmanHelp.this.int_slider), null, end), begin, end);
            }
        });
        menu.add(mi);
        mi = new KAbstractHelp.KPopupMenuItem("switch");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmanHelp.this.insertIntParamStr(RmanHelp.this.replacePNAME(FileUtils.read(RmanHelp.this.int_switch), null, end), begin, end);
            }
        });
        menu.add(mi);
        mi = new KAbstractHelp.KPopupMenuItem("selector");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmanHelp.this.insertIntParamStr(RmanHelp.this.replacePNAME(FileUtils.read(RmanHelp.this.int_selector), null, end), begin, end);
            }
        });
        menu.add(mi);
        return menu;
    }

    private JMenu addParam_Float(String sel, int at) {
        JMenu menu = new JMenu("Floats");
        final int begin = at - sel.length();
        final int end = at;
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem("slider");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmanHelp.this.insertFloatParamStr(RmanHelp.this.replacePNAME(FileUtils.read(RmanHelp.this.float_slider), null, end), begin, end);
            }
        });
        menu.add(mi);
        mi = new KAbstractHelp.KPopupMenuItem("selector");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmanHelp.this.insertFloatParamStr(RmanHelp.this.replacePNAME(FileUtils.read(RmanHelp.this.float_selector), null, end), begin, end);
            }
        });
        menu.add(mi);
        return menu;
    }

    private JMenu addParam_String(String sel, int at) {
        JMenu menu = new JMenu("Strings");
        final int begin = at - sel.length();
        final int end = at;
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem("file");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmanHelp.this.insertStringParamStr(RmanHelp.this.replacePNAME(FileUtils.read(RmanHelp.this.string_file), null, end), begin, end);
            }
        });
        menu.add(mi);
        mi = new KAbstractHelp.KPopupMenuItem("other");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmanHelp.this.insertStringParamStr(RmanHelp.this.replacePNAME(FileUtils.read(RmanHelp.this.string_plain), null, end), begin, end);
            }
        });
        menu.add(mi);
        return menu;
    }

    private KAbstractHelp.KPopupMenuItem addParam_Color(String sel, int at) {
        final int begin = at - sel.length();
        final int end = at;
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem("Color");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmanHelp.this.insertColorParamStr(RmanHelp.this.replacePNAME(FileUtils.read(RmanHelp.this.color), null, end), begin, end);
            }
        });
        return mi;
    }

    private JMenu addParam_Connection(final String sel, final int at) {
        JMenu menu = new JMenu("Misc Params");
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem("TxMake");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmanHelp.this.replacePNAME(FileUtils.read(RmanHelp.this.conn_txmake), sel, at);
            }
        });
        menu.add(mi);
        mi = new KAbstractHelp.KPopupMenuItem("EnvLight");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmanHelp.this.replacePNAME(FileUtils.read(RmanHelp.this.conn_envlight), sel, at);
            }
        });
        menu.add(mi);
        mi = new KAbstractHelp.KPopupMenuItem("TraceSet");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmanHelp.this.replacePNAME(FileUtils.read(RmanHelp.this.conn_traceset), sel, at);
            }
        });
        menu.add(mi);
        mi = new KAbstractHelp.KPopupMenuItem("Bake");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmanHelp.this.replacePNAME(FileUtils.read(RmanHelp.this.conn_bake), sel, at);
            }
        });
        menu.add(mi);
        mi = new KAbstractHelp.KPopupMenuItem("CausticMap");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmanHelp.this.replacePNAME(FileUtils.read(RmanHelp.this.conn_caustic), sel, at);
            }
        });
        menu.add(mi);
        return menu;
    }

    private KAbstractHelp.KPopupMenuItem addRmanSettingsBlocks(String sel, int at) {
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem("Geometric Settings");
        int begin = at - sel.length();
        int end = at;
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmanHelp.this.insertUpdateGeometricSettings();
            }
        });
        return mi;
    }

    private String getCollectionStr() {
        BlockDB[] blocks = this.getDeclaredBlocks();
        if (blocks == null || blocks.length == 0) {
            return "";
        }
        String floatDefault = "\t\tdefault 0.0\n";
        String intDefault = "\t\tdefault 0\n";
        String strDefault = "\t\tdefault \"\"\n";
        String colorDefault = "\t\tdefault {1 1 1}\n";
        String str = FileUtils.read(this.collection_file);
        str = str.replaceAll("(_SIGNATURE)", this.getSignature());
        StringBuffer buf = new StringBuffer();
        for (int n = 0; n < blocks.length; ++n) {
            String[] tokens;
            BlockDB block = blocks[n];
            String pname = block.name;
            String ptype = block.datatype;
            String prange = block.range;
            String defaulval = null;
            if (!prange.equals("") && (tokens = TextUtils.tokenize(prange)).length > 1) {
                defaulval = tokens[0];
            }
            buf.append("\tparam ").append(pname).append(" {\n");
            if (ptype.equals("int")) {
                if (defaulval == null) {
                    buf.append(intDefault);
                } else {
                    buf.append("\t\tdefault ").append(defaulval).append("\n");
                }
            } else if (ptype.equals("float")) {
                if (defaulval == null) {
                    buf.append(floatDefault);
                } else {
                    buf.append("\t\tdefault ").append(defaulval).append("\n");
                }
            } else if (ptype.equals("color")) {
                buf.append(colorDefault);
            } else {
                buf.append(strDefault);
            }
            buf.append("\t\tstate optional\n");
            buf.append("\t\t}");
            if (n >= blocks.length - 1) continue;
            buf.append("\n");
        }
        str = str.replaceAll("(_PNAMES_)", buf.toString());
        return str;
    }

    private String getNodeOptionsStr() {
        String str = FileUtils.read(this.nodeoptions_file);
        String collectionName = this.getSignature() + "_OptionalGeometricSettings";
        str = str.replaceAll("(_CUSTOM_OPTIONAL_)", collectionName);
        return str;
    }

    private String replacePNAME(String str, String selection, int insertAt) {
        if (str == null) {
            Cutter.setLog("    Error:RmanHelp.replacePNAME() - str is null");
            return "";
        }
        str = str.replaceAll("(PNAME)", this.getSignature());
        if (selection == null) {
            return str;
        }
        this.insertParamStr(str, insertAt - selection.length(), insertAt);
        return str;
    }

    private void insertIntParamStr(String str, int begin, int end) {
        str = str.replaceAll("(_INT)", "_Int" + this.intCount++);
        this.insertParamStr(str, begin, end);
    }

    private void insertFloatParamStr(String str, int begin, int end) {
        str = str.replaceAll("(_FLOAT)", "_Float" + this.floatCount++);
        this.insertParamStr(str, begin, end);
    }

    private void insertStringParamStr(String str, int begin, int end) {
        str = str.replaceAll("(_STR)", "_Str" + this.stringCount++);
        this.insertParamStr(str, begin, end);
    }

    private void insertColorParamStr(String str, int begin, int end) {
        str = str.replaceAll("(_COLOR)", "_Color" + this.colorCount++);
        this.insertParamStr(str, begin, end);
    }

    private void insertParamStr(String str, int begin, int end) {
        try {
            this.textpane.setSelectionStart(begin);
            this.textpane.setSelectionEnd(end);
            this.textpane.replaceSelection(str);
        }
        catch (Exception e) {
            Cutter.setLog("    Exception:RmanHelp.insertParamStr()\n        " + e.toString());
            return;
        }
    }

    private String getSignature() {
        String title = this.getTitle();
        String sig = "" + title.charAt(0);
        for (int n = 0; n < title.length(); ++n) {
            if (!Character.isUpperCase(title.charAt(n))) continue;
            sig = sig + title.charAt(n);
        }
        if (sig.length() <= 1) {
            return title;
        }
        return sig.toLowerCase();
    }

    private String getTitle() {
        String title = TextUtils.removeExtension(this.textpane.getFrameTitle());
        if (title.endsWith("UI")) {
            title = title.substring(0, title.length() - 2);
        }
        return title;
    }

    private String getHeader(String rmanDocPath) {
        String[] datetime = DateTimeUtils.getDateTime();
        File f = new File(rmanDocPath);
        String root = f.getParentFile().getPath();
        String name = f.getName();
        String header = "// Generated by Cutter v" + Cutter.version + " at " + datetime[1] + " on the " + datetime[0] + ".\n// The source document on which this mel script is based is,\n//    \"" + FileUtils.toUnixPath(root) + name + "\"\n// Cutter software by Malcolm Kesson (all rights reserved).\n";
        return header;
    }

    private KAbstractHelp.KPopupMenuItem getRIPostTransformMenuItem(String menutitle, final String pathToRiScript, final BlockDB[] blocks) {
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem(menutitle);
        String title = TextUtils.removeExtension(BBxt.getWindowTitle());
        if (title.endsWith("UI")) {
            title = title.substring(0, title.length() - 2);
        }
        final String T = title;
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                File f = new File(FileUtils.getPWDFile(), pathToRiScript);
                String rmanDocPath = BBxt.getWindowFile() == null ? BBxt.getWindowTitle() : BBxt.getWindowFile().getPath();
                String[] datetime = DateTimeUtils.getDateTime();
                String header = RmanHelp.this.getHeader(rmanDocPath);
                String psScript = FileUtils.read(f);
                if (psScript == null) {
                    Cutter.setLog("    Error:RmanHelp.getRImenuItem() - cannot read \"" + f.getPath() + "\"");
                    return;
                }
                psScript = header + FileUtils.read(f);
                psScript = psScript.replaceAll("(_PROC_NAME_RI_)", T + "RI");
                if (blocks == null) {
                    return;
                }
                StringBuffer attrs = new StringBuffer();
                String nodeName = "\\$tformNode";
                for (int n = 0; n < blocks.length; ++n) {
                    BlockDB db = blocks[n];
                    attrs.append("\\$attr = \\`rmanGetAttrName \"").append(db.name).append("\"\\`;\n");
                    String dtype = db.datatype;
                    if (dtype.equals("color")) {
                        dtype = "vector";
                    }
                    attrs.append(dtype).append(" \\$").append(db.name).append(" \\= ");
                    attrs.append("\\`getAttr\\(").append(nodeName).append(" + \"\\.\" + \\$attr\\)\\`;\n");
                    if (n == blocks.length - 1) continue;
                    attrs.append("\n");
                }
                psScript = psScript.replaceAll("(_GET_RMAN_ATTR_)", attrs.toString());
                BBxt.newDocument(T + "RI.mel", psScript);
            }
        });
        return mi;
    }

    private KAbstractHelp.KPopupMenuItem getRIPreShapeMenuItem(String menutitle, final String pathToRiScript, final BlockDB[] blocks) {
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem(menutitle);
        String title = TextUtils.removeExtension(BBxt.getWindowTitle());
        if (title.endsWith("UI")) {
            title = title.substring(0, title.length() - 2);
        }
        final String T = title;
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                File f = new File(FileUtils.getPWDFile(), pathToRiScript);
                String rmanDocPath = BBxt.getWindowFile() == null ? BBxt.getWindowTitle() : BBxt.getWindowFile().getPath();
                String header = RmanHelp.this.getHeader(rmanDocPath);
                String psScript = FileUtils.read(f);
                if (psScript == null) {
                    Cutter.setLog("    Error:RmanHelp.getRImenuItem() - cannot read \"" + f.getPath() + "\"");
                    return;
                }
                psScript = header + FileUtils.read(f);
                psScript = psScript.replaceAll("(_PROC_NAME_RI_)", T + "RI");
                if (blocks == null) {
                    return;
                }
                StringBuffer attrs = new StringBuffer();
                String nodeName = "\\$shapeNode";
                for (int n = 0; n < blocks.length; ++n) {
                    BlockDB db = blocks[n];
                    attrs.append("\\$attr = \\`rmanGetAttrName \"").append(db.name).append("\"\\`;\n");
                    attrs.append("\\$attr = \\`rmanGetFullSharedGeometricAttrName ").append(nodeName).append(" \\$attr\\`;\n");
                    String dtype = db.datatype;
                    if (dtype.equals("color")) {
                        dtype = "vector";
                    }
                    attrs.append(dtype).append(" \\$").append(db.name).append(" \\= ");
                    attrs.append("\\`getAttr ").append("\\$attr\\`;\n");
                    if (n == blocks.length - 1) continue;
                    attrs.append("\n");
                }
                psScript = psScript.replaceAll("(_GET_RMAN_ATTR_)", attrs.toString());
                BBxt.newDocument(T + "RI.mel", psScript);
            }
        });
        return mi;
    }

    private KAbstractHelp.KPopupMenuItem getUIPostTransformmenuItem(final BlockDB[] blocks) {
        String title = TextUtils.removeExtension(BBxt.getWindowTitle());
        if (title.endsWith("UI")) {
            title = title.substring(0, title.length() - 2);
        }
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem("UI PostTransform Script");
        if (blocks == null) {
            mi.setEnabled(false);
        }
        final String T = title;
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                File f = new File(FileUtils.getPWDFile(), "Cutter_Help/rman/uiPostTransformScript.mel");
                String rmanDocPath = BBxt.getWindowFile() == null ? BBxt.getWindowTitle() : BBxt.getWindowFile().getPath();
                String header = RmanHelp.this.getHeader(rmanDocPath);
                String psScript = FileUtils.read(f);
                if (psScript == null) {
                    Cutter.setLog("    Error:RmanHelp.getPostTransformUImenuItem() - cannot read \"" + f.getPath() + "\"");
                    return;
                }
                psScript = header + FileUtils.read(f);
                psScript = psScript.replaceAll("(_PROC_NAME_UI_)", T + "UI");
                psScript = psScript.replaceAll("(_PROC_NAME_RI_)", T + "RI");
                if (blocks == null) {
                    return;
                }
                StringBuffer attrs = new StringBuffer();
                for (int n = 0; n < blocks.length; ++n) {
                    BlockDB db = blocks[n];
                    attrs.append("\t\\$attr = \\`rmanGetAttrName \"").append(db.name).append("\"\\`;\n");
                    if (db.subtype.equals("masterswitch") || db.subtype.equals("switch")) {
                        attrs.append("\trmanAddAttr \\$transformName \\$attr \"0\";\n");
                    } else {
                        attrs.append("\trmanAddAttr \\$transformName \\$attr \"\";\n");
                    }
                    if (n == blocks.length - 1) continue;
                    attrs.append("\n");
                }
                psScript = psScript.replaceAll("(_ADD_RMAN_ATTR_)", attrs.toString());
                BBxt.newDocument(T + "UI.mel", psScript);
            }
        });
        return mi;
    }

    private void insertUpdateGeometricSettings() {
        StringBuffer comment = new StringBuffer();
        comment.append("# The Collection and NodeOptions blocks enable a Pre-Shape MEL script\n");
        comment.append("# to be assigned to \"RenderMan Controls->Geometric Settings\" panel.\n");
        int[] offsets = this.getBlockOffsets("Collection");
        String s = this.getCollectionStr();
        if (s != null || s.length() > 0) {
            if (offsets[2] == this.NOT_FOUND) {
                s = comment.toString() + s;
            }
            this.insertParamStr(s, offsets[0], offsets[1]);
        }
        offsets = this.getBlockOffsets("NodeOptions");
        s = this.getNodeOptionsStr();
        if (s != null || s.length() > 0) {
            this.insertParamStr(s, offsets[0], offsets[1]);
        }
    }

    private int[] getBlockOffsets(String blockname) {
        int originalStart = BBxt.getSelectionStart();
        int docLength = BBxt.getDocumentLength();
        BBxt.setSelection(docLength, docLength);
        Document doc = BBxt.getWindowDocument();
        String[] lines = DocumentUtils.getParagraphs(doc);
        int offset = 0;
        int beginOffset = 0;
        int endOffset = 0;
        boolean beginCounting = false;
        boolean offsetsValid = false;
        int openCount = 0;
        for (int n = 0; n < lines.length; ++n) {
            String line = lines[n];
            if (line.trim().startsWith("#")) {
                offset += line.length();
                continue;
            }
            if (line.trim().startsWith(blockname)) {
                beginCounting = true;
                beginOffset = offset;
            }
            offset += line.length();
            if (!beginCounting) continue;
            int open = TextUtils.countOccurancesOf(line, '{');
            int close = TextUtils.countOccurancesOf(line, '}');
            openCount += open;
            if ((openCount -= close) != 0) continue;
            endOffset = offset - 1;
            beginCounting = false;
            offsetsValid = true;
            break;
        }
        BBxt.setSelection(originalStart, originalStart);
        int[] offsets = new int[3];
        if (!offsetsValid) {
            String text = BBxt.getWindowText();
            int index = text.lastIndexOf(125);
            offsets[0] = index = index == -1 ? text.length() : index;
            offsets[1] = index;
            offsets[2] = this.NOT_FOUND;
            return offsets;
        }
        offsets[0] = beginOffset;
        offsets[1] = endOffset;
        offsets[2] = this.FOUND;
        return offsets;
    }

    private KAbstractHelp.KPopupMenuItem getUIPreShapemenuItem(final BlockDB[] blocks) {
        String title = TextUtils.removeExtension(BBxt.getWindowTitle());
        if (title.endsWith("UI")) {
            title = title.substring(0, title.length() - 2);
        }
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem("UI PreShape Script");
        if (blocks == null) {
            mi.setEnabled(false);
        }
        final String T = title;
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RmanHelp.this.insertUpdateGeometricSettings();
                File f = new File(FileUtils.getPWDFile(), "Cutter_Help/rman/uiPreShapeScript.mel");
                String rmanDocPath = BBxt.getWindowFile() == null ? BBxt.getWindowTitle() : BBxt.getWindowFile().getPath();
                String[] datetime = DateTimeUtils.getDateTime();
                String header = RmanHelp.this.getHeader(rmanDocPath);
                String psScript = FileUtils.read(f);
                if (psScript == null) {
                    Cutter.setLog("    Error:RmanHelp.getPreShapeUImenuItem() - cannot read \"" + f.getPath() + "\"");
                    return;
                }
                psScript = header + FileUtils.read(f);
                psScript = psScript.replaceAll("(_PROC_NAME_UI_)", T + "UI");
                psScript = psScript.replaceAll("(_PROC_NAME_RI_)", T + "RI");
                if (blocks == null) {
                    return;
                }
                StringBuffer attrs = new StringBuffer();
                for (int n = 0; n < blocks.length; ++n) {
                    BlockDB db = blocks[n];
                    attrs.append("\t\\$attr = \\`rmanGetAttrName \"").append(db.name).append("\"\\`;\n");
                    if (db.subtype.equals("masterswitch") || db.subtype.equals("switch")) {
                        attrs.append("\trmanAddAttr \\$shapeName \\$attr \"0\";\n");
                    } else {
                        attrs.append("\trmanAddAttr \\$shapeName \\$attr \"\";\n");
                    }
                    if (n == blocks.length - 1) continue;
                    attrs.append("\n");
                }
                psScript = psScript.replaceAll("(_ADD_RMAN_ATTR_)", attrs.toString());
                BBxt.newDocument(T + "UI.mel", psScript);
            }
        });
        return mi;
    }

    private BlockDB[] getDeclaredBlocks() {
        ScriptParser sp;
        try {
            sp = new ScriptParser(new RmanTokenizer(), BBxt.getWindowText());
        }
        catch (Exception ee) {
            Cutter.setLog("    Exception: RmanHelp.getParams() - Cannot get ScriptParser\n" + ee.toString());
            return null;
        }
        ScriptStructure struct = sp.getStructure();
        if (struct == null || struct.procDB == null || struct.procDB.size() == 0) {
            return null;
        }
        int itemCount = 0;
        Vector<BlockDB> listOfBlocks = new Vector<BlockDB>();
        for (int n = 0; n < struct.procDB.size(); ++n) {
            ProcDBItem db = struct.procDB.elementAt(n);
            if (db == null) continue;
            ++itemCount;
            BlockDB bDB = new BlockDB();
            bDB.datatype = db.procType;
            bDB.name = db.procName;
            String body = db.procBodyText.trim();
            body = TextUtils.trimLeadingChar(body, '{').trim();
            body = TextUtils.trimTrailingChar(body, '}').trim();
            String[] lines = TextUtils.tokenize(body, "\n");
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i].trim();
                if (line.startsWith("label")) {
                    bDB.label = this.grabNextString("label", line);
                }
                if (line.startsWith("subtype")) {
                    bDB.subtype = this.grabNextString("subtype", line);
                }
                if (!line.startsWith("range")) continue;
                bDB.range = this.grabNextString("range", line);
            }
            listOfBlocks.addElement(bDB);
        }
        BlockDB[] out = new BlockDB[listOfBlocks.size()];
        for (int j = 0; j < listOfBlocks.size(); ++j) {
            out[j] = (BlockDB)listOfBlocks.elementAt(j);
        }
        return out;
    }

    private String grabNextString(String head, String str) {
        String tail;
        try {
            tail = str.substring(head.length()).trim();
        }
        catch (IndexOutOfBoundsException e) {
            Cutter.setLog("    Exeception:RmanHelp.grabNextString()\n        " + e.toString());
            return "";
        }
        tail = TextUtils.trimLeadingChar(tail, '\"');
        tail = TextUtils.trimTrailingChar(tail, '\"');
        tail = TextUtils.trimLeadingChar(tail, '{');
        tail = TextUtils.trimTrailingChar(tail, '}');
        return tail;
    }

    static {
        Enumeration<String> e = RmanTokenizer.language.keys();
        while (e.hasMoreElements()) {
            String str = e.nextElement().toString();
            languageTable.put(str.toLowerCase(), str);
        }
    }
}

