/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Rman;

import UI_Components.KTile;
import UI_Desktop.Cutter;
import UI_Script.Rman.BlockDB;
import UI_Tools.AssetManagement.HtmlWriter;
import Utilities.EnvUtils;
import Utilities.FileUtils;
import Utilities.NumberUtils;
import Utilities.TextUtils;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;

public class RmanHtmlWriter
extends HtmlWriter {
    static File HTML = null;
    public static File IMAGES = null;
    static File headerFile = null;
    static File tailFile = null;
    static String headerStr = null;
    static String tailStr = null;
    static File colorFile = null;
    static File connectionFile = null;
    static File fileFile = null;
    static File strFile = null;
    static File selectorFile = null;
    static File bakeFile = null;
    static File sliderFile = null;
    static File switchFile = null;
    static String colorStr = null;
    static String connectionStr = null;
    static String fileStr = null;
    static String strStr = null;
    static String selectorStr = null;
    static String bakeStr = null;
    static String sliderStr = null;
    static String switchStr = null;
    String fileButtonStr = "<img src=\"images/fileUI.png\" alt=\"\" border=\"0\">";

    public RmanHtmlWriter(File file) throws IOException {
        super(file, IMAGES);
    }

    private Color convertToColor(String input) {
        float b;
        float g;
        float r;
        if (input == null || input.trim().length() == 0) {
            return Color.yellow;
        }
        String[] tokens = TextUtils.tokenize(input, " ");
        if (tokens.length != 3) {
            return Color.white;
        }
        try {
            r = (float)NumberUtils.strToDouble(tokens[0]);
            g = (float)NumberUtils.strToDouble(tokens[1]);
            b = (float)NumberUtils.strToDouble(tokens[2]);
        }
        catch (NumberFormatException ex) {
            return Color.red;
        }
        return new Color(r, g, b);
    }

    @Override
    public void writeHeader() {
        if (headerStr == null || headerStr.trim().length() == 0) {
            Cutter.setLog("    Error:RmanHtmlWriter.writeHeader() - no header at \"" + headerFile.getPath() + "\"");
            return;
        }
        this.buff.append(headerStr.replaceAll("(_TITLE_)", this.tightHostDirName));
    }

    public void writeParams(BlockDB[] blocks) {
        if (blocks == null || blocks.length == 0) {
            Cutter.setLog("    Error:RmanHtmlWriter.writeParams() - no params!");
            return;
        }
        for (int n = 0; n < blocks.length; ++n) {
            String str = "";
            BlockDB db = blocks[n];
            if (db.name.indexOf(58) != -1) continue;
            if (db.datatype.equals("color")) {
                KTile tile;
                str = colorStr.replaceAll("(LABEL)", db.label);
                File colorUI_PNG = new File(this.srcImagesDir, "colorUI.png");
                try {
                    tile = new KTile(colorUI_PNG);
                }
                catch (Exception ex) {
                    Cutter.setLog("    Error: ArgsHtmlWriter.writeParams() - cannot find src image:\n" + "        " + colorUI_PNG.getPath());
                    return;
                }
                Rectangle r = new Rectangle(5, 2, 72, 16);
                tile.fill(this.convertToColor(db.defaultValue), r);
                String outName = tile.colorToOuputName() + ".png";
                File outFile = new File(this.hostImagesDir, outName);
                tile.write(outFile, "png");
                str = str.replaceAll("(IMAGE_PNG)", outName);
            } else if (db.datatype.equals("string")) {
                if (db.subtype.equals("file")) {
                    str = fileStr.replaceAll("(LABEL)", db.label);
                    str = str.replaceAll("(DIR_BUTTON)", this.fileButtonStr);
                } else {
                    str = strStr.replaceAll("(LABEL)", db.label);
                }
            } else if (db.subtype.equals("selector")) {
                str = selectorStr.replaceAll("(LABEL)", db.label);
            } else if (db.subtype.equals("slider")) {
                str = sliderStr.replaceAll("(LABEL)", db.label);
            } else if (db.subtype.equals("switch")) {
                str = switchStr.replaceAll("(LABEL)", db.label);
            } else if (db.datatype.equals("float") || db.datatype.equals("int")) {
                str = sliderStr.replaceAll("(LABEL)", db.label);
            }
            if (str.length() > 0) {
                this.buff.append(str);
                continue;
            }
            Cutter.setLog("no string for " + db.name);
        }
    }

    @Override
    public void writeTail() {
        this.buff.append(tailStr);
    }

    static {
        HTML = new File(FileUtils.getPWDFile(), "Cutter_Help/rman/HTML");
        IMAGES = new File(HTML, "images");
        headerFile = EnvUtils.isOSXEnvironment() ? new File(HTML, "OSX_header.html") : new File(HTML, "header.html");
        headerStr = FileUtils.read(headerFile.getPath());
        tailFile = new File(HTML, "tail.html");
        tailStr = FileUtils.read(tailFile.getPath());
        colorFile = new File(HTML, "color.html");
        connectionFile = new File(HTML, "connection.html");
        bakeFile = new File(HTML, "bake.html");
        fileFile = new File(HTML, "file.html");
        strFile = new File(HTML, "string.html");
        selectorFile = new File(HTML, "selector.html");
        sliderFile = new File(HTML, "slider.html");
        switchFile = new File(HTML, "switch.html");
        colorStr = FileUtils.read(colorFile.getPath());
        connectionStr = FileUtils.read(connectionFile.getPath());
        bakeStr = FileUtils.read(bakeFile.getPath());
        fileStr = FileUtils.read(fileFile.getPath());
        strStr = FileUtils.read(strFile.getPath());
        selectorStr = FileUtils.read(selectorFile.getPath());
        sliderStr = FileUtils.read(sliderFile.getPath());
        switchStr = FileUtils.read(switchFile.getPath());
    }
}

