/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Rman;

import Preferences.Preferences;
import UI_Script.Rman.RmanTokenizer;
import UI_Script.SyntaxListener;
import UI_Script.Tcl.TclListener;
import UI_Text.KTextPane.KTextPane;
import UI_Text.Style.StyleEdits;
import java.awt.Color;
import javax.swing.text.StyleConstants;
import kernal.Tokenizers.Tokenizer;

public class RmanListener
extends TclListener {
    private RmanTokenizer rman = new RmanTokenizer();

    public RmanListener(KTextPane textpane, Tokenizer tok) {
        super(textpane, tok);
        this.initDelimitors(textpane);
        this.initStyles(textpane);
    }

    public RmanListener(KTextPane textpane) {
        super(textpane, new RmanTokenizer());
        this.initDelimitors(textpane);
        this.initStyles(textpane);
    }

    @Override
    public void initStyles(KTextPane textpane) {
        super.initStyles(textpane);
        StyleConstants.setForeground(textpane.styleContext.plainStyle, Preferences.getColor(Preferences.TEXT_COLOR_SL_PLAIN));
        StyleConstants.setForeground(textpane.styleContext.commentStyle1, Preferences.getColor(Preferences.TEXT_COLOR_SL_COMMENT));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle1, Preferences.getColor(Preferences.TEXT_COLOR_SL_FUNCTION));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle2, Preferences.getColor(Preferences.TEXT_COLOR_SL_DATATYPE));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle3, Preferences.getColor(Preferences.TEXT_COLOR_SL_VARIABLE));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle4, Preferences.getColor(Preferences.TEXT_COLOR_SL_SHADERTYPE));
        Color darkblue = SyntaxListener.defaultLanguageColor.darker();
        StyleConstants.setForeground(this.textpane.styleContext.languageStyle, darkblue);
        StyleConstants.setForeground(textpane.styleContext.stringStyle1, Preferences.getColor(Preferences.TEXT_COLOR_SL_STRING));
        StyleConstants.setForeground(textpane.styleContext.stringStyle2, Preferences.getColor(Preferences.TEXT_COLOR_SL_STRING));
        StyleConstants.setUnderline(textpane.styleContext.stringStyle2, true);
    }

    @Override
    protected void colorizeLiteral(int offset, String str, StyleEdits editList) {
        this.rman.setBuffer(str);
        this.rman.getComments = true;
        String s = this.rman.getNextStr();
        while (!s.equals("")) {
            int index = this.rman.getBufferIndex() - 1 < 0 ? 0 : this.rman.getBufferIndex();
            int begin = (index += offset) - s.length();
            int length = s.length();
            if (this.tok.isUserVariable(s)) {
                int i;
                if (s.charAt(0) == '-') {
                    editList.addEdit(begin, 1, this.textpane.styleContext.stringStyle1, true);
                    length = s.length() - 1;
                    editList.addEdit(++begin, length, this.textpane.styleContext.keywordStyle3, true);
                }
                if ((i = s.indexOf(92)) != -1) {
                    editList.addEdit(begin, length, this.textpane.styleContext.keywordStyle3, true);
                    editList.addEdit(begin += i, length -= i, this.textpane.styleContext.stringStyle1, true);
                } else {
                    editList.addEdit(begin, s.length(), this.textpane.styleContext.keywordStyle3, true);
                }
            } else {
                editList.addEdit(begin, s.length(), this.textpane.styleContext.stringStyle1, true);
            }
            s = this.rman.getNextStr();
        }
    }

    @Override
    protected boolean customSyntax(String str, int begin, StyleEdits editList) {
        if (str.charAt(0) == '\"') {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.stringStyle1, true);
            String tmp = str.substring(1, str.length() - 0);
            if (tmp.length() > 0) {
                this.colorizeLiteral(begin + 1, tmp, editList);
                return true;
            }
            return false;
        }
        if (str.equals("rman")) {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.keywordStyle3, true);
            return true;
        }
        if (((RmanTokenizer)this.tok).isUIType(str)) {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.stringStyle2, true);
            return true;
        }
        return false;
    }

    @Override
    public void addComments() {
        this.addComments("#");
    }
}

