/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Rman;

import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Script.Help.KAbstractHelp;
import UI_Script.Rman.OpenRmanAction;
import UI_Script.Rman.RmanHelp;
import UI_Script.Rman.RmanListener;
import UI_Script.Rman.RmanTokenizer;
import UI_Script.ScriptParser.ScriptStructure;
import UI_Script.Tcl.TclScriptHandler;
import UI_Text.KTextPane.KTextPane;
import Utilities.FileUtils;
import Utilities.KFileFilter;
import Utilities.TextUtils;
import java.io.File;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;

public class RmanScriptHandler
extends TclScriptHandler {
    public RmanScriptHandler() {
        this.ext = new String[2];
        this.ext[0] = ".rman";
        this.ext[1] = ".RMAN";
        this.setTokenizer();
    }

    @Override
    protected void setTokenizer() {
        this.tokenizer = new RmanTokenizer();
    }

    @Override
    public void deleteTmpFile() {
        File tmp = new File(FileUtils.getPWD(), "temp.rman");
        if (tmp.exists()) {
            tmp.delete();
        }
    }

    @Override
    public String getScriptName() {
        return "Rman";
    }

    @Override
    public String getExecuteLabel() {
        return "Preview " + this.getScriptName();
    }

    @Override
    public String getMakeLabel() {
        return null;
    }

    @Override
    public String getRunLabel() {
        return null;
    }

    @Override
    protected void make(File srcDir) {
    }

    @Override
    protected void run() {
    }

    @Override
    public void execute(File file) {
        KAbstractHelp helper;
        JEditorPane pane = BBxt.getTextPane();
        KTextPane textpane = null;
        if (pane != null && pane instanceof KTextPane) {
            textpane = (KTextPane)pane;
        }
        if ((helper = this.getHelper(textpane)) == null || !(helper instanceof RmanHelp)) {
            Cutter.setLog("    Error:RmanScriptHandler.execute() - cannot get an instance of RmanHelp");
            return;
        }
        ((RmanHelp)helper).openPreViewInBrowser();
    }

    @Override
    public void execute(String str) {
        File file = new File(FileUtils.getPWD(), "temp.rman");
        FileUtils.writeFile(file, str);
        this.execute(file);
    }

    @Override
    public KAbstractHelp getHelper(KTextPane textpane) {
        KAbstractHelp.add(textpane.helper);
        return KAbstractHelp.getInstanceByName(RmanHelp.class.getName(), textpane);
    }

    @Override
    public String getSyntaxListenerClassName(KTextPane textpane) {
        return RmanListener.class.getName();
    }

    @Override
    public JMenuItem getOpenFileMenuItem() {
        JMenuItem item = new JMenuItem("Rman");
        item.addActionListener(new OpenRmanAction());
        return item;
    }

    @Override
    public ScriptStructure getStructure() {
        return null;
    }

    public static void createDocument(String title, String docType) {
        String docStr = RmanScriptHandler.getDocString(docType);
        templateBuffer.setLength(0);
        String[] lineItems = TextUtils.tokenize(docStr);
        for (int n = 0; n < lineItems.length; ++n) {
            String line = RmanScriptHandler.getDocString(lineItems[n]);
            templateBuffer.append(line);
        }
        BBxt.newDocument(title, templateBuffer);
    }

    @Override
    public KFileFilter getFileFilter() {
        KFileFilter filter = new KFileFilter("rman", "Pixar Rman Script");
        return filter;
    }
}

