/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Rman;

import UI_Desktop.Cutter;
import UI_Script.Rman.RmanFunctionsRsrc;
import UI_Script.ScriptParser.ProcDBItem;
import UI_Script.Tcl.TclTokenizer;
import Utilities.TextUtils;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import kernal.Tokenizers.Tokenizer;

public class RmanTokenizer
extends TclTokenizer {
    public static final String RMAN_UI_TYPE = "rman_ui";
    protected static ResourceBundle RmanFunctionsRes;
    public static Hashtable<String, String> language;

    private static String getLanguage(String nm) {
        String str;
        try {
            str = RmanFunctionsRes.getObject(nm).toString();
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    private static int numLanguageItems() {
        int num = 0;
        try {
            num = ((RmanFunctionsRsrc)RmanFunctionsRes).getNumItems();
        }
        catch (MissingResourceException mre) {
            System.out.println("cannot read RmanFunctionsRsrc");
        }
        return num;
    }

    private static void initHashTable() {
        for (int i = 0; i < RmanTokenizer.numLanguageItems(); ++i) {
            language.put(((RmanFunctionsRsrc)RmanFunctionsRes).getKey(i), ((RmanFunctionsRsrc)RmanFunctionsRes).getContent(i));
        }
    }

    public RmanTokenizer() {
        String[] ext = new String[]{"rman", "RMAN"};
        Tokenizer.addToRegistry(RmanTokenizer.class, ext, this.getComments(), this.getDelimitors());
    }

    public boolean isUIType(String str) {
        if (language.containsKey(str)) {
            return language.get(str).equals(RMAN_UI_TYPE);
        }
        return false;
    }

    @Override
    public boolean isDataType(String str) {
        if (language.containsKey(str)) {
            return language.get(str).equals("datatype");
        }
        return false;
    }

    @Override
    public boolean isUserVariable(String str) {
        return false;
    }

    @Override
    public boolean isCommandSubstitution(String str) {
        return str.charAt(0) == '[';
    }

    @Override
    public boolean isFunction(String str) {
        if (language.containsKey(str)) {
            return language.get(str).equals("function");
        }
        return false;
    }

    @Override
    public boolean isLanguageType(String str) {
        if (language.containsKey(str)) {
            return language.get(str).equals("language");
        }
        return false;
    }

    @Override
    public ProcDBItem lpGrabProc(String str) {
        ProcDBItem out = new ProcDBItem();
        int index = this.getBufferIndex();
        if (str.equals("Declare")) {
            out.procOffset[0] = index - str.length();
            out.scope = "declare";
            str = this.getNextStr();
        }
        if (str.equals("")) {
            this.setBufferIndex(index);
            return null;
        }
        if (!(str.equals("param") || str.equals("toropt") || str.equals("torattr") || str.equals("riattr"))) {
            this.setBufferIndex(index);
            return null;
        }
        if (!out.scope.equals("declare")) {
            out.procOffset[0] = index - str.length();
        }
        out.procNameOffset = new int[2];
        int indexAtOpeningBrace = this.getBufferIndex();
        String ptext = this.lpGrabProcParams("{", "}");
        if (ptext == null) {
            this.setBufferIndex(index);
            return null;
        }
        String[] strs = TextUtils.tokenize(ptext);
        if (strs == null || strs.length < 2) {
            this.setBufferIndex(index);
            return null;
        }
        out.procNameOffset[1] = this.getBufferIndex() - 1;
        if (strs.length > 2) {
            strs[1] = ptext.trim().substring(strs[0].length());
        }
        out.procNameOffset[0] = indexAtOpeningBrace + 2;
        out.procName = strs[1];
        int[] offset = this.lpGrabProcBody("{", "}", null);
        if (offset == null) {
            this.setBufferIndex(index);
            return null;
        }
        int from = out.procNameOffset[0];
        int to = out.procNameOffset[1];
        String datatypeAndName = new String(this.getBuffer(from, to));
        String[] tokens = TextUtils.tokenize(datatypeAndName);
        out.procType = tokens[0];
        out.procName = out.procName.trim().replaceAll("(\\s*)", "");
        out.procOffset[0] = offset[0];
        out.procOffset[1] = offset[1];
        out.procBodyText = new String(this.getBuffer(offset[0], offset[1]));
        return out;
    }

    static {
        language = new Hashtable();
        try {
            RmanFunctionsRes = ResourceBundle.getBundle("UI_Script.Rman.RmanFunctionsRsrc");
        }
        catch (MissingResourceException mre) {
            Cutter.setLog("    Errr: RmanFunctionsRsrc = " + mre);
        }
        RmanTokenizer.initHashTable();
    }
}

