/*
 * Decompiled with CFR 0.152.
 */
package UI_Script;

import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Script.Comment;
import UI_Script.Default.KDefaultHelp;
import UI_Script.Help.KAbstractHelp;
import UI_Script.ProjectManagement.ProjectManager;
import UI_Script.ScriptParser.ScriptStructure;
import UI_Script.SyntaxListener;
import UI_Text.KTextPane.KTextPane;
import UI_Window.KWindow.KAbstractTextWindow;
import UI_Window.KWindow.KTextHistoryWindow;
import Utilities.FileUtils;
import Utilities.KFileFilter;
import java.io.File;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import kernal.Tokenizers.Tokenizer;

public abstract class ScriptHandler {
    protected static StringBuffer templateBuffer = new StringBuffer(1024);
    protected String[] ext = null;
    protected ProjectManager manager = null;
    protected Tokenizer tokenizer = null;

    private void ___ABSTRACT__METHODS________() {
    }

    protected abstract void setTokenizer();

    public abstract JMenuItem getOpenFileMenuItem();

    public abstract String getScriptName();

    public abstract void execute(File var1);

    public abstract void execute(String var1);

    public abstract boolean canRunSelection();

    public abstract void deleteTmpFile();

    public abstract String getExecuteLabel();

    public abstract String getMakeLabel();

    public abstract String getRunLabel();

    protected abstract void make(File var1);

    protected abstract void run();

    public abstract KFileFilter getFileFilter();

    private void ___TO_BE_IMPLEMENTED__METHODS________() {
    }

    public File[] getSystemHeadersDirs(File f) {
        return null;
    }

    public boolean isRunnableScript(File file) {
        return true;
    }

    private void ___FILE__METHODS________() {
    }

    public String getPreferredSaveFileName() {
        return null;
    }

    public void doPreSaveOperation(KAbstractTextWindow Ktw) {
    }

    public void doPostSaveOperation(KAbstractTextWindow Ktw) {
    }

    public void executeFromHistory(KTextHistoryWindow window) {
        if (this.ext != null && window != null) {
            String fname = "temp" + this.ext[0];
            File file = new File(FileUtils.getPWD(), fname);
            if (Cutter.input.debug) {
                Cutter.setLog("    Debug:ScriptRegistry.ScriptHandler.executeFromHistory() fname = " + fname);
            }
            FileUtils.writeFile(file, window.getCurrentText());
            this.execute(file);
        }
    }

    public synchronized SyntaxListener getSyntaxListener(KTextPane textpane) {
        SyntaxListener listener = SyntaxListener.getInstanceByClassName(this.getSyntaxListenerClassName(textpane), textpane);
        return listener;
    }

    public synchronized boolean syntaxListenerIsOK(SyntaxListener ls, KTextPane textpane) {
        if (ls == null) {
            return false;
        }
        String targetClassName = this.getSyntaxListenerClassName(textpane);
        String currentClassName = ls.getClass().getName();
        return currentClassName.equals(targetClassName);
    }

    public abstract String getSyntaxListenerClassName(KTextPane var1);

    public Tokenizer getTokenizer() {
        return this.tokenizer;
    }

    public Comment[] getComments() {
        JEditorPane pane = BBxt.getTextPane();
        if (pane instanceof KTextPane) {
            KTextPane textpane = (KTextPane)pane;
            return this.getSyntaxListener(textpane).getTokenizer().getComments();
        }
        return null;
    }

    public synchronized KAbstractHelp getHelper(KTextPane textpane) {
        KAbstractHelp.add(textpane.helper);
        return KAbstractHelp.getInstanceByName(KDefaultHelp.class.getName(), textpane);
    }

    public boolean canHandle(String extension) {
        if (this.ext == null || extension == null) {
            return false;
        }
        if (this.ext.length == 0) {
            return false;
        }
        for (int n = 0; n < this.ext.length; ++n) {
            if (this.ext[n] == null || !this.ext[n].equals(extension)) continue;
            return true;
        }
        return false;
    }

    public boolean canHandle(File file) {
        if (file == null) {
            return false;
        }
        String extension = FileUtils.getExtension(file.getName());
        if (extension == null || extension.trim().length() == 0) {
            return false;
        }
        boolean canDo = this.canHandle(extension);
        if (!canDo) {
            return this.canHandleByName(file.getName());
        }
        return canDo;
    }

    public boolean canHandleByName(String name) {
        if (name == null) {
            return false;
        }
        Class<?> c = this.getClass();
        if (c == null) {
            return false;
        }
        String cn = c.getName();
        if (cn == null) {
            return false;
        }
        return cn.equals("MakeScriptHandler") && (name.startsWith("Makefile") || name.startsWith("makefile"));
    }

    public JMenu getTemplateMenu() {
        return null;
    }

    public String preprocessTemplateText(String inStr) {
        return inStr;
    }

    public synchronized void loadCache(KAbstractTextWindow window) {
    }

    public File convertSelectionToFile(String sel) {
        return null;
    }

    public ScriptStructure getStructure() {
        return null;
    }
}

