/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.ScriptParser;

import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Window.KWindow.KAbstractWindow;
import UI_Window.KWindow.KTextWindow;
import Utilities.TextUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ProcDBItem {
    public static Font plainFont = null;
    public static Font boldFont = null;
    public String procComment = "";
    public String scope = "";
    public String access = "";
    public String memberOf = "";
    public String procType = "";
    public String procSubType = "";
    public String procName = "";
    public String procModifier = "";
    public Vector procArgs = new Vector();
    public int[] procNameOffset = new int[2];
    public int[] procOffset = new int[2];
    public String procBodyText = "";

    public String toString() {
        return "procName: " + this.procName + " procOffsets: " + this.procOffset[0] + ", " + this.procOffset[1] + ", procType: " + this.procType + ", procSubType: " + this.procSubType + ", access: " + this.access + ", procNameOffsets: " + this.procNameOffset[0] + ", " + this.procNameOffset[1] + "\n";
    }

    public ProcDBItem() {
    }

    public ProcDBItem(String name, int begin, int end) {
        this.procName = name;
        this.procNameOffset[0] = begin;
        this.procNameOffset[1] = end;
    }

    public JMenuItem getHiliteProcItem(final File file, boolean showAsPlain) {
        String[] parts;
        String styledName = this.procName;
        if (this.procName.contains("::") && (parts = TextUtils.tokenize(this.procName, ":")) != null && parts.length == 2) {
            styledName = "<HTML><B><FONT COLOR=\"#666666\">" + parts[0] + "</FONT></B>" + "::" + "<FONT COLOR=\"#000000\">" + parts[1] + "</FONT></HTML>";
        }
        JMenuItem item = new JMenuItem(styledName);
        if (plainFont != null && boldFont != null) {
            item.setFont(showAsPlain ? plainFont : boldFont);
            if (!showAsPlain) {
                item.setBackground(Color.white);
            }
        }
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (ProcDBItem.this.procNameOffset == null) {
                    return;
                }
                if (file != null) {
                    KAbstractWindow w = KAbstractDesktop.getWindowWithFile(file);
                    if (w == null) {
                        Thread loader = new Thread(){

                            @Override
                            public void run() {
                                Cutter.setLog("    Debug:ProcDBItem.actionPerformed() - opening file \"" + file.getPath() + "\"");
                                BBxt.newDocument(file);
                            }
                        };
                        loader.start();
                        try {
                            loader.join();
                            KTextWindow.selectionBeginToBeAppliedAt_resumeState = ProcDBItem.this.procNameOffset[0];
                            KTextWindow.selectionEndToBeAppliedAt_resumeState = ProcDBItem.this.procNameOffset[1];
                        }
                        catch (InterruptedException ie) {
                            Cutter.setLog(ie.toString());
                            return;
                        }
                    }
                    if ((w = KAbstractDesktop.getWindowWithFile(file)) != null) {
                        KAbstractDesktop.toFront(w);
                    }
                }
                try {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int line = BBxt.getLineNumberAtOffset(ProcDBItem.this.procNameOffset[0]);
                            if (line >= 0) {
                                int currentOffset;
                                if (ProcDBItem.this.procNameOffset[0] < 0) {
                                    ProcDBItem.this.procNameOffset[0] = 0;
                                }
                                if (ProcDBItem.this.procNameOffset[0] > (currentOffset = BBxt.getSelectionStart())) {
                                    int[] n = BBxt.getOffsetsOfLine(line + 8);
                                    if (n == null) {
                                        int len = BBxt.getDocumentLength();
                                        BBxt.setSelection(len, len);
                                    } else {
                                        BBxt.setSelection(n[1], n[1]);
                                    }
                                } else {
                                    int[] n = BBxt.getOffsetsOfLine(line - 4);
                                    if (n == null) {
                                        BBxt.setSelection(0, 0);
                                    } else {
                                        BBxt.setSelection(n[1], n[1]);
                                    }
                                }
                                try {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            SwingUtilities.invokeLater(new Runnable(){

                                                @Override
                                                public void run() {
                                                    BBxt.setSelection(ProcDBItem.this.procNameOffset[0], ProcDBItem.this.procNameOffset[1]);
                                                }
                                            });
                                        }
                                    });
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return item;
    }

    static {
        Font fb = (Font)UIManager.get("Button.font");
        plainFont = new Font(fb.getName(), 0, 12);
        boldFont = new Font(fb.getName(), 1, 12);
    }
}

