/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.ScriptParser;

import UI_Desktop.Cutter;
import UI_Script.Comment;
import UI_Script.ScriptParser.ProcDBItem;
import UI_Script.ScriptParser.ScriptStructure;
import Utilities.FileUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.io.File;
import java.util.Vector;
import kernal.Tokenizers.Tokenizer;
import kernal.Tokenizers.TokenizerRegistryItem;

public class ScriptParser {
    protected final String DEFAULT_FUNC_RETURN_TYPE = "int";
    private ScriptStructure struct = new ScriptStructure();
    public String defaultReturnType = "int";
    private Tokenizer tok = null;

    public ScriptParser(String srcCode, String ext) throws Exception {
        ext = TextUtils.remove(ext, '.');
        TokenizerRegistryItem tgi = Tokenizer.getMemberWithExt(ext);
        if (tgi == null) {
            throw new Exception("    Exception:ScriptParser.constructor() cannot find tokenizer for extension >" + ext + "<");
        }
        this.commonInit(tgi.getTokenizer(), srcCode);
    }

    public ScriptParser(Tokenizer tok, String srcCode) {
        this.commonInit(tok, srcCode);
    }

    private void commonInit(Tokenizer tok, String srcCode) {
        this.tok = tok;
        tok.getComments = true;
        this.tok.setBuffer(srcCode);
    }

    public String[][] getImports() {
        String line;
        if (this.tok == null) {
            Cutter.setLog("    Error:ScriptParser.getImports() - tok is null");
            return null;
        }
        char[] buff = this.tok.getBuffer();
        if (buff == null) {
            return null;
        }
        String bufferText = new String(buff);
        if (bufferText == null) {
            Cutter.setLog("    Error:ScriptParser.getImports() - bufferText is null");
            return null;
        }
        String[] lines = TextUtils.tokenize(bufferText, "\n");
        if (lines == null || lines.length == 0) {
            Cutter.setLog("    Error:ScriptParser.getImports() - bufferText does not have lines of text.");
            return null;
        }
        Vector<String> list = new Vector<String>();
        String[] keywords = this.tok.getImportKeywords();
        for (int n = 0; n < lines.length; ++n) {
            line = lines[n].trim();
            for (int i = 0; i < keywords.length; ++i) {
                String keyword = keywords[i];
                if (keyword.equals("") || !line.startsWith(keyword)) continue;
                list.addElement(line);
            }
        }
        char[] oldBuff = this.tok.getBuffer();
        Vector<String> sysList = new Vector<String>();
        Vector<String> usrList = new Vector<String>();
        String sysBegin = this.tok.getSysImportBeginEnd()[0];
        String sysEnd = this.tok.getSysImportBeginEnd()[1];
        String usrBegin = this.tok.getUsrImportBeginEnd()[0];
        String usrEnd = this.tok.getUsrImportBeginEnd()[1];
        if (usrBegin == "" && usrEnd == "" && sysBegin == "" && sysEnd == "") {
            this.tok.setBuffer(oldBuff);
            String[][] out = new String[][]{null, null, VectorUtils.toStringArray(list)};
            return out;
        }
        for (int i = 0; i < keywords.length; ++i) {
            String keyword = keywords[i];
            for (int n = 0; n < list.size(); ++n) {
                line = (String)list.elementAt(n);
                this.tok.setBuffer(line);
                String s = this.tok.getNextStr();
                while (!s.equals("")) {
                    if (s.startsWith(keyword)) {
                        s = s.substring(keyword.length()).trim();
                    }
                    if (s.equals("")) {
                        s = this.tok.getNextStr();
                        continue;
                    }
                    if (s.length() > sysBegin.length() + sysEnd.length() && s.startsWith(sysBegin) && s.endsWith(sysEnd)) {
                        sysList.addElement(s.substring(sysBegin.length(), s.length() - sysEnd.length()));
                    } else if (s.length() > usrBegin.length() + usrEnd.length() && s.startsWith(usrBegin) && s.endsWith(usrEnd)) {
                        usrList.addElement(s.substring(usrBegin.length(), s.length() - usrEnd.length()));
                    }
                    s = this.tok.getNextStr();
                }
            }
        }
        this.tok.setBuffer(oldBuff);
        String[][] out = new String[][]{VectorUtils.toStringArray(sysList), VectorUtils.toStringArray(usrList), VectorUtils.toStringArray(list)};
        return out;
    }

    public ScriptStructure getStructure() {
        String lastAccessSpecifier = "";
        String lastComment = "";
        String classname = "";
        int index = this.tok.getBufferIndex();
        this.tok.lpGetClassInterfaceSpans();
        this.tok.setBufferIndex(index);
        String s = this.tok.getNextStr();
        while (!s.equals("")) {
            ProcDBItem db;
            if (s.startsWith("#pragma")) {
                this.struct.addPragma(s.trim());
            }
            if ((db = this.tok.lpGrabProc(s)) != null) {
                this.struct.addProc(db);
            }
            if (this.isComment(s)) {
                lastComment = s;
                this.struct.addComment(this.getCommentBody(s).trim());
            }
            s = this.tok.getNextStr();
        }
        return this.struct;
    }

    protected ProcDBItem getProcWithAccessSpecifier(String access) {
        return null;
    }

    protected ProcDBItem getProc() {
        return null;
    }

    protected ProcDBItem getProcWithDataType(String type) {
        return null;
    }

    private boolean isProcKeyword(String str) {
        return false;
    }

    private boolean isComment(String str) {
        Comment[] cmnt = this.tok.getComments();
        if (cmnt == null) {
            return false;
        }
        for (int n = 0; n < cmnt.length; ++n) {
            if (str.startsWith(cmnt[n].openStr) && cmnt[n].closeStr.equals("\n")) {
                return true;
            }
            if (!str.startsWith(cmnt[n].openStr) || !str.endsWith(cmnt[n].closeStr)) continue;
            return true;
        }
        return false;
    }

    private String getCommentBody(String str) {
        Comment[] cmnt = this.tok.getComments();
        if (cmnt == null) {
            return str;
        }
        for (int n = 0; n < cmnt.length; ++n) {
            if (str.length() > cmnt[n].openLen && str.startsWith(cmnt[n].openStr) && cmnt[n].closeStr.equals("\n")) {
                return str.substring(cmnt[n].openLen);
            }
            if (str.length() <= cmnt[n].openLen + cmnt[n].closeLen || !str.startsWith(cmnt[n].openStr) || !str.endsWith(cmnt[n].closeStr)) continue;
            return str.substring(cmnt[n].openLen, str.length() - cmnt[n].closeLen);
        }
        return str;
    }

    public static boolean containsProcNamed(File f, String procName) {
        ScriptParser sp;
        if (procName == null || procName.length() == 0 || f == null || !f.exists()) {
            return false;
        }
        String text = FileUtils.read(f.getPath());
        if (text == null || text.length() == 0) {
            return false;
        }
        String ext = FileUtils.getExtension(f);
        if (ext == null || ext.length() == 0) {
            return false;
        }
        try {
            sp = new ScriptParser(text, ext);
        }
        catch (Exception ex) {
            return false;
        }
        ScriptStructure struct = sp.getStructure();
        if (struct == null) {
            return false;
        }
        String[] procNames = struct.getProcNames();
        if (procNames == null || procNames.length == 0) {
            return false;
        }
        for (int i = 0; i < procNames.length; ++i) {
            if (!procNames[i].equals(procName)) continue;
            return true;
        }
        return false;
    }
}

