/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.ScriptParser;

import UI_Desktop.Cutter;
import java.lang.reflect.Field;
import kernal.Tokenizers.Tokenizer;

public class ShaderTokenizer
extends Tokenizer {
    public static boolean _getShaderTypeAndName = false;
    public static boolean _getShaderType = false;
    private String[] shaderTypes = null;
    private String[] typesOfShaders = new String[]{"displacement", "surface", "light", "deformation", "volume", "imager"};

    public ShaderTokenizer(String[] shaderTypes) {
        this.setShaderTypes(shaderTypes);
        this.setDelimitor("\n\t :;,.[]{}<>()");
        this.getNextStr_return_delimitor = false;
        this.addComment("/*", "*/");
        this.addComment("//", "\n");
    }

    public void setShaderTypes(String[] shaderTypes) {
        this.shaderTypes = new String[shaderTypes.length];
        for (int n = 0; n < shaderTypes.length; ++n) {
            this.shaderTypes[n] = shaderTypes[n];
        }
    }

    public String[] getShaderTypeAndName() {
        if (this.shaderTypes == null) {
            return null;
        }
        StringBuffer buff = new StringBuffer();
        String possibleName = null;
        String possibleType = null;
        String possibleParenthesis = null;
        Object comment = null;
        int offset = 0;
        int descriptionBeginAt = -1;
        int descriptionEndAt = -1;
        boolean found = false;
        while (!found && offset != -1) {
            this.getNextStr_return_delimitor = false;
            if ((offset = this.getShaderType(offset, buff)) == -1) {
                return null;
            }
            possibleType = buff.toString();
            this.setBufferIndex(offset);
            descriptionBeginAt = offset - possibleType.length();
            possibleName = this.getNextStr().trim();
            offset = this.getBufferIndex();
            this.setDelimitor("(");
            this.getNextStr_return_delimitor = true;
            possibleParenthesis = this.getNextStr();
            if (possibleParenthesis.equals("(")) {
                boolean isOK = false;
                for (int n = 0; n < this.typesOfShaders.length; ++n) {
                    if (!possibleType.equals(this.typesOfShaders[n])) continue;
                    isOK = true;
                }
                if (_getShaderTypeAndName) {
                    Cutter.setLog("ShaderTokenizer.getShaderTypeAndName()\n    possibleType >" + possibleType + "<\n    possibleName >" + possibleName + "<\n    possibleParenthesis >" + possibleParenthesis + "<");
                }
                if (isOK) {
                    descriptionEndAt = this.getBufferIndex();
                    found = true;
                    if (_getShaderTypeAndName) {
                        Cutter.setLog("ShaderTokenizer.getShaderTypeAndName()\n         accepting possibleType >" + possibleType + "<\n         accepting possibleName >" + possibleName + "<\n         accepting descriptionBeginAt >" + descriptionBeginAt + "<\n         accepting descriptionEndAt >" + descriptionEndAt + "<");
                    }
                }
            }
            this.setBufferIndex(offset);
            buff.setLength(0);
        }
        String[] out = new String[]{possibleType, possibleName, "" + descriptionBeginAt, "" + descriptionEndAt};
        return out;
    }

    private int getShaderType(int beginAt, StringBuffer out) {
        int oldIndex = this.getBufferIndex();
        int foundAt = -1;
        int minOffset = 1000000;
        String type = "";
        for (int n = 0; n < this.shaderTypes.length; ++n) {
            this.setBufferIndex(beginAt);
            int offset = this.searchFor(this.shaderTypes[n], true);
            if (offset == -1 || offset >= minOffset) continue;
            minOffset = offset;
            type = this.shaderTypes[n];
            foundAt = this.getBufferIndex();
            if (!_getShaderType) continue;
            Cutter.setLog("ShaderTokenizer.getShaderType() found >" + this.shaderTypes[n] + "< minOffset " + minOffset);
        }
        this.setBufferIndex(oldIndex);
        out.append(type);
        return foundAt;
    }

    static {
        try {
            Field[] fields = new Field[]{ShaderTokenizer.class.getDeclaredField("_getShaderTypeAndName"), ShaderTokenizer.class.getDeclaredField("_getShaderType")};
            Cutter.addDebug(ShaderTokenizer.class, fields);
        }
        catch (NoSuchFieldException ex) {
            Cutter.setLog("Error: ShaderTokenizer.static - " + ex.toString());
        }
    }
}

