/*
 * Decompiled with CFR 0.152.
 */
package UI_Script;

import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Script.PixarDev.AbstractDevkit.DevkitScriptHandler;
import UI_Script.ScriptHandler;
import UI_Window.KWindow.KAbstractTextWindow;
import Utilities.FileUtils;
import Utilities.KFileFilter;
import Utilities.VectorUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

public class ScriptRegistry {
    private static Vector<ScriptHandler> listOfHandlers = new Vector();
    private static KFileFilter[] listOfFileFilters = null;

    public static synchronized void add(ScriptHandler script) {
        listOfHandlers.addElement(script);
    }

    public static synchronized ScriptHandler getHandlerForFile(File file) {
        if (file == null) {
            return null;
        }
        for (int n = 0; n < listOfHandlers.size(); ++n) {
            ScriptHandler handler = listOfHandlers.elementAt(n);
            if (!handler.canHandle(file)) continue;
            if (handler instanceof DevkitScriptHandler) {
                ScriptHandler specificHandler = ((DevkitScriptHandler)handler).getSpecificHandler(file);
                return specificHandler;
            }
            return handler;
        }
        return null;
    }

    public static synchronized ScriptHandler getHandlerForExtension(String ext) {
        for (int n = 0; n < listOfHandlers.size(); ++n) {
            ScriptHandler handler = listOfHandlers.elementAt(n);
            if (!handler.canHandle(ext)) continue;
            return handler;
        }
        return null;
    }

    public static synchronized ScriptHandler getHandlerForScriptName(String name) {
        for (int n = 0; n < listOfHandlers.size(); ++n) {
            ScriptHandler handler = listOfHandlers.elementAt(n);
            if (!handler.getScriptName().equalsIgnoreCase(name)) continue;
            return handler;
        }
        return null;
    }

    public static synchronized String getExtensionForScriptName(String name) {
        ScriptHandler handler = ScriptRegistry.getHandlerForScriptName(name);
        if (handler != null && handler.ext != null) {
            return handler.ext[0];
        }
        return null;
    }

    public static synchronized String getExecuteLabel(String ext) {
        if (ext == null) {
            return null;
        }
        ScriptHandler handler = ScriptRegistry.getHandlerForExtension(ext);
        if (handler == null) {
            return null;
        }
        return handler.getExecuteLabel();
    }

    public static synchronized String getMakeLabel(String ext) {
        if (ext == null) {
            return null;
        }
        ScriptHandler handler = ScriptRegistry.getHandlerForExtension(ext);
        if (handler == null) {
            return null;
        }
        return handler.getMakeLabel();
    }

    public static synchronized String getRunLabel(String ext) {
        if (ext == null) {
            return null;
        }
        ScriptHandler handler = ScriptRegistry.getHandlerForExtension(ext);
        if (handler == null) {
            return null;
        }
        return handler.getRunLabel();
    }

    public static synchronized void deleteTmpFiles() {
        for (int n = 0; n < listOfHandlers.size(); ++n) {
            ScriptHandler handler = listOfHandlers.elementAt(n);
            if (handler == null) continue;
            handler.deleteTmpFile();
        }
    }

    public static synchronized JMenuItem[] getOpenFileMenuItems() {
        Vector<JMenuItem> v = new Vector<JMenuItem>();
        for (int n = 0; n < listOfHandlers.size(); ++n) {
            ScriptHandler script = listOfHandlers.elementAt(n);
            v.addElement(script.getOpenFileMenuItem());
        }
        if (v.size() == 0) {
            return null;
        }
        JMenuItem[] out = new JMenuItem[v.size()];
        for (int n = 0; n < out.length; ++n) {
            out[n] = (JMenuItem)v.elementAt(n);
        }
        return out;
    }

    public static synchronized String[] getScriptsNames() {
        Vector<String> v = new Vector<String>();
        for (int n = 0; n < listOfHandlers.size(); ++n) {
            ScriptHandler script = listOfHandlers.elementAt(n);
            v.addElement(script.getScriptName());
        }
        if (v.size() == 0) {
            return null;
        }
        return VectorUtils.toStringArray(v);
    }

    public static synchronized KFileFilter[] getAllFileFilters() {
        int n;
        if (listOfFileFilters != null) {
            return listOfFileFilters;
        }
        Vector<KFileFilter> list = new Vector<KFileFilter>();
        for (n = 0; n < listOfHandlers.size(); ++n) {
            ScriptHandler handler = listOfHandlers.elementAt(n);
            KFileFilter item = handler.getFileFilter();
            if (item == null) continue;
            list.addElement(item);
        }
        listOfFileFilters = new KFileFilter[list.size()];
        for (n = 0; n < list.size(); ++n) {
            ScriptRegistry.listOfFileFilters[n] = (KFileFilter)list.elementAt(n);
        }
        return listOfFileFilters;
    }

    public static synchronized JMenu[] getTemplateMenus() {
        Vector<JMenu> list = new Vector<JMenu>();
        for (int n = 0; n < listOfHandlers.size(); ++n) {
            ScriptHandler handler = listOfHandlers.elementAt(n);
            JMenu tmp = handler.getTemplateMenu();
            if (tmp == null) continue;
            list.addElement(tmp);
        }
        JMenu[] out = new JMenu[list.size()];
        for (int n = 0; n < list.size(); ++n) {
            out[n] = (JMenu)list.elementAt(n);
        }
        return out;
    }

    public static synchronized void loadCache(final KAbstractTextWindow window) {
        String ext = FileUtils.getExtension(window.getTitle());
        File f = window.getFile();
        ScriptHandler handler = null;
        handler = f != null ? ScriptRegistry.getHandlerForFile(f) : ScriptRegistry.getHandlerForExtension(ext);
        if (handler != null) {
            final ScriptHandler h = handler;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    h.loadCache(window);
                }
            });
        }
    }

    public static class GenericRun
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent evt) {
            String ext = BBxt.getWindowExtension();
            File file = BBxt.getWindowFile();
            if (file == null || !FileUtils.exists(file.getPath())) {
                Cutter.setLog("    Error: ScriptRegistry.GenericRun() - file is null");
                return;
            }
            if (ext == null || ext.trim().length() == 0) {
                Cutter.setLog("    Error: ScriptRegistry.GenericRun() - ext is null");
                return;
            }
            ScriptHandler handler = ScriptRegistry.getHandlerForFile(file);
            if (handler == null) {
                Cutter.setLog("    Error: ScriptRegistry.GenericRun() - handler is null");
                return;
            }
            Cutter.setLog("    Info: ScriptRegistry.GenericRun() - handler is " + handler.getScriptName());
            Cutter.setLog("    Into: ScriptRegistry.GenericRun() - calling handler.run()");
            handler.run();
        }
    }

    public static class GenericMake
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent evt) {
            String ext = BBxt.getWindowExtension();
            File file = BBxt.getWindowFile();
            if (ext == null || ext.trim().length() == 0) {
                return;
            }
            if (file == null || !FileUtils.exists(file.getPath())) {
                Cutter.setLog("    Error: ScriptRegistry.GenericMake() - file is null");
                return;
            }
            ScriptHandler handler = ScriptRegistry.getHandlerForFile(file);
            if (handler == null) {
                return;
            }
            Cutter.setLog("    Info: ScriptRegistry.GenericMake() - handler is " + handler.getScriptName());
            handler.make(file.getParentFile());
        }
    }
}

