/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.See;

import UI_Desktop.Cutter;
import UI_Script.Help.KAbstractHelp;
import UI_Script.Help.KCompletionManager;
import UI_Script.See.SeeFuncStrs;
import UI_Script.See.SeeFunctionCalls;
import UI_Script.See.SeeTokenizer;
import UI_Text.KTextPane.KTextPane;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;

public class SeeHelp
extends KAbstractHelp {
    static SeeTokenizer funcLookup = null;
    private static Hashtable<String, String> languageTable = new Hashtable();
    static String seExprURL;

    public boolean showDocFor(String item, boolean shiftDown) {
        this.useCutterBrowser = !shiftDown;
        return this.launchBrowser(item);
    }

    @Override
    public boolean showDocFor(String item, MouseEvent e) {
        if (e.getModifiers() < 20) {
            Cutter.setLog("    Debug:SeeHelp.showDocFor() - return false because e.getModifiers() < 20");
            return false;
        }
        this.useCutterBrowser = !e.isShiftDown();
        return this.launchBrowser(item);
    }

    public SeeHelp(KTextPane textpane) {
        super(textpane);
        if (funcLookup == null) {
            funcLookup = new SeeTokenizer();
        }
        this.completer.completionActivate();
        this.completer.setWordStartDelims(null);
        this.completer.setListeners(textpane, this);
    }

    @Override
    public void setCompletorListeners() {
        this.completer.setListeners(this.textpane, this);
    }

    @Override
    public boolean completionTargetIsValid(String str) {
        if (str == null || str.trim().length() == 0) {
            return false;
        }
        if (Character.isUpperCase(str.charAt(0))) {
            return false;
        }
        return str.length() >= KCompletionManager.MIN_LEN;
    }

    @Override
    public String[] completionCandidates(String str) {
        return this.completionCandidates(str, languageTable);
    }

    @Override
    public void lookup(String item) {
        if (item == null) {
            return;
        }
        int funcType = SeeTokenizer.getFunctionType(item);
        if (funcType == 0) {
            return;
        }
        String urlStr = null;
        switch (funcType) {
            case 1: {
                urlStr = seExprURL + "#Color_Masking_and_Remapping_Functions";
                break;
            }
            case 2: {
                urlStr = seExprURL + "#Noise_Functions";
                break;
            }
            case 3: {
                urlStr = seExprURL + "#Texture_Lookup_Functions";
                break;
            }
            case 4: {
                urlStr = seExprURL + "#Selection_Functions";
                break;
            }
            case 5: {
                urlStr = seExprURL + "#General_Math_Functions";
                break;
            }
            case 6: {
                urlStr = seExprURL + "#Trigonometry_Functions";
                break;
            }
            case 7: {
                urlStr = seExprURL + "#Vector_Functions";
                break;
            }
            case 8: {
                urlStr = seExprURL + "#Curve_Functions";
                break;
            }
            default: {
                urlStr = seExprURL + "#Misc_Functions";
            }
        }
        if (urlStr != null) {
            this.setHelpPage(urlStr, false);
        }
    }

    @Override
    public void popupTypingCompletion(Point pnt, String textToComplete, int insertAt, MouseEvent e) {
    }

    @Override
    public void popupOnlineHelp(Point pnt, String selection, int insertAt, MouseEvent e) {
        int begin = insertAt - selection.length();
        KAbstractHelp.KPopupMenu popup = new KAbstractHelp.KPopupMenu();
        JMenu defaultMenu = new JMenu("General Options");
        JComponent[] items = this.getDefaultPopupItems(e, selection, insertAt - selection.length(), insertAt);
        for (int n = 0; n < items.length; ++n) {
            if (items[n] == null) continue;
            defaultMenu.add(items[n]);
        }
        JMenu builtin_menu = this.getBuiltins("Builtin Variables", selection, insertAt);
        popup.add(builtin_menu);
        popup.add(new JSeparator());
        JMenu math_menu = this.getMathFuncs("Maths", selection, insertAt);
        popup.add(math_menu);
        JMenu cmr_menu = this.getColorFuncs("Color", selection, insertAt);
        popup.add(cmr_menu);
        JMenu noise_menu = this.getNoiseFuncs("Noise", selection, insertAt);
        popup.add(noise_menu);
        JMenu lookup_menu = this.getTextureFuncs("Texture", selection, insertAt);
        popup.add(lookup_menu);
        JMenu trig_menu = this.getTrigFuncs("Trig", selection, insertAt);
        popup.add(trig_menu);
        JMenu vect_menu = this.getVectorFuncs("Vector", selection, insertAt);
        popup.add(vect_menu);
        JMenu curve_menu = this.getCurveFuncs("Curve", selection, insertAt);
        popup.add(curve_menu);
        JMenu debug_menu = this.getDebugFuncs("Debug", selection, insertAt);
        popup.add(debug_menu);
        JMenu select_menu = this.getSelectionFuncs("Selection", selection, insertAt);
        popup.add(select_menu);
        popup.add(new JSeparator());
        popup.add(defaultMenu);
        if (popup != null) {
            popup.setRequestFocusEnabled(false);
            try {
                popup.show(this.textpane, e.getX(), e.getY());
            }
            catch (Exception ex) {
                Cutter.setLog("    Exception:RixPatternHelp.popupOnlineHelp()\n      " + ex.toString());
            }
        }
    }

    private JMenu getBuiltins(String title, String sel, int at) {
        JMenu menu = new JMenu(title);
        SeeFunctionCalls calls = new SeeFunctionCalls(this.textpane);
        menu.add(calls.P(sel, at));
        menu.add(calls.Pobj(sel, at));
        menu.add(calls.Vn(sel, at));
        menu.add(calls.VLen(sel, at));
        menu.add(calls.Nn(sel, at));
        menu.add(calls.Ngn(sel, at));
        menu.add(calls.Tn(sel, at));
        menu.add(calls.s(sel, at));
        menu.add(calls.t(sel, at));
        menu.add(calls.u(sel, at));
        menu.add(calls.v(sel, at));
        menu.add(calls.w(sel, at));
        menu.add(calls.curvature(sel, at));
        menu.add(calls.curvature_u(sel, at));
        menu.add(calls.curvature_v(sel, at));
        menu.add(calls.objectId(sel, at));
        menu.add(calls.Cs(sel, at));
        menu.add(calls.As(sel, at));
        menu.add(calls.frame(sel, at));
        return menu;
    }

    private JMenu getColorFuncs(String title, String sel, int at) {
        JMenu menu = new JMenu(title);
        String[][] strns = SeeFuncStrs.ColorFuncs;
        for (int n = 0; n < strns.length; ++n) {
            JMenuItem mi = new JMenuItem(strns[n][0]);
            mi.addActionListener(new FuncAction(strns[n][1], sel, at));
            menu.add(mi);
        }
        return menu;
    }

    private JMenu getNoiseFuncs(String title, String sel, int at) {
        JMenu menu = new JMenu(title);
        String[][] strns = SeeFuncStrs.NoiseFuncs;
        for (int n = 0; n < strns.length; ++n) {
            JMenuItem mi = new JMenuItem(strns[n][0]);
            mi.addActionListener(new FuncAction(strns[n][1], sel, at));
            menu.add(mi);
        }
        return menu;
    }

    private JMenu getTextureFuncs(String title, String sel, int at) {
        JMenu menu = new JMenu(title);
        String[][] strns = SeeFuncStrs.TextureFuncs;
        for (int n = 0; n < strns.length; ++n) {
            JMenuItem mi = new JMenuItem(strns[n][0]);
            mi.addActionListener(new FuncAction(strns[n][1], sel, at));
            menu.add(mi);
        }
        return menu;
    }

    private JMenu getSelectionFuncs(String title, String sel, int at) {
        JMenu menu = new JMenu(title);
        String[][] strns = SeeFuncStrs.SelectionFuncs;
        for (int n = 0; n < strns.length; ++n) {
            JMenuItem mi = new JMenuItem(strns[n][0]);
            mi.addActionListener(new FuncAction(strns[n][1], sel, at));
            menu.add(mi);
        }
        return menu;
    }

    private JMenu getMathFuncs(String title, String sel, int at) {
        JMenu menu = new JMenu(title);
        String[][] strns = SeeFuncStrs.MathFuncs;
        for (int n = 0; n < strns.length; ++n) {
            JMenuItem mi = new JMenuItem(strns[n][0]);
            mi.addActionListener(new FuncAction(strns[n][1], sel, at));
            menu.add(mi);
        }
        return menu;
    }

    private JMenu getTrigFuncs(String title, String sel, int at) {
        JMenu menu = new JMenu(title);
        String[][] strns = SeeFuncStrs.TrigFuncs;
        for (int n = 0; n < strns.length; ++n) {
            JMenuItem mi = new JMenuItem(strns[n][0]);
            mi.addActionListener(new FuncAction(strns[n][1], sel, at));
            menu.add(mi);
        }
        return menu;
    }

    private JMenu getVectorFuncs(String title, String sel, int at) {
        JMenu menu = new JMenu(title);
        String[][] strns = SeeFuncStrs.VectorFuncs;
        for (int n = 0; n < strns.length; ++n) {
            JMenuItem mi = new JMenuItem(strns[n][0]);
            mi.addActionListener(new FuncAction(strns[n][1], sel, at));
            menu.add(mi);
        }
        return menu;
    }

    private JMenu getCurveFuncs(String title, String sel, int at) {
        JMenu menu = new JMenu(title);
        String[][] strns = SeeFuncStrs.CurveFuncs;
        for (int n = 0; n < strns.length; ++n) {
            JMenuItem mi = new JMenuItem(strns[n][0]);
            mi.addActionListener(new FuncAction(strns[n][1], sel, at));
            menu.add(mi);
        }
        return menu;
    }

    private JMenu getDebugFuncs(String title, String sel, int at) {
        JMenu menu = new JMenu(title);
        String[][] strns = SeeFuncStrs.DebugFuncs;
        for (int n = 0; n < strns.length; ++n) {
            JMenuItem mi = new JMenuItem(strns[n][0]);
            mi.addActionListener(new FuncAction(strns[n][1], sel, at));
            menu.add(mi);
        }
        return menu;
    }

    private void insertParamStr(String str, int begin, int end) {
        try {
            this.textpane.setSelectionStart(begin);
            this.textpane.setSelectionEnd(end);
            this.textpane.replaceSelection(str + "\n");
        }
        catch (Exception e) {
            Cutter.setLog("    Exception:SeeHelp.insertParamStr()\n        " + e.toString());
            return;
        }
    }

    static {
        Enumeration<String> e = SeeTokenizer.language.keys();
        while (e.hasMoreElements()) {
            String str = e.nextElement().toString();
            languageTable.put(str.toLowerCase(), str);
        }
        seExprURL = "https://rmanwiki.pixar.com/display/REN/PxrSeExpr+Quick+Reference";
    }

    private class FuncAction
    implements ActionListener {
        String payload;
        String selection;
        int offset;

        public FuncAction(String text, String sel, int at) {
            this.payload = text;
            this.selection = sel;
            this.offset = at;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int span = this.offset - this.selection.length();
            SeeHelp.this.insertParamStr(this.payload, span, this.offset);
        }
    }
}

