/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.See;

import Preferences.Preferences;
import UI_Script.See.SeeTokenizer;
import UI_Script.SyntaxListener;
import UI_Text.KTextPane.KTextPane;
import UI_Text.Style.StyleEdits;
import java.awt.Color;
import javax.swing.text.StyleConstants;
import kernal.Tokenizers.Tokenizer;

public class SeeListener
extends SyntaxListener {
    public SeeListener(KTextPane textpane, Tokenizer tok) {
        super(textpane, tok);
        this.initDelimitors(textpane);
        this.initStyles(textpane);
    }

    public SeeListener(KTextPane textpane) {
        super(textpane, new SeeTokenizer());
        this.initDelimitors(textpane);
        this.initStyles(textpane);
    }

    @Override
    public void initDelimitors(KTextPane textpane) {
        char[] delim = new char[]{'-', '$'};
        textpane.addWordDelimitors(delim, delim);
        char[] begin = new char[]{'$'};
        textpane.removeWordDelimitors(begin, null);
    }

    @Override
    public void initStyles(KTextPane textpane) {
        super.initStyles(textpane);
        StyleConstants.setForeground(textpane.styleContext.plainStyle, Preferences.getColor(Preferences.TEXT_COLOR_SEE_PLAIN));
        StyleConstants.setForeground(textpane.styleContext.commentStyle1, Preferences.getColor(Preferences.TEXT_COLOR_SEE_COMMENT));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle3, Preferences.getColor(Preferences.TEXT_COLOR_SEE_VARIABLE));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle1, Preferences.getColor(Preferences.TEXT_COLOR_SEE_FUNCTION));
        Color blue = SyntaxListener.defaultLanguageColor;
        StyleConstants.setForeground(this.textpane.styleContext.keywordStyle2, blue);
        StyleConstants.setForeground(textpane.styleContext.stringStyle1, Preferences.getColor(Preferences.TEXT_COLOR_SEE_STRING));
        StyleConstants.setForeground(textpane.styleContext.stringStyle2, Preferences.getColor(Preferences.TEXT_COLOR_SEE_STRING));
    }

    @Override
    protected boolean customSyntax(String str, int begin, StyleEdits editList) {
        if (this.tok.isNamedSpace(str)) {
            if (str.startsWith("\"") && str.length() >= 3) {
                editList.addEdit(begin, str.length(), this.textpane.styleContext.stringStyle1, true);
                editList.addEdit(begin + 1, str.length() - 2, this.textpane.styleContext.stringStyle2, true);
                return true;
            }
            return false;
        }
        if (this.tok.isShaderType(str)) {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.keywordStyle4, true);
            return true;
        }
        if (this.tok.isSystemVariable(str)) {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.keywordStyle3, true);
            return true;
        }
        if (str.endsWith("Obj") || str.endsWith("ObjN") || str.endsWith("ObjV")) {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.keywordStyle3, true);
            return true;
        }
        return false;
    }

    @Override
    public void addComments() {
        this.addComments("#");
    }
}

