/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.See;

import ClientServer.ClientServer.client.Client;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Script.CommandPort.MayaCommandPort;
import UI_Script.Help.KAbstractHelp;
import UI_Script.Mel.MelScriptHandler;
import UI_Script.ScriptParser.ScriptStructure;
import UI_Script.See.OpenSeeAction;
import UI_Script.See.SeeHelp;
import UI_Script.See.SeeListener;
import UI_Script.See.SeeTokenizer;
import UI_Text.KTextPane.KTextPane;
import UI_Window.KWindow.KAbstractTextWindow;
import UI_Window.KWindow.KAbstractWindow;
import UI_Window.KWindow.KTextHistoryWindow;
import UI_Window.KWindow.KTextWindow;
import Utilities.DialogUtils;
import Utilities.KFileFilter;
import Utilities.TextUtils;
import java.io.File;
import javax.swing.JMenuItem;
import javax.swing.text.Segment;

public class SeeScriptHandler
extends MelScriptHandler {
    public SeeScriptHandler() {
        this.ext = new String[2];
        this.ext[0] = ".see";
        this.ext[1] = ".SEE";
        this.setTokenizer();
    }

    @Override
    protected void setTokenizer() {
        this.tokenizer = new SeeTokenizer();
    }

    @Override
    public String getScriptName() {
        return "SeExpr";
    }

    @Override
    public void execute(File file) {
        String str;
        KAbstractWindow front = BBxt.frontWindow();
        if (front != null && front instanceof KTextWindow && (str = BBxt.getWindowText()) != null && str.trim().length() > 0) {
            this.execute(str);
        }
    }

    @Override
    public void execute(String str) {
        KAbstractWindow front = BBxt.frontWindow();
        if (front != null && front instanceof KTextWindow) {
            int n;
            SeeTokenizer tok = new SeeTokenizer();
            tok.setBuffer(str);
            String seExprNodeName = tok.getSeExprNodeName();
            String selection = BBxt.getSelection();
            int begin = BBxt.getSelectionStart();
            int end = BBxt.getSelectionEnd();
            if (begin != end && (seExprNodeName == null || seExprNodeName.trim().length() == 0)) {
                Segment segment = BBxt.getWindowText(0, begin);
                String[] lines = TextUtils.tokenize(segment.toString(), '\n');
                StringBuffer b = new StringBuffer();
                if (lines != null && lines.length > 0) {
                    for (n = lines.length - 1; n >= 0; --n) {
                        tok.setBuffer(lines[n]);
                        seExprNodeName = tok.getSeExprNodeName();
                        if (seExprNodeName != null) break;
                    }
                }
            }
            Cutter.setLog("    Info:SeeScriptHandler.execute - seExprNodeName is " + seExprNodeName);
            if (seExprNodeName == null) {
                String[] msg = new String[]{"The document does not specifiy the name of the", "PxrSeExpr node that should receive the script.", " ", "A name should be specified as follows,", "     # target: \"PxrSeExpr1\"", " "};
                DialogUtils.showErrorMessage("PxrSeExprNode Name Missing", msg);
                return;
            }
            String[] lines = TextUtils.tokenize(str, '\n');
            StringBuffer buf = new StringBuffer();
            for (n = 0; n < lines.length; ++n) {
                String line = lines[n];
                if (line.trim().startsWith("#")) continue;
                line = TextUtils.replace(line, '\"', "\\\"");
                buf.append(line).append("\\").append("n");
            }
            String melCmd = "setAttr -type \"string\" " + seExprNodeName + ".expression \"" + buf.toString() + "\";";
            front.sendMelToMayaClient(melCmd);
        }
    }

    @Override
    public void executeFromHistory(KTextHistoryWindow window) {
        if (window == null) {
            Cutter.setLog("    Error:MelScriptHandler.executeFromHistory() - history window is null!!");
            return;
        }
        KAbstractTextWindow atw = window.getOwnersWindow();
        Client client = atw.getMayaClient();
        if (client == null) {
            String[] msg = new String[]{"The history window can send its SeExpr script to Maya", "but only if its parent window is connectd to Maya."};
            DialogUtils.showWarningMessage("Must be connected to Maya", msg);
            return;
        }
        String str = BBxt.getSelectionFromAbstractTextWindow(window);
        MayaCommandPort maya = new MayaCommandPort((KTextWindow)atw, client);
        maya.sendStr(str);
    }

    @Override
    public String getSyntaxListenerClassName(KTextPane textpane) {
        return SeeListener.class.getName();
    }

    @Override
    public KAbstractHelp getHelper(KTextPane textpane) {
        KAbstractHelp.add(textpane.helper);
        return KAbstractHelp.getInstanceByName(SeeHelp.class.getName(), textpane);
    }

    @Override
    public JMenuItem getOpenFileMenuItem() {
        JMenuItem item = new JMenuItem("See");
        item.addActionListener(new OpenSeeAction());
        return item;
    }

    @Override
    public ScriptStructure getStructure() {
        return super.getStructure();
    }

    @Override
    public KFileFilter getFileFilter() {
        KFileFilter filter = new KFileFilter("see", "Disney SeExpr");
        return filter;
    }
}

