/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.See;

import UI_Desktop.Cutter;
import UI_Script.See.SeeLanguageRsrc;
import Utilities.TextUtils;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import kernal.Tokenizers.Tokenizer;

public class SeeTokenizer
extends Tokenizer {
    public static final String CMR_FUNCTION = "cmr";
    public static final String NOISE_FUNCTION = "noise";
    public static final String TEXTURE_FUNCTION = "texture";
    public static final String SELECTION_FUNCTION = "selections";
    public static final String MATHS_FUNCTION = "maths";
    public static final String TRIG_FUNCTION = "trig";
    public static final String VECTOR_FUNCTION = "vector";
    public static final String CURVE_FUNCTION = "curve";
    public static final String DEBUG_FUNCTION = "debug";
    public static final int UNKNOWN_FUNCTION_ID = 0;
    public static final int CMR_FUNCTION_ID = 1;
    public static final int NOISE_FUNCTION_ID = 2;
    public static final int TEXTURE_FUNCTION_ID = 3;
    public static final int SELECTION_FUNCTION_ID = 4;
    public static final int MATHS_FUNCTION_ID = 5;
    public static final int TRIG_FUNCTION_ID = 6;
    public static final int VECTOR_FUNCTION_ID = 7;
    public static final int CURVE_FUNCTION_ID = 8;
    public static final int DEBUG_FUNCTION_ID = 9;
    public static final String[] DATATYPES = new String[0];
    private String[] dataTypes = DATATYPES;
    private static ResourceBundle SeeStatementsRes;
    public static Hashtable<String, String> language;

    private static String getFunction(String nm) {
        String str;
        try {
            str = SeeStatementsRes.getObject(nm).toString();
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    private static int numFunctions() {
        int num = 0;
        try {
            num = ((SeeLanguageRsrc)SeeStatementsRes).getNumItems();
        }
        catch (MissingResourceException mre) {
            System.out.println("cannot read SeeLanguageRsrc");
        }
        return num;
    }

    private static void initHashTable() {
        for (int i = 0; i < SeeTokenizer.numFunctions(); ++i) {
            language.put(((SeeLanguageRsrc)SeeStatementsRes).getKey(i), ((SeeLanguageRsrc)SeeStatementsRes).getContent(i));
        }
    }

    public SeeTokenizer() {
        this.addComment("#", "\n");
        char[] esc_chars = new char[]{'\\', '^'};
        this.addQuotation("\"", "\"", esc_chars);
        this.setSyntaxLength(1);
        this.setDefaultDelimitors();
        this.appendDelimitor("*-+=/");
        this.appendDelimitor("/$&?@%~!");
        this.removeDelimitor("$-");
        String[] ext = new String[]{"see", "SEE"};
        Tokenizer.addToRegistry(SeeTokenizer.class, ext, this.getComments(), this.getDelimitors());
    }

    @Override
    public boolean isSystemVariable(String str) {
        return str.compareTo("s") == 0 || str.compareTo("t") == 0 || str.compareTo("u") == 0 || str.compareTo("v") == 0 || str.compareTo("Cs") == 0 || str.compareTo("As") == 0 || str.compareTo("P") == 0 || str.compareTo("Pobj") == 0 || str.compareTo("Nn") == 0 || str.compareTo("Vn") == 0 || str.compareTo("frame") == 0;
    }

    @Override
    public boolean isFunction(String str) {
        return SeeTokenizer.getFunctionType(str) != 0;
    }

    @Override
    public boolean isDataType(String str) {
        for (int n = 0; n < this.dataTypes.length; ++n) {
            if (!str.equals(this.dataTypes[n])) continue;
            return !this.nextNonWhiteCharIs(40) && !this.nextNonWhiteCharIs(34);
        }
        return false;
    }

    public static int getFunctionType(String functionName) {
        if (!language.containsKey(functionName)) {
            return 0;
        }
        String obj = language.get(functionName);
        if (obj == null) {
            return 0;
        }
        if (obj.equals(CMR_FUNCTION)) {
            return 1;
        }
        if (obj.equals(NOISE_FUNCTION)) {
            return 2;
        }
        if (obj.equals(TEXTURE_FUNCTION)) {
            return 3;
        }
        if (obj.equals(SELECTION_FUNCTION)) {
            return 4;
        }
        if (obj.equals(MATHS_FUNCTION)) {
            return 5;
        }
        if (obj.equals(TRIG_FUNCTION)) {
            return 6;
        }
        if (obj.equals(VECTOR_FUNCTION)) {
            return 7;
        }
        if (obj.equals(CURVE_FUNCTION)) {
            return 8;
        }
        if (obj.equals(DEBUG_FUNCTION)) {
            return 9;
        }
        return 0;
    }

    protected String getSeExprNodeName() {
        int oldIndex = this.getBufferIndex();
        this.setBufferIndex(0);
        this.getComments = true;
        String str = this.getNextStr();
        String line = "";
        while (!str.equals("")) {
            if (this.isOpenComment(str)) {
                String[] tokens;
                line = str.trim();
                if (line.length() > 1) {
                    while (line.charAt(0) == '#' || line.charAt(0) == ' ') {
                        line = line.substring(1);
                    }
                }
                if ((tokens = TextUtils.tokenize(line, ": ")) != null && tokens.length > 1 && tokens[0].equalsIgnoreCase("node")) {
                    String name = TextUtils.removeQuotes(tokens[1]);
                    if (name.trim().length() == 0) {
                        return null;
                    }
                    return name;
                }
            }
            str = this.getNextStr();
        }
        this.getComments = false;
        this.setBufferIndex(oldIndex);
        return null;
    }

    static {
        language = new Hashtable();
        try {
            SeeStatementsRes = ResourceBundle.getBundle("UI_Script.See.SeeLanguageRsrc");
        }
        catch (MissingResourceException mre) {
            Cutter.setLog("    Error:SeeTokenizer = " + mre);
        }
        SeeTokenizer.initHashTable();
    }
}

