/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.SolidAngleDev.Ass;

import Preferences.Preferences;
import Processes.ProcListener;
import Processes.ProcessManager;
import UI_Script.ScriptHandler;
import UI_Script.SolidAngleDev.Ass.AssScriptListener;
import UI_Script.SolidAngleDev.Ass.AssScriptTokenizer;
import UI_Script.SolidAngleDev.Shaders.AiKickUtils;
import UI_Text.KTextPane.KTextPane;
import Utilities.DialogUtils;
import Utilities.EnvUtils;
import Utilities.FileUtils;
import Utilities.KFileFilter;
import java.io.File;
import javax.swing.JMenuItem;

public class AssScriptHandler
extends ScriptHandler
implements ProcListener {
    public AssScriptHandler() {
        this.ext = new String[2];
        this.ext[0] = ".ass";
        this.ext[1] = ".ASS";
        this.setTokenizer();
    }

    @Override
    public String getSyntaxListenerClassName(KTextPane textpane) {
        return AssScriptListener.class.getName();
    }

    @Override
    protected void setTokenizer() {
        this.tokenizer = new AssScriptTokenizer();
    }

    @Override
    public JMenuItem getOpenFileMenuItem() {
        return null;
    }

    @Override
    public String getScriptName() {
        return "Arnold Render";
    }

    @Override
    public void execute(String str) {
    }

    @Override
    public void execute(File assFile) {
        String devkitPath = Preferences.get(Preferences.PATH_ARNOLD_DEVKIT);
        String userShadersPath = Preferences.get(Preferences.PATH_ARNOLD_USER_SHADER_DST);
        File bin = new File(devkitPath, "bin");
        String kick_name = EnvUtils.isWinEnvironment() ? "kick.exe" : "kick";
        File kick = new File(bin, kick_name);
        if (!kick.exists()) {
            String[] msg = new String[]{"An Arnold executable called \"kick\" cannot be found.", "Ensure the correct version of Arnold's SDK is installed", "and that the preference:", "   Languages->Arnold SDK->SDK Location->Path", "is \"pointing\" to the SDK directory.\n\n"};
            DialogUtils.showInfoMessage("Cannot Render", msg);
            return;
        }
        ProcessManager fp = new ProcessManager(AiKickUtils.procNameKickRender);
        String str = Preferences.get(Preferences.ARNOLD_RENDER_IPR);
        boolean useIPR = str.equals("true");
        int numParams = useIPR ? 8 : 4;
        String[] items = new String[numParams];
        items[0] = kick.getPath();
        items[1] = "-l";
        items[2] = userShadersPath;
        items[3] = assFile.getPath();
        if (useIPR) {
            items[4] = "-ipr";
            items[5] = "m";
            items[6] = "-v";
            items[7] = "0";
        }
        fp.launch(items, assFile.getParentFile(), true, this, false);
    }

    @Override
    public void processStarted(String procName, String[] progarray, String procID) {
    }

    @Override
    public void processSentString(String procName, String output) {
    }

    @Override
    public void processFinished(String[] progarray) {
    }

    @Override
    public boolean canRunSelection() {
        return false;
    }

    @Override
    public void deleteTmpFile() {
        File tmp = new File(FileUtils.getPWD(), "temp.ass");
        if (tmp.exists()) {
            tmp.delete();
        }
    }

    @Override
    public String getExecuteLabel() {
        return "Render Arnold Scene";
    }

    @Override
    public String getMakeLabel() {
        return null;
    }

    @Override
    public String getRunLabel() {
        return null;
    }

    @Override
    protected void make(File srcDir) {
    }

    @Override
    protected void run() {
    }

    @Override
    public KFileFilter getFileFilter() {
        return new KFileFilter("ass", "Open Arnold Scene");
    }
}

