/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.SolidAngleDev.Shaders.AETemplate;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Script.SolidAngleDev.Shaders.Mtd.AiNodeParametersParser;
import UI_Window.KWindow.KAbstractWindow;
import UI_Window.KWindow.KTextWindow;
import Utilities.FileUtils;
import Utilities.TextUtils;
import java.io.File;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class AETemplateWriter {
    public static void writeTemplate() {
        Document srcDoc = AETemplateWriter.getSouceCodeDoc();
        File srcFile = BBxt.getWindowFile();
        if (srcFile == null) {
            Cutter.setLog("    Error: AETemplateWriter() - BBxt.getWindowFile() returned null.");
            return;
        }
        String dsoName = TextUtils.removeExtension(srcFile.getName());
        String userTmplatesDirPath = Preferences.get(Preferences.PATH_ARNOLD_USER_AETEMPLATES);
        File tmpFile = new File(userTmplatesDirPath, dsoName + "Template.py");
        AiNodeParametersParser parm_parser = new AiNodeParametersParser(srcDoc, true);
        Vector<AiNodeParametersParser.NodeParameter> listOfParms = parm_parser.getDeclaredParms();
        if (listOfParms.size() == 0) {
            Cutter.setLog("    Info: writeTemplate.writeAETemplate() - listOfParms is empty.");
            return;
        }
        StringBuffer b = new StringBuffer();
        b.append("# This file is create/updated by Cutter.\n\n");
        b.append("import pymel.core as pm\n");
        b.append("import mtoa.utils as utils\n");
        b.append("import mtoa.ui.ae.utils as aeUtils\n");
        b.append("from mtoa.ui.ae.shaderTemplate import ShaderAETemplate\n\n");
        b.append("# Note the name of the class must be AE<shader_name>Template\n");
        b.append("class AE").append(dsoName).append("Template(ShaderAETemplate):\n");
        b.append("\tdef setup(self):\n");
        b.append("\t\t# Add the shader swatch to the AE\n");
        b.append("\t\tself.addSwatch()\n");
        b.append("\t\tself.beginScrollLayout()\n\n");
        b.append("\t\t# Add a list that allows to replace the shader for other one\n");
        b.append("\t\tself.addCustom('message', 'AEshaderTypeNew', 'AEshaderTypeReplace')\n\n");
        String activePanelName = null;
        String panelState = "True";
        boolean doDeclareBeginLayout = false;
        boolean doDeclareEndLayout = false;
        boolean addControlIsActive = false;
        for (int n = 0; n < listOfParms.size(); ++n) {
            AiNodeParametersParser.NodeParameter parm = listOfParms.elementAt(n);
            if (parm.uiHints.size() == 0) {
                Cutter.setLog("    Info: AETemplateWriter.writeTemplate() - parm \"" + parm.parmName + "\" has no uiHints.");
                continue;
            }
            String[] panelNameState = parm.uiHints.get("panel");
            if (panelNameState == null || panelNameState.length < 1) continue;
            if (activePanelName == null) {
                activePanelName = panelNameState[0];
                doDeclareBeginLayout = true;
                addControlIsActive = true;
                doDeclareEndLayout = false;
            } else if (activePanelName.equalsIgnoreCase(panelNameState[0])) {
                doDeclareBeginLayout = false;
            } else {
                doDeclareEndLayout = true;
                doDeclareBeginLayout = true;
                activePanelName = panelNameState[0];
            }
            if (panelNameState.length >= 2) {
                panelState = panelNameState[1];
                String string = panelState = panelState.equalsIgnoreCase("closed") ? "True" : "False";
            }
            if (doDeclareEndLayout) {
                b.append("\t\tself.endLayout()\n\n");
                doDeclareEndLayout = false;
                addControlIsActive = false;
            }
            if (doDeclareBeginLayout) {
                b.append("\t\tself.beginLayout(\"").append(AETemplateWriter.convertToLabel(activePanelName)).append("\", collapse=");
                b.append(panelState).append(")\n");
                doDeclareBeginLayout = false;
            }
            String label = AETemplateWriter.convertToLabel(parm.parmName);
            b.append("\t\tself.addControl(\"").append(parm.parmName).append("\", label=\"");
            b.append(label).append("\", annotation=\"\")\n");
            addControlIsActive = true;
        }
        if (addControlIsActive) {
            b.append("\t\tself.endLayout()\n\n");
        }
        b.append("\t\t# include/call base class/node attributes\n");
        b.append("\t\tpm.mel.AEdependNodeTemplate(self.nodeName)\n\n");
        b.append("\t\t# Add Section for the extra controls not displayed before\n");
        b.append("\t\tself.addExtraControls()\n");
        b.append("\t\tself.endScrollLayout()\n\n");
        KAbstractWindow kaw = KAbstractDesktop.getWindowWithFile(tmpFile);
        if (kaw != null) {
            kaw.saveFile();
        }
        FileUtils.writeFile(tmpFile, b.toString());
        if (kaw != null) {
            try {
                final String str = b.toString();
                JEditorPane textpane = BBxt.getTextPane(kaw);
                if (textpane != null) {
                    textpane.setSelectionStart(0);
                    textpane.setSelectionEnd(textpane.getDocument().getLength());
                    final Document document = textpane.getDocument();
                    if (document != null) {
                        try {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        document.remove(0, document.getLength());
                                        document.insertString(0, str, null);
                                    }
                                    catch (BadLocationException ex) {
                                        Cutter.setLog("    Exception: AETemplateWriter.writeTemplate() - " + ex.toString());
                                    }
                                }
                            });
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (Exception e) {
                Cutter.setLog("    Exception: AETemplateWriter.writeTemplate() - " + e.toString());
            }
        }
    }

    private static String convertToLabel(String text) {
        String out = TextUtils.capitalize(text);
        String[] parts = TextUtils.tokenize(out = TextUtils.replace(out, "_", " "));
        if (parts != null && parts.length > 0) {
            StringBuffer b = new StringBuffer();
            for (int n = 0; n < parts.length; ++n) {
                b.append(TextUtils.capitalize(parts[n]));
                b.append(" ");
            }
            return b.toString().trim();
        }
        return out;
    }

    private static Document getSouceCodeDoc() {
        KAbstractWindow win = BBxt.frontWindow();
        if (win == null || !(win instanceof KTextWindow)) {
            return null;
        }
        KTextWindow ktw = (KTextWindow)win;
        return ktw.getTextPane().getDocument();
    }
}

