/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.SolidAngleDev.Shaders;

import Preferences.Preferences;
import Processes.ProcListener;
import Processes.ProcessManager;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Text.KTextPane.KTextPane;
import UI_Window.KWindow.KAbstractWindow;
import Utilities.DialogUtils;
import Utilities.EnvUtils;
import Utilities.FileUtils;
import Utilities.NumberUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.io.File;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class AiKickUtils
implements ProcListener {
    private static String assTemplate = "options\n{\nname options\ncamera \"camera\"\nxres 400\nyres 400\noperator \"aiSetTransform1\"\n}\n\npersp_camera\n{\nname camera\nmatrix\n\t1 0 0 0\n\t0 1 0 0\n\t0 0 1 0\n\t0 0 7 1\n}\n\nsphere\n{\nname\tsphereShape1\ncenter\t0 0 0\nradius\t3\nmatrix\n 1        0        0        0\n 0        0        1        0\n 0       -1        0        0\n 0        0        0        1\nshader\t\"__SHADER_NAME__\"\n}\n\nset_transform\n{\nname aiSetTransform1\nselection \"sphereShape1\"\nscale 1 1 1\nrotate 0 0 0\ntranslate 0 0 1\n}\n\nnoise\n{\nname aiNoise1\noctaves 1\ndistortion 1\namplitude 1\nscale 1 1 1\n}\n\n__SHADER_NAME__\n{\nname __SHADER_NAME__\n__SHADER_PARAMS__\n}\n";
    public static String procNameKickInfo = "Arnold Shader Info";
    public static String procNameKickRender = "Arnold Render";
    private boolean FlagGenerateAss = false;
    private KTextPane textpane = null;
    private String nodeName = "";
    private int numParams = 0;
    private String[] params = null;
    private String path_to_shader = "";
    private Vector<String> listOfRawLines = new Vector();

    public AiKickUtils(KTextPane textpane) {
        this.textpane = textpane;
    }

    public void generateAssFile(File srcFile) {
        this.FlagGenerateAss = true;
        if (!this.launchKickInfo(srcFile)) {
            this.FlagGenerateAss = false;
            return;
        }
    }

    public void launchKickRender(File assFile) {
        String kick_name;
        String devkitPath = Preferences.get(Preferences.PATH_ARNOLD_DEVKIT);
        File bin = new File(devkitPath, "bin");
        File kick = new File(bin, kick_name = EnvUtils.isWinEnvironment() ? "kick.exe" : "kick");
        if (!kick.exists()) {
            String[] msg = new String[]{"An Arnold executable called \"kick\" cannot be found.", "Ensure the correct version of Arnold's SDK is installed", "and that the preference:", "   Languages->Arnold SDK->SDK Location->Path", "is \"pointing\" to the SDK directory.\n\n"};
            DialogUtils.showInfoMessage("Cannot Render", msg);
            return;
        }
        this.FlagGenerateAss = false;
        ProcessManager fp = new ProcessManager(procNameKickRender);
        String str = Preferences.get(Preferences.ARNOLD_RENDER_IPR);
        boolean useIPR = str.equals("true");
        int numParams = useIPR ? 8 : 4;
        String[] items = new String[numParams];
        items[0] = kick.getPath();
        items[1] = "-l";
        items[2] = new File(this.path_to_shader).getParent();
        items[3] = assFile.getPath();
        if (useIPR) {
            items[4] = "-ipr";
            items[5] = "m";
            items[6] = "-v";
            items[7] = "0";
        }
        fp.launch(items, assFile.getParentFile(), true, this, false);
    }

    public boolean launchKickInfo(File srcFile) {
        String kick_name;
        String[] info = this.getShaderPathAndName(srcFile);
        if (info == null) {
            return false;
        }
        String devkitPath = Preferences.get(Preferences.PATH_ARNOLD_DEVKIT);
        File bin = new File(devkitPath, "bin");
        File kick = new File(bin, kick_name = EnvUtils.isWinEnvironment() ? "kick.exe" : "kick");
        if (!kick.exists()) {
            String[] msg = new String[]{"An Arnold executable called \"kick\" cannot be found.", "Ensure the correct version of Arnold's SDK is installed", "and that the preference:", "   Languages->Arnold SDK->SDK Location->Path", "is \"pointing\" to the SDK directory.\n\n"};
            DialogUtils.showInfoMessage("Cannot Run Kick", msg);
            return false;
        }
        ProcessManager fp = new ProcessManager(procNameKickInfo);
        String[] item = new String[]{kick.getPath(), "-l", info[0], "-info", info[1], "-v", "0"};
        fp.launch(item, new File(info[0]).getParentFile(), true, this, false);
        return true;
    }

    public String[] getShaderPathAndName(File srcFile) {
        String compiledShadersPath = Preferences.get(Preferences.PATH_ARNOLD_USER_SHADER_DST);
        String dsoName = TextUtils.removeExtension(srcFile.getName());
        String dsoExt = EnvUtils.isWinEnvironment() ? ".dll" : ".so";
        String dsoFullName = dsoName + dsoExt;
        String dsoFullPath = new File(compiledShadersPath, dsoFullName).getPath();
        boolean dsoExist = false;
        dsoExist = FileUtils.exists(dsoFullPath);
        if (!dsoExist) {
            dsoFullPath = new File(srcFile.getParent(), dsoFullName).getPath();
            dsoExist = FileUtils.exists(dsoFullPath);
        }
        if (!dsoExist) {
            return null;
        }
        String[] out = new String[]{dsoFullPath, dsoName};
        return out;
    }

    @Override
    public void processStarted(String procName, String[] progarray, String procID) {
        this.listOfRawLines.clear();
    }

    @Override
    public void processSentString(String procName, String output) {
        if (procName.equals(procNameKickInfo)) {
            this.listOfRawLines.add(output);
        }
    }

    @Override
    public void processFinished(String[] progarray) {
        boolean processIsInfo = false;
        boolean processIsRender = false;
        if (progarray != null) {
            for (int n = 0; n < progarray.length; ++n) {
                if (progarray[n].equals("-l")) {
                    this.path_to_shader = progarray[n + 1];
                }
                if (progarray[n].equals("-info")) {
                    processIsInfo = true;
                }
                if (!progarray[n].endsWith(".ass")) continue;
                processIsRender = true;
            }
        }
        if (processIsInfo) {
            if (!this.parse_info()) {
                Cutter.setLog("Shader Info Process Finished - error.");
                this.FlagGenerateAss = false;
                return;
            }
            if (this.FlagGenerateAss) {
                File dest = new File(this.path_to_shader).getParentFile();
                File assFile = new File(dest, this.nodeName + ".ass");
                String assOut = assTemplate.replaceAll("(__SHADER_NAME__)", this.nodeName);
                assOut = assOut.replaceAll("(__SHADER_PARAMS__)", VectorUtils.stringArrayToText(this.params));
                FileUtils.writeFile(assFile, assOut);
                this.updateAssOnDesktop(assFile, assOut);
                this.FlagGenerateAss = false;
                this.launchKickRender(assFile);
            }
        } else if (processIsRender) {
            // empty if block
        }
    }

    private void updateAssOnDesktop(File assFile, final String assText) {
        final KAbstractWindow kaw = KAbstractDesktop.getWindowWithFile(assFile);
        if (kaw == null) {
            BBxt.newDocument(assFile);
        } else {
            try {
                JEditorPane textpane = BBxt.getTextPane(kaw);
                if (textpane != null) {
                    textpane.setSelectionStart(0);
                    textpane.setSelectionEnd(textpane.getDocument().getLength());
                    final Document document = textpane.getDocument();
                    if (document != null) {
                        try {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        document.remove(0, document.getLength());
                                        document.insertString(0, assText, null);
                                        kaw.saveFile();
                                    }
                                    catch (BadLocationException ex) {
                                        Cutter.setLog("    Exception:AiKickUtils.updateAssOnDesktop() - " + ex.toString());
                                    }
                                }
                            });
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (Exception e) {
                Cutter.setLog("    Exception:AiKickUtils.updateAssOnDesktop() - " + e.toString());
            }
        }
    }

    private boolean parse_info() {
        int n;
        Vector<String> listOfParams = new Vector<String>();
        boolean readParms = false;
        this.params = null;
        int param_index = 0;
        for (n = 0; n < this.listOfRawLines.size(); ++n) {
            String line = this.listOfRawLines.elementAt(n);
            if ((line = line.trim()).startsWith("node:")) {
                this.nodeName = line.substring(5).trim();
            }
            if (line.startsWith("parameters:")) {
                line = line.substring(11).trim();
                this.numParams = NumberUtils.strToInt(line);
            }
            if (readParms) {
                String[] tokens = TextUtils.tokenize(line);
                int lenOfFirstToken = 0;
                if (tokens.length >= 2) {
                    String[] t;
                    lenOfFirstToken = tokens[0].length();
                    line = line.substring(lenOfFirstToken).trim();
                    line = line.replace(',', ' ');
                    if (tokens[0].trim().equals("BOOL")) {
                        t = TextUtils.tokenize(line);
                        String convertedValue = t[1].equals("true") ? "1" : "0";
                        line = t[0] + "    " + convertedValue;
                    } else if (tokens[0].trim().equals("MATRIX")) {
                        t = TextUtils.tokenize(line);
                        line = t[0] + " \n1 0 0 0\n 0 1 0 0\n 0 0 1 0\n 0 0 0 1";
                    } else {
                        line = tokens[0].trim().equals("CLOSURE") ? "###" + tokens[1] : line.replaceAll("(     )", " ");
                    }
                    if (++param_index < this.numParams) {
                        listOfParams.add(line);
                    } else {
                        readParms = false;
                    }
                }
            }
            if (!line.startsWith("---")) continue;
            readParms = true;
        }
        if (listOfParams.size() == 0 || this.numParams == 0) {
            return false;
        }
        if (listOfParams.size() != this.numParams - 1) {
            return false;
        }
        this.params = new String[this.numParams - 1];
        for (n = 0; n < this.params.length; ++n) {
            this.params[n] = (String)listOfParams.elementAt(n);
        }
        this.listOfRawLines.clear();
        return true;
    }
}

