/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.SolidAngleDev.Shaders;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Components.KMenuItem;
import UI_Desktop.Cutter;
import UI_Desktop.KDesktop;
import UI_Script.Help.KAbstractHelp;
import UI_Script.SolidAngleDev.Shaders.AETemplate.AETemplateWriter;
import UI_Script.SolidAngleDev.Shaders.AiFuncStrs;
import UI_Script.SolidAngleDev.Shaders.AiHeaderLookup;
import UI_Script.SolidAngleDev.Shaders.AiKickUtils;
import UI_Text.KTextPane.KCaret;
import UI_Text.KTextPane.KTextPane;
import UI_Tools.Find.FindTool;
import Utilities.DocumentUtils;
import Utilities.FinderUtils;
import Utilities.ListenerUtils;
import Utilities.MayaNodeIdUtils;
import Utilities.TextUtils;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.Document;
import javax.swing.text.Segment;

public class AiShaderHelp
extends KAbstractHelp
implements PopupMenuListener {
    private AiKickUtils kicker;
    JMenu miscActions;
    JMenuItem openMtdItem;
    JMenuItem openAETemplateItem;
    JMenuItem makeAETemplateItem;
    JMenuItem verifyItem;
    JMenuItem generateAssFileItem;
    JMenuItem nodeIdReportItem;

    public AiShaderHelp(KTextPane textpane) {
        super(textpane);
        this.kicker = new AiKickUtils(this.textpane);
        this.miscActions = new JMenu("Other Actions");
        this.openMtdItem = new JMenuItem("Open .mtd File");
        this.openAETemplateItem = new JMenuItem("Open AETemplate File");
        this.makeAETemplateItem = new JMenuItem("Update AETemplate File");
        this.verifyItem = new JMenuItem("Verify Shader");
        this.generateAssFileItem = new JMenuItem("Render Shader");
        this.nodeIdReportItem = new JMenuItem("Generate MayaNodeID Report");
        char[] delims = KCaret.getDefaultDelimitors();
        char[] modified = new char[delims.length - 1];
        int counter = 0;
        for (int n = 0; n < delims.length; ++n) {
            if (delims[n] == '#') continue;
            modified[counter] = delims[n];
            ++counter;
        }
    }

    private void addLookupInHeaderItem(KAbstractHelp.KPopupMenu popup, String title, final String sel, int at) {
        final KAbstractHelp.KPopupMenuItem lookupmenu = new KAbstractHelp.KPopupMenuItem(title);
        popup.add(lookupmenu);
        lookupmenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String header;
                String selection = sel;
                if (sel.trim().length() == 0) {
                    Segment seg = BBxt.getSelection(null);
                    selection = seg.toString();
                }
                if ((header = AiHeaderLookup.tableDB.get(selection)) == null || header.trim().length() == 0) {
                    Cutter.setLog("    Error:AiShaderHelp.openHeader() - no header file for >" + selection + "<");
                    return;
                }
                String path = null;
                if (path == null || path.trim().length() == 0) {
                    path = Preferences.get(Preferences.PATH_ARNOLD_DEVKIT);
                }
                if (path == null || path.trim().length() == 0) {
                    Cutter.setLog("    Debug:AiShaderHelp.getDefaultDevkitPopup().actionPerformed() - cannot find path to pro-server installation");
                    return;
                }
                File includeDir = new File(path, "include");
                final File headerFile = new File(includeDir, header);
                Cutter.setLog("    Debug:AiShaderHelp.getDefaultDevkitPopup().actionPerformed() - headerFile \"" + headerFile.getPath() + "\"");
                if (!headerFile.exists()) {
                    Cutter.setLog("    Debug:AiShaderHelp.getDefaultDevkitPopup().actionPerformed() - headerFile does not exist \"" + headerFile.getPath() + "\"");
                    JOptionPane.showMessageDialog(KDesktop.desktopPane, "Unable to find,\n     \"" + headerFile.getPath() + "\"\nOpen the Preferences Tool and choose the\n     Languages->Pixar Devkit tab.\nEnsure the path to RenderManProSever is correct.\n\n", "Cannot Find Header File", 0);
                    return;
                }
                final FindTool finder = FindTool.init();
                if (!finder.isVisible()) {
                    finder.showSelf();
                }
                final String target = selection;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BBxt.newDocument(headerFile);
                        FindTool.setFindText(target, false);
                        FindTool.ignoreCase(false);
                        FindTool.wholeWord(true);
                        1 v0 = this;
                        v0.finder.clickFindButton();
                    }
                });
            }
        });
        popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                Segment seg = BBxt.getSelection(null);
                String selection = seg.toString();
                String header = AiHeaderLookup.tableDB.get(selection);
                if (header == null || header.trim().length() == 0) {
                    lookupmenu.setEnabled(false);
                } else {
                    lookupmenu.setEnabled(true);
                    lookupmenu.setText("Find in \"" + header + "\"");
                }
                File cppSrcFile = AiShaderHelp.this.textpane.getFrame().getFile();
                String dsoName = TextUtils.removeExtension(cppSrcFile.getName());
                if (dsoName == null || dsoName.trim().length() == 0) {
                    Cutter.setLog("    Info:AiShaderHelp.popupMenuWillBecomeVisible() - unable to get the name of the shader dso!");
                    return;
                }
                String userShdDirPath = Preferences.get(Preferences.PATH_ARNOLD_USER_SHADER_DST);
                File f = new File(userShdDirPath, dsoName + ".mtd");
                if (f.exists()) {
                    AiShaderHelp.this.openMtdItem.setEnabled(true);
                    AiShaderHelp.this.openMtdItem.setText("Open \"" + f.getName() + "\"");
                } else {
                    AiShaderHelp.this.openMtdItem.setEnabled(false);
                    AiShaderHelp.this.openMtdItem.setText("Open .mtd file");
                }
                f = new File(userShdDirPath, dsoName + "Template.py");
                if (f.exists()) {
                    AiShaderHelp.this.openAETemplateItem.setEnabled(true);
                    AiShaderHelp.this.openAETemplateItem.setText("Open \"" + f.getName() + "\"");
                    AiShaderHelp.this.makeAETemplateItem.setText("Update \"" + f.getName() + "\"");
                } else {
                    AiShaderHelp.this.openAETemplateItem.setEnabled(false);
                    AiShaderHelp.this.openAETemplateItem.setText("Open AETemplate file");
                    AiShaderHelp.this.makeAETemplateItem.setText("Create \"" + f.getName() + "\"");
                }
            }
        });
    }

    @Override
    public void popupOnlineHelp(Point pnt, String selection, int insertAt, MouseEvent e) {
        KAbstractHelp.KPopupMenu popup = new KAbstractHelp.KPopupMenu();
        final File f = this.textpane.getFrame().getFile();
        popup.removeAll();
        PopupMenuListener[] pops = popup.getPopupMenuListeners();
        if (pops != null) {
            for (int n = 0; n < pops.length; ++n) {
                popup.removePopupMenuListener(pops[n]);
            }
        }
        popup.addPopupMenuListener(this);
        ListenerUtils.removeAllActions(this.verifyItem);
        ListenerUtils.removeAllActions(this.generateAssFileItem);
        this.addLookupInHeaderItem(popup, "Find in header", selection, insertAt);
        JMenu decl_params_menu = this.getDeclareParamFuncs("Declare Shader Parameters", selection, insertAt);
        popup.add(decl_params_menu);
        JMenu eval_params_menu = this.getEvalParamFuncs("Evaluate Shader Parameters", selection, insertAt);
        popup.add(eval_params_menu);
        JMenu matrix_funcs_menu = this.getMatrixFuncs("Matrix Functions", selection, insertAt);
        popup.add(matrix_funcs_menu);
        JMenu vector_funcs_menu = this.getVectorFuncs("Vector Functions", selection, insertAt);
        popup.add(vector_funcs_menu);
        JMenu noise_funcs_menu = this.getNoiseFuncs("Noise Functions", selection, insertAt);
        popup.add(noise_funcs_menu);
        popup.add(new JSeparator());
        popup.add(this.miscActions);
        this.miscActions.add(this.openMtdItem);
        this.miscActions.add(this.openAETemplateItem);
        this.miscActions.add(this.makeAETemplateItem);
        this.miscActions.add(this.verifyItem);
        this.miscActions.add(this.generateAssFileItem);
        this.miscActions.add(this.nodeIdReportItem);
        this.nodeIdReportItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MayaNodeIdUtils.writeFullReport();
            }
        });
        this.openMtdItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File cppSrcFile = AiShaderHelp.this.textpane.getFrame().getFile();
                String dsoName = TextUtils.removeExtension(cppSrcFile.getName());
                if (dsoName == null || dsoName.trim().length() == 0) {
                    Cutter.setLog("    Info:AiShaderHelp.openMtd() - unable to get the name of the shader dso!");
                    return;
                }
                String mtd_name = dsoName + ".mtd";
                String userShdDirPath = Preferences.get(Preferences.PATH_ARNOLD_USER_SHADER_DST);
                File f = new File(userShdDirPath, mtd_name);
                if (f.exists()) {
                    BBxt.newDocument(f);
                } else {
                    Cutter.setLog("    Info:AiShaderHelp.openMtd() - cannot find \"" + f.getPath() + "\"");
                }
            }
        });
        this.openAETemplateItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File cppSrcFile = AiShaderHelp.this.textpane.getFrame().getFile();
                String dsoName = TextUtils.removeExtension(cppSrcFile.getName());
                if (dsoName == null || dsoName.trim().length() == 0) {
                    Cutter.setLog("    Info:AiShaderHelp.openAETemplate() - unable to get the name of the shader dso!");
                    return;
                }
                String ae_name = dsoName + "Template.py";
                String userShdDirPath = Preferences.get(Preferences.PATH_ARNOLD_USER_SHADER_DST);
                File f = new File(userShdDirPath, ae_name);
                if (f.exists()) {
                    BBxt.newDocument(f);
                } else {
                    Cutter.setLog("    Info:AiShaderHelp.openAETemplate() - cannot find \"" + f.getPath() + "\"");
                }
            }
        });
        this.makeAETemplateItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File cppSrcFile = AiShaderHelp.this.textpane.getFrame().getFile();
                String dsoName = TextUtils.removeExtension(cppSrcFile.getName());
                if (dsoName == null || dsoName.trim().length() == 0) {
                    Cutter.setLog("    Info:AiShaderHelp.updatAETemplate() - unable to get the name of the shader dso!");
                    return;
                }
                String ae_name = dsoName + "Template.py";
                String userShdDirPath = Preferences.get(Preferences.PATH_ARNOLD_USER_SHADER_DST);
                File f = new File(userShdDirPath, ae_name);
                AETemplateWriter.writeTemplate();
                if (f.exists()) {
                    BBxt.newDocument(f);
                }
            }
        });
        this.verifyItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AiShaderHelp.this.kicker.launchKickInfo(f);
            }
        });
        this.generateAssFileItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AiShaderHelp.this.kicker.generateAssFile(f);
            }
        });
        popup.add(new JSeparator());
        JMenu defaultMenu = new JMenu("General Options");
        JComponent[] items = this.getDefaultPopupItems(e, selection, insertAt - selection.length(), insertAt);
        for (int n = 0; n < items.length; ++n) {
            if (items[n] == null) continue;
            defaultMenu.add(items[n]);
        }
        popup.add(defaultMenu);
        popup.pack();
        popup.show(this.textpane, pnt.x, pnt.y);
    }

    @Override
    public void popupTypingCompletion(Point pnt, String textToComplete, int insertAt, MouseEvent e) {
        Cutter.setLog("popupTypingCompletion");
    }

    @Override
    public void lookup(String item) {
    }

    @Override
    public boolean showDocFor(String item, MouseEvent e) {
        return false;
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        File f = this.textpane.getFrame().getFile();
        if (this.kicker.getShaderPathAndName(f) == null) {
            this.verifyItem.setEnabled(false);
        } else {
            this.verifyItem.setEnabled(true);
        }
    }

    private JMenu getDeclareParamFuncs(String title, String sel, int at) {
        JMenu menu = new JMenu(title);
        String[][] strns = AiFuncStrs.DeclareParamFuncs;
        for (int n = 0; n < strns.length; ++n) {
            KMenuItem mi = new KMenuItem(strns[n][0]);
            mi.addActionListener(new FuncAction(strns[n][1], sel, at));
            menu.add(mi);
        }
        return menu;
    }

    private JMenu getMatrixFuncs(String title, String sel, int at) {
        JMenu menu = new JMenu(title);
        String[][] strns = AiFuncStrs.MatrixFuncs;
        for (int n = 0; n < strns.length; ++n) {
            KMenuItem mi = new KMenuItem(strns[n][0]);
            mi.addActionListener(new FuncAction(strns[n][1], sel, at));
            menu.add(mi);
        }
        return menu;
    }

    private JMenu getVectorFuncs(String title, String sel, int at) {
        JMenu menu = new JMenu(title);
        String[][] strns = AiFuncStrs.VectorFuncs;
        for (int n = 0; n < strns.length; ++n) {
            KMenuItem mi = new KMenuItem(strns[n][0]);
            mi.addActionListener(new FuncAction(strns[n][1], sel, at));
            menu.add(mi);
        }
        return menu;
    }

    private JMenu getNoiseFuncs(String title, String sel, int at) {
        JMenu menu = new JMenu(title);
        String[][] strns = AiFuncStrs.NoiseFuncs;
        for (int n = 0; n < strns.length; ++n) {
            KMenuItem mi = new KMenuItem(strns[n][0]);
            mi.addActionListener(new FuncAction(strns[n][1], sel, at));
            menu.add(mi);
        }
        return menu;
    }

    private JMenu getEvalParamFuncs(String title, String sel, int at) {
        JMenu menu = new JMenu(title);
        String[][] strns = AiFuncStrs.EvalParamFuncs;
        for (int n = 0; n < strns.length; ++n) {
            KMenuItem mi = new KMenuItem(strns[n][0]);
            mi.addActionListener(new FuncAction(strns[n][1], sel, at));
            menu.add(mi);
        }
        return menu;
    }

    private void insertParamStr(String str, int begin, int end) {
        try {
            this.textpane.setSelectionStart(begin);
            this.textpane.setSelectionEnd(end);
            this.textpane.replaceSelection(str + "\n");
        }
        catch (Exception e) {
            Cutter.setLog("    Exception:AiShaderHelp.insertParamStr()\n        " + e.toString());
            return;
        }
    }

    private class FuncAction
    implements ActionListener {
        String payload;
        String selection;
        int offset;

        public FuncAction(String text, String sel, int at) {
            this.payload = text;
            this.selection = sel;
            this.offset = at;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int span = this.offset - this.selection.length();
            KTextPane textpane = (KTextPane)BBxt.getTextPane();
            if (textpane == null) {
                Cutter.setLog("    Error:AiShaderHelp.actionPerformed() - textpane is null!");
                return;
            }
            Document doc = textpane.getDocument();
            if (doc == null) {
                Cutter.setLog("    Error:AiShaderHelp.actionPerformed() - textpane.getDocument() returned null!");
                return;
            }
            int numTabs = DocumentUtils.countTabStopsAtOffset(doc, this.offset);
            if (numTabs > 0) {
                AiShaderHelp.this.insertParamStr(this.payload, span, this.offset);
            } else {
                AiShaderHelp.this.insertParamStr("\t" + this.payload, span, this.offset);
            }
            if (this.payload.startsWith("AiParameterEnum")) {
                this.declareAiMenuItems(doc);
            } else if (this.payload.startsWith("AiParameterMtx")) {
                this.declareAiIndentity(doc);
            }
        }

        private void declareAiMenuItems(Document document) {
            String decl = "static const char* menu_items[] = { \"label_0\", \"label_1\", \"label_2\", NULL };\n";
            String text = BBxt.getWindowText();
            if (text != null && text.trim().length() > 0) {
                int[] result;
                int beginAt = 0;
                boolean doIgnoreCase = false;
                boolean doWholeWord = true;
                FinderUtils.FindDB db = FinderUtils.find(text, "static const char* menu_items[]", beginAt, doIgnoreCase, doWholeWord);
                if (db.absBegin != -1 && db.absEnd != -1) {
                    return;
                }
                db = FinderUtils.find(text, "node_parameters", beginAt, doIgnoreCase, doWholeWord);
                if (db.absBegin != -1 && db.absEnd != -1 && (result = DocumentUtils.getLineNumberAt(document, db.absEnd)) != null) {
                    AiShaderHelp.this.insertParamStr(decl, result[1], result[1]);
                }
            }
        }

        private void declareAiIndentity(Document document) {
            String decl = "\tAtMatrix identity_matrix = AiM4Identity();\n";
            String text = BBxt.getWindowText();
            if (text != null && text.trim().length() > 0) {
                int[] result;
                int beginAt = 0;
                boolean doIgnoreCase = false;
                boolean doWholeWord = true;
                FinderUtils.FindDB db = FinderUtils.find(text, "AtMatrix identity_matrix = AiM4Identity();", beginAt, doIgnoreCase, doWholeWord);
                if (db.absBegin != -1 && db.absEnd != -1) {
                    return;
                }
                db = FinderUtils.find(text, "node_parameters", beginAt, doIgnoreCase, doWholeWord);
                if (db.absBegin != -1 && db.absEnd != -1 && (result = DocumentUtils.getLineNumberAt(document, db.absEnd)) != null) {
                    AiShaderHelp.this.insertParamStr(decl, result[2], result[2]);
                }
            }
        }
    }
}

