/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.SolidAngleDev.Shaders;

import Preferences.Preferences;
import UI_Script.SolidAngleDev.Shaders.AiHeaderLookup;
import UI_Script.SolidAngleDev.Shaders.AiShaderTokenizer;
import UI_Script.SyntaxListener;
import UI_Text.KTextPane.KTextPane;
import UI_Text.Style.StyleEdits;
import java.awt.Color;
import javax.swing.text.StyleConstants;

public class AiShaderListener
extends SyntaxListener {
    public AiShaderListener(KTextPane textpane) {
        super(textpane, new AiShaderTokenizer());
        this.initDelimitors(textpane);
        this.initStyles(textpane);
    }

    @Override
    public void initStyles(KTextPane textpane) {
        super.initStyles(textpane);
        StyleConstants.setForeground(textpane.styleContext.languageStyle, Color.blue);
        StyleConstants.setForeground(textpane.styleContext.plainStyle, Preferences.getColor(Preferences.TEXT_COLOR_C_PLAIN));
        StyleConstants.setForeground(textpane.styleContext.commentStyle1, Preferences.getColor(Preferences.TEXT_COLOR_C_COMMENT));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle1, Preferences.getColor(Preferences.TEXT_COLOR_C_FUNCTION));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle2, Preferences.getColor(Preferences.TEXT_COLOR_C_DATATYPE));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle3, Preferences.getColor(Preferences.TEXT_COLOR_C_VARIABLE));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle4, Preferences.getColor(Preferences.TEXT_COLOR_C_VARIABLE).brighter());
        StyleConstants.setBold(textpane.styleContext.keywordStyle4, true);
        StyleConstants.setForeground(textpane.styleContext.stringStyle1, Preferences.getColor(Preferences.TEXT_COLOR_C_STRING));
        StyleConstants.setForeground(textpane.styleContext.stringStyle2, Preferences.getColor(Preferences.TEXT_COLOR_C_STRING));
    }

    @Override
    protected boolean customSyntax(String str, int begin, StyleEdits editList) {
        if (str.equals("AI_SHADER_NODE_EXPORT_METHODS") || str.equals("node_parameters") || str.equals("node_initialize") || str.equals("node_update") || str.equals("node_finish") || str.equals("shader_evaluate") || str.equals("node_loader")) {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.keywordStyle3, true);
            return true;
        }
        if (str.startsWith("AI_TYPE_") || str.startsWith("AI_NODE_") || str.startsWith("AI_VERSION_") || str.equals("AI_VERSION")) {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.keywordStyle3, true);
            return true;
        }
        if (AiHeaderLookup.tableGlobals.containsKey(str)) {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.keywordStyle4, true);
            return true;
        }
        return false;
    }
}

