/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.SolidAngleDev.Shaders;

import Preferences.Preferences;
import Processes.ProcListener;
import Processes.ProcessManager;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Desktop.KDesktop;
import UI_Script.BuildMsgListener;
import UI_Script.Help.KAbstractHelp;
import UI_Script.ScriptHandler;
import UI_Script.SolidAngleDev.Shaders.AiShaderHelp;
import UI_Script.SolidAngleDev.Shaders.AiShaderListener;
import UI_Script.SolidAngleDev.Shaders.AiShaderTokenizer;
import UI_Script.SolidAngleDev.Shaders.Mtd.AiMtdWriter;
import UI_Text.KTextPane.KCaret;
import UI_Text.KTextPane.KTextPane;
import UI_Tools.Monitor.Monitor;
import UI_Window.KWindow.KAbstractWindow;
import UI_Window.KWindow.KTextWindow;
import Utilities.DialogUtils;
import Utilities.DocumentUtils;
import Utilities.EnvUtils;
import Utilities.FileUtils;
import Utilities.KFileFilter;
import Utilities.RegExpUtils;
import Utilities.TextUtils;
import java.io.File;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class AiShaderScriptHandler
extends ScriptHandler
implements ProcListener {
    private String makefile_Name_OSX = "Makefile.arnoldShader_OSX";
    private String makefile_Name_LIN = "Makefile.arnoldShader_LINUX";
    private String makefile_Name_WIN = "Build_arnoldShader.bat";
    protected File cppSrcFile = null;
    private String usersMakefileName = "";
    protected boolean failure = false;
    public static final String[] errorStrs = new String[]{"error", "Undefined Symbols"};
    protected Vector<BuildMsgListener> buildListeners = new Vector();
    String currentBuildDirPath;
    String currentDsoName;

    public void addBuildListener(BuildMsgListener bl) {
        for (int n = 0; n < this.buildListeners.size(); ++n) {
            if (this.buildListeners.elementAt(n) != bl) continue;
            return;
        }
        this.buildListeners.add(bl);
    }

    public void removeBuildListener(BuildMsgListener bl) {
        this.buildListeners.remove(bl);
    }

    public AiShaderScriptHandler() {
        this.ext = new String[2];
        this.ext[0] = ".cpp";
        this.ext[1] = ".CPP";
        this.setTokenizer();
    }

    @Override
    public String getSyntaxListenerClassName(KTextPane textpane) {
        return AiShaderListener.class.getName();
    }

    @Override
    public boolean canHandle(File file) {
        if (file == null) {
            return false;
        }
        String path = file.getPath();
        if (path == null) {
            return false;
        }
        String srcText = FileUtils.read(path);
        if (srcText == null || srcText.trim().length() == 0) {
            return false;
        }
        return RegExpUtils.split(srcText, "(AI_SHADER_NODE_EXPORT_METHODS)") != null;
    }

    @Override
    public File convertSelectionToFile(String sel) {
        File userSrcDir;
        File f = super.convertSelectionToFile(sel);
        if (f != null) {
            return f;
        }
        String p = Preferences.get(Preferences.PATH_DEVKIT_USER_INCLUDE_DIRECTORIES);
        if (p != null && p.trim().length() > 0 && (f = new File(userSrcDir = new File(p), sel)).exists()) {
            return f;
        }
        return null;
    }

    @Override
    public void execute(String str) {
    }

    @Override
    public void execute(File file) {
        if (file == null) {
            return;
        }
        this.cppSrcFile = file;
        Cutter.setLog("    Debug: AiShaderScriptHandler.execute() - cppSrcFile \"" + this.cppSrcFile.getPath() + "\"");
        String devkitPath = Preferences.get(Preferences.PATH_ARNOLD_DEVKIT);
        String buildDirPath = Preferences.get(Preferences.PATH_ARNOLD_USER_SHADER_DST);
        Cutter.setLog("    Debug: AiShaderScriptHandler.execute() - buildDirPath \"" + buildDirPath + "\"");
        if (buildDirPath.trim().length() == 0) {
            buildDirPath = this.cppSrcFile.getParent();
            if (EnvUtils.isWinEnvironment()) {
                buildDirPath = buildDirPath.replace('\\', '/');
                devkitPath = devkitPath.replace('\\', '/');
                Cutter.setLog("    Debug: AiShaderScriptHandler.execute() - buildDirPath \"" + buildDirPath + "\"");
                Cutter.setLog("    Debug: AiShaderScriptHandler.execute() - devkitPath \"" + devkitPath + "\"");
            }
        }
        Cutter.setLog("    Debug: AiShaderScriptHandler.execute() - post buildDirPath \"" + buildDirPath + "\"");
        String dsoName = TextUtils.removeExtension(this.cppSrcFile.getName());
        String dsoExt = EnvUtils.isWinEnvironment() ? ".dll" : ".so";
        String dsoFullName = dsoName + dsoExt;
        String dsoDestPath = new File(buildDirPath, dsoFullName).getPath();
        this.updateNodeName(dsoName);
        String cppSrcName = this.cppSrcFile.getName();
        String cppSrcPath = this.cppSrcFile.getPath();
        String cppSrcParentDirPath = this.cppSrcFile.getParent();
        Cutter.setLog("    Debug: AiShaderScriptHandler.execute() - cppSrcParentDirPath \"" + cppSrcParentDirPath + "\"");
        File template = this.getTemplateMakefile();
        if (template == null) {
            Cutter.setLog("    Error: AiShaderScriptHandler.execute() - getTemplateMakefile() returned null");
            this.noTemplateError();
            return;
        }
        String makeStr = FileUtils.read(template);
        makeStr = makeStr.replaceAll("(__DEVKIT_PATH__)", devkitPath);
        makeStr = makeStr.replaceAll("(__CPP_SRC_PATH__)", cppSrcPath);
        makeStr = makeStr.replaceAll("(__DSO_DEST_PATH__)", dsoDestPath);
        makeStr = makeStr.replaceAll("(__SRC_FILENAME__)", dsoName);
        String cppSrcPathWin = new File(cppSrcParentDirPath, dsoName).getPath();
        cppSrcPathWin = TextUtils.trimTrailingChar(cppSrcPathWin, '\\');
        if (EnvUtils.isWinEnvironment()) {
            cppSrcPathWin = cppSrcPathWin.replace('\\', '/');
        }
        makeStr = makeStr.replaceAll("(__DSO_TEMP_DEST_PATH__)", cppSrcPathWin);
        this.usersMakefileName = !EnvUtils.isWinEnvironment() ? "Makefile." + dsoName : "Build_" + dsoName + ".bat";
        File usersMakeFile = new File(this.cppSrcFile.getParentFile(), this.usersMakefileName);
        Cutter.setLog("    Debug: AiShaderScriptHandler.execute() - buildDirPath \"" + buildDirPath + "\"");
        Cutter.setLog("    Debug: AiShaderScriptHandler.execute() - cppSrcParentDirPath \"" + cppSrcParentDirPath + "\"");
        if (EnvUtils.isWinEnvironment()) {
            String winEnvScript = this.getTemplateWinEnvScript();
            if (winEnvScript.trim().length() == 0) {
                Cutter.setLog("    Error: AiShaderScriptHandler.execute() - getTemplateWinEnvScript() failed!");
                return;
            }
            if (!buildDirPath.equals(cppSrcParentDirPath)) {
                makeStr = makeStr + "\n";
                makeStr = makeStr + "move " + dsoName + ".dll \"" + buildDirPath + "\\" + dsoName + ".dll\"\n";
                makeStr = makeStr + "echo \"" + buildDirPath + "\\" + dsoName + ".dll\"\n";
            }
            String fullBatText = winEnvScript + "\t\n" + makeStr.replace('/', '\\');
            FileUtils.writeFile(usersMakeFile, fullBatText);
            String[] item = new String[]{"cmd", "/Q", "/C", usersMakeFile.getName()};
            if (Cutter.input.debug) {
                // empty if block
            }
            ProcessManager fp = new ProcessManager(this.getScriptName());
            fp.launch(item, this.cppSrcFile.getParentFile(), true, this, false);
        } else {
            FileUtils.writeFile(usersMakeFile, makeStr);
            ProcessManager fp = new ProcessManager(this.getScriptName());
            String[] item = new String[]{"make", "-f", usersMakeFile.getName()};
            fp.launch(item, this.cppSrcFile.getParentFile(), true, this, false);
        }
        this.currentBuildDirPath = buildDirPath;
        this.currentDsoName = dsoName;
    }

    private boolean updateNodeName(String dsoName) {
        KAbstractWindow win = BBxt.frontWindow();
        if (win == null || !(win instanceof KTextWindow)) {
            return false;
        }
        KTextWindow ktw = (KTextWindow)win;
        KCaret caret = BBxt.getKCaret();
        int dot = caret.getDot();
        Document doc = ktw.getTextPane().getDocument();
        if (doc == null) {
            return false;
        }
        String[] lines = DocumentUtils.getParagraphs(doc, 0, doc.getLength());
        if (lines == null) {
            return false;
        }
        for (int n = 0; n < lines.length; ++n) {
            String line = lines[n];
            if (!line.trim().startsWith("node->name")) continue;
            String newLine = "\tnode->name           = \"" + dsoName + "\";\n";
            int[] offsets = DocumentUtils.getOffsetsOfLine(doc, n + 1);
            try {
                doc.remove(offsets[1], offsets[0]);
                doc.insertString(offsets[1], newLine, null);
                ktw.saveFile();
                BBxt.setSelection(dot, dot);
                continue;
            }
            catch (BadLocationException ex) {
                Cutter.setLog("    Exception:Ai.updateAssOnDesktop() - " + ex.toString());
            }
        }
        return true;
    }

    protected File getTemplateMakefile() {
        File pwd = FileUtils.getPWDFile();
        File f = null;
        if (EnvUtils.isWinEnvironment()) {
            f = new File(pwd, "custom_templates/Bat/" + this.makefile_Name_WIN);
            if (!f.exists()) {
                f = new File(pwd, "Cutter_Help/templates/Bat/" + this.makefile_Name_WIN);
            } else {
                Cutter.setLog("    Info:AiShaderScriptHandler.getTemplateMakefile() - using custom template.");
            }
        } else if (EnvUtils.isOSXEnvironment()) {
            f = new File(pwd, "custom_templates/MakeFile/" + this.makefile_Name_OSX);
            if (!f.exists()) {
                f = new File(pwd, "Cutter_Help/templates/MakeFile/" + this.makefile_Name_OSX);
            } else {
                Cutter.setLog("    Info:AiShaderScriptHandler.getTemplateMakefile() - using custom template.");
            }
        } else {
            f = new File(pwd, "custom_templates/MakeFile/" + this.makefile_Name_LIN);
            if (!f.exists()) {
                f = new File(pwd, "Cutter_Help/templates/MakeFile/" + this.makefile_Name_LIN);
            } else {
                Cutter.setLog("    Info:AiShaderScriptHandler.getTemplateMakefile() - using custom template.");
            }
        }
        return !f.exists() ? null : f;
    }

    protected String getTemplateWinEnvScript() {
        String WinEnvScript = null;
        String varspath = Preferences.get(Preferences.PATH_CPP_VCVARSX86_AMD64_BAT);
        if (varspath.trim().length() == 0) {
            String[] msg = new String[]{"To build a plugin Cutter reads a vcvars bat file normally located at,", "\"Microsoft Visual Studio 14.0/VC/bin/amd64_x86/vcvarsamd64_x86.bat\"", "The path to this bat file has not been specified in Cutter's Preferences", "    Languages->Cpp", "Or, the wrong path has been specified.\n"};
            DialogUtils.showErrorMessage("Path to vcvars bat not Set in Prefs", msg);
            return "";
        }
        File f = new File(varspath);
        if (f == null || !f.exists()) {
            String[] msg = new String[]{"To build a plugin Cutter reads a vcvars bat file normally located at,", "\"Microsoft Visual Studio 14.0/VC/bin/amd64_x86/vcvarsamd64_x86.bat\"", "The path to this bat file does NOT exist.\n"};
            DialogUtils.showErrorMessage("Cannot File vcvars bat", msg);
            return "";
        }
        if (f.isDirectory()) {
            String[] msg = new String[]{"To build a plugin Cutter reads a vcvars bat file normally located at,", "\"Microsoft Visual Studio 14.0/VC/bin/amd64_x86/vcvarsamd64_x86.bat\"", "The path to this bat file has not been specified correctly in ", "Cutter's Preferences", "    Languages->Cpp", "The path incorrectly specified is,", "\"" + varspath + "\"\n"};
            DialogUtils.showErrorMessage("Path to vcvars bat Incorrectly Set in Prefs", msg);
            return "";
        }
        WinEnvScript = FileUtils.read(f);
        WinEnvScript = "@call \"" + varspath + "\"";
        if (WinEnvScript == null || WinEnvScript.trim().length() == 0) {
            String[] msg = new String[]{"To build a plugin Cutter reads a vcvars bat file normally located at,", "\"Microsoft Visual Studio 14.0/VC/bin/amd64_x86/vcvarsamd64_x86.bat\"", "The file appears to be empty.\n"};
            DialogUtils.showErrorMessage("Empty vcvars bat ??", msg);
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(WinEnvScript);
        Cutter.setLog("    Info:DevkitScriptHandler.getTemplateWinEnvScript() - WinEnvCommand is\n" + WinEnvScript + "\n");
        return WinEnvScript == null ? "" : buf.toString();
    }

    protected void noTemplateError() {
        String templateName = this.makefile_Name_WIN;
        if (EnvUtils.isOSXEnvironment()) {
            templateName = this.makefile_Name_OSX;
        } else if (EnvUtils.isLinuxEnvironment()) {
            templateName = this.makefile_Name_LIN;
        }
        String language = this.ext[0] == ".c" || this.ext[1] == ".C" ? "C" : "C++";
        JOptionPane.showMessageDialog(KDesktop.desktopPane, "\nCutter references a template makefile when compiling a '" + language + "'\nlanguage file that implements a Arnold shader.\nCutter searches the following directories for the template:\n        \"custom_templates/Bat\",\n        \"Cutter_Help/templates/Bat\"\nThe template must be named \"" + templateName + "\" and\nwithout it Cutter cannot continue.\n\n", "Error - Cannot Find Template File", 0);
    }

    @Override
    public KAbstractHelp getHelper(KTextPane textpane) {
        KAbstractHelp.add(textpane.helper);
        return KAbstractHelp.getInstanceByName(AiShaderHelp.class.getName(), textpane);
    }

    @Override
    protected void setTokenizer() {
        this.tokenizer = new AiShaderTokenizer();
    }

    @Override
    public KFileFilter getFileFilter() {
        return null;
    }

    @Override
    public String getExecuteLabel() {
        return "Build Arnold Shader";
    }

    @Override
    public String getMakeLabel() {
        return null;
    }

    @Override
    public String getRunLabel() {
        return null;
    }

    @Override
    protected void make(File srcDir) {
    }

    @Override
    protected void run() {
    }

    @Override
    public void deleteTmpFile() {
        File tmp = new File(FileUtils.getPWD(), "temp.cpp");
        if (tmp.exists()) {
            tmp.delete();
        }
    }

    @Override
    public String getScriptName() {
        return "Arnold Shader";
    }

    @Override
    public JMenuItem getOpenFileMenuItem() {
        return null;
    }

    @Override
    public boolean canRunSelection() {
        return false;
    }

    private boolean failureHappened(String output) {
        for (int n = 0; n < errorStrs.length; ++n) {
            if (!TextUtils.contains(output, errorStrs[n], true)) continue;
            for (int i = 0; i < this.buildListeners.size(); ++i) {
                this.buildListeners.elementAt(i).buildFailed("SolidAngle Devkit: Build Failed 2");
            }
            return true;
        }
        return false;
    }

    @Override
    public void processStarted(String procName, String[] progarray, String procID) {
        this.failure = false;
        Monitor.initErrorStrings(this.getScriptName(), errorStrs);
        for (int n = 0; n < this.buildListeners.size(); ++n) {
            this.buildListeners.elementAt(n).buildStarted();
        }
    }

    @Override
    public void processSentString(String procName, String output) {
        if (this.failure) {
            return;
        }
        this.failure = this.failureHappened(output);
        for (int n = 0; n < this.buildListeners.size(); ++n) {
            this.buildListeners.elementAt(n).buildSentString(output);
        }
    }

    @Override
    public void processFinished(String[] progarray) {
        String boolStr;
        if (!this.failure) {
            String msg = "\nBuild Successful.\n";
            for (int n = 0; n < this.buildListeners.size(); ++n) {
                this.buildListeners.elementAt(n).buildFinished(msg.trim());
            }
        } else {
            for (int n = 0; n < this.buildListeners.size(); ++n) {
                this.buildListeners.elementAt(n).buildFinished("SolidAngle Devkit: Build Failed");
            }
        }
        if ((boolStr = Preferences.get(Preferences.CPP_MAKEFILE_CLEANUP)).equals("true")) {
            File makeFile = new File(this.cppSrcFile.getParent(), this.usersMakefileName);
            makeFile.delete();
        }
        Cutter.setLog("    Debug: AiShaderScriptHandler.processFinished() - calling writeMtdFile()");
        AiMtdWriter.writeFiles(this.currentBuildDirPath, this.currentDsoName);
    }
}

