/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.SolidAngleDev.Shaders.Mtd;

import UI_Desktop.Cutter;
import Utilities.FileUtils;
import Utilities.TextUtils;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;

public class AiMtdFileParser {
    public Hashtable<String, AttrDBItem> attrDB = null;
    private File mtdFile = null;

    public AiMtdFileParser(File mtdFile) {
        this.mtdFile = mtdFile;
    }

    public Hashtable<String, AttrDBItem> parseFile() {
        this.attrDB = new Hashtable();
        if (!this.mtdFile.exists()) {
            return this.attrDB;
        }
        Enumeration<String> e = FileUtils.readLines(this.mtdFile.getPath());
        if (e == null || !e.hasMoreElements()) {
            return this.attrDB;
        }
        int lineCounter = 0;
        boolean attrBlockIsOpen = false;
        AttrDBItem item = null;
        while (e.hasMoreElements()) {
            String line = e.nextElement();
            if (line == null) continue;
            try {
                line = line.strip();
            }
            catch (NoSuchMethodError err) {
                Cutter.setLog("    Exception: AiMtdFileParser.parseFile() " + err);
            }
            if (line.startsWith("[") && line.endsWith("]")) {
                line = line.substring(1, line.length() - 1);
                if ((line = line.strip()).startsWith("attr ")) {
                    if (item != null) {
                        item.setAttrEndLine(lineCounter);
                        this.attrDB.put(item.name, item);
                    }
                    String attrName = line.substring(5);
                    item = new AttrDBItem(attrName);
                    item.attrBeginLine = lineCounter;
                }
            } else if (item != null) {
                if (line.startsWith("#")) {
                    item.attrBlock.append(line).append("\n");
                } else {
                    item.attrBlock.append("\t\t").append(line).append("\n");
                }
            }
            ++lineCounter;
        }
        if (item != null) {
            item.setAttrEndLine(lineCounter);
            this.attrDB.put(item.name, item);
        }
        return this.attrDB;
    }

    public class AttrDBItem {
        public String name = "";
        public String attrName = "";
        public int attrBeginLine = -1;
        private int attrEndLine = -1;
        public StringBuffer attrBlock = new StringBuffer();
        public boolean isMaya = true;

        public void setAttrEndLine(int n) {
            this.attrEndLine = n;
            String[] str = TextUtils.tokenize(this.attrBlock.toString(), '\n');
            for (int i = 0; i < str.length; ++i) {
                if (!str[i].trim().startsWith("houdini")) continue;
                this.isMaya = false;
            }
        }

        public String toString() {
            return this.attrBlock.toString();
        }

        public AttrDBItem(String name) {
            this.attrName = "\t[attr " + name + "]";
            this.name = name;
        }
    }
}

