/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.SolidAngleDev.Shaders.Mtd;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Script.SolidAngleDev.Shaders.Mtd.AiMtdFileParser;
import UI_Script.SolidAngleDev.Shaders.Mtd.AiNodeParametersParser;
import UI_Window.KWindow.KAbstractWindow;
import UI_Window.KWindow.KTextWindow;
import Utilities.FileUtils;
import Utilities.MayaNodeIdUtils;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class AiMtdWriter {
    public static void writeFiles(String buildDirPath, String dsoName) {
        int[] ids = MayaNodeIdUtils.getAllUsedNodeIds();
        if (ids == null) {
            Cutter.setLog("    Debug: AiShaderScriptHandler.writeMtdFile() - MayaNodeIdUtils.getAllUsedNodeIds() returned null.");
        } else {
            Cutter.setLog("    Debug: AiShaderScriptHandler.writeMtdFile() - MayaNodeIdUtils.getAllUsedNodeIds() returned " + ids.length + " ids.");
        }
        int maya_id = MayaNodeIdUtils.getMinNodeId();
        if (ids != null) {
            maya_id = MayaNodeIdUtils.getFirstAvailable(ids);
        }
        boolean mtdStyleIsMaya = Preferences.get(Preferences.ARNOLD_DEVKIT_MTD_STYLE).equalsIgnoreCase("MAYA");
        File mtdFile = new File(buildDirPath, dsoName + ".mtd");
        Document srcDoc = AiMtdWriter.getSouceCodeDoc();
        AiMtdFileParser mtdFileParser = new AiMtdFileParser(mtdFile);
        Hashtable<String, AiMtdFileParser.AttrDBItem> tableOfFileAttrs = mtdFileParser.parseFile();
        AiNodeParametersParser parm_parser = new AiNodeParametersParser(srcDoc, mtdStyleIsMaya);
        String attrsText = parm_parser.getMtdAttrsText(tableOfFileAttrs);
        Vector<AiNodeParametersParser.NodeParameter> listOfParms = parm_parser.getDeclaredParms();
        AiMtdWriter.writeMtd(mtdFile, dsoName, maya_id, mtdStyleIsMaya, attrsText);
    }

    private static void writeMtd(File mtdFile, String dsoName, int maya_id, boolean mtdStyleIsMaya, String attrsText) {
        StringBuffer b = new StringBuffer();
        if (mtdStyleIsMaya) {
            b.append("# This .mtd file is intended for use with Maya. If your shader will be used by\n");
            b.append("# Houdini the \"style\" of the .mtd can be set in Preferences->Languages->Arnold SDK.\n");
        } else {
            b.append("# This .mtd file is intended for use with Houdini. If your shader will be used by\n");
            b.append("# Maya the \"style\" of the .mtd can be set in Preferences->Languages->Arnold SDK.\n");
        }
        b.append("# \n");
        b.append("# This file is automatically updated by Cutter when its corresponding shader\n");
        b.append("# is compiled.\n\n");
        b.append("[").append("node ").append(dsoName).append("]\n");
        if (mtdStyleIsMaya) {
            b.append("\tmaya.id").append("\t\t\t\t").append("INT").append("\t\t").append(maya_id).append("\n");
            b.append("\tmaya.name").append("\t\t\t").append("STRING").append("\t").append("\"" + dsoName + "\"\n");
            b.append("\tmaya.classification").append("\t").append("STRING").append("\t").append("\"Utility\"\n");
        } else {
            b.append("\thoudini.icon").append("\t\t").append("STRING").append("\t").append("\"VOP_" + dsoName + "\"\n");
            b.append("\thoudini.category").append("\t").append("STRING").append("\t").append("\"Utility\"\n");
            b.append("\thoudini.help_url").append("\t").append("STRING").append("\t").append("\"\"\n");
        }
        final KAbstractWindow kaw = KAbstractDesktop.getWindowWithFile(mtdFile);
        if (kaw != null) {
            kaw.saveFile();
        }
        b.append(attrsText);
        FileUtils.writeFile(mtdFile, b.toString());
        if (kaw != null) {
            try {
                final String str = b.toString();
                JEditorPane textpane = BBxt.getTextPane(kaw);
                if (textpane != null) {
                    textpane.setSelectionStart(0);
                    textpane.setSelectionEnd(textpane.getDocument().getLength());
                    final Document document = textpane.getDocument();
                    if (document != null) {
                        try {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        document.remove(0, document.getLength());
                                        document.insertString(0, str, null);
                                        kaw.saveFile();
                                    }
                                    catch (BadLocationException ex) {
                                        Cutter.setLog("    Exception: AiMtdWriter.writeFile() - " + ex.toString());
                                    }
                                }
                            });
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (Exception e) {
                Cutter.setLog("    Exception: AiMtdWriter.writeFile() - " + e.toString());
            }
        }
    }

    private static Document getSouceCodeDoc() {
        KAbstractWindow win = BBxt.frontWindow();
        if (win == null || !(win instanceof KTextWindow)) {
            return null;
        }
        KTextWindow ktw = (KTextWindow)win;
        return ktw.getTextPane().getDocument();
    }
}

