/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.SolidAngleDev.Shaders.Mtd;

import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Script.SolidAngleDev.Shaders.Mtd.AiMtdFileParser;
import UI_Text.KTextPane.KTextPane;
import Utilities.DocumentUtils;
import Utilities.FinderUtils;
import Utilities.TextUtils;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.text.Document;
import javax.swing.text.Segment;

public class AiNodeParametersParser {
    static final int byteID = 0;
    static final int intID = 1;
    static final int uintID = 2;
    static final int boolID = 3;
    static final int floatID = 4;
    static final int rgbID = 5;
    static final int rgbaID = 6;
    static final int vecID = 7;
    static final int vec2ID = 8;
    static final int strID = 9;
    static final int ptrID = 10;
    static final int nodeID = 11;
    static final int arrayID = 12;
    static final int mtxID = 13;
    static final int enumID = 14;
    static final int closureID = 15;
    static Hashtable<String, Integer> table = new Hashtable();
    static boolean mtdStyleIsMaya;
    public Vector<NodeParameter> listOfDeclaredParms = new Vector();
    Document srcDocument;

    public AiNodeParametersParser(Document srcDocument, boolean mtdStyleIsMaya) {
        this.srcDocument = srcDocument;
        AiNodeParametersParser.mtdStyleIsMaya = mtdStyleIsMaya;
        this.initListOfDeclaredParms();
    }

    public Vector<NodeParameter> getDeclaredParms() {
        return this.listOfDeclaredParms;
    }

    private void initListOfDeclaredParms() {
        int beginAt = 0;
        boolean doIgnoreCase = false;
        boolean doWholeWord = true;
        String text = BBxt.getWindowText();
        FinderUtils.FindDB db = FinderUtils.find(text, "node_parameters", beginAt, doIgnoreCase, doWholeWord);
        if (db.absBegin == -1 || db.absEnd == -1) {
            return;
        }
        beginAt = db.absEnd;
        db = FinderUtils.find(text, "{", beginAt, doIgnoreCase, doWholeWord);
        if (db.absBegin == -1 || db.absEnd == -1) {
            return;
        }
        int openBlockIndex = db.absEnd;
        beginAt = db.absEnd;
        db = FinderUtils.find(text, "}", beginAt, doIgnoreCase, doWholeWord);
        if (db.absBegin == -1 || db.absEnd == -1) {
            return;
        }
        int closeBlockIndex = db.absBegin - 1;
        Segment segment = new Segment();
        DocumentUtils.getSegment(this.srcDocument, openBlockIndex, closeBlockIndex, segment);
        if (segment == null || segment.length() == 0) {
            return;
        }
        String block = segment.toString().trim();
        String[] lines = TextUtils.tokenize(block, "\n");
        if (lines == null || lines.length == 0) {
            return;
        }
        for (int n = 0; n < lines.length; ++n) {
            try {
                this.listOfDeclaredParms.add(new NodeParameter(lines[n].trim()));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getMtdAttrsText(Hashtable<String, AiMtdFileParser.AttrDBItem> tableOfFileAttrs) {
        StringBuffer b = new StringBuffer();
        for (int n = 0; n < this.listOfDeclaredParms.size(); ++n) {
            NodeParameter np = this.listOfDeclaredParms.elementAt(n);
            AiMtdFileParser.AttrDBItem item = tableOfFileAttrs.get(np.parmName);
            if (item != null) {
                if (item.isMaya == mtdStyleIsMaya) {
                    b.append(item.attrName).append("\n");
                    b.append(item.attrBlock.toString());
                    continue;
                }
                if (item.isMaya == mtdStyleIsMaya && !item.isMaya == !mtdStyleIsMaya) continue;
                b.append(np.toString());
                continue;
            }
            b.append(np.toString());
        }
        return b.toString();
    }

    private static void insertStr(KTextPane textpane, String str, int begin, int end) {
        try {
            textpane.setSelectionStart(begin);
            textpane.setSelectionEnd(end);
            textpane.replaceSelection(str + "\n");
        }
        catch (Exception e) {
            Cutter.setLog("    Exception:AiShader.insertStr()\n        " + e.toString());
            return;
        }
    }

    static {
        table.put("AiParameterByte", 0);
        table.put("AiParameterInt", 1);
        table.put("AiParameterUInt", 2);
        table.put("AiParameterBool", 3);
        table.put("AiParameterFlt", 4);
        table.put("AiParameterRGB", 5);
        table.put("AiParameterRGBA", 6);
        table.put("AiParameterVec", 7);
        table.put("AiParameterVec2", 8);
        table.put("AiParameterStr", 9);
        table.put("AiParameterPtr", 10);
        table.put("AiParameterNode", 11);
        table.put("AiParameterArray", 12);
        table.put("AiParameterMtx", 13);
        table.put("AiParameterEnum", 14);
        table.put("AiParameterClosure", 15);
    }

    public class NodeParameter {
        public int aiType;
        public String aiName;
        public String parmName;
        public String[] args;
        public Hashtable<String, String[]> uiHints = new Hashtable();

        public NodeParameter(String declaration) throws Exception {
            String[] hintParts;
            int index = declaration.indexOf("(");
            if (index == -1) {
                throw new Exception("Cannot find open parenthesis.");
            }
            this.aiName = declaration.substring(0, index);
            if (!table.containsKey(this.aiName)) {
                throw new Exception("Cannot find \"" + this.aiName + "\"");
            }
            this.aiType = table.get(this.aiName);
            this.args = TextUtils.tokenize(declaration.substring(index + 1), ",");
            for (int n = 0; n < this.args.length; ++n) {
                this.args[n] = TextUtils.removeQuotes(this.args[n]);
            }
            this.parmName = this.args[0];
            index = declaration.indexOf(";");
            if (index == -1) {
                throw new Exception("declaration of " + this.parmName + " does not conclude with \";\"");
            }
            String[] parts = TextUtils.tokenize(declaration, ';');
            String state = "closed";
            if (parts.length == 2 && (hintParts = TextUtils.tokenize(parts[1], ':')).length >= 2) {
                String hint = hintParts[0].trim();
                String value = hintParts[1].trim();
                value = TextUtils.removeQuotes(value).trim();
                hint = TextUtils.trim(hint, "//").trim();
                if (hintParts.length == 3) {
                    state = hintParts[2].trim();
                }
                String[] value_state = new String[]{value, state};
                this.uiHints.put(hint, value_state);
            }
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            b.append("\t[attr ").append(this.args[0]).append("]\n");
            if (mtdStyleIsMaya) {
                b.append("\t\t").append("maya.name").append("\t\tSTRING\t\"").append(this.args[0]).append("\"\n");
            } else {
                b.append("\t\t").append("houdini.label").append("\tSTRING\t\"").append(this.args[0]).append("\"\n");
            }
            b.append("#\t\t").append("desc\t").append("\t\tSTRING\t").append("\"\"\n");
            switch (this.aiType) {
                case 1: {
                    b.append("#\t\t").append("min\t").append("\t\t\tINT\t").append("0\n");
                    b.append("#\t\t").append("max\t").append("\t\t\tINT\t").append("10\n");
                    b.append("#\t\t").append("softmin\t").append("\t\tINT\t").append("0\n");
                    b.append("#\t\t").append("softmax\t").append("\t\tINT\t").append("10\n");
                    break;
                }
                case 4: {
                    b.append("#\t\t").append("min\t").append("\t\t\tFLOAT\t").append("0\n");
                    b.append("#\t\t").append("max\t").append("\t\t\tFLOAT\t").append("1\n");
                    b.append("#\t\t").append("softmin\t").append("\t\tFLOAT\t").append("0\n");
                    b.append("#\t\t").append("softmax\t").append("\t\tFLOAT\t").append("1\n");
                    break;
                }
            }
            return b.toString();
        }
    }
}

