/*
 * Decompiled with CFR 0.152.
 */
package UI_Script;

import UI_Desktop.Cutter;
import UI_Script.Comment;
import UI_Script.Escape;
import UI_Script.Quotation;
import UI_Text.Style.KStyleContext;
import Utilities.DocumentUtils;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import kernal.Tokenizers.Tokenizer;

public class Syntax {
    public int preUpdate = 0;
    public int postUpdate = 0;
    protected Tokenizer tok = null;
    public int currWordBegin = 0;
    public int beginParse = 0;
    public int endParse = -1;
    public int preUpdateAt = 0;
    public int postUpdateAt = 0;
    public int preUpdateStyleID = 0;
    public int postUpdateStyleID = 0;
    public Comment prevActiveCmnt = null;
    public int prevBeginCmnt = 0;
    public int prevEndCmnt = 0;
    public Comment activeCmnt = null;
    public int beginCmnt = 0;
    public int endCmnt = 0;
    public Quotation prevActiveQuot = null;
    public Quotation activeQuot = null;
    public int beginQuot = 0;
    public Escape prevActiveEscape = null;
    public Escape activeEscape = null;
    public int beginEscape = 0;
    public char preUpdateChar = (char)48;
    public char postUpdateChar = (char)48;
    protected Segment segment = null;
    protected boolean preUpdateDone = false;

    public void lookBack(int n, char prevChar, char c0, char c1, char c2, char c3) {
    }

    public void lookForward(int n, char prevChar, char c0, char c1, char c2, char c3) {
    }

    public Syntax(Document doc) {
        this.segment = DocumentUtils.getSegment(doc, 0, doc.getLength());
    }

    public Syntax(Document doc, Tokenizer tok, int preUpdate, int postUpdate) {
        this.segment = DocumentUtils.getSegment(doc, 0, doc.getLength());
        this.preUpdate = preUpdate;
        this.postUpdate = postUpdate;
        this.tok = tok;
        if (preUpdate - 1 >= this.segment.offset) {
            this.preUpdateChar = this.segment.array[preUpdate - 1 + this.segment.offset];
        }
        this.postUpdateChar = this.segment.array[postUpdate + this.segment.offset];
    }

    public void close() {
    }

    public int findClosingComment() {
        if (this.activeCmnt == null || this.segment == null) {
            return -1;
        }
        return this.activeCmnt.findCloseComment(this.segment, this.preUpdateAt);
    }

    public int findClosingComment(Comment tmpCmnt, int beginAt) {
        if (tmpCmnt == null || this.segment == null) {
            return -1;
        }
        int offset = tmpCmnt.findCloseComment(this.segment, beginAt);
        return offset;
    }

    public int findClosingQuotation(Quotation tmpQuot, int beginAt) {
        if (tmpQuot == null || this.segment == null) {
            return -1;
        }
        int offset = tmpQuot.findCloseQuotation(this.segment, beginAt);
        return offset;
    }

    public int findClosingQuotation() {
        if (this.activeQuot == null || this.segment == null) {
            return -1;
        }
        return this.activeQuot.findCloseQuotation(this.segment, this.preUpdateAt);
    }

    public boolean preUpdateCheckPoint(boolean escape, boolean comment, boolean string, boolean doLog, int offset) {
        if (this.preUpdateDone) {
            return false;
        }
        if (comment) {
            this.preUpdateStyleID = 1;
            this.postUpdateStyleID = 1;
        } else if (string) {
            this.preUpdateStyleID = 10;
            this.postUpdateStyleID = 10;
        } else if (escape) {
            this.preUpdateStyleID = 16;
            this.postUpdateStyleID = 16;
        }
        this.preUpdateDone = true;
        if (doLog) {
            Cutter.setLog("Syntax.preUpdateCheckPoint() \"preUpdate\" at: " + offset + this.toString());
        }
        return true;
    }

    public void postUpdateCheckPoint(boolean escape, boolean comment, boolean string, boolean doLog) {
        if (comment) {
            this.postUpdateStyleID = 1;
        }
        if (string) {
            this.postUpdateStyleID = 10;
        }
        if (!comment && !string) {
            this.postUpdateStyleID = 0;
        }
        if (escape) {
            this.postUpdateStyleID = 16;
        } else if (doLog) {
            Cutter.setLog("Syntax.postUpdateCheckPoint()\n   not setting postUpdateStyleID");
        }
        if (doLog) {
            Cutter.setLog("Syntax.postUpdateCheckPoint()" + this.toString());
        }
    }

    public boolean isOpenComment(int n) {
        if (this.preUpdate == this.postUpdate && this.preUpdateDone) {
            return false;
        }
        this.activeCmnt = this.tok.isOpenComment(this.segment, n);
        return this.activeCmnt != null;
    }

    public boolean isCloseComment(int n) {
        if (this.activeCmnt == null) {
            return false;
        }
        if (n < this.beginCmnt + this.activeCmnt.openLen + this.activeCmnt.closeLen) {
            return false;
        }
        return this.activeCmnt._isCloseComment(this.segment, n);
    }

    public boolean isOpenEscape(int n) {
        if (this.preUpdate == this.postUpdate && this.preUpdateDone) {
            return false;
        }
        this.activeEscape = this.tok.isOpenEscape(this.segment, n);
        return this.activeEscape != null;
    }

    public boolean isCloseEscape(int n) {
        if (this.activeEscape == null) {
            return false;
        }
        if (n < this.beginEscape + this.activeEscape.openLen + this.activeEscape.closeLen) {
            return false;
        }
        return this.activeEscape._isCloseEscape(this.segment, n);
    }

    public boolean isOpenQuotation(int n) {
        if (this.preUpdate == this.postUpdate && this.preUpdateDone) {
            return false;
        }
        this.activeQuot = this.tok.isOpenQuotation(this.segment, n);
        return this.activeQuot != null;
    }

    public boolean isOpenQuotation(String str) {
        if (this.activeQuot == null) {
            return false;
        }
        return this.activeQuot.isOpenQuotation(str);
    }

    public boolean isCloseQuotation(int n) {
        if (this.activeQuot == null) {
            return false;
        }
        if (n < this.beginQuot + this.activeQuot.openLen + this.activeQuot.closeLen) {
            return false;
        }
        return this.activeQuot._isCloseQuotation(this.segment, n);
    }

    public boolean isCloseQuotation(String str) {
        if (this.activeQuot == null) {
            return false;
        }
        return this.activeQuot.isCloseQuotation(str);
    }

    public boolean containsEscapedQuotation(String str) {
        if (this.activeQuot == null) {
            return false;
        }
        return this.activeQuot.containsEscapedQuotation(str);
    }

    public boolean endsWithEscape(String str) {
        if (this.activeQuot == null) {
            return false;
        }
        return this.activeQuot.endsWithEscape(str);
    }

    public boolean isQuotationEscapeChar(char c) {
        if (this.activeQuot == null) {
            return false;
        }
        return this.activeQuot.isEscapeChar(c);
    }

    public boolean hitCloseComment(int offset) {
        if (this.activeCmnt == null) {
            return false;
        }
        String str = this.getStringFromTo(offset - (this.activeCmnt.closeLen - 1), offset + (this.activeCmnt.closeLen - 1));
        return str.trim().equals(this.activeCmnt.closeStr);
    }

    public boolean hitOpenComment(int offset) {
        if (this.activeCmnt == null) {
            return false;
        }
        String str = this.getStringFromTo(offset - (this.activeCmnt.openLen - 1), offset + (this.activeCmnt.openLen - 1));
        return str.trim().equals(this.activeCmnt.openStr);
    }

    private String getStringFromTo(int from, int to) {
        StringBuffer out = new StringBuffer();
        for (int n = 0; n < to - from; ++n) {
            out.append(this.segment.array[from + n + this.segment.offset]);
        }
        return out.toString();
    }

    public boolean containsAnyQuotation(String str) {
        if (this.tok == null || str == null) {
            return false;
        }
        return this.tok.containsAnyQuotation(str);
    }

    public Comment containsClosingComment(String str) {
        if (this.tok == null || str == null) {
            return null;
        }
        return this.tok.containsClosingComment(str);
    }

    public Comment containsOpenComment(String str) {
        if (this.tok == null || str == null) {
            return null;
        }
        return this.tok.containsOpenComment(str);
    }

    public Escape containsOpenEscape(String str) {
        if (this.tok == null || str == null) {
            return null;
        }
        return this.tok.containsOpenEscape(str);
    }

    public void init() {
        System.out.println("Syntax.init()");
        this.beginParse = 0;
        this.preUpdateStyleID = 0;
        this.postUpdateStyleID = 0;
        this.activeCmnt = null;
        this.activeQuot = null;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("\n");
        out.append("     preUpdate: " + this.preUpdate + "\n");
        out.append("     postUpdate: " + this.postUpdate + "\n");
        out.append("     beginParse: " + this.beginParse + "\n");
        out.append("     preUpdateStyleID: " + KStyleContext.lookup(this.preUpdateStyleID) + "\n");
        out.append("     postUpdateStyleID: " + KStyleContext.lookup(this.postUpdateStyleID) + "\n");
        out.append("     prevActiveCmnt: " + (this.prevActiveCmnt == null ? "[null]" : this.prevActiveCmnt.getName()) + "\n");
        out.append("     prevBeginCmnt: " + this.prevBeginCmnt + "\n");
        out.append("     prevEndCmnt: " + this.prevEndCmnt + "\n");
        out.append("     prevActiveQuot: " + (this.prevActiveQuot == null ? "[null]" : this.prevActiveQuot.getName()) + "\n");
        out.append("     prevActiveEscape: " + (this.prevActiveEscape == null ? "[null]" : this.prevActiveEscape.getName()) + "\n");
        out.append("     activeCmnt: " + (this.activeCmnt == null ? "[null]" : this.activeCmnt.getName()) + "\n");
        out.append("     activeQuot: " + (this.activeQuot == null ? "[null]" : this.activeQuot.getName()) + "\n");
        out.append("     activeEscape: " + (this.activeEscape == null ? "[null]" : this.activeEscape.getName()) + "\n");
        if (this.preUpdateChar != '0') {
            out.append("     preUpdateChar > " + this.preUpdateChar + "< asci: " + this.preUpdateChar + "\n");
        }
        out.append("     postUpdateChar > " + this.postUpdateChar + "<\n");
        return out.toString();
    }
}

