/*
 * Decompiled with CFR 0.152.
 */
package UI_Script;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Script.Comment;
import UI_Script.Escape;
import UI_Script.Syntax;
import UI_Text.KTextPane.KDocument;
import UI_Text.KTextPane.KTextPane;
import UI_Text.Style.KStyleContext;
import UI_Text.Style.StyleEdits;
import UI_Window.KWindow.KAbstractTextWindow;
import Utilities.DocumentUtils;
import Utilities.DynamicEdit;
import Utilities.TextUtils;
import java.awt.Color;
import java.awt.Font;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import kernal.Tokenizers.Tokenizer;

public abstract class SyntaxListener
implements DocumentListener {
    private static Vector<SyntaxListener> freelisteners = new Vector();
    public static String fileExtension = "";
    public static boolean _findStartOfPreviousWord = false;
    public static boolean _findStartOfNextWord = false;
    public static boolean _parse = false;
    public static boolean _parseTime = false;
    public static boolean _nullSyntax = false;
    public static boolean _insertUpdate = false;
    public static boolean _removeUpdate = false;
    public static boolean _getExistingSyntax = false;
    public static boolean _removeComments = false;
    public static boolean _finalize = false;
    public static int userMaxColoredLength = 64000;
    private static boolean userWantsColoration = true;
    public static final boolean OPEN = true;
    public static final boolean CLOSED = false;
    protected boolean quotation = false;
    protected boolean comment = false;
    protected StringBuffer msg = new StringBuffer();
    protected Segment segment = new Segment();
    protected Element element = null;
    protected DocumentEvent.EventType updateType;
    public KTextPane textpane;
    protected boolean showParseOffsets = false;
    public Color plainTextColor = Color.black;
    public Color commentColor = Color.black;
    public Color keywordColor1 = Color.black;
    public Color keywordColor2 = Color.black;
    public Color keywordColor3 = Color.black;
    public Color keywordColor4 = Color.black;
    public Color stringColor = Color.black;
    public static Color defaultLanguageColor;
    public Tokenizer tok = null;
    protected StyleEdits editList;
    public Syntax syntax = null;
    public static boolean ignoreRemoveUpdate;
    protected boolean doColoration = true;
    private boolean string;
    private boolean escape;
    protected String str = "";

    private static void add(SyntaxListener item) {
        if (item == null) {
            return;
        }
        if (freelisteners.contains(item)) {
            return;
        }
        freelisteners.addElement(item);
    }

    static synchronized SyntaxListener getInstanceByClassName(String name, KTextPane textpane) {
        SyntaxListener.add(textpane.getSyntaxListener());
        if (freelisteners.size() > 0) {
            for (int n = 0; n < freelisteners.size(); ++n) {
                SyntaxListener obj = freelisteners.elementAt(n);
                if (obj == null || !obj.getClass().getName().equals(name)) continue;
                freelisteners.remove(n);
                SyntaxListener listener = obj;
                listener.textpane = textpane;
                int prefsize = 12;
                try {
                    String str = Preferences.get(Preferences.TEXT_FONT_SIZE);
                    if (str != null && str.trim().length() > 0) {
                        prefsize = Integer.parseInt(str);
                    }
                }
                catch (NumberFormatException e) {
                    prefsize = 12;
                }
                textpane.setFont(new Font(KStyleContext.defaultFont.getName(), 0, prefsize));
                KStyleContext.setDefaultStyles(textpane);
                listener.initStyles(textpane);
                listener.textpane.initCaretsDefaultColors();
                listener.textpane.initCaretsDefaultWordDelimitors();
                listener.initDelimitors(textpane);
                return listener;
            }
        }
        Constructor<?> constr = null;
        SyntaxListener listener = null;
        try {
            Class<?> cls = Class.forName(name);
            Class[] params = new Class[]{textpane.getClass()};
            constr = cls.getConstructor(params);
            Object[] p = new Object[]{textpane};
            listener = (SyntaxListener)constr.newInstance(p);
            return listener;
        }
        catch (Exception e) {
            Cutter.setLog("    Error: SyntaxListener.getInstanceByName - " + name);
            Cutter.setLog(e.toString());
            return null;
        }
    }

    public void suspendColoration() {
        this.doColoration = false;
    }

    public void resumeColoration() {
        if (SyntaxListener.userWantsColoration() && this.textpane.getDocument().getLength() <= userMaxColoredLength) {
            this.doColoration = true;
        } else {
            this.doColoration = false;
            Cutter.setLog("    Info: SyntaxListener.resumeColoration() - Cannot resume because either:");
            Cutter.setLog("            document length [" + this.textpane.getDocument().getLength() + "]\n            exceeds users max coloration length [" + userMaxColoredLength + "] OR \n            user does not want syntax coloration to be active");
        }
    }

    public boolean colorationIsActive() {
        return SyntaxListener.userWantsColoration() && this.textpane.getDocument().getLength() <= userMaxColoredLength && this.doColoration;
    }

    public static boolean userWantsColoration() {
        return userWantsColoration;
    }

    public static void setUserWantsColoration(boolean f) {
        Cutter.setLog("   Debug:SyntaxListener.setUserWantsColoration() - " + f);
        userWantsColoration = f;
    }

    public void initStyles(KTextPane textpane) {
    }

    public void initDelimitors(KTextPane textpane) {
    }

    public SyntaxListener(KTextPane textpane) {
        this.textpane = textpane;
        this.applyWritePrivaledge();
        StyleConstants.setForeground(this.textpane.styleContext.languageStyle, defaultLanguageColor);
        StyleConstants.setForeground(this.textpane.styleContext.plainStyle, this.plainTextColor);
    }

    public SyntaxListener(KTextPane textpane, Tokenizer tokenizer) {
        this.textpane = textpane;
        this.applyWritePrivaledge();
        this.tok = tokenizer;
        StyleConstants.setForeground(this.textpane.styleContext.languageStyle, defaultLanguageColor);
        StyleConstants.setForeground(this.textpane.styleContext.plainStyle, this.plainTextColor);
    }

    public void setTokenizer(Tokenizer tokenizer) {
        this.tok = tokenizer;
    }

    protected void applyWritePrivaledge() {
        this.textpane.setEditable(true);
    }

    public Tokenizer getTokenizer() {
        return this.tok;
    }

    protected Syntax getSyntax(Document doc, Tokenizer tok, int preUpdate, int postUpdate) {
        return new Syntax(doc, tok, preUpdate, postUpdate);
    }

    public synchronized Syntax getExistingSyntax(int preUpdate, int postUpdate) {
        char c1 = '\u0000';
        char c2 = '\u0000';
        char c3 = '\u0000';
        char prevChar = ' ';
        boolean peek = false;
        if (postUpdate < 0) {
            Cutter.setLog("    Warning:SyntaxListener.getExistingSyntax() returning null");
            return null;
        }
        int len = this.tok.getSyntaxLength();
        this.segment = DocumentUtils.getSegment(this.textpane.getDocument(), 0, this.textpane.getDocument().getLength());
        this.comment = false;
        this.string = false;
        this.escape = false;
        Syntax syntax = this.getSyntax(this.textpane.getDocument(), this.tok, preUpdate, postUpdate);
        syntax.preUpdateAt = preUpdate;
        for (int n = 0; n <= postUpdate; ++n) {
            char c0 = this.segment.array[n + this.segment.offset];
            c1 = n + 1 < this.segment.count ? this.segment.array[n + this.segment.offset + 1] : (char)'\u0000';
            c2 = n + 2 < this.segment.count ? this.segment.array[n + this.segment.offset + 2] : (char)'\u0000';
            char c = c3 = n + 3 < this.segment.count ? this.segment.array[n + this.segment.offset + 3] : (char)'\u0000';
            if (this.escape && syntax.isCloseEscape(n)) {
                this.escape = false;
                syntax.prevActiveEscape = syntax.activeEscape;
                if (!this.string && n <= preUpdate) {
                    syntax.beginParse = n;
                }
                syntax.currWordBegin = n;
                syntax.activeEscape = null;
            }
            if (this.comment && syntax.isCloseComment(n)) {
                this.comment = false;
                syntax.prevActiveCmnt = syntax.activeCmnt;
                syntax.prevBeginCmnt = syntax.beginCmnt;
                syntax.prevEndCmnt = n;
                if (n <= preUpdate) {
                    syntax.beginParse = n;
                }
                syntax.currWordBegin = n;
                syntax.activeCmnt = null;
            }
            if (this.string && syntax.isCloseQuotation(n)) {
                this.string = false;
                syntax.prevActiveQuot = syntax.activeQuot;
                if (n <= preUpdate) {
                    syntax.beginParse = n;
                }
                syntax.currWordBegin = n;
                syntax.activeQuot = null;
            }
            if (!this.comment && !this.string && Character.isWhitespace(c0) && n <= preUpdate) {
                syntax.beginParse = syntax.currWordBegin;
                syntax.currWordBegin = n;
            }
            if (n <= preUpdate) {
                syntax.lookBack(n, prevChar, c0, c1, c2, c3);
            }
            if (n == preUpdate) {
                syntax.preUpdateCheckPoint(this.escape, this.comment, this.string, _getExistingSyntax, n);
            }
            syntax.lookBack(n, prevChar, c0, c1, c2, c3);
            if (!this.comment && !this.string && syntax.isOpenQuotation(n)) {
                this.string = true;
                if (n <= preUpdate) {
                    syntax.beginParse = n;
                }
                syntax.beginQuot = n;
                n = n + syntax.activeQuot.openLen - 1;
            }
            if (!this.comment && !this.string && syntax.isOpenComment(n)) {
                this.comment = true;
                if (n < preUpdate) {
                    syntax.beginParse = n;
                }
                syntax.beginCmnt = n;
                n += syntax.activeCmnt.openLen - 1;
            }
            if (!this.comment && !this.escape && syntax.isOpenEscape(n)) {
                this.escape = true;
                syntax.prevActiveEscape = null;
                if (n <= preUpdate && !this.string) {
                    syntax.beginParse = n;
                } else if (this.string) {
                    syntax.beginParse = syntax.beginQuot;
                }
                syntax.beginEscape = n;
                n = n + syntax.activeEscape.openLen - 1;
            }
            if (n + 1 > postUpdate) {
                boolean bl = syntax.preUpdateCheckPoint(this.escape, this.comment, this.string, _getExistingSyntax, n);
            }
            prevChar = c0;
        }
        syntax.postUpdateCheckPoint(this.escape, this.comment, this.string, _getExistingSyntax);
        syntax.close();
        return syntax;
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
    }

    protected int[] getInsertParseSpan(DocumentEvent evt, Syntax syntax) {
        int updateAt = evt.getOffset();
        int begin = syntax.beginParse;
        int end = -1;
        int docLength = this.textpane.getDocument().getLength();
        if (syntax.preUpdateStyleID == 0 && syntax.postUpdateStyleID == 0) {
            end = syntax.preUpdateChar != '0' && this.tok.isOpenComment(syntax.preUpdateChar) ? syntax.findClosingComment() : (syntax.prevActiveEscape != null && syntax.prevActiveEscape.getName().equals("ESCAPE") ? -1 : (this.textpane.numTabs > 0 ? this.findLineEnd(updateAt) : this.findWordBreak(updateAt + evt.getLength(), this.findLineEnd(updateAt + evt.getLength()))));
        } else if (syntax.preUpdateStyleID == 0 && syntax.postUpdateStyleID == 1) {
            end = syntax.findClosingComment(syntax.activeCmnt, updateAt + evt.getLength() + 1);
            end = this.balancedQuotations(updateAt, end, this.msg);
        } else if (syntax.preUpdateStyleID == 0 && syntax.postUpdateStyleID == 10) {
            end = -1;
        } else if (syntax.preUpdateStyleID == 0 && syntax.postUpdateStyleID == 16) {
            end = -1;
        } else if (syntax.preUpdateStyleID == 1 && syntax.postUpdateStyleID == 0) {
            end = syntax.findClosingComment(syntax.prevActiveCmnt, updateAt + evt.getLength());
            end = this.balancedQuotations(updateAt, end, this.msg);
        } else if (syntax.preUpdateStyleID == 1 && syntax.postUpdateStyleID == 1) {
            String back = this.getStringFromTo(updateAt - (syntax.activeCmnt.closeLen - 1), updateAt);
            String forward = this.getStringFromTo(updateAt + evt.getLength(), updateAt + evt.getLength() + (syntax.activeCmnt.closeLen - 1));
            boolean splitCloseCmnt = false;
            if (syntax.activeCmnt.isCloseComment(back + forward)) {
                splitCloseCmnt = true;
            }
            if (syntax.hitCloseComment(updateAt + evt.getLength())) {
                end = this.findClosingComment(updateAt + evt.getLength());
                end = this.balancedQuotations(updateAt, end, this.msg);
            } else {
                Comment cmnt = this.openCmntInserted(updateAt);
                if (cmnt != null) {
                    end = syntax.findClosingComment();
                    end = this.balancedQuotations(updateAt, end, this.msg);
                } else {
                    end = syntax.findClosingComment();
                }
            }
        } else if (syntax.preUpdateStyleID == 10 && syntax.postUpdateStyleID == 10) {
            end = syntax.prevActiveEscape != null && syntax.prevActiveEscape.getName().equals("ESCAPE") ? -1 : (syntax.isQuotationEscapeChar('\\') && syntax.postUpdateChar == '\"' ? -1 : syntax.findClosingQuotation());
        } else if (syntax.preUpdateStyleID == 10 && syntax.postUpdateStyleID == 0) {
            end = -1;
        } else if (syntax.preUpdateStyleID == 10 && syntax.postUpdateStyleID == 16) {
            end = -1;
        }
        end = end == -1 ? docLength : end;
        int[] out = new int[]{begin, end};
        return out;
    }

    protected int[] getRemoveParseSpan(DocumentEvent evt, Syntax syntax) {
        Comment cmnt;
        String strRemoved = "";
        Document kdoc = evt.getDocument();
        if (kdoc instanceof KDocument) {
            strRemoved = ((KDocument)kdoc).stringRemoved;
        }
        if (strRemoved == null || strRemoved.length() == 0) {
            return null;
        }
        int begin = syntax.beginParse;
        int end = -1;
        int updateAt = evt.getOffset();
        int docLength = this.textpane.getDocument().getLength();
        if (syntax.preUpdateStyleID == 1 && syntax.postUpdateStyleID == 1) {
            cmnt = this.closeCmntRemoved(updateAt);
            if (cmnt != null) {
                end = syntax.findClosingComment(cmnt, updateAt + 1);
                end = this.balancedQuotations(updateAt, end, this.msg);
            } else {
                end = syntax.findClosingComment();
            }
        } else if (syntax.preUpdateStyleID == 10 && syntax.postUpdateStyleID == 10) {
            Escape esc = syntax.containsOpenEscape(strRemoved);
            end = esc != null ? -1 : (syntax.endsWithEscape(strRemoved) ? -1 : (syntax.isOpenQuotation(strRemoved) || syntax.isCloseQuotation(strRemoved) ? -1 : syntax.findClosingQuotation()));
        } else if (syntax.preUpdateStyleID == 16 && syntax.postUpdateStyleID == 16) {
            end = -1;
        } else if (syntax.preUpdateStyleID == 0 && syntax.postUpdateStyleID == 0) {
            Escape esc = syntax.containsOpenEscape(strRemoved);
            if (esc != null) {
                end = -1;
            } else if (strRemoved.endsWith("\\")) {
                end = -1;
            } else if (syntax.containsAnyQuotation(strRemoved)) {
                end = -1;
            } else {
                cmnt = syntax.containsOpenComment(strRemoved);
                if (cmnt != null) {
                    end = syntax.findClosingComment(cmnt, updateAt);
                    char c = this.getCharAt(updateAt - 1);
                    if (Character.isWhitespace(c)) {
                        begin = updateAt;
                    }
                    end = this.balancedQuotations(updateAt, end, this.msg);
                } else {
                    cmnt = this.closeCmntRemoved(updateAt);
                    if (cmnt != null || (cmnt = this.openCmntRemoved(updateAt)) != null) {
                        end = syntax.findClosingComment(cmnt, updateAt + 1);
                        end = this.balancedQuotations(updateAt, end, this.msg);
                    } else {
                        cmnt = syntax.containsOpenComment(strRemoved);
                        if (cmnt != null) {
                            end = syntax.findClosingComment(cmnt, updateAt);
                            char c = this.getCharAt(updateAt - 1);
                            if (Character.isWhitespace(c)) {
                                begin = updateAt;
                            }
                            end = this.balancedQuotations(updateAt, end, this.msg);
                        } else {
                            char prev = this.getCharAt(updateAt - 1);
                            char current = this.getCharAt(updateAt);
                            end = Character.isWhitespace(prev) || Character.isWhitespace(current) && !this.textpane.isWordEndDelimitor(current) ? this.findWordBreak(updateAt, docLength) : this.findWordBreak(updateAt, docLength);
                        }
                    }
                }
            }
        }
        int n = end = end == -1 ? docLength : end;
        if (begin == 1) {
            begin = 0;
        }
        int[] out = new int[]{begin, end};
        return out;
    }

    @Override
    public void insertUpdate(DocumentEvent evt) {
        if (!this.doColoration) {
            return;
        }
        int[] offset = this.getInsertOffsets(evt);
        if (offset == null) {
            return;
        }
        this.syntax = this.getExistingSyntax(offset[0], offset[1]);
        if (this.syntax == null) {
            return;
        }
        this.initDebugMessage("SyntaxListener.insertUpdate()", evt.getOffset(), this.syntax);
        int[] span = this.getInsertParseSpan(evt, this.syntax);
        if (span == null) {
            this.displayDebugMessage(null);
            return;
        }
        if (_insertUpdate) {
            this.displayDebugMessage(span);
        }
        if (span[0] == span[1]) {
            return;
        }
        this.parse(DocumentUtils.getSegment(this.textpane.getDocument(), span[0], span[1] - span[0]), span[0]);
    }

    @Override
    public void removeUpdate(DocumentEvent evt) {
        int[] span;
        if (ignoreRemoveUpdate) {
            ignoreRemoveUpdate = false;
            return;
        }
        if (!this.doColoration) {
            return;
        }
        if (this.textpane.getDocument() == null) {
            Cutter.setLog("    Error:SyntaxListener.removeUpdate() - textpane.getDocument() returned null.");
            return;
        }
        this.syntax = this.getExistingSyntax(evt.getOffset(), evt.getOffset());
        if (this.syntax == null && this.textpane.getDocument().getLength() == 0) {
            int end = this.handleNullSyntax();
            if (end > 0) {
                this.parse(DocumentUtils.getSegment(this.textpane.getDocument(), 0, end), 0);
            }
            return;
        }
        if (this.syntax == null) {
            String ss = this.textpane.stringRemoved();
            if (ss == null) {
                return;
            }
            if (this.tok.containsOpenComment(this.textpane.stringRemoved()) != null) {
                int[] span2 = DocumentUtils.getElementOffsets(this.textpane.getDocument(), evt.getOffset());
                int spanbegin = span2[1];
                int spanlength = span2[2];
                if (spanlength == 0) {
                    return;
                }
                this.parse(DocumentUtils.getSegment(this.textpane.getDocument(), spanbegin, spanlength), spanbegin);
                return;
            }
            return;
        }
        if (_removeUpdate) {
            this.initDebugMessage("SyntaxListener.removeUpdate()", evt.getOffset(), this.syntax);
        }
        if ((span = this.getRemoveParseSpan(evt, this.syntax)) == null) {
            return;
        }
        if (_removeUpdate) {
            this.displayDebugMessage(span);
        }
        if (span[0] == span[1]) {
            return;
        }
        this.parse(DocumentUtils.getSegment(this.textpane.getDocument(), span[0], span[1] - span[0]), span[0]);
    }

    public final synchronized void parseAll() {
        if (!this.colorationIsActive()) {
            Cutter.setLog("    Debug:SyntaxListener.parseAll() - cannot because colorationIsActive() is " + this.colorationIsActive());
            return;
        }
        this.parseAllWillHappen();
        if (this.textpane.getDocument().getLength() > 0) {
            Segment s = new Segment();
            try {
                this.textpane.getDocument().getText(0, this.textpane.getDocument().getLength(), s);
            }
            catch (BadLocationException e) {
                System.out.println("    Error in SyntaxListener.parseAll() = " + e);
            }
            DefaultStyledDocument doc = (DefaultStyledDocument)this.textpane.getDocument();
            doc.setCharacterAttributes(0, this.textpane.getDocument().getLength(), this.textpane.styleContext.plainStyle, true);
            this.parse(s, 0);
        }
    }

    protected synchronized void parse(Segment segment, int offset) {
        if (!this.colorationIsActive()) {
            Cutter.setLog("    Debug:SyntaxListener.parse(segment,offset) - cannot because colorationIsActive() is " + this.colorationIsActive());
            return;
        }
        if (segment == null) {
            Cutter.setLog("    Error:SyntaxListener.parse(Segment, int) - null segment");
            return;
        }
        if (segment == null || segment.count == 0) {
            return;
        }
        if (this.tok == null) {
            Cutter.setLog("    Error:SyntaxListener.parse(Segment, int) - null tokenizer");
            return;
        }
        this.tok.setBuffer(segment);
        this.tok.getComments = true;
        this.str = this.tok.getNextStr();
        if (this.str == null) {
            Cutter.setLog("    Error:SyntaxListener.parse(Segment, int) - initial getNextStr() returned a null string");
            return;
        }
        this.editList = new StyleEdits(this);
        while (!this.str.equals("")) {
            int index = this.tok.getBufferIndex() - 1 < 0 ? 0 : this.tok.getBufferIndex();
            int begin = (index += offset) - this.str.length();
            if (this.tok.isDataType(this.str)) {
                this.editList.addEdit(begin, this.str.length(), this.textpane.styleContext.keywordStyle2, true);
            } else if (this.tok.isDataModifier(this.str)) {
                this.editList.addEdit(begin, this.str.length(), this.textpane.styleContext.keywordStyle2, true);
            } else if (this.tok.isFunction(this.str)) {
                this.editList.addEdit(begin, this.str.length(), this.textpane.styleContext.keywordStyle1, true);
            } else if (this.tok.isLanguageType(this.str)) {
                this.editList.addEdit(begin, this.str.length(), this.textpane.styleContext.languageStyle, true);
            } else if (this.tok.isOpenComment(this.str)) {
                this.editList.addEdit(begin, this.str.length(), this.textpane.styleContext.commentStyle1, true);
            } else if (this.tok.isSystemHeader(this.str)) {
                this.editList.addEdit(begin, this.str.length(), this.textpane.styleContext.stringStyle1, true);
            } else if (this.tok.isUserVariable(this.str)) {
                int arrayBegin = this.str.indexOf(91);
                if (arrayBegin != -1) {
                    this.editList.addEdit(begin, arrayBegin, this.textpane.styleContext.keywordStyle3, true);
                    this.editList.addEdit(begin + arrayBegin, this.str.length() - arrayBegin, this.textpane.styleContext.plainStyle, true);
                } else {
                    this.editList.addEdit(begin, this.str.length(), this.textpane.styleContext.keywordStyle3, true);
                }
            } else if (!this.customSyntax(this.str, begin, this.editList)) {
                if (this.tok.isOpenQuotation(this.str)) {
                    this.editList.addEdit(begin, this.str.length(), this.textpane.styleContext.stringStyle1, true);
                } else {
                    this.editList.addEdit(begin, this.str.length(), this.textpane.styleContext.plainStyle, true);
                }
            }
            this.str = this.tok.getNextStr();
        }
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SyntaxListener.this.editList.applyEdits((DefaultStyledDocument)SyntaxListener.this.textpane.getDocument());
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean customSyntax(String str, int begin, StyleEdits editList) {
        return false;
    }

    protected int handleNullSyntax() {
        int docLength;
        String str = this.textpane.stringRemoved();
        String msg = "[handleNullSyntax] - ";
        Segment segment = DocumentUtils.getSegment(this.textpane.getDocument(), 0, 1);
        int end = docLength = this.textpane.getDocument().getLength();
        if (segment == null) {
            if (_nullSyntax) {
                Cutter.setLog("empty document - no parsing required");
            }
            return 0;
        }
        if (this.tok == null) {
            if (_nullSyntax) {
                Cutter.setLog("Cannot parse - no tokenizer");
            }
            return 0;
        }
        if (this.tok.containsOpenComment(str) != null) {
            end = this.findClosingComment(0);
            if (this.tok.containsClosingComment(str) != null) {
                msg = msg + "removed open comment parse to closing comment";
            } else {
                end = this.findClosingComment(end == -1 ? docLength : end);
                msg = msg + "removed open and close comment parse to the second closing comment";
            }
        } else if (this.tok.containsClosingComment(str) != null) {
            msg = msg + "removed close comment parse to closing comment";
            end = this.findClosingComment(0);
        } else if (TextUtils.contains(str, '\"')) {
            if (_nullSyntax) {
                Cutter.setLog("<\">parse all - deletion has cursor at offset zero");
            }
        } else {
            if (_nullSyntax) {
                Cutter.setLog("SyntaxListener.handleNullSyntax Deletion has cursor at offset zero - nothing to parse");
            }
            return 0;
        }
        if (_nullSyntax) {
            Cutter.setLog(msg + " end = " + end);
        }
        return end == -1 ? docLength : end;
    }

    protected void colorizeLiteral(int offset, String str, StyleEdits editList) {
    }

    protected void parseAllWillHappen() {
    }

    public final void parseFromTo(int begin, int end) {
        Cutter.setLog("parseFromTo begin end " + begin + "   " + end);
        if (!this.colorationIsActive()) {
            Cutter.setLog("    Info: SyntaxListener.parseFromTo() - cannot because doColoration flag is " + this.doColoration);
            return;
        }
        if (!SyntaxListener.userWantsColoration()) {
            Cutter.setLog("    Info: SyntaxListener.parseFromTo() - cannot because userWantsColoration flag is " + SyntaxListener.userWantsColoration());
            return;
        }
        if (end - begin < 0) {
            Cutter.setLog("    Error: SyntaxListener.parseFromTo() has been give a negative length");
            this.parseAll();
            return;
        }
        Segment s = new Segment();
        try {
            this.textpane.getDocument().getText(begin, end - begin, s);
            this.parse(s, begin);
        }
        catch (BadLocationException e) {
            System.out.println("    Exception: SyntaxListener.parseFromTo() begin = " + begin + ", end = " + end);
            System.out.println("" + e);
        }
    }

    protected final int findQuote(int begin) {
        this.segment = DocumentUtils.getSegment(this.textpane.getDocument(), begin, this.textpane.getDocument().getLength() - begin);
        if (this.segment == null) {
            return -1;
        }
        for (int n = 0; n < this.segment.count; ++n) {
            if (this.segment.array[n + this.segment.offset] != '\"') continue;
            return begin + n;
        }
        return -1;
    }

    protected final int findQuote(int begin, int end) {
        end = end == -1 ? this.textpane.getDocument().getLength() : end;
        int n = end = end > this.textpane.getDocument().getLength() ? this.textpane.getDocument().getLength() : end;
        if (this.segment == null) {
            return -1;
        }
        this.segment = DocumentUtils.getSegment(this.textpane.getDocument(), begin, end - begin);
        for (int n2 = 0; n2 < this.segment.count; ++n2) {
            if (this.segment.array[n2 + this.segment.offset] != '\"') continue;
            return begin + n2 + 1;
        }
        return -1;
    }

    protected int countQuotes(int begin, int end) {
        end = end == -1 ? this.textpane.getDocument().getLength() : end;
        this.segment = DocumentUtils.getSegment(this.textpane.getDocument(), begin, end - begin);
        if (this.segment == null) {
            return 1;
        }
        int num = 0;
        for (int n = 0; n < this.segment.count; ++n) {
            if (n > 0 && this.tok.isOpenComment(this.segment, n) != null) {
                return num;
            }
            if (this.segment.array[n + this.segment.offset] != '\"') continue;
            ++num;
        }
        return num;
    }

    protected int balancedQuotations(int begin, int end, StringBuffer msg) {
        int offset = this.balancedQuotations(begin, end);
        int n = end = end == -1 ? this.textpane.getDocument().getLength() : end;
        if (offset != -1) {
            msg.append("- NONE or EVEN quotes upto " + end);
            return offset;
        }
        msg.append("- UNEVEN quotes upto " + end);
        return -1;
    }

    protected int balancedQuotations(int begin, int end) {
        end = end == -1 ? this.textpane.getDocument().getLength() : end;
        this.segment = DocumentUtils.getSegment(this.textpane.getDocument(), begin, end - begin);
        if (this.segment == null) {
            return -1;
        }
        if (this.tok.balancedQuotations(this.segment, 0)) {
            return end;
        }
        return -1;
    }

    protected int count(String str, char c) {
        int num = 0;
        for (int n = 0; n < str.length(); ++n) {
            if (str.charAt(n) != c) continue;
            ++num;
        }
        return num;
    }

    protected KAbstractTextWindow getFrame() {
        return (KAbstractTextWindow)this.textpane.getRootPane().getParent();
    }

    protected int[] getInsertOffsets(DocumentEvent evt) {
        int[] out = new int[]{evt.getOffset(), evt.getOffset() + evt.getLength()};
        if (evt.getLength() == this.textpane.getDocument().getLength()) {
            this.parse(DocumentUtils.getSegment(this.textpane.getDocument(), 0, this.textpane.getDocument().getLength()), 0);
            return null;
        }
        return out;
    }

    public void addComments() {
    }

    public void addComments(String comment) {
        Position[][] p = this.textpane.getLines();
        if (p == null) {
            return;
        }
        int parseFrom = BBxt.getSelectionStart();
        int parseTo = BBxt.getSelectionEnd();
        boolean count = false;
        Segment lineSegment = new Segment();
        StringBuffer outbuff = new StringBuffer();
        StringBuffer linebuff = new StringBuffer();
        for (int n = 0; n < p.length; ++n) {
            int begin = p[n][0].getOffset();
            int end = p[n][1].getOffset() - 1;
            DocumentUtils.getSegment(this.textpane.getDocument(), begin, end, lineSegment);
            begin = 0;
            end = lineSegment.count - 1;
            String str = lineSegment.toString();
            str = str.trim();
            if (str.length() >= comment.length() && str.substring(0, comment.length()).equals(comment)) {
                linebuff.append(lineSegment.toString());
            } else {
                linebuff.append(comment + lineSegment.toString());
            }
            linebuff.append("\n");
            outbuff.append(linebuff);
            linebuff.setLength(0);
        }
        BBxt.paste(outbuff.toString());
        parseTo = parseFrom + outbuff.length();
    }

    public void addComments(String commentBegin, String commentEnd) {
        int n;
        Position[][] p = this.textpane.getLines();
        if (p == null) {
            return;
        }
        int parseFrom = BBxt.getSelectionStart();
        int parseTo = BBxt.getSelectionEnd();
        boolean count = false;
        Segment lineSegment = new Segment();
        StringBuffer outbuff = new StringBuffer();
        StringBuffer linebuff = new StringBuffer();
        if (p.length == 0) {
            outbuff.append(commentBegin + BBxt.getSelection() + commentEnd);
            BBxt.paste(outbuff.toString());
            return;
        }
        for (n = 0; n < Math.abs(p[0][0].getOffset() - parseFrom); ++n) {
            outbuff.append("\n");
        }
        for (n = 0; n < p.length; ++n) {
            int begin = p[n][0].getOffset();
            int end = p[n][1].getOffset() - 1;
            DocumentUtils.getSegment(this.textpane.getDocument(), begin, end, lineSegment);
            begin = 0;
            end = lineSegment.count - 1;
            String str = lineSegment.toString();
            str = str.trim();
            if (str.length() == 0) {
                outbuff.append("\n");
                continue;
            }
            int cmntBeginLen = commentBegin.length();
            int cmntEndLen = commentEnd.length();
            int totalCmntLen = cmntBeginLen + cmntEndLen;
            if (str.length() >= totalCmntLen) {
                String head = str.substring(0, cmntBeginLen);
                int beginOffset = str.length() - cmntEndLen;
                int endOffset = beginOffset + cmntEndLen;
                String tail = str.substring(beginOffset, endOffset);
                if (head.equals(commentBegin) && tail.equals(commentEnd)) {
                    linebuff.append(lineSegment.toString());
                } else {
                    linebuff.append(commentBegin + lineSegment.toString() + commentEnd);
                }
            } else {
                linebuff.append(commentBegin + lineSegment.toString() + commentEnd);
            }
            linebuff.append("\n");
            outbuff.append(linebuff);
            linebuff.setLength(0);
        }
        BBxt.paste(outbuff.toString());
    }

    public void removeComments(boolean allText) {
        Position endMarker;
        String s;
        Comment[] cmnt;
        if (_removeComments) {
            Cutter.setLog("SyntaxListener.removeComments(boolean)");
        }
        if ((cmnt = this.tok.comments) == null) {
            Cutter.setLog("    Warning: SyntaxListener.removeComments(boolean) - no comments defined");
            return;
        }
        Document doc = this.textpane.getDocument();
        int begin = this.textpane.getSelectionStart();
        int end = this.textpane.getSelectionEnd();
        try {
            s = doc.getText(end - 1, 1);
        }
        catch (BadLocationException e) {
            Cutter.setLog("    Error: SyntaxListener.removeComments(boolean)\n           cannot get the last character of the selection");
            return;
        }
        boolean endCommentIsNewline = false;
        for (int n = 0; n < cmnt.length; ++n) {
            if (!cmnt[n].closeStr.equals("\n")) continue;
            endCommentIsNewline = true;
        }
        if (endCommentIsNewline && !s.equals("\n")) {
            int[] temp = null;
            if (endCommentIsNewline && (temp = DocumentUtils.getElementOffsets(doc, end)) != null) {
                end = temp[2];
            }
        }
        if (begin == end) {
            begin = 0;
            end = doc.getLength();
        }
        try {
            endMarker = doc.createPosition(end);
        }
        catch (BadLocationException e) {
            Cutter.setLog("    Error: SyntaxListener.removeComments(Comment[]) " + e);
            return;
        }
        for (int n = 0; n < cmnt.length; ++n) {
            this.removeComments(doc, cmnt[n], allText, begin, endMarker.getOffset());
        }
        this.textpane.setSelectionStart(begin);
        this.textpane.setSelectionEnd(begin);
        if (!allText) {
            this.parseAll();
        }
    }

    public void removeComments(Document doc, Comment cmnt, boolean allText, int begin, int end) {
        DynamicEdit edit;
        int i;
        Segment segment = DocumentUtils.getSegment(doc, begin, end - begin);
        Tokenizer tok = new Tokenizer();
        Vector<DynamicEdit> edits = new Vector<DynamicEdit>();
        tok.setBuffer(segment);
        int[] offset = tok.charSearch(cmnt.openStr, true);
        if (_removeComments) {
            Cutter.setLog("SEGMENT____________ offset = " + segment.offset + " begin = " + begin);
            if (offset != null) {
                Cutter.setLog("offset[0] = " + offset[0]);
            }
            Cutter.setLog(segment.toString());
            Cutter.setLog("<<");
        }
        while (offset != null) {
            int cmntBegin = begin + offset[0];
            offset = tok.charSearch(cmnt.closeStr, true);
            int cmntEnd = offset == null ? begin + segment.count : begin + offset[1];
            if (!this.addDynamicEdit(doc, edits, cmntBegin, cmntEnd)) {
                return;
            }
            offset = tok.charSearch(cmnt.openStr, true);
        }
        if (_removeComments) {
            Cutter.setLog("Edit list ________");
            for (i = 0; i < edits.size(); ++i) {
                edit = (DynamicEdit)edits.elementAt(i);
                Cutter.setLog("edit:" + i + "    " + edit.getBegin() + " " + edit.getEnd());
            }
            Cutter.setLog("");
        }
        for (i = 0; i < edits.size(); ++i) {
            edit = (DynamicEdit)edits.elementAt(i);
            if (edit == null) continue;
            if (allText) {
                edit.removeText();
                continue;
            }
            edit.removeHeadTail(cmnt.openLen, cmnt.closeLen);
        }
        edits.removeAllElements();
        edits = null;
    }

    private boolean addDynamicEdit(Document doc, Vector<DynamicEdit> v, int begin, int end) {
        try {
            v.addElement(new DynamicEdit(doc, begin, end));
        }
        catch (BadLocationException e) {
            Cutter.setLog("    Error: MelListener.removeComments(Comment[]) " + e);
            return false;
        }
        return true;
    }

    protected Comment closeCmntRemoved(int updateAt) {
        String removedStr = this.textpane.stringRemoved();
        String back = this.getStringFromTo(updateAt - (this.tok.getCloseCmntLength() - 1), updateAt);
        String ahead = this.getStringFromTo(updateAt, updateAt + (this.tok.getCloseCmntLength() - 1));
        back = back + removedStr;
        ahead = removedStr + ahead;
        String possibleOpen = this.getStringFromTo(updateAt - this.tok.getOpenCmntLength(), updateAt);
        if (this.tok.isOpenComment(possibleOpen)) {
            return null;
        }
        if (this.tok.containsClosingComment(removedStr) != null) {
            return Comment.getComment(null, removedStr);
        }
        if (this.tok.containsClosingComment(ahead) != null) {
            return Comment.getComment(null, ahead);
        }
        if (this.tok.containsClosingComment(back) != null) {
            return Comment.getComment(null, back);
        }
        return null;
    }

    protected Comment openCmntRemoved(int updateAt) {
        String removedStr = this.textpane.stringRemoved();
        String back = this.getStringFromTo(updateAt - (this.tok.getOpenCmntLength() - 1), updateAt);
        String ahead = this.getStringFromTo(updateAt, updateAt + (this.tok.getOpenCmntLength() - 1));
        back = back + removedStr;
        ahead = removedStr + ahead;
        if (this.tok.containsOpenComment(removedStr) != null) {
            return Comment.getComment(removedStr, null);
        }
        if (this.tok.containsOpenComment(ahead) != null) {
            return Comment.getComment(ahead, null);
        }
        if (this.tok.containsOpenComment(back) != null) {
            return Comment.getComment(back, null);
        }
        return null;
    }

    protected boolean _openCmntInserted(int updateAt) {
        String back = this.getStringFromTo(updateAt - (this.tok.getOpenCmntLength() - 1), updateAt);
        String ahead = this.getStringFromTo(updateAt, updateAt + (this.tok.getOpenCmntLength() - 1));
        return this.tok.containsOpenComment(back + ahead) != null;
    }

    protected Comment openCmntInserted(int updateAt) {
        String back = this.getStringFromTo(updateAt - (this.tok.getOpenCmntLength() - 1), updateAt);
        String ahead = this.getStringFromTo(updateAt, updateAt + (this.tok.getOpenCmntLength() - 1));
        if (this.tok.containsOpenComment(back + ahead) != null) {
            return Comment.getComment(back + ahead, null);
        }
        return null;
    }

    protected int findWordBreak(int from, int to) {
        int n;
        to = to == -1 ? this.textpane.getDocument().getLength() : to;
        this.segment = DocumentUtils.getSegment(this.textpane.getDocument(), from, to - from);
        if (this.segment == null) {
            return to;
        }
        int beginAt = 0;
        if (Character.isWhitespace(this.segment.array[this.segment.offset])) {
            for (n = beginAt; n < this.segment.count && Character.isWhitespace(this.segment.array[n + this.segment.offset]); ++n) {
                ++beginAt;
            }
        }
        for (n = 0 + beginAt; n < this.segment.count; ++n) {
            if (!Character.isWhitespace(this.segment.array[n + this.segment.offset])) continue;
            return n + from;
        }
        return to;
    }

    protected int findLineEnd(int from) {
        return DocumentUtils.getElementOffsets(this.textpane.getDocument(), from)[2];
    }

    protected int findLineBegin(int from) {
        return DocumentUtils.getElementOffsets(this.textpane.getDocument(), from)[1];
    }

    protected int findPreviousOpenComment(int from) {
        if (from <= 0) {
            return 0;
        }
        this.segment = DocumentUtils.getSegment(this.textpane.getDocument(), 0, from);
        if (this.segment == null) {
            return 0;
        }
        for (int i = this.segment.count - 1; i >= 0; --i) {
            if (this.tok.isOpenComment(this.segment, i) == null) continue;
            return i;
        }
        return 0;
    }

    protected int findStartOfPreviousWord(int from) {
        if (from <= 0) {
            return 0;
        }
        this.segment = DocumentUtils.getSegment(this.textpane.getDocument(), 0, from);
        if (this.segment == null) {
            return 0;
        }
        for (int n = this.segment.count - 1; n >= 0; --n) {
            if (this.segment.array[n + this.segment.offset] == '\n') {
                return n;
            }
            if (!Character.isWhitespace(this.segment.array[n + this.segment.offset])) break;
        }
        for (int i = n; i >= 0; --i) {
            if (!Character.isWhitespace(this.segment.array[i + this.segment.offset])) continue;
            if (_findStartOfPreviousWord) {
                Cutter.setLog("SyntaxListener.findStartOfPreviousWord() - searched from " + from + ", found at " + (i + 1));
            }
            return i + 1;
        }
        if (_findStartOfPreviousWord) {
            Cutter.setLog("SyntaxListener.findStartOfPreviousWord() - searched from " + from + ", failed to find word");
        }
        return 0;
    }

    protected int findStartOfNextWord(int from) {
        if (from > this.textpane.getDocument().getLength()) {
            return -1;
        }
        this.segment = DocumentUtils.getSegment(this.textpane.getDocument(), from, this.textpane.getDocument().getLength() - from);
        if (this.segment == null) {
            return -1;
        }
        for (int n = 0; n < this.segment.count && Character.isWhitespace(this.segment.array[n + this.segment.offset]); ++n) {
        }
        for (int i = n; i < this.segment.count; ++i) {
            if (!Character.isWhitespace(this.segment.array[i + this.segment.offset])) continue;
            if (_findStartOfNextWord) {
                Cutter.setLog("SyntaxListener.findStartOfNextWord() - searched from " + from + ", found at " + (i + from));
            }
            return i + from;
        }
        if (_findStartOfNextWord) {
            Cutter.setLog("SyntaxListener.findStartOfNextWord() - searched from " + from + ", failed to find word");
        }
        return -1;
    }

    protected int findOpenComment(int from) {
        if (from > this.textpane.getDocument().getLength()) {
            return -1;
        }
        this.segment = DocumentUtils.getSegment(this.textpane.getDocument(), from, this.textpane.getDocument().getLength() - from);
        if (this.segment == null) {
            return -1;
        }
        int offset = this.tok.findOpenComment(this.segment, 0);
        return offset == -1 ? offset : offset + from;
    }

    protected int findClosingComment(int from) {
        if (from > this.textpane.getDocument().getLength()) {
            return -1;
        }
        this.segment = DocumentUtils.getSegment(this.textpane.getDocument(), from, this.textpane.getDocument().getLength() - from);
        if (this.segment == null) {
            return -1;
        }
        int offset = this.tok.findCloseComment(this.segment, 0);
        return offset == -1 ? offset : offset + from;
    }

    public char getCharAt(int index) {
        this.segment = DocumentUtils.getSegment(this.textpane.getDocument(), index, 1);
        if (this.segment == null) {
            return '\u0000';
        }
        return this.segment.array[this.segment.offset];
    }

    public String getStringFromTo(int from, int to) {
        to = to == -1 ? this.textpane.getDocument().getLength() : to;
        this.segment = DocumentUtils.getSegment(this.textpane.getDocument(), from, to - from);
        if (this.segment == null) {
            return null;
        }
        StringBuffer out = new StringBuffer();
        for (int n = 0; n < to - from; ++n) {
            out.append(this.segment.array[n + this.segment.offset]);
        }
        return out.toString();
    }

    private String asciToString(int code) {
        switch ((char)code) {
            case '\n': {
                return "RETURN";
            }
            case '\t': {
                return "TAB";
            }
            case ' ': {
                return "SPACE";
            }
        }
        return "" + (char)code;
    }

    private String decodeSyntax(int updateAt, int[] syntax) {
        StringBuffer out = new StringBuffer();
        out.append("[update at " + updateAt + "]");
        out.append("    syntax = " + KStyleContext.lookup(syntax[1]));
        out.append(", " + KStyleContext.lookup(syntax[2]));
        out.append("  begin at " + syntax[0]);
        out.append("  char prior to update = |" + this.asciToString(syntax[3]) + "|  char after update = |" + this.asciToString(syntax[4]) + "|\n");
        return out.toString();
    }

    public void initDebugMessage(String title, int updateAt, Syntax syntax) {
        this.msg.setLength(0);
        this.msg.append("\n" + title + " ");
        this.msg.append("[updateAt " + updateAt + "]");
        this.msg.append(syntax.toString());
    }

    protected void displayDebugMessage(int[] span) {
        if (span == null) {
            Cutter.setLog(this.msg.toString());
        } else {
            Cutter.setLog(this.msg.append("\nparse " + span[0] + " to " + span[1]));
        }
    }

    static {
        String str = Preferences.get(Preferences.TEXT_COLOR_MAXLENGTH);
        if (str != null) {
            try {
                userMaxColoredLength = Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                Cutter.setLog("    Warning: SyntaxListener.getUserPrefs() expected an integer from Preferences.TEXT_COLOR_MAXLENGTH = >" + str + "<");
                userMaxColoredLength = 1;
            }
        }
        userWantsColoration = (str = Preferences.get(Preferences.TEXT_COLOR_ACTIVE)) != null && str.equals("true");
        try {
            Field[] fields = new Field[]{SyntaxListener.class.getDeclaredField("_getExistingSyntax"), SyntaxListener.class.getDeclaredField("_insertUpdate"), SyntaxListener.class.getDeclaredField("_removeUpdate"), SyntaxListener.class.getDeclaredField("_findStartOfNextWord"), SyntaxListener.class.getDeclaredField("_findStartOfPreviousWord"), SyntaxListener.class.getDeclaredField("_parse"), SyntaxListener.class.getDeclaredField("_parseTime"), SyntaxListener.class.getDeclaredField("_removeComments"), SyntaxListener.class.getDeclaredField("_finalize")};
            Cutter.addDebug(SyntaxListener.class, fields);
        }
        catch (NoSuchFieldException ex) {
            Cutter.setLog("Error: SyntaxListener.static - " + ex.toString());
        }
        defaultLanguageColor = new Color(0, 0, 179);
        ignoreRemoveUpdate = false;
    }
}

