/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Tcl;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Desktop.KDesktop;
import UI_Script.Help.KAbstractHelp;
import UI_Script.Tcl.TclTokenizer;
import UI_Text.KTextPane.KTextPane;
import UI_Tools.AssetManagement.HtmlWriterIndex;
import Utilities.FileUtils;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JSeparator;

public class TclHelp
extends KAbstractHelp {
    protected static KAbstractHelp TclHelp = null;
    public static String docsPath;
    public static String docsIndexURL;
    public static String cutrTclIndexURL;
    private static String TCL_DOCS_NOT_FOUND_URL;
    static String[] fileTypes;
    private static Hashtable<String, String> languageTable;
    private static String REFER_TO_FULL_DOCS;

    public static void initPaths() {
        docsPath = UI_Script.Tcl.TclHelp.configurePath(Preferences.get(Preferences.PATH_TCL_DOCS));
        if (docsPath.equals("")) {
            docsPath = new File(FileUtils.getPWD(), "Cutter_Help/tcl/ActiveTcl/tcl/TclCmd").getPath();
        }
        docsPath = UI_Script.Tcl.TclHelp.configurePath(docsPath);
        docsPath = docsPath + "/";
    }

    public static String getcutrTclIndexURL() {
        File file = new File(FileUtils.getPWD(), "Cutter_Help/tcl/ActiveTcl/tcl/cutrTclIndex.html");
        cutrTclIndexURL = file.getPath();
        cutrTclIndexURL = UI_Script.Tcl.TclHelp.configurePath(cutrTclIndexURL);
        return cutrTclIndexURL;
    }

    public static boolean docsIndexURLIsValid() {
        String str = UI_Script.Tcl.TclHelp.getcutrTclIndexURL();
        if (str == null || str.length() == 0) {
            return false;
        }
        return KAbstractHelp.docsIndexURLIsValid(str);
    }

    @Override
    public boolean showDocFor(String item, MouseEvent e) {
        if (e.getModifiers() < 20) {
            Cutter.setLog("    Debug:TclHelp.showDocFor() - return false because e.getModifiers() < 20");
            return false;
        }
        this.useCutterBrowser = !e.isShiftDown();
        return this.launchBrowser(item);
    }

    public TclHelp(KTextPane textpane) {
        super(textpane);
        UI_Script.Tcl.TclHelp.initPaths();
        this.completer.completionActivate();
        this.completer.setWordStartDelims(null);
        this.completer.setListeners(textpane, this);
    }

    @Override
    public void setCompletorListeners() {
        this.completer.setListeners(this.textpane, this);
    }

    @Override
    public boolean completionTargetIsValid(String str) {
        if (str == null || str.trim().length() == 0) {
            return false;
        }
        if (str.length() < 2) {
            return false;
        }
        return Character.isLowerCase(str.charAt(0));
    }

    @Override
    public String[] completionCandidates(String str) {
        return this.completionCandidates(str, languageTable);
    }

    @Override
    protected void lookup(String item) {
        if (item == null) {
            return;
        }
        TclTokenizer tok = new TclTokenizer();
        tok.setBuffer(item);
        if (tok.isFunction(item)) {
            if (TclTokenizer.language.get(item).equals("tk")) {
                File tclDir = new File(docsPath).getParentFile();
                File tkDir = new File(tclDir, "TkCmd/" + item + ".htm");
                if (!this.setHelpPage(tkDir.getPath())) {
                    this.setGenericPage();
                }
            } else if (TclTokenizer.language.get(item).equals("tklib")) {
                File tclDir = new File(docsPath).getParentFile();
                File tklibDir = new File(tclDir, "TkLib/" + item + ".htm");
                if (!this.setHelpPage(tklibDir.getPath())) {
                    this.setGenericPage();
                }
            } else if (TclTokenizer.language.get(item).equals("tcllib")) {
                File tclDir = new File(docsPath).getParentFile();
                File tcllibDir = new File(tclDir, "TclLib/" + item + ".htm");
                if (!this.setHelpPage(tcllibDir.getPath())) {
                    this.setGenericPage();
                }
            } else if (!this.setHelpPage(docsPath + item + ".htm")) {
                this.setGenericPage();
            }
        } else {
            this.setGenericPage();
        }
    }

    protected void setGenericPage() {
        String masterIndex = Preferences.get(Preferences.PATH_TCL_DOCS) + "/contents.htm";
        Cutter.setLog("TclHelp.setGenericPage() masterIndex = " + masterIndex);
        if (FileUtils.exists(masterIndex)) {
            this.setHelpPage(docsPath + "/contents.htm");
        } else {
            Cutter.setLog("setHelpPage(TCL_DOCS_NOT_FOUND_URL) = " + TCL_DOCS_NOT_FOUND_URL);
            this.setHelpPage(TCL_DOCS_NOT_FOUND_URL);
        }
    }

    @Override
    public void popupTypingCompletion(Point pnt, String textToComplete, int insertAt, MouseEvent e) {
    }

    @Override
    protected JComponent[] getDefaultPopupItems(MouseEvent e, String initialSelection, int begin, int end) {
        this.initSelectionData(initialSelection, begin, end);
        this.mouseEvent = e;
        JComponent[] list = new JComponent[]{this.getDefaultSendMailMenu(), this.getDefaultOpenPathMenu(), this.getDefaultSelectBlockMenu(), this.getDefaultFileBrowseMenu(), this.getDefaultEditMenu(), this.getDefaultTextShiftMenu(), this.getDefaultCmntMenu(), this.getDefaultCaseMenu(), this.getDefaultEditRGBMenu(), this.getDefaultExportAsHtml(), this.getDefaultLineNumbering(), this.getDefaultTypingCompletion(), new JSeparator(), this.getDefaultExecute()};
        return list;
    }

    @Override
    public void popupOnlineHelp(Point pnt, final String selection, final int end, MouseEvent e) {
        KAbstractHelp.KPopupMenu popup = new KAbstractHelp.KPopupMenu();
        JComponent[] items = this.getDefaultPopupItems(e, selection, end - selection.length(), end);
        for (int n = 0; n < items.length; ++n) {
            if (items[n] == null) continue;
            popup.add(items[n]);
        }
        popup.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                int begin = end - selection.length();
                if (begin >= 0 && end >= 0) {
                    BBxt.setSelection(begin, end);
                }
            }
        });
        popup.pack();
        popup.show(this.textpane, pnt.x, pnt.y);
    }

    static {
        TCL_DOCS_NOT_FOUND_URL = HELP_DOCS_BASE_URL + "tcl/notfound.html";
        fileTypes = new String[]{".tcl", ".TCL"};
        languageTable = new Hashtable();
        docsPath = UI_Script.Tcl.TclHelp.configurePath(Preferences.get(Preferences.PATH_TCL_DOCS));
        listOfSubClasses.addElement(TclHelp.class);
        docsIndexURL = docsPath + File.separatorChar + "index.html";
        File tclDir = new File(FileUtils.getPWD(), "Cutter_Help/tcl/ActiveTcl/tcl");
        File cutrTclIndexFile = new File(FileUtils.getPWD(), "Cutter_Help/tcl/ActiveTcl/tcl/cutrTclIndex.html");
        File cutter_helpFile = new File(FileUtils.getPWD(), "Cutter_Help/tcl/ActiveTcl/tcl/cutrTclIndex.html");
        cutrTclIndexURL = cutrTclIndexFile.getPath();
        cutrTclIndexURL = UI_Script.Tcl.TclHelp.configurePath(cutrTclIndexURL);
        if (tclDir.exists()) {
            Cutter.setLog("    Info: TclHelp attempting to make the index for the TCL docs");
            HtmlWriterIndex.createHostDir(cutrTclIndexFile);
            try {
                HtmlWriterIndex indexer = new HtmlWriterIndex(cutrTclIndexFile);
                indexer.makePage();
            }
            catch (IOException e) {
                Cutter.setLog("    Exception: TclHelp.static()  >" + e.toString() + "<");
            }
            Cutter.setLog("    Info: TclHelp successfully made the index for the TCL docs");
        }
        if (cutrTclIndexFile.exists() && tclDir.exists()) {
            KDesktop.tclIndexItem.setEnabled(true);
        } else {
            Cutter.setLog("    Info: TclHelp cannot make the index for TCL docs. One or other of these items\n          " + cutrTclIndexFile.getPath() + " exists = " + cutrTclIndexFile.exists() + "\n          " + tclDir.getPath() + " exists = " + tclDir.exists() + "\n          does not exist!");
            KDesktop.tclIndexItem.setEnabled(false);
        }
        Enumeration<String> e = TclTokenizer.language.keys();
        while (e.hasMoreElements()) {
            String str = e.nextElement().toString();
            languageTable.put(str.toLowerCase(), str);
        }
        REFER_TO_FULL_DOCS = "Refer to full documentation";
    }
}

