/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Tcl;

import Preferences.Preferences;
import UI_Script.SyntaxListener;
import UI_Script.Tcl.TclTokenizer;
import UI_Text.KTextPane.KTextPane;
import UI_Text.Style.StyleEdits;
import java.awt.Color;
import javax.swing.text.StyleConstants;
import kernal.Tokenizers.Tokenizer;

public class TclListener
extends SyntaxListener {
    private TclTokenizer tcl = new TclTokenizer();

    public TclListener(KTextPane textpane, Tokenizer tok) {
        super(textpane, tok);
        this.initDelimitors(textpane);
        this.initStyles(textpane);
    }

    public TclListener(KTextPane textpane) {
        super(textpane, new TclTokenizer());
        this.initDelimitors(textpane);
        this.initStyles(textpane);
    }

    @Override
    public void initDelimitors(KTextPane textpane) {
        char[] delim = new char[]{'-', '$'};
        textpane.addWordDelimitors(delim, delim);
        char[] begin = new char[]{'$'};
        textpane.removeWordDelimitors(begin, null);
    }

    @Override
    public void initStyles(KTextPane textpane) {
        super.initStyles(textpane);
        StyleConstants.setForeground(textpane.styleContext.plainStyle, Preferences.getColor(Preferences.TEXT_COLOR_TCL_PLAIN));
        StyleConstants.setForeground(textpane.styleContext.commentStyle1, Preferences.getColor(Preferences.TEXT_COLOR_TCL_COMMENT));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle3, Preferences.getColor(Preferences.TEXT_COLOR_TCL_USER_VARIABLE));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle1, Preferences.getColor(Preferences.TEXT_COLOR_TCL_FUNCTION));
        Color blue = SyntaxListener.defaultLanguageColor;
        StyleConstants.setForeground(this.textpane.styleContext.keywordStyle2, blue);
        StyleConstants.setForeground(textpane.styleContext.stringStyle1, Preferences.getColor(Preferences.TEXT_COLOR_TCL_STRING));
        StyleConstants.setForeground(textpane.styleContext.stringStyle2, Preferences.getColor(Preferences.TEXT_COLOR_TCL_STRING));
    }

    @Override
    protected void colorizeLiteral(int offset, String str, StyleEdits editList) {
        this.tcl.setBuffer(str);
        this.tcl.getComments = true;
        String s = this.tcl.getNextStr();
        while (!s.equals("")) {
            int index = this.tcl.getBufferIndex() - 1 < 0 ? 0 : this.tcl.getBufferIndex();
            int begin = (index += offset) - s.length();
            int length = s.length();
            if (this.tok.isUserVariable(s)) {
                int i;
                if (s.charAt(0) == '-') {
                    editList.addEdit(begin, 1, this.textpane.styleContext.stringStyle1, true);
                    length = s.length() - 1;
                    editList.addEdit(++begin, length, this.textpane.styleContext.keywordStyle3, true);
                }
                if ((i = s.indexOf(92)) != -1) {
                    editList.addEdit(begin, length, this.textpane.styleContext.keywordStyle3, true);
                    editList.addEdit(begin += i, length -= i, this.textpane.styleContext.stringStyle1, true);
                } else {
                    editList.addEdit(begin, s.length(), this.textpane.styleContext.keywordStyle3, true);
                }
            } else if (this.tcl.isIceFunction(s)) {
                editList.addEdit(begin, length, this.textpane.styleContext.keywordStyle2, true);
            } else {
                editList.addEdit(begin, s.length(), this.textpane.styleContext.stringStyle1, true);
            }
            s = this.tcl.getNextStr();
        }
    }

    @Override
    protected boolean customSyntax(String str, int begin, StyleEdits editList) {
        if (str.charAt(0) == '\"') {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.stringStyle1, true);
            String tmp = str.substring(1, str.length() - 0);
            if (tmp.length() > 0) {
                this.colorizeLiteral(begin + 1, tmp, editList);
                return true;
            }
            return false;
        }
        if (this.tok.isUserVariable(str)) {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.keywordStyle3, true);
            return true;
        }
        if (((TclTokenizer)this.tok).isItFunction(str)) {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.keywordStyle2, true);
            return true;
        }
        if (((TclTokenizer)this.tok).isINIFunction(str)) {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.keywordStyle2, true);
            return true;
        }
        if (((TclTokenizer)this.tok).isRISFunction(str)) {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.keywordStyle2, true);
            return true;
        }
        return false;
    }

    @Override
    public void addComments() {
        this.addComments("#");
    }
}

