/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Tcl;

import Processes.ProcessManager;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Script.Help.KAbstractHelp;
import UI_Script.ScriptHandler;
import UI_Script.ScriptParser.ScriptStructure;
import UI_Script.Tcl.OpenTclAction;
import UI_Script.Tcl.TclHelp;
import UI_Script.Tcl.TclListener;
import UI_Script.Tcl.TclTokenizer;
import UI_Text.KTextPane.KTextPane;
import UI_Window.KWindow.KAbstractWindow;
import UI_Window.KWindow.KTextHistoryWindow;
import UI_Window.KWindow.KTextWindow;
import Utilities.DocumentUtils;
import Utilities.EnumUtils;
import Utilities.FileUtils;
import Utilities.KFileFilter;
import Utilities.TextUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.text.Document;
import kernal.Tokenizers.Tokenizer;

public class TclScriptHandler
extends ScriptHandler {
    public static final String BATCH_PRMAN_RENDER = "batch_prman_render";
    private static ResourceBundle res;

    protected static String getDocString(String nm) {
        String str = null;
        try {
            str = res.getObject(nm).toString();
        }
        catch (MissingResourceException mre) {
            Cutter.setLog("    Error: TclScriptHandler.getDocsSting()\n" + mre);
            str = null;
        }
        return str;
    }

    @Override
    public boolean canRunSelection() {
        return true;
    }

    public TclScriptHandler() {
        this.ext = new String[4];
        this.ext[0] = ".tcl";
        this.ext[1] = ".TCL";
        this.ext[2] = ".ini";
        this.ext[3] = ".INI";
        this.setTokenizer();
    }

    @Override
    protected void setTokenizer() {
        this.tokenizer = new TclTokenizer();
    }

    @Override
    public void deleteTmpFile() {
        File tmp = new File(FileUtils.getPWD(), "temp.tcl");
        if (tmp.exists()) {
            tmp.delete();
        }
    }

    @Override
    public String getScriptName() {
        return "Tcl";
    }

    @Override
    public String getExecuteLabel() {
        return "Execute " + this.getScriptName();
    }

    @Override
    public String getMakeLabel() {
        return null;
    }

    @Override
    public String getRunLabel() {
        return null;
    }

    @Override
    protected void make(File srcDir) {
    }

    @Override
    protected void run() {
    }

    @Override
    public void execute(File file) {
        boolean isWish = false;
        if (BBxt.isItIceDocument()) {
            Cutter.setLog("    Info:TclScriptHandler.execute(File) - isItIceDocument true");
            String text = BBxt.getWindowText();
            if (text == null) {
                Cutter.setLog("    Error:TclScriptHandler.execute(File) - front window has no text");
                return;
            }
            StringBuffer buf = new StringBuffer();
            for (int n = 0; n < text.length(); ++n) {
                if (text.charAt(n) == '\n') {
                    buf.append('\r');
                    continue;
                }
                buf.append(text.charAt(n));
            }
            text = buf.toString();
            text = TextUtils.trimTrailingChar(text, '\r');
            String[] items = new String[]{"it", "-console \r", text};
            ProcessManager fp = new ProcessManager("it");
            fp.launch(items, new File(FileUtils.getPWD()), false, null, false, false);
            return;
        }
        KAbstractWindow w = KAbstractDesktop.getWindowWithFile(file);
        String[] lines = null;
        if (w != null && w instanceof KTextWindow) {
            Document doc;
            JEditorPane textpane = BBxt.getTextPane(w);
            if (textpane != null && (lines = DocumentUtils.getParagraphs(doc = textpane.getDocument(), 1, 8)) != null) {
                for (int n = 0; n < lines.length; ++n) {
                    String[] strs = TextUtils.tokenize(lines[n].toString().trim(), " /");
                    if (strs == null) continue;
                    for (int i = 0; i < strs.length; ++i) {
                        if (!strs[i].equalsIgnoreCase("wish")) continue;
                        isWish = true;
                    }
                }
            }
        } else {
            Enumeration<String> e = FileUtils.readLines(file.getPath());
            lines = EnumUtils.toStringArray(e);
            if (lines != null) {
                for (int n = 0; n < lines.length; ++n) {
                    String[] strs = TextUtils.tokenize(lines[n].toString().trim(), " /");
                    if (strs == null) continue;
                    for (int i = 0; i < strs.length; ++i) {
                        if (!strs[i].equalsIgnoreCase("wish")) continue;
                        isWish = true;
                    }
                }
            }
        }
        String args = "";
        if (lines != null && lines.length > 0) {
            Tokenizer tok = new Tokenizer();
            tok.addQuotation("\"", "\"", '\\');
            for (int n = 0; n < lines.length; ++n) {
                tok.setBuffer(lines[n]);
                args = tok.getValueForToken("ARGS", true);
                if (args != null) break;
            }
        }
        String[] items = args != null ? new String[]{"tclsh", file.getPath(), args} : new String[]{"tclsh", file.getPath()};
        if (isWish) {
            items[0] = "wish";
        }
        String cmndName = isWish ? "Wish" : "Tcl";
        ProcessManager fp = new ProcessManager(cmndName);
        fp.launch(items, null, true, null, false);
    }

    @Override
    public void executeFromHistory(KTextHistoryWindow window) {
        String str = window.getAllText();
        if (str == null || str.trim().length() == 0) {
            Cutter.setLog("    Info:TclScriptHandler.executeFromHistory() - no text in history, cannot execute.");
        }
        this.execute(str);
    }

    @Override
    public void execute(String str) {
        File file = new File(FileUtils.getPWD(), "temp.tcl");
        FileUtils.writeFile(file, str);
        this.execute(file);
    }

    @Override
    public KAbstractHelp getHelper(KTextPane textpane) {
        KAbstractHelp.add(textpane.helper);
        return KAbstractHelp.getInstanceByName(TclHelp.class.getName(), textpane);
    }

    @Override
    public String getSyntaxListenerClassName(KTextPane textpane) {
        return TclListener.class.getName();
    }

    @Override
    public JMenuItem getOpenFileMenuItem() {
        JMenuItem item = new JMenuItem("Tcl");
        item.addActionListener(new OpenTclAction());
        return item;
    }

    @Override
    public ScriptStructure getStructure() {
        return null;
    }

    @Override
    public JMenu getTemplateMenu() {
        JMenu tcl = new JMenu("Tcl");
        JMenuItem item = new JMenuItem("Prman Batch Render");
        ActionListener batchRenderAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TclScriptHandler.createDocument("untitled.tcl", TclScriptHandler.BATCH_PRMAN_RENDER);
            }
        };
        item.addActionListener(batchRenderAction);
        item.setEnabled(true);
        tcl.add(item);
        return tcl;
    }

    public static void createDocument(String title, String docType) {
        String docStr = TclScriptHandler.getDocString(docType);
        templateBuffer.setLength(0);
        String[] lineItems = TextUtils.tokenize(docStr);
        for (int n = 0; n < lineItems.length; ++n) {
            String line = TclScriptHandler.getDocString(lineItems[n]);
            templateBuffer.append(line);
        }
        BBxt.newDocument(title, templateBuffer);
    }

    @Override
    public KFileFilter getFileFilter() {
        KFileFilter filter = new KFileFilter("tcl", "Tcl Script");
        return filter;
    }

    static {
        try {
            res = ResourceBundle.getBundle("UI_Script.Tcl.TclDocumentsRsrc");
        }
        catch (MissingResourceException mre) {
            Cutter.setLog("TclScriptHandler: a resource file is missing --> " + mre);
        }
    }
}

