/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Tcl;

import UI_Desktop.Cutter;
import UI_Script.ScriptParser.ProcDBItem;
import UI_Script.Tcl.INIFunctionsRsrc;
import UI_Script.Tcl.ITICEFunctionsRsrc;
import UI_Script.Tcl.TCLFunctionsRsrc;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import kernal.Tokenizers.Tokenizer;

public class TclTokenizer
extends Tokenizer {
    public static final String TKFUNCTION = "tk";
    public static final String TKLIBFUNCTION = "tklib";
    public static final String TCLLIBFUNCTION = "tcllib";
    public static final String ITFUNCTION = "it";
    public static final String ICEFUNCTION = "ice";
    public static final String INIFUNCTION = "ini";
    protected static ResourceBundle TCLFunctionsRes;
    protected static ResourceBundle ITICEFuntionsRes;
    protected static ResourceBundle INIFuntionsRes;
    public static Hashtable<String, String> language;
    public static Hashtable<String, String> itIceLanguage;
    public static Hashtable<String, String> iniLanguage;

    private static int numINIItems() {
        int num = 0;
        try {
            num = ((INIFunctionsRsrc)INIFuntionsRes).getNumItems();
        }
        catch (MissingResourceException mre) {
            System.out.println("cannot read INIFunctionsRsrc");
        }
        return num;
    }

    private static int numITICEItems() {
        int num = 0;
        try {
            num = ((ITICEFunctionsRsrc)ITICEFuntionsRes).getNumItems();
        }
        catch (MissingResourceException mre) {
            System.out.println("cannot read ITICEFunctionsRsrc");
        }
        return num;
    }

    private static int numLanguageItems() {
        int num = 0;
        try {
            num = ((TCLFunctionsRsrc)TCLFunctionsRes).getNumItems();
        }
        catch (MissingResourceException mre) {
            System.out.println("cannot read TCLFunctionsRsrc");
        }
        return num;
    }

    private static void initHashTables() {
        int i;
        for (i = 0; i < TclTokenizer.numITICEItems(); ++i) {
            itIceLanguage.put(((ITICEFunctionsRsrc)ITICEFuntionsRes).getKey(i), ((ITICEFunctionsRsrc)ITICEFuntionsRes).getContent(i));
        }
        for (i = 0; i < TclTokenizer.numINIItems(); ++i) {
            iniLanguage.put(((INIFunctionsRsrc)INIFuntionsRes).getKey(i), ((INIFunctionsRsrc)INIFuntionsRes).getContent(i));
        }
        for (i = 0; i < TclTokenizer.numLanguageItems(); ++i) {
            language.put(((TCLFunctionsRsrc)TCLFunctionsRes).getKey(i), ((TCLFunctionsRsrc)TCLFunctionsRes).getContent(i));
        }
    }

    public TclTokenizer() {
        this.addComment("#", "\n");
        char[] esc_chars = new char[]{'\\', '^'};
        this.addQuotation("\"", "\"", esc_chars);
        this.setSyntaxLength(1);
        this.addEscape("\\\"", "");
        this.addEscape("^\"", "");
        this.addEscape("\\\\", "");
        this.addEscape("\\'", "");
        this.addEscape("\\[", "");
        this.addEscape("\\]", "");
        this.addEscape("\\{", "");
        this.addEscape("\\}", "");
        this.addEscape("\\$", "");
        this.setDefaultDelimitors();
        this.appendDelimitor("*-+=/");
        this.appendDelimitor("/$&?@%~!");
        this.removeDelimitor("$-");
        String[] ext = new String[]{"tcl", "TCL"};
        Tokenizer.addToRegistry(TclTokenizer.class, ext, this.getComments(), this.getDelimitors());
    }

    @Override
    public ProcDBItem lpGrabProc(String str) {
        ProcDBItem out = new ProcDBItem();
        int index = this.getBufferIndex();
        if (!str.equals("proc")) {
            this.setBufferIndex(index);
            return null;
        }
        str = this.getNextStr();
        if (str.equals("")) {
            this.setBufferIndex(index);
            return null;
        }
        out.procName = str;
        String enclosingName = "";
        int procNameOffset = this.getBufferIndex();
        for (int j = 0; j < this.listOfClassInterfaceSpans.size(); ++j) {
            Tokenizer.ClassInterfaceSpan cis = (Tokenizer.ClassInterfaceSpan)this.listOfClassInterfaceSpans.elementAt(j);
            if (procNameOffset < cis.span[0] || procNameOffset > cis.span[1]) continue;
            enclosingName = cis.name;
            break;
        }
        if (enclosingName.trim().length() > 0) {
            out.procName = enclosingName + "::" + out.procName;
        }
        out.procNameOffset = new int[2];
        out.procNameOffset[1] = this.getBufferIndex();
        out.procNameOffset[0] = out.procNameOffset[1] - str.length();
        str = this.getNextStr();
        if (str.equals("")) {
            this.setBufferIndex(index);
            return null;
        }
        if (str.equals("{")) {
            str = this.getNextStr();
            while (!str.startsWith("{")) {
                str = this.getNextStr();
                if (!str.equals("")) continue;
                return out;
            }
            this.ungetString(str);
            int[] offset = this.lpGrabProcBody("{", "}", null);
            out.procOffset[0] = offset == null ? 0 : out.procNameOffset[0];
            out.procOffset[1] = offset == null ? 0 : offset[1];
            return out;
        }
        this.setBufferIndex(index);
        return null;
    }

    @Override
    public boolean isUserVariable(String str) {
        if (str.charAt(0) == '$') {
            return true;
        }
        return str.length() > 1 && str.charAt(0) == '-' && str.charAt(1) == '$';
    }

    public boolean isItIceFunction(String str) {
        return itIceLanguage.containsKey(str);
    }

    public boolean isItFunction(String str) {
        if (!itIceLanguage.containsKey(str)) {
            return false;
        }
        return itIceLanguage.get(str).equals(ITFUNCTION);
    }

    public boolean isRISFunction(String str) {
        return str != null && (str.equals("Displacement") || str.equals("Bxdf") || str.equals("Pattern"));
    }

    public boolean isIceFunction(String str) {
        if (!itIceLanguage.containsKey(str)) {
            return false;
        }
        return itIceLanguage.get(str).equals(ICEFUNCTION);
    }

    public boolean isINIFunction(String str) {
        if (!iniLanguage.containsKey(str)) {
            return false;
        }
        return iniLanguage.get(str).equals(INIFUNCTION);
    }

    public boolean isCommandSubstitution(String str) {
        return str.charAt(0) == '[';
    }

    @Override
    public boolean isFunction(String str) {
        return language.containsKey(str);
    }

    @Override
    public boolean isLanguageType(String str) {
        if (language.containsKey(str)) {
            return language.get(str).equals("language");
        }
        return false;
    }

    public String __getNextStr() {
        char c;
        boolean literal = false;
        boolean endOfString = false;
        boolean endOfComment = false;
        this.debug = false;
        if (this.debug) {
            Cutter.setLog("Entered GetNextStr");
        }
        if ((c = this.readChar()) == '\u0000') {
            if (this.debug) {
                Cutter.setLog("GetNextStr, readChar() ERROR, char = >" + c + "< index = " + this.getBufferIndex());
            }
            return "";
        }
        this.outBuff.setLength(0);
        if (this.debug) {
            Cutter.setLog("GetNextStr, read first char =  >" + c + "<");
        }
        if (this.debug) {
            Cutter.setLog("2c = |" + c + "|");
        }
        if (this.isSpace(c)) {
            c = this.removeSpace();
        }
        if (this.debug) {
            Cutter.setLog("stripped space c = |" + c + "| index = " + this.getBufferIndex());
        }
        if (c == '\u0000') {
            return "";
        }
        this.outBuff.append(c);
        if (c == ';') {
            return this.outBuff.toString();
        }
        char[] chars = this.peekNextChars(this.getOpenCmntLength() - 1);
        String temp = c + (chars == null ? "" : new String(chars));
        if (this.getComments && this.isOpenComment(temp)) {
            c = this.readChar();
            if (c == '\u0000' || c == '\r' || c == '\n') {
                return this.outBuff.toString();
            }
            do {
                this.outBuff.append(c);
                c = this.readChar();
                if (c != '\u0000') continue;
                return this.outBuff.toString();
            } while (c != '\r' && c != '\n');
            this.ungetChar();
            return this.outBuff.toString();
        }
        if (this.isDelimitor(c)) {
            return this.outBuff.toString();
        }
        if (c == '\"') {
            literal = true;
        }
        block10: while (!endOfString && !this.mEndOfBuffer) {
            c = this.readChar();
            switch (c) {
                case '\u0000': {
                    return this.outBuff.toString();
                }
                case '\"': {
                    if (literal) {
                        if (this.peekPrevChar(2) == '\\') {
                            this.outBuff.append(c);
                            continue block10;
                        }
                        this.outBuff.append(c);
                        return this.outBuff.toString();
                    }
                    this.ungetChar();
                    return this.outBuff.toString();
                }
                case '$': {
                    if (this.peekPrevChar(2) == '\\') {
                        this.outBuff.append(c);
                        continue block10;
                    }
                }
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case ']': 
                case '^': 
                case '}': {
                    if (literal) break;
                    if (this.debug) {
                        Cutter.setLog("Parenthesis c = " + c + " buff = |" + this.outBuff.toString() + "|");
                    }
                    this.ungetChar();
                    return this.outBuff.toString();
                }
                case '\t': 
                case ' ': {
                    if (literal) break;
                    this.ungetChar();
                    return this.outBuff.toString();
                }
                case '\n': 
                case '\r': {
                    if (literal) break;
                    this.ungetChar();
                    return this.outBuff.toString();
                }
                case '/': {
                    if (literal) break;
                    this.ungetChar();
                    return this.outBuff.toString();
                }
            }
            this.outBuff.append(c);
        }
        if (this.debug) {
            Cutter.setLog("getNextStr() is returning:" + this.outBuff.toString());
        }
        return this.outBuff.toString();
    }

    static {
        language = new Hashtable();
        itIceLanguage = new Hashtable();
        iniLanguage = new Hashtable();
        try {
            TCLFunctionsRes = ResourceBundle.getBundle("UI_Script.Tcl.TCLFunctionsRsrc");
            ITICEFuntionsRes = ResourceBundle.getBundle("UI_Script.Tcl.ITICEFunctionsRsrc");
            INIFuntionsRes = ResourceBundle.getBundle("UI_Script.Tcl.INIFunctionsRsrc");
        }
        catch (MissingResourceException mre) {
            Cutter.setLog("    Exception: TCLFunctionsRes, ITICEFuntionsRes or INIFuntionsRes = " + mre);
        }
        TclTokenizer.initHashTables();
    }
}

