/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Vfl;

import UI_Desktop.Cutter;
import UI_Script.C.CTokenizer;
import UI_Script.ScriptParser.ProcDBItem;
import UI_Script.Vfl.SLLanguageRsrc;
import Utilities.FinderUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import kernal.Tokenizers.Tokenizer;

public class SlTokenizer
extends Tokenizer {
    public static final String GEO_FUNCTION = "geometric";
    public static final String MATH_FUNCTION = "math";
    public static final String SHADE_FUNCTION = "shading";
    public static final String MAP_FUNCTION = "mapping";
    public static final String COLOR_FUNCTION = "color";
    public static final String VOLUME_FUNCTION = "volume";
    public static final String STRING_FUNCTION = "print";
    public static final String MESSAGE_FUNCTION = "message";
    public static final String COLOR_SPACE = "kolor_space";
    public static final String MATRIX_FUNCTION = "matrix";
    public static final String OVERLOADED_FUNCTION = "overloaded";
    public static final String ARRAY_FUNCTION = "array";
    public static final String PLAUSIBLE_FUNCTION = "plausible";
    public static final String MISC_FUNCTION = "misc";
    public static final int UNKNOWN_FUNCTION_ID = 0;
    public static final int GEO_FUNCTION_ID = 1;
    public static final int MATH_FUNCTION_ID = 2;
    public static final int SHADE_FUNCTION_ID = 3;
    public static final int MAP_FUNCTION_ID = 4;
    public static final int COLOR_FUNCTION_ID = 5;
    public static final int VOLUME_FUNCTION_ID = 6;
    public static final int STRING_FUNCTION_ID = 7;
    public static final int MESSAGE_FUNCTION_ID = 8;
    public static final int COLOR_SPACE_ID = 9;
    public static final int MATRIX_FUNCTION_ID = 10;
    public static final int OVERLOADED_FUNCTION_ID = 11;
    public static final int ARRAY_FUNCTION_ID = 12;
    public static final int PLAUSIBLE_FUNCTION_ID = 13;
    public static final int MISC_FUNCTION_ID = 14;
    public static final String SURFACE = "surface";
    public static final String DISPLACEMENT = "displacement";
    public static final String LIGHT = "light";
    public static final String VOLUME = "volume";
    public static final String IMAGER = "imager";
    public static final String TRANSFORM = "transform";
    private static ResourceBundle SLStatementsRes;
    public static Hashtable<String, String> language;
    public static final double version = 1.0;
    public static final String[] SHADERTYPES;
    public static final String[] DATATYPES;
    public static final String[] STDRSLTYPES;
    public static final String[] DATAMODIFIERS;
    public String[] shaderTypes = SHADERTYPES;
    public String[] dataTypes = VectorUtils.toStringArray(DATATYPES, STDRSLTYPES);
    public String[] dataModifiers = DATAMODIFIERS;
    public String[] stdrslTypes = STDRSLTYPES;
    public boolean getComments = false;
    protected int typeStringOffset = -1;
    protected int nameStringOffset = -1;
    protected int shaderTypeBegin = -1;
    protected int shaderVarsBegin = -1;
    protected String shaderName = null;
    protected String shaderType = null;
    protected String shaderDescription = null;
    static String[] SLIM_MACROS;

    private static String getFunction(String nm) {
        String str;
        try {
            str = SLStatementsRes.getObject(nm).toString();
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    private static int numFunctions() {
        int num = 0;
        try {
            num = ((SLLanguageRsrc)SLStatementsRes).getNumItems();
        }
        catch (MissingResourceException mre) {
            System.out.println("cannot read SLLanguageRsrc");
        }
        return num;
    }

    private static void initHashTable() {
        for (int i = 0; i < SlTokenizer.numFunctions(); ++i) {
            language.put(((SLLanguageRsrc)SLStatementsRes).getKey(i), ((SLLanguageRsrc)SLStatementsRes).getContent(i));
        }
    }

    public Hashtable getSLIM_MacroValues() {
        Hashtable<String, String> table = new Hashtable<String, String>();
        String value = "";
        int[] offset = null;
        int oldOffset = this.getBufferIndex();
        this.setBufferIndex(0);
        for (int n = 0; n < SLIM_MACROS.length; ++n) {
            if (Cutter.input.debug) {
                Cutter.setLog("    Debug:SlTokenizer.getSLIM_MacroValues() - SLIM_MACROS[n] >" + SLIM_MACROS[n] + "<");
            }
            if ((offset = this.charSearch(SLIM_MACROS[n], false)) != null) {
                this.setBufferIndex(offset[1]);
                value = this.getNextStr().trim();
                table.put(SLIM_MACROS[n], value);
                continue;
            }
            if (!Cutter.input.debug) continue;
            Cutter.setLog("    Debug:SlTokenizer.getSLIM_MacroValues() - could not find >" + SLIM_MACROS[n] + "<");
        }
        this.setBufferIndex(oldOffset);
        return table;
    }

    public boolean isSLIM_Shader() {
        int[] slimOffsets = this.charSearch("SLIM_VERSION", false);
        return slimOffsets != null;
    }

    public boolean isRMSHyperShade_shader() {
        String src = new String(this.getBuffer());
        FinderUtils.FindDB db = FinderUtils.doFind(src, "RMSSTAMP", 0, false, true);
        return db.absBegin != -1;
    }

    public String[] getShaderTypeAndName() {
        StringBuffer buff = new StringBuffer();
        String posName = null;
        String posType = null;
        Object posOpenParen = null;
        Object comment = null;
        boolean offset = false;
        int beginAt = -1;
        int endAt = -1;
        boolean found = false;
        boolean return_delim = this.getNextStr_return_delimitor;
        String delims = this.getDelimitors();
        boolean isRMS = this.isRMSHyperShade_shader();
        Cutter.setLog("    Info:SlTokenizer.getShaderTypeAndName() - isRMSHyperShade_shader = " + isRMS);
        boolean isSlim = this.isSLIM_Shader();
        Cutter.setLog("    Info:SlTokenizer.getShaderTypeAndName() - isSLIM_Shader = " + isSlim);
        if (isSlim) {
            int[] typeoffsets = this.stringSearch("SLIM_SHADERTYPE", false);
            int[] nameoffsets = this.stringSearch("SLIM_INSTANCENAME", false);
            if (nameoffsets == null || typeoffsets == null) {
                Cutter.setLog("    Error:SlTokenizer.getShaderTypeAndName() - the shader defines SLIM_VERSION,\n           however, the values of SLIM_SHADERTYPE and/or SLIM_INSTANCENAME cannot\n           be found in the file. The tokenizer is unable to determine what type\n           of shader is being compiled or the name of the shader.");
                return null;
            }
            this.setBufferIndex(typeoffsets[1]);
            posType = this.getNextStr().trim();
            if (posType.equals("")) {
                Cutter.setLog("    Error:SlTokenizer.getShaderTypeAndName() - the shader source was generated,\n           from a Slim template. The tokenizer was unable to find the value of\n           defined constant SLIM_SHADERTYPE!");
                return null;
            }
            this.setBufferIndex(nameoffsets[1]);
            posName = this.getNextStr().trim();
            if (posName.equals("")) {
                Cutter.setLog("    Error:SlTokenizer.getShaderTypeAndName() - the shader source was generated,\n           from a Slim template. The tokenizer was unable to find the value of\n           defined constant SLIM_INSTANCENAME!");
                return null;
            }
            String[] out = new String[]{posType, posName, "" + typeoffsets[0], "" + typeoffsets[1]};
            return out;
        }
        ShdTypeName db = this.getShaderTypeOffsets();
        if (db == null) {
            Cutter.setLog("    Error: SlTokenizer.getShaderTypeAndName() - failed to get type and name.");
            return null;
        }
        Cutter.setLog("    Debug: SlTokenizer.getShaderTypeAndName() - db = " + db.toString());
        this.shaderTypeBegin = db.beginOffset;
        String[] out = new String[]{db.shaderType, db.shaderName, "" + db.beginOffset, "" + db.endOffset};
        return out;
    }

    private ShdTypeName getShaderTypeOffsets() {
        int n;
        ShdTypeName db;
        int oldIndex = this.getBufferIndex();
        Vector<ShdTypeName> candidates = new Vector<ShdTypeName>();
        for (int n2 = 0; n2 < this.shaderTypes.length; ++n2) {
            String s;
            this.setBufferIndex(0);
            int offset = this.searchFor(this.shaderTypes[n2], true);
            if (offset == -1 || (s = this.getNextStr()).equals("(") || s.equals(",") || TextUtils.isInList(this.shaderTypes, s)) continue;
            String possibleName = s;
            s = this.getNextStr();
            if (!s.equals("(")) continue;
            db = new ShdTypeName(this.shaderTypes[n2], possibleName, offset - this.shaderTypes[n2].length(), this.getBufferIndex());
            candidates.addElement(db);
        }
        this.setBufferIndex(oldIndex);
        if (candidates.size() == 0) {
            return null;
        }
        if (candidates.size() == 1) {
            return (ShdTypeName)candidates.elementAt(0);
        }
        int minOffset = 1000000;
        for (n = 0; n < candidates.size(); ++n) {
            db = (ShdTypeName)candidates.elementAt(n);
            if (db.beginOffset > minOffset) continue;
            minOffset = db.beginOffset;
        }
        for (n = 0; n < candidates.size(); ++n) {
            db = (ShdTypeName)candidates.elementAt(n);
            if (db.beginOffset > minOffset) continue;
            return db;
        }
        return null;
    }

    private int __getShaderTypeOffsets(StringBuffer outType) {
        int oldIndex = this.getBufferIndex();
        int foundAt = -1;
        int minOffset = 1000000;
        String type = "";
        char[] b = this.getBuffer();
        String text = new String(b);
        for (int n = 0; n < this.shaderTypes.length; ++n) {
            this.setBufferIndex(0);
            int offset = this.searchFor(this.shaderTypes[n], true);
            if (offset == -1 || this.nextNonWhiteCharIs(40) || offset >= minOffset) continue;
            type = this.shaderTypes[n];
            foundAt = this.getBufferIndex();
            break;
        }
        this.setBufferIndex(oldIndex);
        outType.append(type);
        return foundAt;
    }

    public String getShaderDescription() {
        if (this.shaderTypeBegin == -1) {
            Cutter.setLog("    Error: SlTokenizer.getShaderDescription() - shaderTypeBegin is -1");
        }
        int oldIndex = this.getBufferIndex();
        this.setBufferIndex(0);
        this.getComments = true;
        String str = this.getNextStr();
        String desc = "";
        while (!str.equals("")) {
            if (this.isOpenComment(str)) {
                desc = str;
            }
            if (this.getBufferIndex() >= oldIndex) break;
            str = this.getNextStr();
        }
        this.setBufferIndex(oldIndex);
        return desc.trim();
    }

    public SlTokenizer(char[] carray) {
        this();
        this.setBuffer(carray);
    }

    public SlTokenizer() {
        this.addComment("/*", "*/");
        this.addComment("//", "\n");
        this.addQuotation("\"", "\"", '\\');
        this.setSyntaxLength(2);
        this.name = "SlTokenizer";
        this.setDefaultDelimitors();
        this.appendDelimitor("*-+=/");
        this.appendDelimitor("/$&?@%~!");
        String[] ext = new String[]{"sl", "SL"};
        Tokenizer.addToRegistry(SlTokenizer.class, ext, this.getComments(), this.getDelimitors());
    }

    @Override
    public ProcDBItem lpGrabProc(String str) {
        String tmp;
        ProcDBItem out = new ProcDBItem();
        int index = this.getBufferIndex();
        if (str.equals("") || this.isComment(str)) {
            this.setBufferIndex(index);
            return null;
        }
        if (str.startsWith("#")) {
            int closeOfBlockOffset = this.findNewline(index);
            if (closeOfBlockOffset != -1) {
                this.setBufferIndex(closeOfBlockOffset + 1);
                return null;
            }
            this.setBufferIndex(index);
            return null;
        }
        if (str.equals("typedef") || str.equals("struct") || str.equals("extern")) {
            int closeOfBlockOffset = this.findForward(index, ';');
            if (closeOfBlockOffset != -1) {
                this.setBufferIndex(closeOfBlockOffset + 1);
                return null;
            }
            this.setBufferIndex(index);
            return null;
        }
        out.procType = str;
        Hashtable slimtable = null;
        boolean isSlimShader = false;
        if (out.procType.equals("SLIM_SHADERTYPE")) {
            isSlimShader = true;
            slimtable = this.getSLIM_MacroValues();
            tmp = (String)slimtable.get("SLIM_SHADERTYPE");
            if (tmp != null && tmp.trim().length() > 0) {
                out.procType = tmp;
            }
        }
        str = this.getNextStr();
        while (!str.equals("") && (str.equals("[") || str.equals("]") || str.equals("*"))) {
            str = this.getNextStr();
        }
        if (str.equals("")) {
            this.setBufferIndex(index);
            return null;
        }
        out.procName = str;
        if (out.procName.equals("SLIM_INSTANCENAME")) {
            if (slimtable == null) {
                slimtable = this.getSLIM_MacroValues();
            }
            if ((tmp = (String)slimtable.get("SLIM_INSTANCENAME")) != null && tmp.trim().length() > 0) {
                out.procName = tmp;
            }
        }
        if (str.equals("public") || str.equals("private")) {
            out.access = str;
            str = this.getNextStr();
            if (str.equals("") || !this.isDataType(str)) {
                return null;
            }
            out.procType = str;
            str = this.getNextStr();
            if (str.equals("")) {
                return null;
            }
            out.procName = str;
        } else if (this.isFunction(out.procName)) {
            this.setBufferIndex(index);
            return null;
        }
        out.procNameOffset = new int[2];
        out.procNameOffset[1] = this.getBufferIndex();
        out.procNameOffset[0] = out.procNameOffset[1] - str.length();
        String ptext = this.lpGrabProcParams("(", ")");
        if (ptext == null) {
            this.setBufferIndex(index);
            return null;
        }
        int[] offset = this.lpGrabProcBody("{", "}", null);
        if (offset == null) {
            this.setBufferIndex(index);
            return null;
        }
        out.procOffset[0] = out.procNameOffset[0];
        out.procOffset[1] = offset[1];
        for (int n = 0; n < CTokenizer.ILLEGAL_PROC_NAMES.length; ++n) {
            if (!out.procName.equals(CTokenizer.ILLEGAL_PROC_NAMES[n])) continue;
            return null;
        }
        if (TextUtils.contains("*-+=/", out.procName.charAt(0))) {
            return null;
        }
        if (offset != null) {
            if (!out.procType.equals("class")) {
                if (isSlimShader) {
                    this.setBufferIndex(offset[0]);
                }
                this.setBufferIndex(offset[0]);
                return out;
            }
            this.setBufferIndex(offset[0]);
            return out;
        }
        this.setBufferIndex(index);
        return null;
    }

    @Override
    public boolean isSystemHeader(String str) {
        return false;
    }

    @Override
    public boolean isFunction(String str) {
        if (SlTokenizer.getFunctionType(str) == 0) {
            return false;
        }
        return this.nextNonWhiteCharIs(40);
    }

    public static int getFunctionType(String functionName) {
        if (!language.containsKey(functionName)) {
            return 0;
        }
        String obj = language.get(functionName);
        if (obj == null) {
            return 0;
        }
        if (obj.equals(GEO_FUNCTION)) {
            return 1;
        }
        if (obj.equals(MATH_FUNCTION)) {
            return 2;
        }
        if (obj.equals(SHADE_FUNCTION)) {
            return 3;
        }
        if (obj.equals(MAP_FUNCTION)) {
            return 4;
        }
        if (obj.equals(COLOR_FUNCTION)) {
            return 5;
        }
        if (obj.equals("volume")) {
            return 6;
        }
        if (obj.equals(STRING_FUNCTION)) {
            return 7;
        }
        if (obj.equals(MESSAGE_FUNCTION)) {
            return 8;
        }
        if (obj.equals(MATRIX_FUNCTION)) {
            return 10;
        }
        if (obj.equals(ARRAY_FUNCTION)) {
            return 12;
        }
        if (obj.equals(PLAUSIBLE_FUNCTION)) {
            return 13;
        }
        if (obj.equals(MISC_FUNCTION)) {
            return 14;
        }
        if (obj.equals(OVERLOADED_FUNCTION)) {
            return 11;
        }
        return 0;
    }

    @Override
    public boolean isComment(String str) {
        return str.length() > 1 && str.charAt(0) == '/' && str.charAt(1) == '*';
    }

    @Override
    public boolean isDataType(String str) {
        for (int n = 0; n < this.dataTypes.length; ++n) {
            if (!str.equals(this.dataTypes[n])) continue;
            return !this.nextNonWhiteCharIs(40) && !this.nextNonWhiteCharIs(34);
        }
        return false;
    }

    public boolean isStdrslType(String str) {
        for (int n = 0; n < this.stdrslTypes.length; ++n) {
            if (!str.equals(this.stdrslTypes[n])) continue;
            return !this.nextNonWhiteCharIs(40) && !this.nextNonWhiteCharIs(34);
        }
        return false;
    }

    @Override
    public String[] getDataTypes() {
        return this.dataTypes;
    }

    @Override
    public boolean isDataModifier(String str) {
        for (int n = 0; n < this.dataModifiers.length; ++n) {
            if (!str.equals(this.dataModifiers[n])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isLanguageType(String str) {
        if (!language.containsKey(str)) {
            return false;
        }
        return language.get(str).equals("language");
    }

    public String[] getShaderTypes() {
        return this.shaderTypes;
    }

    @Override
    public boolean isShaderType(String str) {
        for (int n = 0; n < this.shaderTypes.length; ++n) {
            if (!str.equals(this.shaderTypes[n])) continue;
            return true;
        }
        return str.equals("class");
    }

    public void addShaderTypes(String[] extra) {
        if (extra == null || extra.length == 0) {
            return;
        }
        this.shaderTypes = VectorUtils.toStringArray(this.shaderTypes, extra);
    }

    @Override
    public boolean isNamedSpace(String s) {
        if (s.length() < 5) {
            return false;
        }
        String str = Tokenizer.removeQuotes(s);
        return str.compareTo("camera") == 0 || str.compareTo("world") == 0 || str.compareTo("current") == 0 || str.compareTo("shader") == 0 || str.compareTo("object") == 0 || str.compareTo("NDC") == 0 || str.compareTo("catmull-rom") == 0 || str.compareTo("bspline") == 0 || str.compareTo("linear") == 0 || str.compareTo("catmull-clark") == 0 || str.compareTo("rgb") == 0 || str.compareTo("hsv") == 0 || str.compareTo("hsl") == 0 || str.compareTo("xyz") == 0 || str.compareTo("xyY") == 0 || str.compareTo("YIQ") == 0;
    }

    @Override
    public boolean isSystemVariable(String str) {
        return str.compareTo("Cs") == 0 || str.compareTo("Ci") == 0 || str.compareTo("N") == 0 || str.compareTo("Os") == 0 || str.compareTo("Oi") == 0 || str.compareTo("P") == 0 || str.compareTo("Cl") == 0 || str.compareTo("I") == 0 || str.compareTo("E") == 0 || str.compareTo("PI") == 0 || str.compareTo("u") == 0 || str.compareTo("v") == 0 || str.compareTo("s") == 0 || str.compareTo("t") == 0 || str.compareTo("du") == 0 || str.compareTo("dv") == 0 || str.compareTo("L") == 0 || str.compareTo("dPdu") == 0 || str.compareTo("dPdv") == 0 || str.compareTo("Ng") == 0 || str.compareTo("Ps") == 0 || str.compareTo("VolumeField") == 0;
    }

    public String remove(String target) {
        int n;
        this.rewindBuffer();
        int start = this.searchFor(target, false);
        if (start == -1) {
            return null;
        }
        StringBuffer out = new StringBuffer();
        for (n = 0; n < start; ++n) {
            out.append(this.mBuff[n]);
        }
        boolean doCopy = false;
        for (n = start; n < this.mBuff.length; ++n) {
            if (this.mBuff[n] == '\n') {
                doCopy = true;
                int n2 = n = n + 1 < this.mBuff.length ? ++n : n;
            }
            if (!doCopy) continue;
            out.append(this.mBuff[n]);
        }
        return out.toString();
    }

    @Override
    public String[] getImportKeywords() {
        return new String[]{"#include"};
    }

    static {
        language = new Hashtable();
        try {
            SLStatementsRes = ResourceBundle.getBundle("UI_Script.Sl.SLLanguageRsrc");
        }
        catch (MissingResourceException mre) {
            Cutter.setLog("    Errr: SlTokenizer = " + mre);
        }
        SlTokenizer.initHashTable();
        SHADERTYPES = new String[]{"class", DISPLACEMENT, SURFACE, LIGHT, "deformation", "volume", IMAGER};
        DATATYPES = new String[]{"void", "float", COLOR_FUNCTION, "point", "string", "vector", "normal", MATRIX_FUNCTION, "shader", "__radiancesample", "filterregion"};
        STDRSLTYPES = new String[]{"stdrsl_AreaSampler", "stdrsl_BSDFComponent", "stdrsl_BSDFComponent_v1", "stdrsl_Fresnel", "stdrsl_Fresnel_v1", "stdrsl_HenyeyGreenstein", "stdrsl_HenyeyGreenstein_v1", "stdrsl_IsotropicVolume", "stdrsl_IsotropicVolume_v1", "stdrsl_Lambert", "stdrsl_Lambert_v1", "stdrsl_OrenNayar", "stdrsl_OrenNayar_v1", "stdrsl_SampleMgr", "stdrsl_SampleMgrPathTrace", "stdrsl_ShadingUtils", "stdrsl_ShadingUtils_v1", "stdrsl_SpecularAS", "stdrsl_SpecularAS_v1", "stdrsl_SpecularDBRDF", "stdrsl_SpecularDBRDF_v1", "stdrsl_SpecularGGX", "stdrsl_SpecularGGX_v1", "stdrsl_SpecularBeckmann", "stdrsl_SpecularBeckmann_v1", "stdrsl_SpecularPhong", "stdrsl_SpecularPhong_v1", "stdrsl_SpecularMicrofacet", "stdrsl_SpecularMicrofacet_v1", "stdrsl_SphericalHarmonic", "stdrsl_SphericalHarmonic_v1", "stdrsl_ShadingContext", "stdrsl_ShadingContext_v1", "__radiancesample", "rms_GPSurface"};
        DATAMODIFIERS = new String[]{"constant", "uniform", "output", "varying"};
        SLIM_MACROS = new String[]{"SLIM_TYPEID_surface", "SLIM_TYPEID_displacement", "SLIM_TYPEID_volume", "SLIM_TYPEID_light", "SLIM_TYPEID_class", "SLIM_VERSION", "SLIM_SHADERTYPE", "SLIM_SHADERTYPEID", "SLIM_INSTANCETYPE", "SLIM_INSTANCENAME"};
    }

    private class ShdTypeName {
        String shaderType = "";
        String shaderName = "";
        int beginOffset = -1;
        int endOffset = -1;

        public ShdTypeName(String t, String n, int b, int e) {
            this.shaderType = t;
            this.shaderName = n;
            this.beginOffset = b;
            this.endOffset = e;
        }

        public String toString() {
            return this.shaderType + " " + this.shaderName + " " + this.beginOffset + " " + this.endOffset;
        }
    }
}

