/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Vfl;

import UI_Desktop.Cutter;
import Utilities.DocumentUtils;
import Utilities.TextUtils;
import java.util.Vector;
import javax.swing.text.Document;
import javax.swing.text.Segment;

public class VFLPragma {
    private Vector<Hint> listOfHints = new Vector();
    private Vector<Label> listOfLabels = new Vector();
    private Document doc = this.doc = null;

    public VFLPragma() {
        int n;
        Segment segment = DocumentUtils.getSegment(this.doc, 0, this.doc.getLength());
        if (segment == null) {
            return;
        }
        String[] lines = TextUtils.tokenize(segment.toString(), "\n");
        for (n = 0; n < lines.length; ++n) {
            String[] items;
            String line = lines[n].trim();
            if (line.length() == 0 || (items = TextUtils.tokenize(line)) == null || items.length < 4 || !items[0].equals("#pragma")) continue;
            if (items[1].equals("hint")) {
                this.listOfHints.addElement(new Hint(items[2], items[3]));
                continue;
            }
            if (!items[1].equals("label")) continue;
            String name = items[2];
            items = TextUtils.tokenize(line, "\"");
            if (items == null || items.length != 2) continue;
            this.listOfLabels.addElement(new Label(name, items[1]));
        }
        Cutter.setLog("");
        for (n = 0; n < this.listOfHints.size(); ++n) {
            Cutter.setLog(this.listOfHints.elementAt(n).toString());
        }
        Cutter.setLog("");
        for (n = 0; n < this.listOfLabels.size(); ++n) {
            Cutter.setLog(this.listOfLabels.elementAt(n).toString());
        }
    }

    public class Hint {
        public String name;
        public String value;

        public Hint(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return "Hint name: " + this.name + "     value: " + this.value;
        }
    }

    public class Label {
        public String name;
        public String text;

        public Label(String name, String text) {
            this.name = name;
            this.text = text;
        }

        public String toString() {
            return "Label name: " + this.name + "    text: " + this.text;
        }
    }
}

