/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Vfl;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Script.Help.KAbstractHelp;
import UI_Script.Help.Url;
import UI_Script.Vfl.VflTokenizer;
import UI_Text.KTextPane.KCaret;
import UI_Text.KTextPane.KTextPane;
import Utilities.BrowserUtils;
import Utilities.DocumentUtils;
import Utilities.FileUtils;
import Utilities.TextUtils;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.text.Segment;

public class VflHelp
extends KAbstractHelp {
    public static boolean _getOnlineHelp;
    private static Hashtable<String, String> languageTable;
    protected static KAbstractHelp vexhelp;
    public static String docsPath;
    public static String docsIndexURL;
    private static String VFL_DOCS_NOT_FOUND_URL;
    static String[] fileTypes;
    private static String REFER_TO_FULL_DOCS;

    public static void initPaths() {
        docsPath = VflHelp.configurePath(Preferences.get(Preferences.PATH_VEX_DOCS));
        File f = new File(Preferences.get(Preferences.PATH_VEX_DOCS));
        if (docsPath.equals("") || !f.exists()) {
            docsPath = new File(FileUtils.getPWD(), "Cutter_Help/vex_docs").getPath();
        }
        docsPath = VflHelp.configurePath(docsPath);
    }

    public static String __getDocsIndexURL() {
        VflHelp.initPaths();
        docsIndexURL = Url.join(docsPath, "index.html");
        return docsIndexURL;
    }

    public static boolean __docsIndexURLIsValid() {
        String str = VflHelp.getDocsIndexURL();
        if (str == null || str.length() == 0) {
            return false;
        }
        return KAbstractHelp.docsIndexURLIsValid(str);
    }

    @Override
    public boolean showDocFor(String item, MouseEvent e) {
        this.useCutterBrowser = !e.isShiftDown();
        return this.launchBrowser(item);
    }

    public VflHelp(KTextPane textpane) {
        super(textpane);
        VflHelp.initPaths();
        this.completer.completionActivate();
        char[] delims = KCaret.getDefaultDelimitors();
        char[] modified = new char[delims.length - 1];
        int counter = 0;
        for (int n = 0; n < delims.length; ++n) {
            if (delims[n] == '#') continue;
            modified[counter] = delims[n];
            ++counter;
        }
        this.completer.setWordStartDelims(modified);
        this.completer.setListeners(textpane, this);
    }

    @Override
    public void setCompletorListeners() {
        this.completer.setListeners(this.textpane, this);
    }

    @Override
    public boolean completionTargetIsValid(String str) {
        if (str == null || str.trim().length() == 0) {
            return false;
        }
        if (str.startsWith("#")) {
            return true;
        }
        if (str.length() < 2) {
            return false;
        }
        return Character.isLowerCase(str.charAt(0));
    }

    @Override
    public String[] completionCandidates(String str) {
        return this.completionCandidates(str, languageTable);
    }

    @Override
    protected void lookup(String item) {
        String s;
        if (item == null) {
            return;
        }
        VflTokenizer tok = new VflTokenizer();
        tok.setBuffer(item);
        String urlStr = Preferences.get(Preferences.PATH_VEX_DOCS);
        if (urlStr.endsWith("_index")) {
            urlStr = urlStr.substring(0, urlStr.length() - 6);
        }
        TextUtils.replace(urlStr, ' ', "%20");
        Cutter.setLog("    Debug:VFLHelp.lookup() - item >" + item + "<");
        Segment seg = DocumentUtils.getSegment(this.textpane.getDocument(), BBxt.getSelectionEnd());
        if (seg != null && (s = seg.toString()) != null && s.trim().startsWith("#pragma")) {
            String[] toks = TextUtils.tokenize(s);
            urlStr = toks != null && toks.length >= 2 ? urlStr + "pragmas#pragma-" + toks[1] : urlStr + "pragmas";
            BrowserUtils.open(urlStr, true);
            return;
        }
        if (tok.isFunction(item)) {
            urlStr = urlStr + "functions/" + item;
        } else if (tok.isDataType(item)) {
            urlStr = urlStr + "lang#data-types";
        } else if (tok.isLanguageType(item)) {
            urlStr = urlStr + "statement";
        } else if (tok.isSystemVariable(item)) {
            Segment segment = DocumentUtils.getSegment(this.textpane.getDocument(), 0, this.textpane.getDocument().getLength());
            tok.setBuffer(segment);
            String context = tok.getNameOfContext();
            if (context.equals("displacement")) {
                context = "displace";
            }
            urlStr = urlStr + "contexts/" + context;
        }
        BrowserUtils.open(urlStr, true);
    }

    @Override
    public void popupTypingCompletion(Point pnt, String textToComplete, int insertAt, MouseEvent e) {
    }

    static {
        int i;
        String str;
        _getOnlineHelp = false;
        languageTable = new Hashtable();
        try {
            Field[] fields = new Field[]{VflHelp.class.getDeclaredField("_getOnlineHelp")};
            Cutter.addDebug(VflHelp.class, fields);
        }
        catch (NoSuchFieldException ex) {
            Cutter.setLog("Error: VflHelp.static - " + ex.toString());
        }
        Enumeration<String> e = VflTokenizer.functions.keys();
        while (e.hasMoreElements()) {
            str = e.nextElement().toString();
            languageTable.put(str.toLowerCase(), str);
        }
        for (i = 0; i < VflTokenizer.shaderTypes.length; ++i) {
            str = VflTokenizer.shaderTypes[i];
            languageTable.put(str.toLowerCase(), str);
        }
        for (i = 0; i < VflTokenizer.CONTEXT_NAMES.length; ++i) {
            str = VflTokenizer.CONTEXT_NAMES[i];
            languageTable.put(str.toLowerCase(), str);
        }
        for (i = 0; i < VflTokenizer.types.length; ++i) {
            str = VflTokenizer.types[i];
            languageTable.put(str.toLowerCase(), str);
        }
        e = languageTable.keys();
        while (e.hasMoreElements()) {
            str = e.nextElement().toString();
            if (!str.startsWith("#")) continue;
            languageTable.put(str, str.substring(1));
        }
        languageTable.put("#include", "include");
        languageTable.put("#define", "define");
        languageTable.put("#if", "if");
        languageTable.put("#endif", "endif");
        languageTable.put("#pragma", "pragma");
        languageTable.put("#ifndef", "ifndef");
        languageTable.put("#ifdef", "ifdef");
        languageTable.put("#include", "include");
        vexhelp = null;
        VFL_DOCS_NOT_FOUND_URL = HELP_DOCS_BASE_URL + "vfl/notfound.html";
        fileTypes = new String[]{".vfl", ".VFL"};
        docsPath = VflHelp.configurePath(Preferences.get(Preferences.PATH_VEX_DOCS));
        listOfSubClasses.addElement(VflHelp.class);
        REFER_TO_FULL_DOCS = "Refer to full documentation";
    }
}

