/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Vfl;

import Preferences.Preferences;
import UI_Script.SyntaxListener;
import UI_Script.Vfl.VflTokenizer;
import UI_Text.KTextPane.KTextPane;
import UI_Text.Style.StyleEdits;
import javax.swing.text.StyleConstants;

public class VflListener
extends SyntaxListener {
    public VflListener(KTextPane textpane) {
        super(textpane, new VflTokenizer());
        this.initDelimitors(textpane);
        this.initStyles(textpane);
    }

    @Override
    public void initDelimitors(KTextPane textpane) {
    }

    @Override
    public void initStyles(KTextPane textpane) {
        super.initStyles(textpane);
        StyleConstants.setForeground(textpane.styleContext.plainStyle, Preferences.getColor(Preferences.TEXT_COLOR_VFL_PLAIN));
        StyleConstants.setForeground(textpane.styleContext.commentStyle1, Preferences.getColor(Preferences.TEXT_COLOR_VFL_COMMENT));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle1, Preferences.getColor(Preferences.TEXT_COLOR_VFL_FUNCTION));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle2, Preferences.getColor(Preferences.TEXT_COLOR_VFL_DATATYPE));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle3, Preferences.getColor(Preferences.TEXT_COLOR_VFL_VARIABLE));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle4, Preferences.getColor(Preferences.TEXT_COLOR_VFL_SHADERTYPE));
        StyleConstants.setForeground(textpane.styleContext.stringStyle1, Preferences.getColor(Preferences.TEXT_COLOR_VFL_STRING));
        StyleConstants.setForeground(textpane.styleContext.stringStyle2, Preferences.getColor(Preferences.TEXT_COLOR_VFL_STRING));
        StyleConstants.setUnderline(textpane.styleContext.stringStyle2, true);
    }

    @Override
    protected boolean customSyntax(String str, int begin, StyleEdits editList) {
        if (this.tok.isShaderType(str)) {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.keywordStyle4, true);
            return true;
        }
        if (this.tok.isSystemVariable(str)) {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.keywordStyle3, true);
            return true;
        }
        if (((VflTokenizer)this.tok).isNamedPragma(str)) {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.keywordStyle3, true);
            return true;
        }
        if (((VflTokenizer)this.tok).isNamedSpace(str)) {
            editList.addEdit(begin, str.length(), this.textpane.styleContext.stringStyle2, true);
            return true;
        }
        return false;
    }

    @Override
    public void addComments() {
        this.addComments("//");
    }
}

