/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Vfl;

import Preferences.Preferences;
import Processes.ProcListener;
import Processes.ProcessManager;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Script.Help.KAbstractHelp;
import UI_Script.ScriptHandler;
import UI_Script.ScriptParser.ScriptStructure;
import UI_Script.Vfl.OpenVflAction;
import UI_Script.Vfl.VflHelp;
import UI_Script.Vfl.VflListener;
import UI_Script.Vfl.VflTokenizer;
import UI_Text.KTextPane.KTextPane;
import UI_Tools.Monitor.Monitor;
import UI_Tools.Preferences.PrefsPanels.Languages.VFLPanel;
import UI_Window.KWindow.KTextHistoryWindow;
import Utilities.FileUtils;
import Utilities.KFileFilter;
import Utilities.RegExpUtils;
import Utilities.TextUtils;
import Utilities.UnixUtils;
import java.io.File;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;

public class VflScriptHandler
extends ScriptHandler
implements ProcListener {
    private static final String[][] SHOP_SUBDIR = new String[][]{{"surface", "surface", "SHOPsurface"}, {"displacement", "displace", "SHOPdisplace"}, {"light", "light", "SHOPlight"}, {"shadow", "shadow", "SHOPshadow"}, {"fog", "fog", "SHOPfog"}};
    public static final String VFL_SUFACE = "vfl_surface";
    public static final String VFL_TAM_SUFACE_DIFFUSE = "vfl_tam_surface_diffuse";
    public static final String VFL_TAM_SUFACE_PLASTIC = "vfl_tam_surface_plastic";
    public static final String VFL_TAM_DISPLACEMENT = "vfl_tam_displacement";
    public static final String VFL_SET_HOUDINI_PATHS_BAT = "vfl_set_houdini_paths_bat";
    private static ResourceBundle res;
    private String shaderType = "";

    protected static String getDocString(String nm) {
        String str = null;
        try {
            str = res.getObject(nm).toString();
        }
        catch (MissingResourceException mre) {
            Cutter.setLog("    Error: VflScriptHandler.getDocsSting()\n" + mre);
            str = null;
        }
        return str;
    }

    @Override
    public boolean canRunSelection() {
        return false;
    }

    public VflScriptHandler() {
        this.ext = new String[2];
        this.ext[0] = ".vfl";
        this.ext[1] = ".VFL";
        this.setTokenizer();
    }

    @Override
    protected void setTokenizer() {
        this.tokenizer = new VflTokenizer();
    }

    @Override
    public void deleteTmpFile() {
        File tmp = new File(FileUtils.getPWD(), "temp.vfl");
        if (tmp.exists()) {
            tmp.delete();
        }
    }

    @Override
    public String getScriptName() {
        return "Vfl";
    }

    @Override
    public String getExecuteLabel() {
        return "Compile " + this.getScriptName();
    }

    @Override
    public String getMakeLabel() {
        return null;
    }

    @Override
    public String getRunLabel() {
        return null;
    }

    @Override
    protected void make(File srcDir) {
    }

    @Override
    protected void run() {
    }

    @Override
    public void execute(String str) {
    }

    public void execute(String str, String vexName) {
        File file = new File(FileUtils.getPWD(), "temp.vfl");
        FileUtils.writeFile(file, str);
        this.execute(file);
    }

    @Override
    public void execute(File vflSrcFile) {
        String binpath;
        String inputText = BBxt.getWindowText();
        if (inputText == null) {
            Cutter.setLog("    Error:VflScriptHandler.execute - Front window has no text");
            return;
        }
        VflTokenizer tok = new VflTokenizer();
        tok.setBuffer(inputText);
        String[] identifier = tok.getShaderTypeAndName();
        if (identifier == null) {
            Cutter.setLog("    Error:VflScriptHandler.execute() - cannot find shader type and name!");
            return;
        }
        String vexType = identifier[0];
        String vexName = identifier[1];
        String pathToOTL = VFLPanel.getOTLPath();
        File resolvedOTLPath = FileUtils.resolveRelativePath(FileUtils.getPWDFile(), pathToOTL);
        pathToOTL = UnixUtils.path(resolvedOTLPath.getPath());
        if (pathToOTL.trim().length() == 0) {
            pathToOTL = new File(vflSrcFile.getParent(), vexName + ".otl").getPath();
        } else if (!new File(pathToOTL).getParentFile().exists()) {
            pathToOTL = new File(vflSrcFile.getParent(), vexName + ".otl").getPath();
        } else if (!pathToOTL.endsWith(".otl")) {
            pathToOTL = pathToOTL + "/" + vexName + ".otl";
        }
        pathToOTL = pathToOTL.replace('\\', '/');
        String pathToVfl = vflSrcFile.getPath();
        pathToVfl = pathToVfl.replace('\\', '/');
        String pathToVexDir = VFLPanel.getVEXDirPath();
        if (pathToVexDir.trim().length() == 0) {
            pathToVexDir = vflSrcFile.getParent();
        }
        if ((binpath = Preferences.get(Preferences.PATH_HOUDINI_BIN).trim()).length() != 0 && !(binpath = binpath.replace('\\', '/')).endsWith("/")) {
            binpath = binpath + "/";
        }
        String vcc = binpath + "vcc";
        tok.setBufferIndex(0);
        tok.grabComments = true;
        StringBuffer buf = new StringBuffer();
        String s = tok.getNextStr();
        while (!s.equals("")) {
            if (!tok.isComment(s)) {
                buf.append(s).append(" ");
            }
            s = tok.getNextStr();
        }
        String decommentedInput = buf.toString();
        boolean hasVopsPragma = false;
        RegExpUtils rePragma = new RegExpUtils();
        String regexpPragma = rePragma.encodeAsRE("#pragma optable vop", true, true);
        String[] partsPragma = decommentedInput.split(regexpPragma, 2);
        if (partsPragma != null && partsPragma.length > 1) {
            hasVopsPragma = true;
        }
        Cutter.setLog("    Debug:VflScriptHandler.execute() - hasVopsPragma = " + hasVopsPragma);
        if (hasVopsPragma) {
            this.shaderType = "Vop";
            File vexfile = new File(pathToVexDir, vexName);
            String vexFilePath = vexfile.getPath();
            vexFilePath = vexFilePath + ".vex";
            vexFilePath = vexFilePath.replace('\\', '/');
            ProcessManager fp = new ProcessManager("Vcc");
            String[] items = new String[]{vcc, "-l", pathToOTL, "-o", vexFilePath, pathToVfl};
            fp.launch(items, null, true, this, false);
        } else {
            this.shaderType = "Vex";
            ProcessManager fp = new ProcessManager("Vcc");
            String[] items = new String[]{vcc, "-L", pathToOTL, pathToVfl};
            fp.launch(items, null, true, this, false);
        }
    }

    @Override
    public void processSentString(String procName, String output) {
    }

    @Override
    public void processStarted(String procName, String[] progarray, String procID) {
    }

    @Override
    public void processFinished(String[] progarray) {
        Monitor.finalizePanelText("Vcc", "Compiled " + this.shaderType + ":\n");
    }

    @Override
    public void executeFromHistory(KTextHistoryWindow window) {
        String str = window.getTextPane().getCopyNoComments();
        if (str == null) {
            Cutter.setLog("    Error: VflScriptHandler.executeFromHistory()            textpane has no uncommented text");
            return;
        }
        VflTokenizer tok = new VflTokenizer();
        tok.setBuffer(str);
        String[] identifier = tok.getShaderTypeAndName();
        if (identifier == null) {
            Cutter.setLog("    Error: VflScriptHandler.executeFromHistory() Cannot find the name of the shader");
            return;
        }
        this.execute(window.getAllText(), identifier[1]);
    }

    @Override
    public String getSyntaxListenerClassName(KTextPane textpane) {
        return VflListener.class.getName();
    }

    @Override
    public KAbstractHelp getHelper(KTextPane textpane) {
        KAbstractHelp.add(textpane.helper);
        return KAbstractHelp.getInstanceByName(VflHelp.class.getName(), textpane);
    }

    @Override
    public JMenuItem getOpenFileMenuItem() {
        JMenuItem item = new JMenuItem("Vfl");
        item.addActionListener(new OpenVflAction());
        return item;
    }

    @Override
    public ScriptStructure getStructure() {
        return null;
    }

    public static void createDocument(String title, String docType) {
        String docStr = VflScriptHandler.getDocString(docType);
        templateBuffer.setLength(0);
        String[] lineItems = TextUtils.tokenize(docStr);
        for (int n = 0; n < lineItems.length; ++n) {
            String line = VflScriptHandler.getDocString(lineItems[n]);
            templateBuffer.append(line);
        }
        BBxt.newDocument(title, templateBuffer);
    }

    @Override
    public KFileFilter getFileFilter() {
        KFileFilter filter = new KFileFilter("vfl", "Houdini Vex Shading Language");
        return filter;
    }

    static {
        try {
            res = ResourceBundle.getBundle("UI_Script.Vfl.VflDocumentsRsrc");
        }
        catch (MissingResourceException mre) {
            Cutter.setLog("VflScriptHandler: a resource file is missing --> " + mre);
        }
    }
}

