/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Vfl;

import UI_Desktop.Cutter;
import UI_Script.C.CTokenizer;
import UI_Script.Vfl.VFLFunctionsRsrc;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.text.Segment;
import kernal.Tokenizers.Tokenizer;

public class VflTokenizer
extends CTokenizer {
    public static final String[] types = new String[]{"float", "int", "matrix", "matrix3", "vector", "vector4", "string"};
    public static final String GEO_FUNCTION = "geometric";
    public static final String MATH_FUNCTION = "math";
    public static final String VECTOR_FUNCTION = "vector";
    public static final String INTERPOLATION_FUNCTION = "interpolation";
    public static final String MATRIX_FUNCTION = "matrix";
    public static final String RENDERING_FUNCTION = "rendering";
    public static final String COLOR_FUNCTION = "color";
    public static final String NOISE_FUNCTION = "noise";
    public static final String RANDOM_FUNCTION = "random";
    public static final String IMAGE_FUNCTION = "image";
    public static final String MAP_FUNCTION = "map";
    public static final String TRANSFORM_FUNCTION = "transform";
    public static final String MISC_FUNCTION = "misc";
    public static final String COP_SPECIFIC_FUNCTION = "cop_specific";
    public static final String POP_SOP_SPECIFIC_FUNCTION = "pop_sop_specific";
    public static final String SOP_SPECIFIC_FUNCTION = "sop_specific";
    public static final String CHOP_SPECIFIC_FUNCTION = "chop_specific";
    public static final String STRING_FUNCTION = "string";
    public static final String ZDEPTH_FUNCTION = "zdepth";
    public static final String IMAGE3D_FUNCTION = "image3d";
    public static final String SURFACE_SHADER_FUNCTION = "surface_shader";
    public static final String DISPLACEMENT_SHADER_FUNCTION = "displacement_shader";
    public static final String LIGHT_SHADER_FUNCTION = "light_shader";
    public static final String SHADOW_SHADER_FUNCTION = "shadow_shader";
    public static final String FOG_SHADER_FUNCTION = "fog_shader";
    public static final String COMMON_SHADER_FUNCTION = "common_shader";
    public static final String GLOBAL_VARIABLE = "sys_variable";
    public static final String PRAGMA_NAME = "pragma_name";
    public static final int UNKNOWN_FUNCTION_ID = 0;
    public static final int GEO_FUNCTION_ID = 1;
    public static final int MATH_FUNCTION_ID = 2;
    public static final int VECTOR_FUNCTION_ID = 3;
    public static final int INTERPOLATION_FUNCTION_ID = 4;
    public static final int MATRIX_FUNCTION_ID = 5;
    public static final int RENDERING_FUNCTION_ID = 6;
    public static final int COLOR_FUNCTION_ID = 7;
    public static final int NOISE_FUNCTION_ID = 8;
    public static final int RANDOM_FUNCTION_ID = 9;
    public static final int IMAGE_FUNCTION_ID = 10;
    public static final int MAP_FUNCTION_ID = 11;
    public static final int TRANSFORM_FUNCTION_ID = 12;
    public static final int MISC_FUNCTION_ID = 13;
    public static final int COP_SPECIFIC_FUNCTION_ID = 14;
    public static final int POP_SOP_SPECIFIC_FUNCTION_ID = 15;
    public static final int SOP_SPECIFIC_FUNCTION_ID = 16;
    public static final int CHOP_SPECIFIC_FUNCTION_ID = 17;
    public static final int STRING_FUNCTION_ID = 18;
    public static final int ZDEPTH_FUNCTION_ID = 19;
    public static final int IMAGE3D_FUNCTION_ID = 20;
    public static final int SURFACE_SHADER_FUNCTION_ID = 21;
    public static final int DISPLACEMENT_SHADER_FUNCTION_ID = 22;
    public static final int LIGHT_SHADER_FUNCTION_ID = 23;
    public static final int SHADOW_SHADER_FUNCTION_ID = 24;
    public static final int FOG_SHADER_FUNCTION_ID = 25;
    public static final int COMMON_SHADER_FUNCTION_ID = 26;
    public static final int GLOBAL_VARIABLE_ID = 27;
    public static final int PRAGMA_NAME_ID = 28;
    public static final String COP_CONTEXT = "cop";
    public static final String COP2_CONTEXT = "cop2";
    public static final String SOP_CONTEXT = "sop";
    public static final String POP_CONTEXT = "pop";
    public static final String CHOP_CONTEXT = "chop";
    public static final String IMAGE3D_CONTEXT = "3dimage";
    public static final String SURFACE_CONTEXT = "surface";
    public static final String DISPLACEMENT_CONTEXT = "displacement";
    public static final String LIGHT_CONTEXT = "light";
    public static final String SHADOW_CONTEXT = "shadow";
    public static final String FOG_CONTEXT = "fog";
    public static final String COMMON_CONTEXT = "common";
    public static final String[] CONTEXT_NAMES = new String[]{"cop", "cop2", "sop", "pop", "chop", "3dimage", "surface", "displacement", "light", "shadow", "fog", "common"};
    private static ResourceBundle VFLStatementsRes;
    public static Hashtable<String, String> functions;
    public static final double version = 1.0;
    public static String[] shaderTypes;
    public boolean getComments = false;
    protected int typeStringOffset = -1;
    protected int nameStringOffset = -1;
    protected int shaderTypeBegin = -1;
    protected String shaderName;
    protected String shaderType;
    protected String shaderDescription;

    private static String getFunction(String nm) {
        String str;
        try {
            str = VFLStatementsRes.getObject(nm).toString();
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    private static int numFunctions() {
        int num = 0;
        try {
            num = ((VFLFunctionsRsrc)VFLStatementsRes).getNumItems();
        }
        catch (MissingResourceException mre) {
            System.out.println("cannot read VFLStatementsRes");
        }
        return num;
    }

    private static void initHashTable() {
        for (int i = 0; i < VflTokenizer.numFunctions(); ++i) {
            functions.put(((VFLFunctionsRsrc)VFLStatementsRes).getKey(i), ((VFLFunctionsRsrc)VFLStatementsRes).getContent(i));
        }
    }

    private void ___LANGUAGE__PROFILE__METHODS________() {
    }

    @Override
    public String[] getAccessTypes() {
        return null;
    }

    @Override
    public String[] getScopeTypes() {
        return null;
    }

    @Override
    public String getPragmaStr() {
        return "#pragma";
    }

    @Override
    public String getProcKeyword() {
        return null;
    }

    @Override
    public String[] getDataTypes() {
        return null;
    }

    public String[] getShaderTypeAndName() {
        StringBuffer buff = new StringBuffer();
        String posName = null;
        String posType = null;
        String posOpenParen = null;
        Object comment = null;
        int offset = 0;
        int beginAt = -1;
        int endAt = -1;
        boolean found = false;
        boolean return_delim = this.getNextStr_return_delimitor;
        String delims = this.getDelimitors();
        while (!found && offset != -1) {
            this.getNextStr_return_delimitor = false;
            offset = this.getShaderTypeOffsets(buff);
            if (offset == -1) {
                this.getNextStr_return_delimitor = return_delim;
                this.setDelimitor(delims);
                return null;
            }
            posType = buff.toString();
            this.setBufferIndex(offset);
            beginAt = offset - posType.length();
            posName = this.getNextStr().trim();
            offset = this.getBufferIndex();
            this.setDelimitor("(");
            this.getNextStr_return_delimitor = true;
            posOpenParen = this.getNextStr();
            if (posOpenParen.equals("(") && this.isShaderType(posType)) {
                endAt = this.getBufferIndex();
                found = true;
            }
            this.setBufferIndex(offset);
            buff.setLength(0);
        }
        this.getNextStr_return_delimitor = return_delim;
        this.setDelimitor(delims);
        this.shaderTypeBegin = beginAt;
        String[] out = new String[]{posType, posName, "" + beginAt, "" + endAt};
        return out;
    }

    public String[] __getShaderTypeAndName() {
        StringBuffer buff = new StringBuffer();
        String posName = null;
        String posType = null;
        String posOpenParen = null;
        Object comment = null;
        int offset = 0;
        int beginAt = -1;
        int endAt = -1;
        boolean found = false;
        while (!found && offset != -1) {
            this.getNextStr_return_delimitor = false;
            offset = this.getShaderTypeOffsets(buff);
            if (offset == -1) {
                return null;
            }
            posType = buff.toString();
            this.setBufferIndex(offset);
            beginAt = offset - posType.length();
            posName = this.getNextStr().trim();
            offset = this.getBufferIndex();
            this.setDelimitor("(");
            this.getNextStr_return_delimitor = true;
            posOpenParen = this.getNextStr();
            if (posOpenParen.equals("(") && this.isShaderType(posType)) {
                endAt = this.getBufferIndex();
                found = true;
                Cutter.setLog("ShaderTokenizer.getShaderTypeAndName()\n         accepting possibleType >" + posType + "<\n         accepting possibleName >" + posName + "<\n         accepting beginAt >" + beginAt + "<\n         accepting endAt >" + endAt + "<");
            }
            this.setBufferIndex(offset);
            buff.setLength(0);
        }
        String[] out = new String[]{posType, posName, "" + beginAt, "" + endAt};
        return out;
    }

    private int getShaderTypeOffsets(StringBuffer outType) {
        int oldIndex = this.getBufferIndex();
        int foundAt = -1;
        int minOffset = 1000000;
        String type = "";
        for (int n = 0; n < shaderTypes.length; ++n) {
            this.setBufferIndex(0);
            int offset = this.searchFor(shaderTypes[n], true);
            if (offset == -1 || this.nextNonWhiteCharIs(40) || offset >= minOffset) continue;
            minOffset = offset;
            type = shaderTypes[n];
            foundAt = this.getBufferIndex();
        }
        this.setBufferIndex(oldIndex);
        outType.append(type);
        return foundAt;
    }

    protected int[] __getDescriptionOffsets() {
        if (this.typeStringOffset == -1) {
            Cutter.setLog("    Error: SLTokenizer.getDescriptionOffsets() - typeStringOffset == -1");
            return null;
        }
        int oldIndex = this.getBufferIndex();
        int end = this.typeStringOffset - this.shaderType.length();
        int n = this.peekPrevNonWhite(end - 1);
        if (n == -1) {
            return null;
        }
        char c = this.peekAtChar(n);
        if (c != '/') {
            return null;
        }
        int start = this.findBackward(n - 1, '/');
        int[] out = new int[]{start, n};
        this.setBufferIndex(oldIndex);
        return out;
    }

    protected String getShaderDescription() {
        if (this.shaderTypeBegin == -1) {
            Cutter.setLog("    Error: SlTokenizer.getShaderDescription() - shaderTypeBegin is -1");
        }
        int oldIndex = this.getBufferIndex();
        this.setBufferIndex(0);
        this.getComments = true;
        String str = this.getNextStr();
        String desc = "";
        while (!str.equals("")) {
            if (this.isOpenComment(str)) {
                desc = str;
            }
            if (this.getBufferIndex() >= oldIndex) break;
            str = this.getNextStr();
        }
        this.setBufferIndex(oldIndex);
        return desc.trim();
    }

    public VflTokenizer() {
        String[] ext = new String[]{"vfl", "VFL"};
        Tokenizer.addToRegistry(VflTokenizer.class, ext, this.getComments(), this.getDelimitors());
    }

    @Override
    public boolean isFunction(String str) {
        return VflTokenizer.getFunctionType(str) != 0;
    }

    public static int getFunctionType(String functionName) {
        if (!functions.containsKey(functionName)) {
            return 0;
        }
        String obj = functions.get(functionName);
        if (obj == null) {
            return 0;
        }
        if (obj.equals(GEO_FUNCTION)) {
            return 1;
        }
        if (obj.equals(MATH_FUNCTION)) {
            return 2;
        }
        if (obj.equals(VECTOR_FUNCTION)) {
            return 3;
        }
        if (obj.equals(INTERPOLATION_FUNCTION)) {
            return 4;
        }
        if (obj.equals(MATRIX_FUNCTION)) {
            return 5;
        }
        if (obj.equals(RENDERING_FUNCTION)) {
            return 6;
        }
        if (obj.equals(COLOR_FUNCTION)) {
            return 7;
        }
        if (obj.equals(NOISE_FUNCTION)) {
            return 8;
        }
        if (obj.equals(RANDOM_FUNCTION)) {
            return 9;
        }
        if (obj.equals(IMAGE_FUNCTION)) {
            return 10;
        }
        if (obj.equals(MAP_FUNCTION)) {
            return 11;
        }
        if (obj.equals(TRANSFORM_FUNCTION)) {
            return 12;
        }
        if (obj.equals(MISC_FUNCTION)) {
            return 13;
        }
        if (obj.equals(STRING_FUNCTION)) {
            return 18;
        }
        if (obj.equals(ZDEPTH_FUNCTION)) {
            return 19;
        }
        if (obj.equals(IMAGE3D_FUNCTION)) {
            return 20;
        }
        if (obj.equals(COMMON_SHADER_FUNCTION)) {
            return 26;
        }
        if (obj.equals(SURFACE_SHADER_FUNCTION)) {
            return 21;
        }
        if (obj.equals(DISPLACEMENT_SHADER_FUNCTION)) {
            return 22;
        }
        if (obj.equals(LIGHT_SHADER_FUNCTION)) {
            return 23;
        }
        if (obj.equals(SHADOW_SHADER_FUNCTION)) {
            return 24;
        }
        if (obj.equals(FOG_SHADER_FUNCTION)) {
            return 25;
        }
        return 0;
    }

    @Override
    public boolean isDataType(String str) {
        return str.compareTo("float") == 0 || str.compareTo("int") == 0 || str.compareTo(MATRIX_FUNCTION) == 0 || str.compareTo("matrix3") == 0 || str.compareTo(VECTOR_FUNCTION) == 0 || str.compareTo("vector4") == 0 || str.compareTo(STRING_FUNCTION) == 0;
    }

    @Override
    public boolean isLanguageType(String str) {
        return str.compareTo("if") == 0 || str.compareTo("else") == 0 || str.compareTo("while") == 0 || str.compareTo("for") == 0 || str.compareTo("break") == 0 || str.compareTo("return") == 0 || str.compareTo("#include") == 0 || str.compareTo("#define") == 0 || str.compareTo("#undef") == 0 || str.compareTo("#ifdef") == 0 || str.compareTo("#ifndef") == 0 || str.compareTo("#if") == 0 || str.compareTo("#else") == 0 || str.compareTo("#endif") == 0 || str.compareTo("#pragma") == 0;
    }

    @Override
    public boolean isShaderType(String str) {
        for (int n = 0; n < shaderTypes.length; ++n) {
            if (str.compareTo(shaderTypes[n]) != 0) continue;
            return true;
        }
        return false;
    }

    public static String[] getShaderTypes() {
        return shaderTypes;
    }

    @Override
    public boolean isNamedSpace(String s) {
        if (s.length() < 5) {
            return false;
        }
        String str = Tokenizer.removeQuotes(s);
        return str.compareTo("camera") == 0 || str.compareTo("world") == 0 || str.compareTo("current") == 0 || str.compareTo("shader") == 0 || str.compareTo("object") == 0 || str.compareTo("rgb") == 0 || str.compareTo("hsv") == 0 || str.compareTo("xyz") == 0 || str.compareTo("xyY") == 0 || str.compareTo("YIQ") == 0;
    }

    public static String[] getContextNames() {
        return CONTEXT_NAMES;
    }

    public String getNameOfContext() {
        String[] contextNames = CONTEXT_NAMES;
        int result = -1;
        int minOffset = 1000000;
        String contextName = COMMON_CONTEXT;
        for (int n = 0; n < contextNames.length; ++n) {
            this.rewindBuffer();
            int offset = this.searchFor(contextNames[n], true);
            if (offset == -1 || offset >= minOffset) continue;
            minOffset = offset;
            contextName = contextNames[n];
        }
        return contextName;
    }

    @Override
    public boolean isSystemVariable(String str) {
        if (!functions.containsKey(str)) {
            return false;
        }
        String obj = functions.get(str);
        if (obj == null) {
            return false;
        }
        return obj.equals(GLOBAL_VARIABLE);
    }

    public boolean isNamedPragma(String str) {
        if (!functions.containsKey(str)) {
            return false;
        }
        String obj = functions.get(str);
        if (obj == null) {
            return false;
        }
        return obj.equals(PRAGMA_NAME);
    }

    public String _4_getNextStr() {
        char c;
        boolean literal = false;
        boolean endOfString = false;
        boolean endOfComment = false;
        if (this.debug) {
            Cutter.setLog("Entered GetNextStr");
        }
        if ((c = this.readChar()) == '\u0000') {
            if (this.debug) {
                Cutter.setLog("GetNextStr, readChar() ERROR, char = >" + c + "<");
            }
            return "";
        }
        this.outBuff.setLength(0);
        if (this.debug) {
            Cutter.setLog("GetNextStr, read first char =  >" + c + "<");
        }
        if (this.isSpace(c)) {
            c = this.removeSpace();
        }
        if (c == '\u0000') {
            return "";
        }
        this.outBuff.append(c);
        if (c == ';') {
            return this.outBuff.toString();
        }
        if (c == '-') {
            return this.outBuff.toString();
        }
        if (c == '*') {
            c = this.readChar();
            if (c == '\u0000') {
                return this.outBuff.toString();
            }
            if (c == '/') {
                this.outBuff.append(c);
            }
            this.ungetChar();
        }
        if (c == '/') {
            if (this.peekNextChar() == '*' || this.peekNextChar() == '/') {
                c = this.readChar();
                if (c == '\u0000') {
                    return this.outBuff.toString();
                }
                if (c == '/') {
                    do {
                        this.outBuff.append(c);
                        if (c != '\n' && c != '\r') continue;
                        return this.outBuff.toString();
                    } while ((c = this.readChar()) != '\u0000');
                    return this.outBuff.toString();
                }
                block9: while (true) {
                    this.outBuff.append(c);
                    c = this.readChar();
                    if (c == '\u0000') {
                        return this.outBuff.toString();
                    }
                    do {
                        if (c != '*') continue block9;
                        this.outBuff.append(c);
                        c = this.readChar();
                        if (c != '\u0000') continue;
                        return this.outBuff.toString();
                    } while (c != '/');
                    break;
                }
                return this.outBuff.append(c).toString();
            }
            return this.outBuff.toString();
        }
        if (c == '(' || c == ')') {
            return this.outBuff.toString();
        }
        if (c == '\"') {
            literal = true;
        }
        while (!endOfString && !this.mEndOfBuffer) {
            c = this.readChar();
            switch (c) {
                case '\u0000': {
                    return "";
                }
                case '\"': {
                    if (literal) {
                        this.outBuff.append(c);
                        return this.outBuff.toString();
                    }
                    this.ungetChar();
                    return this.outBuff.toString();
                }
                case '(': 
                case ')': 
                case ',': 
                case '-': 
                case ';': {
                    if (literal) break;
                    this.ungetChar();
                    return this.outBuff.toString();
                }
                case '\t': 
                case ' ': {
                    if (literal) break;
                    this.ungetChar();
                    return this.outBuff.toString();
                }
                case '\n': 
                case '\r': {
                    if (literal) break;
                    this.ungetChar();
                    return this.outBuff.toString();
                }
                case '/': {
                    if (literal) break;
                    this.ungetChar();
                    return this.outBuff.toString();
                }
            }
            this.outBuff.append(c);
        }
        if (this.debug) {
            Cutter.setLog("getNextStr() is returning:" + this.outBuff.toString());
        }
        return this.outBuff.toString();
    }

    public String remove(String target) {
        int n;
        this.rewindBuffer();
        int start = this.searchFor(target, false);
        if (start == -1) {
            return null;
        }
        StringBuffer out = new StringBuffer();
        for (n = 0; n < start; ++n) {
            out.append(this.mBuff[n]);
        }
        boolean doCopy = false;
        for (n = start; n < this.mBuff.length; ++n) {
            if (this.mBuff[n] == '\n') {
                doCopy = true;
                int n2 = n = n + 1 < this.mBuff.length ? ++n : n;
            }
            if (!doCopy) continue;
            out.append(this.mBuff[n]);
        }
        return out.toString();
    }

    public static String vflGetShaderName(Segment segment) {
        if (segment == null) {
            return null;
        }
        VflTokenizer tok = new VflTokenizer();
        String[] shaderTypes = VflTokenizer.getShaderTypes();
        int result = -1;
        if (segment == null) {
            return null;
        }
        tok.setBuffer(segment);
        for (int n = 0; n < shaderTypes.length; ++n) {
            tok.rewindBuffer();
            if (tok.searchFor(shaderTypes[n], true) == -1) continue;
            return tok.getNextStr();
        }
        return null;
    }

    static {
        functions = new Hashtable();
        try {
            VFLStatementsRes = ResourceBundle.getBundle("UI_Script.Vfl.VFLFunctionsRsrc");
        }
        catch (MissingResourceException mre) {
            Cutter.setLog("    Error: VflTokenizer = " + mre);
        }
        VflTokenizer.initHashTable();
        shaderTypes = new String[]{DISPLACEMENT_CONTEXT, SURFACE_CONTEXT, SHADOW_CONTEXT, SOP_CONTEXT, COP_CONTEXT, COP2_CONTEXT, POP_CONTEXT, CHOP_CONTEXT, LIGHT_CONTEXT, IMAGE3D_FUNCTION, FOG_CONTEXT};
    }
}

