/*
 * Decompiled with CFR 0.152.
 */
package UI_Text.KTextPane;

import UI_Desktop.Cutter;
import Utilities.DialogUtils;
import Utilities.TextUtils;
import javax.swing.JTextPane;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.Segment;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TabExpander;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public abstract class KAbstractTextPane
extends JTextPane {
    private static final long serialVersionUID = 1L;

    @Override
    protected EditorKit createDefaultEditorKit() {
        return new KEditorKit();
    }

    public static class KEditorKit
    extends StyledEditorKit {
        private static final long serialVersionUID = 1L;
        private final ViewFactory defaultFactory = new KViewFactory();

        @Override
        public ViewFactory getViewFactory() {
            return this.defaultFactory;
        }

        public class KViewFactory
        implements ViewFactory {
            @Override
            public View create(Element elem) {
                String kind = elem.getName();
                if (kind != null) {
                    if (kind.equals("content")) {
                        return new KLabelView(elem);
                    }
                    if (kind.equals("paragraph")) {
                        return new KParagraphView(elem);
                    }
                    if (kind.equals("section")) {
                        return new KBoxView(elem, 1);
                    }
                    if (kind.equals("component")) {
                        return new ComponentView(elem);
                    }
                    if (kind.equals("icon")) {
                        return new IconView(elem);
                    }
                }
                return new KLabelView(elem);
            }
        }

        static class KLabelView
        extends LabelView {
            public KLabelView(Element elem) {
                super(elem);
            }

            @Override
            public Segment getText(int p0, int p1) {
                Segment segment;
                block3: {
                    if (p0 > p1) {
                        int temp = p0;
                        p0 = p1;
                        p1 = temp;
                    }
                    segment = null;
                    try {
                        segment = super.getText(p0, p1);
                    }
                    catch (Throwable e) {
                        segment = new Segment(new String("").toCharArray(), 0, 0);
                        if (!Cutter.input.debug) break block3;
                        System.out.println("    Exception:KAbstractTextPane.KLabelView.getText()\n        " + e.toString());
                        System.out.println("         p0 = " + p0 + "  p1 = " + p1);
                        Thread.currentThread();
                        Thread.dumpStack();
                    }
                }
                return segment;
            }

            @Override
            public float getPreferredSpan(int axis) {
                return super.getPreferredSpan(axis);
            }

            @Override
            public float getTabbedSpan(float x, TabExpander e) {
                float result = super.getTabbedSpan(x, e);
                this.preferenceChanged(this, true, false);
                return result;
            }
        }

        static class KBoxView
        extends BoxView {
            public KBoxView(Element elem, int axis) {
                super(elem, axis);
            }

            @Override
            public void layout(int width, int height) {
                try {
                    super.layout(width, height);
                }
                catch (Throwable e) {
                    String[] str = TextUtils.formatAsArray(e.toString(), 100);
                    String[] s = new String[]{"dumpstack"};
                    DialogUtils.showErrorMessage("Error in Layout", s);
                    if (Cutter.input.debug) {
                        System.out.println("    PRINTOUT ONLY FROM DEBUGMODE");
                        System.out.println("    Exception:KAbstractTextPane.KBoxView.layout()\n        " + e.toString());
                        System.out.println("         width = " + width + "  height = " + height);
                        Thread.currentThread();
                        Thread.dumpStack();
                    }
                    return;
                }
            }

            @Override
            public void setSize(float width, float height) {
                width = width < 0.0f ? Math.abs(width) : width;
                height = height < 0.0f ? Math.abs(height) : height;
                try {
                    super.setSize(width, height);
                }
                catch (Throwable e) {
                    if (Cutter.input.debug) {
                        System.out.println("    Exception:KAbstractTextPane.KBoxView.setSize()\n        " + e.toString());
                        System.out.println("         width = " + width + "  height = " + height);
                        Thread.currentThread();
                        Thread.dumpStack();
                    }
                    return;
                }
            }
        }

        static class KParagraphView
        extends ParagraphView {
            public KParagraphView(Element elem) {
                super(elem);
            }

            @Override
            public void layout(int width, int height) {
                try {
                    super.layout(10240, height);
                }
                catch (Throwable e) {
                    if (Cutter.input.debug) {
                        System.out.println("    Debug only:\n");
                        System.out.println("    Exception:KAbstractTextPane.KParagraphView.layout()\n        " + e.toString());
                        System.out.println("         width = " + width + "  height = " + height);
                        System.out.println("                 " + e.toString());
                    }
                    super.layout(width, height);
                }
            }
        }
    }
}

