/*
 * Decompiled with CFR 0.152.
 */
package UI_Text.KTextPane;

import Preferences.Preferences;
import UI_Desktop.Cutter;
import UI_Script.Osl.OslTokenizer;
import UI_Text.KTextPane.KDocument;
import UI_Text.KTextPane.KTextPane;
import Utilities.DocumentUtils;
import java.awt.Color;
import java.util.Stack;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import kernal.Tokenizers.Tokenizer;

public class KBlockBeginEndHiliter
implements CaretListener {
    private int caretPosition = -1;
    private KTextPane textpane = null;
    private KDocument doc = null;
    private Segment char_segment = new Segment();
    private Segment doc_segment = new Segment();
    private Hilighter hilighter = new Hilighter();
    private Tokenizer tok;
    private Style plainStyle;
    private String ostr = "";
    private String cstr = "";
    private String styleNameAtDot_prev = "";
    private String styleNameAtDot = "";
    private String styleNameAtDot_post = "";

    public KBlockBeginEndHiliter(KTextPane textpane, KDocument kdoc, Style plain) {
        this.textpane = textpane;
        this.doc = kdoc;
        this.plainStyle = plain;
        this.char_segment.setPartialReturn(true);
    }

    public void initHiliteColor() {
        this.hilighter.initColor();
    }

    public void initTokenizer(Tokenizer t) {
        String clsname = t.getClass().getName();
        this.tok = Tokenizer.getInstanceByClassName(clsname);
    }

    private void handlePython(CaretEvent e) {
        int dot;
        Cutter.setLog("\nhandlePython at " + e.getDot());
        this.caretPosition = dot = e.getDot();
        if (this.hilighter.beginEndCharsAreActive || this.hilighter.entireBlockIsActive) {
            this.hilighter.unhiliteBeginEndChars();
            this.hilighter.unhiliteEntireBlock();
            this.textpane.parseAll();
        }
        boolean isHandlingBlock = false;
        if (dot <= 0) {
            return;
        }
        try {
            Segment lineSegment = new Segment();
            Segment local_char_segment = new Segment();
            this.doc.getText(dot - 1, 1, local_char_segment);
            if (local_char_segment == null || !local_char_segment.toString().equals(":")) {
                return;
            }
            isHandlingBlock = true;
            this.tok.getCR_Newlines = true;
            int openBlockTabcount = DocumentUtils.countTabStopsAtOffset(this.doc, dot);
            int[] temp = DocumentUtils.getLineNumberAt(this.doc, dot);
            if (temp == null) {
                return;
            }
            int openBlockLineNum = temp[0];
            Segment local_doc_segment = DocumentUtils.getSegment((Document)this.doc, 0, this.doc.getLength());
            this.tok.setBuffer(local_doc_segment);
            this.tok.setBufferIndex(dot);
            String s = this.tok.getNextStr();
            int[] prevLineOffsets = null;
            while (!s.equals("")) {
                if (!this.tok.isComment(s) && s.equals("\n")) {
                    int offset = this.tok.getBufferIndex() - 1;
                    int[] lineData = DocumentUtils.getLineNumberAt(this.doc, offset);
                    int lineNum = lineData[0];
                    if (lineNum == openBlockLineNum) {
                        s = this.tok.getNextStr();
                        continue;
                    }
                    int[] lineOffsets = DocumentUtils.getOffsetsOfLine(this.doc, lineNum);
                    DocumentUtils.getSegment(this.doc, lineOffsets[1], lineOffsets[2] - 1, lineSegment);
                    if (lineSegment.toString().trim().length() > 0) {
                        int tabs = DocumentUtils.countTabStopsAtOffset(this.doc, offset);
                        int spaces = DocumentUtils.countSpacesAtOffset(this.doc, offset);
                        if (tabs == openBlockTabcount && spaces == 0) {
                            if (lineOffsets == null) {
                                prevLineOffsets = DocumentUtils.getOffsetsOfLine(this.doc, lineNum - 1);
                            }
                            if (prevLineOffsets != null) {
                                this.hilighter.saveEntireBlockOffsets(this.caretPosition - 1, prevLineOffsets[2]);
                                this.hilighter.hiliteEntireBlock();
                            }
                            this.tok.getCR_Newlines = false;
                            return;
                        }
                        prevLineOffsets = lineOffsets;
                    }
                }
                s = this.tok.getNextStr();
            }
            if (isHandlingBlock && prevLineOffsets != null) {
                this.hilighter.saveEntireBlockOffsets(this.caretPosition - 1, (int)prevLineOffsets[2]);
                this.hilighter.hiliteEntireBlock();
            }
            this.tok.getCR_Newlines = false;
        }
        catch (BadLocationException ex) {
            Cutter.setLog("    Exception:KBlockBeginEndHititer.caretUpdate() - " + ex.toString());
            return;
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.styleNameAtDot = DocumentUtils.getCharacterStyleName(this.doc, e.getDot());
        if (this.styleNameAtDot.equals("c1mnt") || this.styleNameAtDot.equals("c2mnt") || this.styleNameAtDot.equals("c3mnt")) {
            return;
        }
        if (e.getDot() > 0) {
            this.styleNameAtDot_prev = DocumentUtils.getCharacterStyleName(this.doc, e.getDot() - 1);
        }
        this.styleNameAtDot_post = DocumentUtils.getCharacterStyleName(this.doc, e.getDot() + 1);
        if (this.styleNameAtDot_prev.equals("DefaultText")) {
            this.styleNameAtDot_prev = "plain";
        }
        if (this.styleNameAtDot_post.equals("DefaultText")) {
            this.styleNameAtDot_post = "plain";
        }
        if (e.getDot() != e.getMark()) {
            this.hilighter.unhiliteBeginEndChars();
            return;
        }
        if (e.getDot() == e.getMark()) {
            int dot;
            this.caretPosition = dot = e.getDot();
            this.hilighter.unhiliteBeginEndChars();
            try {
                this.doc.getText(dot, 1, this.char_segment);
                int close = this.getCloseOffset(this.caretPosition + 1, this.char_segment);
                if (close != -1) {
                    this.hilighter.saveBeginEndCharsOffsets(this.caretPosition, close);
                    this.hilighter.hiliteBeginEndChars();
                    return;
                }
                int open = this.getOpenOffset(this.caretPosition + 1, this.char_segment);
                if (open != -1) {
                    this.hilighter.saveBeginEndCharsOffsets(open, this.caretPosition);
                    this.hilighter.hiliteBeginEndChars();
                    return;
                }
                if (dot <= 1) {
                    return;
                }
                this.doc.getText(dot - 1, 1, this.char_segment);
                open = this.getOpenOffset(this.caretPosition, this.char_segment);
                if (open != -1) {
                    this.hilighter.saveBeginEndCharsOffsets(open, this.caretPosition - 1);
                    this.hilighter.hiliteBeginEndChars();
                    return;
                }
                close = this.getCloseOffset(this.caretPosition, this.char_segment);
                if (close != -1) {
                    this.hilighter.saveBeginEndCharsOffsets(this.caretPosition - 1, close);
                    this.hilighter.hiliteBeginEndChars();
                }
            }
            catch (BadLocationException ex) {
                Cutter.setLog("    Exception:KBlockBeginEndHititer.caretUpdate() - " + ex.toString());
                return;
            }
        }
    }

    private boolean isOpenOrCloseChar(String c) {
        if (c == null) {
            return false;
        }
        return c.equals("<") || c.equals(">") || c.equals("{") || c.equals("}") || c.equals("(") || c.equals(")") || c.equals("[") || c.equals("]");
    }

    private int getOpenOffset(int closureIndex, Segment seg) {
        if (seg == null) {
            return -1;
        }
        String c = seg.toString();
        if (c.equals(">")) {
            this.ostr = "<";
            this.cstr = ">";
        } else if (c.equals("}")) {
            this.ostr = "{";
            this.cstr = "}";
        } else if (c.equals(")")) {
            this.ostr = "(";
            this.cstr = ")";
        } else if (c.equals("]")) {
            this.ostr = "[";
            this.cstr = "]";
        } else {
            return -1;
        }
        this.doc_segment = DocumentUtils.getSegment((Document)this.doc, 0, closureIndex);
        this.tok.setBuffer(this.doc_segment);
        this.tok.setBufferIndex(0);
        int openCount = 0;
        int lastPop = -1;
        IndexStack stack = new IndexStack();
        boolean getMetaData = false;
        String s = this.tok instanceof OslTokenizer ? ((OslTokenizer)this.tok).getNextStr(getMetaData) : this.tok.getNextStr();
        while (!s.equals("")) {
            if (!this.tok.isComment(s)) {
                if (s.equals(this.ostr)) {
                    ++openCount;
                    stack.push(this.tok.getBufferIndex() - 1);
                } else if (s.equals(this.cstr)) {
                    --openCount;
                    lastPop = stack.pop();
                }
                if (this.tok.getBufferIndex() == closureIndex) {
                    return lastPop;
                }
            }
            if (this.tok instanceof OslTokenizer) {
                s = ((OslTokenizer)this.tok).getNextStr(getMetaData);
                continue;
            }
            s = this.tok.getNextStr();
        }
        return -1;
    }

    private int getCloseOffset(int openerIndex, Segment seg) {
        if (seg == null) {
            return -1;
        }
        String c = seg.toString();
        if (c.equals("<")) {
            this.ostr = "<";
            this.cstr = ">";
        } else if (c.equals("{")) {
            this.ostr = "{";
            this.cstr = "}";
        } else if (c.equals("(")) {
            this.ostr = "(";
            this.cstr = ")";
        } else if (c.equals("[")) {
            this.ostr = "[";
            this.cstr = "]";
        } else {
            return -1;
        }
        this.doc_segment = DocumentUtils.getSegment((Document)this.doc, 0, this.doc.getLength());
        this.tok.setBuffer(this.doc_segment);
        this.tok.setBufferIndex(openerIndex);
        int openCount = 1;
        boolean getMetaData = true;
        String s = this.tok instanceof OslTokenizer ? ((OslTokenizer)this.tok).getNextStr(getMetaData) : this.tok.getNextStr();
        while (!s.equals("")) {
            if (!this.tok.isComment(s)) {
                if (s.equals(this.ostr)) {
                    ++openCount;
                } else if (s.equals(this.cstr)) {
                    --openCount;
                }
                if (openCount == 0) {
                    return this.tok.getBufferIndex() - 1;
                }
            }
            if (this.tok instanceof OslTokenizer) {
                s = ((OslTokenizer)this.tok).getNextStr(getMetaData);
                continue;
            }
            s = this.tok.getNextStr();
        }
        return -1;
    }

    private class Hilighter
    extends StyleContext {
        private boolean beginEndCharsAreActive = false;
        private boolean entireBlockIsActive = false;
        private Position[] beginEndCharPos = new Position[2];
        private Position[] beginEndBlockPos = new Position[2];
        private int absBegin = -1;
        private int absEnd = -1;
        public Style hiStyle;
        public Style prevStyle;

        public Hilighter() {
            Style def = this.getStyle("default");
            this.hiStyle = this.addStyle("Hilite", def);
            StyleConstants.setUnderline(this.hiStyle, false);
            this.initColor();
        }

        public void initColor() {
            Color paper = Preferences.getColor(Preferences.DOCUMENT_BACKGROUND_COLOR);
            float r = (float)paper.getRed() / 255.0f;
            float g = (float)paper.getGreen() / 255.0f;
            float b = (float)paper.getBlue() / 255.0f;
            float low2 = 0.7f;
            float high2 = 0.8f;
            r = low2 + (r - 0.0f) * (high2 - low2) / 1.0f;
            g = low2 + (g - 0.0f) * (high2 - low2) / 1.0f;
            b = low2 + (b - 0.0f) * (high2 - low2) / 1.0f;
            Color hilite = new Color(r, g, b);
            StyleConstants.setBackground(this.hiStyle, hilite);
        }

        public void saveBeginEndCharsOffsets(int b, int e) {
            try {
                this.beginEndCharPos[0] = KBlockBeginEndHiliter.this.doc.createPosition(b);
                this.beginEndCharPos[1] = KBlockBeginEndHiliter.this.doc.createPosition(e);
                this.beginEndCharsAreActive = true;
            }
            catch (BadLocationException ex) {
                Cutter.setLog("    Exception:KBlockBeginEndHiliter.Hilighter.saveBeginEndCharsOffsets() " + ex.toString());
                return;
            }
        }

        public void saveEntireBlockOffsets(int b, int e) {
            if (this.beginEndCharsAreActive) {
                this.unhiliteBeginEndChars();
            }
            try {
                this.beginEndBlockPos[0] = KBlockBeginEndHiliter.this.doc.createPosition(b);
                this.beginEndBlockPos[1] = KBlockBeginEndHiliter.this.doc.createPosition(e);
                this.entireBlockIsActive = true;
            }
            catch (BadLocationException ex) {
                Cutter.setLog("    Exception:KBlockBeginEndHiliter.Hilighter.saveEntireBlockOffsets() " + ex.toString());
                return;
            }
        }

        public void hiliteBeginEndChars() {
            if (!this.beginEndCharsAreActive) {
                return;
            }
            final int b = this.beginEndCharPos[0].getOffset();
            final int e = this.beginEndCharPos[1].getOffset();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String b_str = KBlockBeginEndHiliter.this.textpane.getCharAt(b);
                    String e_str = KBlockBeginEndHiliter.this.textpane.getCharAt(e);
                    if (KBlockBeginEndHiliter.this.isOpenOrCloseChar(b_str)) {
                        KBlockBeginEndHiliter.this.doc.setCharacterAttributes(b, 1, Hilighter.this.hiStyle, true);
                    }
                    if (KBlockBeginEndHiliter.this.isOpenOrCloseChar(e_str)) {
                        KBlockBeginEndHiliter.this.doc.setCharacterAttributes(e, 1, Hilighter.this.hiStyle, true);
                    }
                    Hilighter.this.beginEndCharsAreActive = true;
                }
            });
        }

        public void hiliteEntireBlock() {
            if (!this.entireBlockIsActive) {
                return;
            }
            final int b = this.beginEndBlockPos[0].getOffset();
            final int e = this.beginEndBlockPos[1].getOffset();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int length = e - b;
                    KBlockBeginEndHiliter.this.doc.setCharacterAttributes(b, length, Hilighter.this.hiStyle, true);
                    Hilighter.this.entireBlockIsActive = true;
                }
            });
        }

        public void unhiliteEntireBlock() {
            if (!this.entireBlockIsActive) {
                return;
            }
            if (this.beginEndBlockPos == null || this.beginEndBlockPos.length != 2 || this.beginEndBlockPos[0] == null || this.beginEndBlockPos[1] == null) {
                return;
            }
            final int b = this.beginEndBlockPos[0].getOffset();
            final int e = this.beginEndBlockPos[1].getOffset();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        KBlockBeginEndHiliter.this.doc.setCharacterAttributes(b, e - b, KBlockBeginEndHiliter.this.plainStyle, true);
                        Hilighter.this.entireBlockIsActive = false;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }

        public void unhiliteBeginEndChars() {
            if (this.beginEndCharPos == null || this.beginEndCharPos.length != 2 || this.beginEndCharPos[0] == null || this.beginEndCharPos[1] == null) {
                return;
            }
            final int b = this.beginEndCharPos[0].getOffset();
            final int e = this.beginEndCharPos[1].getOffset();
            final int blen = this.beginEndCharPos[0].getOffset() + 1 == ((KBlockBeginEndHiliter)KBlockBeginEndHiliter.this).doc.stringInsertedAt ? ((KBlockBeginEndHiliter)KBlockBeginEndHiliter.this).doc.stringInsertedLen + 1 : 1;
            final int elen = this.beginEndCharPos[1].getOffset() + 1 == ((KBlockBeginEndHiliter)KBlockBeginEndHiliter.this).doc.stringInsertedAt ? ((KBlockBeginEndHiliter)KBlockBeginEndHiliter.this).doc.stringInsertedLen + 1 : 1;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int[] offsets;
                    KBlockBeginEndHiliter.this.doc.setCharacterAttributes(b, blen, KBlockBeginEndHiliter.this.plainStyle, true);
                    KBlockBeginEndHiliter.this.doc.setCharacterAttributes(e, elen, KBlockBeginEndHiliter.this.plainStyle, true);
                    String prev_b = DocumentUtils.getCharacterStyleName(KBlockBeginEndHiliter.this.doc, b - 1);
                    String post_b = DocumentUtils.getCharacterStyleName(KBlockBeginEndHiliter.this.doc, b + 1);
                    String prev_e = DocumentUtils.getCharacterStyleName(KBlockBeginEndHiliter.this.doc, e - 1);
                    String post_e = DocumentUtils.getCharacterStyleName(KBlockBeginEndHiliter.this.doc, e + 1);
                    if (prev_b.equals("Hilite") || prev_b.equals("plain")) {
                        KBlockBeginEndHiliter.this.doc.setCharacterAttributes(b - 1, 1, KBlockBeginEndHiliter.this.plainStyle, true);
                    }
                    if (post_b.equals("Hilite")) {
                        KBlockBeginEndHiliter.this.doc.setCharacterAttributes(b + 1, 1, KBlockBeginEndHiliter.this.plainStyle, true);
                    }
                    if (prev_e.equals("Hilite") || prev_e.equals("plain")) {
                        KBlockBeginEndHiliter.this.doc.setCharacterAttributes(e - 1, 1, KBlockBeginEndHiliter.this.plainStyle, true);
                    }
                    if (post_e.equals("Hilite")) {
                        KBlockBeginEndHiliter.this.doc.setCharacterAttributes(e + 1, 1, KBlockBeginEndHiliter.this.plainStyle, true);
                    }
                    if ((offsets = DocumentUtils.getLineNumberAt(KBlockBeginEndHiliter.this.doc, b)) != null && offsets.length == 3) {
                        int startOfLineOffset = offsets[1];
                        String s = DocumentUtils.getCharacterStyleName(KBlockBeginEndHiliter.this.doc, startOfLineOffset);
                        if (s.equals("Hilite")) {
                            KBlockBeginEndHiliter.this.doc.setCharacterAttributes(startOfLineOffset, 1, KBlockBeginEndHiliter.this.plainStyle, true);
                        }
                    }
                    Hilighter.this.beginEndCharsAreActive = false;
                }
            });
        }
    }

    private class IndexStack {
        Stack<Integer> stack = new Stack();

        public void push(int index) {
            this.stack.push(index);
        }

        public int pop() {
            if (this.stack.empty()) {
                return -1;
            }
            Integer i = this.stack.pop();
            return i;
        }
    }
}

