/*
 * Decompiled with CFR 0.152.
 */
package UI_Text.KTextPane;

import UI_BBXT.BBxt;
import UI_Components.KTextField.KSerialTextField;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.ExtendedDesktopPane;
import UI_Script.Help.PopUpTriggerListener;
import UI_Text.KTextPane.KTextPane;
import UI_Window.KWindow.KAbstractTextWindow;
import Utilities.ComponentUtils;
import Utilities.EnvUtils;
import Utilities.SegmentUtils;
import Utilities.TextUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;

public class KCaret
extends DefaultCaret
implements ChangeListener {
    private static char[] defaultDelimitors;
    private Vector<PopUpTriggerListener> listOfPopUpTriggerListeners = new Vector();
    private boolean doAdjustCursor = true;
    public boolean allowDragging = true;
    public boolean isFirstClick = true;
    public boolean isSecondClick = false;
    private int firstClickOffset = -1;
    public Color color = Color.yellow;
    public Color selectionColor = Color.yellow;
    public Color defocusedSelectionColor = Color.lightGray;
    private int mousePressed_doublClickedAt = -1;
    private boolean hasFocus = false;
    private char[] wordBeginDelimitors;
    private char[] wordEndDelimitors;

    public static char[] getDefaultDelimitors() {
        return defaultDelimitors;
    }

    public KCaret() {
        if (EnvUtils.javaVersionAsInt() >= 14) {
            this.doAdjustCursor = false;
        }
        this.setWordDelimitors(defaultDelimitors, defaultDelimitors);
    }

    private void ___CARET_COLOR__METHODS________() {
    }

    public Color getCaretColor() {
        return this.getComponent().getCaretColor();
    }

    public Color getSelectionColor() {
        return this.getComponent().getSelectionColor();
    }

    @Override
    public void setVisible(boolean flag) {
        try {
            super.setVisible(flag);
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int dot = this.getDot();
        dot = dot - 1 > 0 ? dot - 1 : dot;
        JTextComponent textpane = this.getComponent();
    }

    @Override
    public String toString() {
        return "  Rectangle[x=" + this.x + ",y=" + this.y + ",width=" + this.width + ",height=" + this.height;
    }

    public KTextPane getTextPane() {
        return (KTextPane)this.getComponent();
    }

    public void addPopUpTriggerListener(PopUpTriggerListener l) {
        if (l == null) {
            return;
        }
        if (!this.listOfPopUpTriggerListeners.contains(l)) {
            this.listOfPopUpTriggerListeners.addElement(l);
        }
    }

    public void removePopUpTriggerListener(PopUpTriggerListener l) {
        if (l == null) {
            return;
        }
        this.listOfPopUpTriggerListeners.removeElement(l);
    }

    public void removeAllHelperPopUpTriggerListeners() {
        this.listOfPopUpTriggerListeners.removeAllElements();
    }

    private int getOffsetAtMouseEvent(MouseEvent e) {
        JTextComponent textpane = this.getComponent();
        int offset = -1;
        try {
            offset = textpane.viewToModel2D(e.getPoint());
        }
        catch (NoSuchMethodError er) {
            offset = textpane.viewToModel(new Point(e.getX(), e.getY()));
            Cutter.setLog("    Debug:NoSuchMethodError: KCaret.getOffsetAtMouseEvent() - using textpane.viewToMode() NOT textpane.viewToModel2D().");
        }
        return offset;
    }

    private void handlePopupTrigger(MouseEvent e) {
        JTextComponent textpane = this.getComponent();
        int begin = this.getMark() < this.getDot() ? this.getMark() : this.getDot();
        int end = begin == this.getMark() ? this.getDot() : this.getMark();
        int mouseLocation = this.getOffsetAtMouseEvent(e);
        if (mouseLocation == -1) {
            return;
        }
        textpane.setCaretPosition(mouseLocation);
        super.mouseReleased(e);
        if (end > begin) {
            BBxt.setSelection(begin, end);
        }
        this.notifyPopupTriggerListeners(e);
    }

    public void notifyPopupTriggerListeners(MouseEvent e) {
        JTextComponent textpane = this.getComponent();
        if (this.listOfPopUpTriggerListeners.size() > 0) {
            textpane.setCursor(Cursor.getPredefinedCursor(0));
        }
        for (int n = 0; n < this.listOfPopUpTriggerListeners.size(); ++n) {
            PopUpTriggerListener item = this.listOfPopUpTriggerListeners.elementAt(n);
            if (item == null) continue;
            int begin = this.getMark() < this.getDot() ? this.getMark() : this.getDot();
            int end = begin == this.getMark() ? this.getDot() : this.getMark();
            try {
                Point popupOrigin = new Point(e.getX(), e.getY());
                item.popupOnlineHelp(popupOrigin, textpane.getDocument().getText(begin, end - begin), end, e);
                continue;
            }
            catch (BadLocationException ex) {
                Cutter.setLog("    Exception: KCaret.actionPerformed() " + ex);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.allowDragging) {
            try {
                super.mouseDragged(e);
            }
            catch (Exception ex) {
                Cutter.setLog("    Exception:KCaret.mouseDragged() - " + ex.toString());
                return;
            }
        }
        if (this.firstClickOffset != -1) {
            this.setDot(this.firstClickOffset);
            this.firstClickOffset = -1;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        KAbstractTextWindow atw;
        JTextComponent textpane = this.getComponent();
        if (this.isFirstClick) {
            KAbstractTextWindow atw2;
            this.isFirstClick = false;
            this.isSecondClick = true;
            this.firstClickOffset = this.getOffsetAtMouseEvent(e);
            if (textpane.getClass().getName().equals("UI_Text.KTextPane.KTextPane") && (atw2 = ((KTextPane)textpane).getFrame()).appearanceIsSelected()) {
                textpane.grabFocus();
            }
            return;
        }
        KeyboardFocusManager man = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component comp = man.getFocusOwner();
        if (textpane != comp && textpane instanceof KTextPane && (atw = ((KTextPane)textpane).getFrame()).appearanceIsSelected()) {
            textpane.grabFocus();
        }
        this.firstClickOffset = -1;
        if (e.getClickCount() == 2) {
            super.mousePressed(e);
            this.mousePressed_doublClickedAt = this.isSecondClick ? this.getOffsetAtMouseEvent(e) : this.getOffsetAtMouseEvent(e);
            return;
        }
        this.isSecondClick = false;
        if (e.getClickCount() == 1 && e.isPopupTrigger()) {
            this.handlePopupTrigger(e);
            return;
        }
        try {
            super.mousePressed(e);
        }
        catch (Exception Ex) {
            Cutter.setLog("    Exception:KCaret.mousePressed() - super.mousePressed(e) " + Ex.toString());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        JTextComponent textpane = this.getComponent();
        if (!textpane.hasFocus()) {
            textpane.grabFocus();
        }
        if (e.getClickCount() == 2) {
            return;
        }
        if (this.doAdjustCursor) {
            try {
                int ps;
                if ((double)this.y != textpane.modelToView2D(this.getDot()).getY() && (ps = this.getDot() - 1) >= 0) {
                    textpane.setCaretPosition(ps);
                }
            }
            catch (Exception ex) {
                Cutter.setLog("    Exception: KCaret.mouseReleased(): " + ex);
            }
        }
        if (SwingUtilities.isMiddleMouseButton(e) && !e.isAltDown() && this.getDot() != this.getMark()) {
            super.mouseReleased(e);
            return;
        }
        if (e.isPopupTrigger()) {
            this.handlePopupTrigger(e);
            return;
        }
        super.mouseReleased(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        JTextComponent textpane = this.getComponent();
        if (SwingUtilities.isMiddleMouseButton(e) && this.getDot() != this.getMark()) {
            int mouseLocation = this.getOffsetAtMouseEvent(e);
            if (mouseLocation != -1) {
                textpane.setCaretPosition(mouseLocation);
            }
            return;
        }
        if (e.getClickCount() == 2) {
            String item = null;
            item = this.mousePressed_doublClickedAt != -1 ? this.selectWord(this.mousePressed_doublClickedAt) : this.selectWord(e);
            this.mousePressed_doublClickedAt = -1;
            if (item == null) {
                item = "";
            }
            if (textpane instanceof KTextPane && item != null) {
                ((KTextPane)textpane).showHelpDocFor(item, e);
            }
            return;
        }
        super.mouseClicked(e);
    }

    public String selectWord(MouseEvent e) {
        int offset = this.getOffsetAtMouseEvent(e);
        if (offset != -1) {
            return this.selectWord(offset);
        }
        return null;
    }

    public String selectWord(int selectAt) {
        int end;
        int start;
        final JTextComponent textpane = this.getComponent();
        int[] offset = new int[3];
        KeyboardFocusManager man = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component comp = man.getFocusOwner();
        if (comp == null && Cutter.input.debug) {
            Cutter.setLog("    Debug:KCaret.selectWord() - KeyboardFocusManager.getFocusOwner() returned null!");
        }
        if (comp != null && textpane != null && comp != textpane) {
            if (Cutter.input.debug) {
                Cutter.setLog("\n    Debug:KCaret.selectWord() - textpane is not the focus owner. Will force textpane to grab focus.\n");
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    textpane.grabFocus();
                }
            });
        }
        if (!(textpane.getDocument() instanceof AbstractDocument)) {
            Cutter.setLog("    Error: KCaret.selectWord() - document not an instanceof AbstractDocument");
        }
        Element element = ((AbstractDocument)textpane.getDocument()).getParagraphElement(selectAt);
        offset[1] = element.getStartOffset();
        offset[2] = element.getEndOffset();
        offset[0] = offset[2] - offset[1];
        Segment segment = new Segment();
        int begin = Math.abs(offset[1]);
        int length = Math.abs(offset[0]);
        try {
            textpane.getDocument().getText(begin, length, segment);
        }
        catch (BadLocationException ex) {
            Cutter.setLog("    Error:KCaret.selectWord() inputs = " + begin + ", " + length + ex);
            return null;
        }
        int deltaMark = selectAt - offset[1];
        int deltaBegin = this.selectWordStart(segment, deltaMark);
        if (deltaBegin == -1) {
            this.setDot(offset[1]);
        } else {
            this.setDot(offset[1] + deltaBegin);
        }
        int deltaEnd = this.selectWordEnd(segment, deltaMark);
        if (deltaEnd != -1) {
            this.moveDot(offset[1] + deltaEnd);
            textpane.setSelectionEnd(offset[1] + deltaEnd);
        }
        if ((start = offset[1] + deltaBegin) > (end = offset[1] + deltaEnd)) {
            textpane.setSelectionStart(end);
            textpane.setSelectionEnd(start);
            Cutter.setLog("    Debug:KCaret.selectWord() - start > end. Calling textpane.setSelectionStart(end)\n          and setSelectionEnd(start) to try to correct back-to-front selection offsets.");
        }
        return textpane.getSelectedText();
    }

    public int selectWordStart(Segment segment, int deltaMark) {
        try {
            for (int n = deltaMark - 1; n >= 0; --n) {
                int index = n + segment.offset;
                char c = segment.array[n + segment.offset];
                for (int i = 0; i < this.wordBeginDelimitors.length; ++i) {
                    if (c != this.wordBeginDelimitors[i]) continue;
                    return n + 1;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            Cutter.setLog("   Debug: KCaret.selectWordStart() - exception        " + ex.toString());
            return -1;
        }
        return -1;
    }

    public int selectWordStart(Segment segment, int deltaMark, char[] delims) {
        try {
            for (int n = deltaMark - 1; n >= 0; --n) {
                int index = n + segment.offset;
                char c = segment.array[n + segment.offset];
                for (int i = 0; i < delims.length; ++i) {
                    if (c != delims[i]) continue;
                    return n + 1;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            Cutter.setLog("   Debug: KCaret.selectWordStart() - exception        " + ex.toString());
            return -1;
        }
        return -1;
    }

    public int selectWordEnd(Segment segment, int deltaMark) {
        for (int n = deltaMark; n < segment.count; ++n) {
            char c = segment.array[n + segment.offset];
            for (int i = 0; i < this.wordEndDelimitors.length; ++i) {
                if (c != this.wordEndDelimitors[i]) continue;
                return n;
            }
        }
        return -1;
    }

    public String[] getWordAt(int mouseAt, char[] delims) {
        int deltaEnd;
        JTextComponent textpane = this.getComponent();
        Element element = ((AbstractDocument)textpane.getDocument()).getParagraphElement(mouseAt);
        int begin = element.getStartOffset();
        int end = element.getEndOffset();
        int length = end - begin;
        Segment segment = new Segment();
        try {
            textpane.getDocument().getText(begin, length, segment);
        }
        catch (BadLocationException ex) {
            Cutter.setLog("    Error: 1 KCaret.getWordAt() inputs = " + begin + ", " + length + " " + ex);
            return null;
        }
        String line = SegmentUtils.toString(segment, 0, segment.length());
        String[] parts = TextUtils.tokenize(line);
        if (parts == null) {
            return null;
        }
        String[] out = new String[2];
        out[0] = parts[0];
        int deltaMouseAt = mouseAt - begin;
        int deltaBegin = delims != null && delims.length > 0 ? this.selectWordStart(segment, deltaMouseAt, delims) : this.selectWordStart(segment, deltaMouseAt);
        if (deltaBegin == -1) {
            deltaBegin = 0;
        }
        if (deltaBegin == (deltaEnd = this.selectWordEnd(segment, deltaMouseAt))) {
            return null;
        }
        length = deltaEnd - deltaBegin;
        String outStr = SegmentUtils.toString(segment, deltaBegin, length);
        if (outStr == null) {
            Cutter.setLog("    Error: KCaret.getWordAt() - deltaBegin = " + deltaBegin + " length = " + length);
        }
        out[1] = outStr;
        return out;
    }

    public String getWordAndContextAt(int mouseAt, char[] delims) {
        int deltaEnd;
        JTextComponent textpane = this.getComponent();
        Element element = ((AbstractDocument)textpane.getDocument()).getParagraphElement(mouseAt);
        int begin = element.getStartOffset();
        int end = element.getEndOffset();
        int length = end - begin;
        Segment segment = new Segment();
        try {
            textpane.getDocument().getText(begin, length, segment);
        }
        catch (BadLocationException ex) {
            Cutter.setLog("    Error: 1 KCaret.getWordAt() inputs = " + begin + ", " + length + " " + ex);
            return null;
        }
        String[] out = new String[2];
        int deltaMouseAt = mouseAt - begin;
        int deltaBegin = delims != null && delims.length > 0 ? this.selectWordStart(segment, deltaMouseAt, delims) : this.selectWordStart(segment, deltaMouseAt);
        if (deltaBegin == -1) {
            deltaBegin = 0;
        }
        if (deltaBegin == (deltaEnd = this.selectWordEnd(segment, deltaMouseAt))) {
            return null;
        }
        length = deltaEnd - deltaBegin;
        String outStr = SegmentUtils.toString(segment, deltaBegin, length);
        if (outStr == null) {
            Cutter.setLog("    Error: KCaret.getWordAt() - deltaBegin = " + deltaBegin + " length = " + length);
        }
        return outStr;
    }

    @Override
    public void setSelectionVisible(boolean flag) {
        if (!this.hasFocus && !flag) {
            this.isFirstClick = true;
            this.isSecondClick = false;
            JTextComponent parentTextComp = this.getComponent();
            if (!parentTextComp.getSelectionColor().equals(this.defocusedSelectionColor)) {
                this.paintDefocusedSelection();
            }
            return;
        }
        super.setSelectionVisible(flag);
    }

    @Override
    public void focusLost(FocusEvent e) {
        Component lostFocusComp = e.getOppositeComponent();
        JTextComponent parentTextComp = this.getComponent();
        boolean useSelectionColor = false;
        this.hasFocus = false;
        if (lostFocusComp == null || lostFocusComp instanceof JCheckBox || lostFocusComp instanceof JButton || lostFocusComp instanceof KSerialTextField) {
            super.focusLost(e);
            return;
        }
        if (ComponentUtils.getParentOfClass(lostFocusComp, "Tools") != null) {
            useSelectionColor = true;
        }
        if (lostFocusComp instanceof JTextComponent || lostFocusComp instanceof ExtendedDesktopPane || lostFocusComp.getClass().getName().equals("javax.swing.JScrollPane$ScrollBar")) {
            parentTextComp.setSelectionColor(this.defocusedSelectionColor);
            int b = parentTextComp.getSelectionStart();
            int end = parentTextComp.getSelectionEnd();
            parentTextComp.setSelectionStart(b);
            parentTextComp.setSelectionEnd(end);
            super.repaint();
            this.setVisible(false);
            this.isFirstClick = true;
        }
        this.setVisible(false);
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.hasFocus = true;
        JTextComponent c = this.getComponent();
        if (c != null) {
            int b = c.getSelectionStart();
            int end = c.getSelectionEnd();
            c.setSelectionColor(this.selectionColor);
            c.setSelectionStart(b);
            c.setSelectionEnd(end);
        }
        super.focusGained(e);
    }

    public void paintDefocusedSelection() {
        JTextComponent parentTextComp = this.getComponent();
        if (parentTextComp != null) {
            parentTextComp.setSelectionColor(this.defocusedSelectionColor);
            int b = parentTextComp.getSelectionStart();
            int end = parentTextComp.getSelectionEnd();
            try {
                parentTextComp.setSelectionStart(b);
                parentTextComp.setSelectionEnd(end);
            }
            catch (Exception ex) {
                Cutter.setLog("    Exception:KCaret.paintDefocusedSelection() - caught ");
                Cutter.setLog("          " + ex.toString());
            }
        }
        super.repaint();
    }

    private void ___WORD_DELIMITOR__METHODS________() {
    }

    public void addWordDelimitors(char[] beginners, char[] enders) {
        if (beginners == null && enders == null) {
            return;
        }
        this.wordBeginDelimitors = TextUtils.addToCharArray(this.wordBeginDelimitors, beginners);
        this.wordEndDelimitors = TextUtils.addToCharArray(this.wordEndDelimitors, enders);
    }

    public void initDefaultWordDelimitors() {
        this.wordBeginDelimitors = TextUtils.addToCharArray(null, defaultDelimitors);
        this.wordEndDelimitors = TextUtils.addToCharArray(null, defaultDelimitors);
    }

    public void setWordDelimitors(char[] begin, char[] end) {
        if (begin == null && end == null) {
            return;
        }
        this.wordBeginDelimitors = TextUtils.addToCharArray(null, begin);
        this.wordEndDelimitors = TextUtils.addToCharArray(null, end);
    }

    public void removeWordDelimitors(char[] begin, char[] end) {
        if (begin != null) {
            this.wordBeginDelimitors = TextUtils.removeFromCharArray(this.wordBeginDelimitors, begin);
        }
        if (end != null) {
            this.wordEndDelimitors = TextUtils.removeFromCharArray(this.wordEndDelimitors, end);
        }
    }

    public boolean isWordBeginDelimitor(char c) {
        if (c == '\u0000') {
            return false;
        }
        for (int n = 0; n < this.wordBeginDelimitors.length; ++n) {
            if (this.wordBeginDelimitors[n] != c) continue;
            return true;
        }
        return false;
    }

    public boolean isWordEndDelimitor(char c) {
        if (c == '\u0000') {
            return false;
        }
        for (int n = 0; n < this.wordEndDelimitors.length; ++n) {
            if (this.wordEndDelimitors[n] != c) continue;
            return true;
        }
        return false;
    }

    static {
        int n;
        Vector<Character> item = new Vector<Character>();
        item.addElement(Character.valueOf('\t'));
        item.addElement(Character.valueOf('\n'));
        for (n = 32; n < 48; ++n) {
            item.addElement(Character.valueOf((char)n));
        }
        for (n = 58; n < 65; ++n) {
            item.addElement(Character.valueOf((char)n));
        }
        for (n = 91; n < 97; ++n) {
            if (n == 95) continue;
            item.addElement(Character.valueOf((char)n));
        }
        for (n = 123; n < 127; ++n) {
            item.addElement(Character.valueOf((char)n));
        }
        defaultDelimitors = new char[item.size()];
        for (n = 0; n < item.size(); ++n) {
            KCaret.defaultDelimitors[n] = ((Character)item.elementAt(n)).charValue();
        }
    }
}

