/*
 * Decompiled with CFR 0.152.
 */
package UI_Text.KTextPane;

import UI_Desktop.Cutter;
import UI_Text.KTextPane.KTextPane;
import UI_Text.KTextPane.KTextUndoManager;
import Utilities.DocumentUtils;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import javax.swing.text.StyleContext;

public class KDocument
extends DefaultStyledDocument {
    private static Vector freelist = new Vector();
    private int n;
    public int quotesRemoved = 0;
    public String stringRemoved = "";
    public int stringRemovedAt = 0;
    public int stringInsertedLen = 0;
    public int stringInsertedAt = 0;
    public String stringInserted = "";
    private KTextPane textpane;
    public KTextUndoManager undoManager = null;
    private boolean undoManagerIsListening = true;

    public KTextUndoManager addNewUndoManager(KTextPane textpane) {
        this.undoManager = new KTextUndoManager(textpane);
        this.addUndoableEditListener(this.undoManager);
        this.undoManagerIsListening = true;
        return this.undoManager;
    }

    public void undoManagerResumeListening() {
        if (!this.undoManagerIsListening) {
            this.addUndoableEditListener(this.undoManager);
        }
        this.undoManagerIsListening = true;
    }

    public void undoManagerSuspendListening() {
        if (this.undoManagerIsListening) {
            this.removeUndoableEditListener(this.undoManager);
        }
        this.undoManagerIsListening = false;
    }

    public KDocument(StyleContext styles, KTextPane textpane) {
        super(styles);
        this.textpane = textpane;
        this.undoManager = new KTextUndoManager(textpane);
        this.addUndoableEditListener(this.undoManager);
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        this.quotesRemoved = 0;
        Segment s = DocumentUtils.getSegment((Document)this, offs, len);
        this.stringRemoved = s.toString();
        this.stringRemovedAt = offs;
        this.n = 0;
        while (this.n < s.count) {
            if (s.array[this.n + s.offset] == '\"') {
                ++this.quotesRemoved;
            }
            ++this.n;
        }
        super.remove(offs, len);
    }

    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        this.stringInsertedLen = str.length();
        this.stringInsertedAt = offset;
        this.stringInserted = str;
        super.insertString(offset, str, a);
    }

    @Override
    public void setCharacterAttributes(int offset, int length, AttributeSet s, boolean replace) {
        this.undoManagerSuspendListening();
        super.setCharacterAttributes(offset, length, s, replace);
        this.undoManagerResumeListening();
    }

    public void removeAllListeners() {
        int n;
        EventListener[] el = this.getListeners(DocumentListener.class);
        if (el != null) {
            for (n = 0; n < el.length; ++n) {
                this.removeDocumentListener((DocumentListener)el[n]);
            }
        }
        if ((el = this.getListeners(UndoableEditListener.class)) != null) {
            for (n = 0; n < el.length; ++n) {
                this.removeUndoableEditListener((UndoableEditListener)el[n]);
            }
        }
    }

    public EventListener[] getAllListeners() {
        int n;
        EventListener[] evl = this.getListeners(DocumentListener.class);
        EventListener[] uedl = this.getListeners(UndoableEditListener.class);
        int num = evl == null ? 0 : evl.length;
        EventListener[] out = new EventListener[num += uedl == null ? 0 : uedl.length];
        int j = 0;
        if (evl != null && evl.length > 0) {
            for (n = 0; n < evl.length; ++n) {
                out[j++] = evl[n];
            }
        }
        if (uedl != null && uedl.length > 0) {
            for (n = 0; n < uedl.length; ++n) {
                out[j++] = uedl[n];
            }
        }
        return out;
    }

    public void addListeners(EventListener[] items) {
        if (items == null || items.length == 0) {
            return;
        }
        for (int n = 0; n < items.length; ++n) {
            EventListener item = items[n];
            if (item instanceof DocumentListener) {
                this.addDocumentListener((DocumentListener)item);
                continue;
            }
            Cutter.setLog("    Error:KTextPane.KDocument.addListeners");
            Cutter.setLog("Cannot add EventListener of class " + item.getClass().getName());
        }
    }

    public void redo() throws Exception {
        if (this.undoManager != null) {
            this.undoManager.redo();
        }
    }

    public void undo() throws Exception {
        if (this.undoManager != null) {
            this.undoManager.undo();
        }
    }

    public boolean canUndo() throws Exception {
        return this.undoManager == null ? false : this.undoManager.canUndo();
    }

    public boolean canRedo() throws Exception {
        return this.undoManager == null ? false : this.undoManager.canRedo();
    }

    public String getPresentationName() throws Exception {
        return this.undoManager.getPresentationName();
    }

    public String getUndoPresentationName() throws Exception {
        return this.undoManager.getUndoPresentationName();
    }

    public String getRedoPresentationName() throws Exception {
        return this.undoManager.getRedoPresentationName();
    }
}

