/*
 * Decompiled with CFR 0.152.
 */
package UI_Text.KTextPane;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Script.Comment;
import UI_Script.Default.KDefaultHelp;
import UI_Script.Default.KDefaultScriptHandler;
import UI_Script.Help.KAbstractHelp;
import UI_Script.Help.PopUpTriggerListener;
import UI_Script.Python.PythonHelp;
import UI_Script.ScriptHandler;
import UI_Script.ScriptRegistry;
import UI_Script.SyntaxListener;
import UI_Text.KTextPane.KAbstractTextPane;
import UI_Text.KTextPane.KBlockBeginEndHiliter;
import UI_Text.KTextPane.KCaret;
import UI_Text.KTextPane.KDocument;
import UI_Text.KTextPane.KTabsListener;
import UI_Text.KTextPane.KWordHiliter;
import UI_Text.KeyMaps.KKeyMaps;
import UI_Text.Style.KStyleContext;
import UI_Window.KWindow.KAbstractTextWindow;
import UI_Window.KWindow.KTextWindow;
import Utilities.DocumentUtils;
import Utilities.DynamicEdit;
import Utilities.EnvUtils;
import Utilities.FileUtils;
import Utilities.TextUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.Style;
import javax.swing.text.TextAction;
import kernal.Tokenizers.Tokenizer;

public class KTextPane
extends KAbstractTextPane {
    private static final long serialVersionUID = 1L;
    private String defaultFontName = Cutter.defaultTextPaneFontName;
    static Hashtable<String, Action> tableOfActions = null;
    public static boolean _helpTrigger = false;
    public static boolean _setCharacterAttributes = false;
    public static boolean _spanDetails = false;
    public static boolean _processComponentKeyEvent = false;
    public static boolean _finalize = true;
    private int lastReturn = 0;
    private int lineCount = 1;
    private int charCount = 0;
    private int caretOffset;
    private boolean doIncrement = true;
    private StringBuffer rowBuf = new StringBuffer();
    private SyntaxListener syntaxListener = null;
    private KAbstractTextWindow frame = null;
    private KCaret kcaret = null;
    public int numTabs = 0;
    public int quotesRemoved = 0;
    public String stringRemoved = "";
    public String stringAdded = "";
    public int prevCaret = 0;
    public char charDeleted;
    public char charAdded;
    public char nextChar;
    public char prevChar = '\u0000';
    public KAbstractHelp helper = null;
    public KStyleContext styleContext = new KStyleContext();
    private boolean hasSelection = false;
    public KBlockBeginEndHiliter hiliter;
    public KWordHiliter wordHiliter;
    private Vector<CaretListener> caretListeners = null;
    private Vector<DocumentListener> documentListeners = null;
    private Vector<KTabsListener> tabsListeners = new Vector();
    public KDocument document;
    private Segment segment = new Segment();
    public int position;
    private int n;
    private int i;
    public boolean replaceSpacesWithTabsOffered = false;
    public boolean doReplaceSpacesWithTabs = false;

    @Override
    protected EditorKit createDefaultEditorKit() {
        return new KAbstractTextPane.KEditorKit();
    }

    public void undoManagerResumeListening() {
        ((KDocument)this.getDocument()).undoManagerResumeListening();
    }

    public void undoManagerSuspendListening() {
        ((KDocument)this.getDocument()).undoManagerSuspendListening();
    }

    public KTextPane(KAbstractTextWindow frame) {
        this.frame = frame;
        this.document = new KDocument(this.styleContext, this);
        this.setStyledDocument(this.document);
        super.setFont(KStyleContext.defaultFont);
        this.document.setLogicalStyle(0, this.styleContext.defaultTextStyle);
        this.document.undoManager.setDocument(this.document);
        this.setDefaultCaret();
        this.updateSyntaxListener(frame.getTitle());
        this.hiliter = new KBlockBeginEndHiliter(this, (KDocument)this.getDocument(), this.styleContext.plainStyle);
        this.hiliter.initHiliteColor();
        this.hiliter.initTokenizer(this.syntaxListener.tok);
        this.addCaretListener(this.hiliter);
        String title = frame.getTitle();
        String ext = FileUtils.getExtension(title);
        this.wordHiliter = new KWordHiliter(this, (KDocument)this.getDocument(), this.styleContext.plainStyle);
        this.wordHiliter.initTokenizer(this.syntaxListener.tok);
        this.addCaretListener(this.wordHiliter);
        this.addMouseListener(this.wordHiliter);
        this.getDocument().addDocumentListener(this.wordHiliter);
        KKeyMaps.setDefaults(this);
        BackwardAction baction = new BackwardAction(this);
        ForwardAction faction = new ForwardAction(this);
        DropTarget dt = this.getDropTarget();
        dt.setActive(false);
    }

    public void showHelpDocFor(String item, final MouseEvent e) {
        if (item == null || item.trim().length() == 0) {
            if (this.helper != null && this.helper instanceof PythonHelp) {
                String temp = this.getCharAt(this.getMark());
                if (temp == null) {
                    return;
                }
                item = temp;
            } else {
                return;
            }
        }
        if (e.getClickCount() == 2 && (e.isAltDown() || e.isMetaDown() || !EnvUtils.isOSXEnvironment() && e.isControlDown())) {
            Cutter.setLog("    Debug:KTextPane.showHelpDocFor() - double click+modifier key item \"" + item + "\"");
            if (e.isPopupTrigger()) {
                Cutter.setLog("    Debug:KTextPane.showHelpDocFor() - ignoring popup event");
                return;
            }
            if (this.helper == null || this.helper instanceof KDefaultHelp) {
                return;
            }
            Cutter.htmlWindow.setFindField(item);
            final String processedItem = item;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    KTextPane.this.helper.showDocFor(processedItem, e);
                }
            });
        }
    }

    public void setDefaultCaret() {
        this.kcaret = new KCaret();
        this.caretListeners = null;
        this.caretListeners = new Vector();
        this.initCaretsDefaultColors();
        this.kcaret.setBlinkRate(((DefaultCaret)this.getCaret()).getBlinkRate());
        this.setCaret(this.kcaret);
    }

    public void initCaretsDefaultColors() {
        Color caretColor = TextUtils.toColor(Preferences.get(Preferences.DOCUMENT_CARET_COLOR));
        Color caretSelectionColor = TextUtils.toColor(Preferences.get(Preferences.DOCUMENT_CARET_SELECTION_COLOR));
        if (caretColor == null) {
            Cutter.setLog("    Error: KTextPane.initCaretsDefaultColors() - caret color is null");
        }
        if (caretSelectionColor == null) {
            Cutter.setLog("    Error: KTextPane.initCaretsDefaultColors() - caret selection color is null");
        }
        this.setCaretColor(caretColor == null ? Color.yellow : caretColor);
        this.setSelectionColor(caretSelectionColor == null ? new Color(255, 255, 0) : caretSelectionColor);
        Color dfSelectionColor = TextUtils.toColor(Preferences.get(Preferences.DOCUMENT_CARET_DEFOCUSED_SELECTION_COLOR));
        this.kcaret.selectionColor = this.getSelectionColor();
        this.kcaret.defocusedSelectionColor = dfSelectionColor == null ? Color.lightGray : dfSelectionColor;
        this.kcaret.color = this.getCaretColor();
    }

    public void initCaretsDefaultWordDelimitors() {
        this.kcaret.initDefaultWordDelimitors();
    }

    @Override
    public void addCaretListener(CaretListener l) {
        if (this.caretListeners == null) {
            this.caretListeners = new Vector();
        }
        this.caretListeners.remove(l);
        this.caretListeners.addElement(l);
        super.removeCaretListener(l);
        super.addCaretListener(l);
    }

    @Override
    public void removeCaretListener(CaretListener l) {
        if (this.caretListeners != null) {
            this.caretListeners.remove(l);
        }
        super.removeCaretListener(l);
    }

    public void addTabsListener(KTabsListener l) {
        this.tabsListeners.remove(l);
        this.tabsListeners.addElement(l);
    }

    public void removeAllHelperPopUpTriggerListeners() {
        this.getKCaret().removeAllHelperPopUpTriggerListeners();
    }

    public void addDocumentListener(DocumentListener l) {
        Document document = this.getDocument();
        if (document != null) {
            if (this.documentListeners == null) {
                this.documentListeners = new Vector();
            }
            this.documentListeners.addElement(l);
            document.addDocumentListener(l);
        }
    }

    public void removeDocumentListener(DocumentListener l) {
        Document document = this.getDocument();
        if (document != null) {
            if (this.documentListeners != null) {
                this.documentListeners.remove(l);
            }
            document.removeDocumentListener(l);
        }
    }

    public void addPopUpTriggerListener(PopUpTriggerListener l) {
        this.kcaret.addPopUpTriggerListener(l);
    }

    public void removeAllStyles() {
        Enumeration<?> e = ((DefaultStyledDocument)this.getStyledDocument()).getStyleNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name == null) continue;
            this.removeStyle(name);
        }
    }

    public void addStyles(String[] names, Style[] styles) {
        DefaultStyledDocument doc = (DefaultStyledDocument)this.getStyledDocument();
        for (int n = 0; n < styles.length; ++n) {
            doc.addStyle(names[n], styles[n]);
        }
    }

    public String getStyleNameAtOffset(int offset) {
        return this.getStyledDocument().getCharacterElement(offset).getAttributes().getAttribute(AttributeSet.NameAttribute).toString();
    }

    @Override
    public void setEditable(boolean flag) {
        this.setEditable(flag, false);
    }

    public void setEditable(boolean flag, boolean silent) {
        KAbstractTextWindow w = this.getFrame();
        File f = null;
        if (w != null && flag && (f = w.getFile()) != null && !f.canWrite()) {
            flag = false;
        }
        super.setEditable(flag);
        if (w != null && !silent) {
            w.setSaveable(flag);
        }
    }

    @Override
    public boolean isEditable() {
        return super.isEditable();
    }

    public Dimension getSelectedTextSize() {
        if (this.getSelectionLength() == 0) {
            return null;
        }
        return null;
    }

    public boolean isWordBeginDelimitor(char c) {
        return this.kcaret.isWordBeginDelimitor(c);
    }

    public boolean isWordEndDelimitor(char c) {
        return this.kcaret.isWordEndDelimitor(c);
    }

    public KCaret getKCaret() {
        return this.kcaret;
    }

    public void isSelectable(boolean flag) {
        this.kcaret.allowDragging = flag;
    }

    public void hideCaret() {
        this.kcaret.setVisible(false);
    }

    public void showCaret() {
        this.kcaret.setVisible(true);
    }

    public int getDot() {
        return this.kcaret.getDot();
    }

    public int getMark() {
        return this.kcaret.getMark();
    }

    public String selectWord() {
        return this.kcaret.selectWord(this.getDot());
    }

    public String[] getWordAt(int offset, char[] delims) {
        return this.kcaret.getWordAt(offset, delims);
    }

    public void addWordDelimitors(char[] begin, char[] end) {
        this.kcaret.addWordDelimitors(begin, end);
    }

    public void setWordDelimitors(char[] begin, char[] end) {
        this.kcaret.setWordDelimitors(begin, end);
    }

    public void removeWordDelimitors(char[] begin, char[] end) {
        this.kcaret.removeWordDelimitors(begin, end);
    }

    private void updateHelper(ScriptHandler handler) {
        if (handler == null) {
            Cutter.setLog("    Warning: KTextPane.updateHelper() has been passed a null handler");
            return;
        }
        this.helper = handler.getHelper(this);
        if (this.helper != null) {
            this.kcaret.addPopUpTriggerListener(this.helper);
        }
    }

    public void updateSyntaxListener(String name) {
        File f;
        ScriptHandler handler;
        String copy = TextUtils.remove(name, '*');
        if (copy.endsWith(" [NOT EDITABLE]")) {
            copy = copy.substring(0, copy.length() - " [NOT EDITABLE]".length());
        }
        if ((handler = null) == null && (f = this.getFrameFile()) != null) {
            handler = ScriptRegistry.getHandlerForFile(f);
        }
        if (handler == null) {
            handler = ScriptRegistry.getHandlerForExtension(FileUtils.getExtension(copy));
        }
        if (handler == null) {
            handler = new KDefaultScriptHandler();
        }
        if (handler != null) {
            if (handler.syntaxListenerIsOK(this.syntaxListener, this)) {
                this.updateHelper(handler);
                return;
            }
            this.removeDocumentListener(this.syntaxListener);
            SyntaxListener listener = handler.getSyntaxListener(this);
            this.updateHelper(handler);
            this.syntaxListener = listener;
            this.addDocumentListener(this.syntaxListener);
            String defaultName = Preferences.get(Preferences.TEXT_FONT_NAME);
            Font f2 = new Font(defaultName, 0, 12);
            this.setFont(f2);
            if (this.wordHiliter != null) {
                this.wordHiliter.initTokenizer(this.syntaxListener.tok);
                this.wordHiliter.initHiliteColor();
            }
        } else {
            Cutter.setLog("    Warning: KTextPane.updateSyntaxListener() [" + name + "] - handler is null");
        }
    }

    public synchronized void suspendSyntaxColoration() {
        if (this.syntaxListener != null) {
            this.syntaxListener.suspendColoration();
        } else {
            Cutter.setLog("    Warning: KTextPane.suspendSyntaxColoration() - cannot suspend because syntaxListener is null");
        }
    }

    public synchronized void resumeSyntaxColoration() {
        this.updateSyntaxListener(this.getFrameTitle());
        if (this.syntaxListener != null) {
            this.syntaxListener.resumeColoration();
        } else {
            Cutter.setLog("    Warning: KTextPane.resumeSyntaxColoration() - cannot resume because syntaxListener is null");
        }
    }

    public synchronized boolean syntaxColorationIsActive() {
        return this.syntaxListener == null ? false : this.syntaxListener.colorationIsActive();
    }

    public void removeSyntaxListener() {
        if (this.getDocument() != null && this.syntaxListener != null) {
            this.getDocument().removeDocumentListener(this.syntaxListener);
        }
        this.syntaxListener = null;
    }

    @Override
    public void paste() {
        super.paste();
    }

    public synchronized void parseAll() {
        if (this.syntaxListener != null) {
            this.syntaxListener.parseAll();
        } else {
            Cutter.setLog("    Warning: KTextPane.parseAll()  syntaxListener is null");
        }
    }

    public void parseFromTo(int begin, int end) {
        if (this.syntaxListener != null) {
            this.syntaxListener.parseFromTo(begin, end);
        }
    }

    public String getSyntaxListenerClassName(KTextPane textpane) {
        if (this.syntaxListener != null) {
            return this.syntaxListener.getClass().getName();
        }
        return null;
    }

    public SyntaxListener getSyntaxListener() {
        return this.syntaxListener;
    }

    public String getSyntaxFileExtension() {
        return this.syntaxListener == null ? null : SyntaxListener.fileExtension;
    }

    public Comment[] getComments() {
        if (this.syntaxListener == null) {
            return null;
        }
        Tokenizer tok = this.syntaxListener.tok;
        if (tok == null) {
            return null;
        }
        return tok.comments;
    }

    public String getNameOfStyleContext() {
        return KStyleContext.name;
    }

    public KAbstractTextWindow getFrame() {
        return this.frame;
    }

    public String getFrameTitle() {
        return this.frame.getTitle();
    }

    public File getFrameFile() {
        return this.frame.getFile();
    }

    public Rectangle getFrameBounds() {
        return this.frame.getBounds();
    }

    public JScrollPane getScrollPane() {
        return ((KTextWindow)this.frame).getScrollPane();
    }

    public void suspendScrollPaneLayoutManager() {
        ((KTextWindow)this.frame).suspendScrollPaneLayoutManager();
    }

    public void resumeScrollPaneLayoutManager() {
        ((KTextWindow)this.frame).resumeScrollPaneLayoutManager();
    }

    public void updateAutoTab() {
        try {
            int n;
            int position = this.getCaretPosition();
            if (position == 0) {
                this.numTabs = 0;
                return;
            }
            this.rowBuf.setLength(0);
            this.rowBuf.append(this.getText(0, position));
            for (n = this.rowBuf.length() - 1; n >= 0; --n) {
                if (this.rowBuf.charAt(n) != '\n') continue;
                this.lastReturn = n;
                break;
            }
            this.numTabs = 0;
            for (n = this.rowBuf.length() - 1; n > this.lastReturn; --n) {
                if (this.rowBuf.charAt(n) != '\t') continue;
                ++this.numTabs;
            }
        }
        catch (BadLocationException ex) {
            Cutter.setLog("    Error: KTextPane.updateAutoTab() - bad location = " + ex);
            return;
        }
    }

    private String decodeID(KeyEvent e) {
        switch (e.getID()) {
            case 401: {
                return "[KEY_PRESSED]";
            }
            case 402: {
                return "[KEY_RELEASED]";
            }
            case 400: {
                return "[KEY_TYPED]";
            }
        }
        return "[unknown key action]";
    }

    public int quotesRemoved() {
        return this.quotesRemoved;
    }

    public String stringRemoved() {
        return this.stringRemoved;
    }

    public int stringLengthRemoved() {
        return this.stringRemoved == null ? 0 : this.stringRemoved.length();
    }

    public String stringAdded() {
        return this.stringAdded;
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        block4: {
            if (this.helper.completer.canHandle(e)) {
                return;
            }
            if (KKeyMaps.canHandle(e) || e == null) {
                return;
            }
            try {
                super.processKeyEvent(e);
            }
            catch (Exception ex) {
                if (!Cutter.input.debug) break block4;
                Cutter.setLog("    Exception:KTextPane.processKeyEvent() - called super.processKeyEvent() \n        " + ex.toString());
            }
        }
    }

    @Override
    protected void processComponentKeyEvent(KeyEvent e) {
        if (Cutter.input.debug && this.getSelectionStart() != this.getSelectionEnd()) {
            String evt = "unknown";
            if (e.getID() == 401) {
                evt = "KeyEvent.KEY_PRESSED";
            } else if (e.getID() == 402) {
                evt = "KeyEvent.KEY_RELEASED";
            }
        }
        if (e.getID() != 401) {
            super.processComponentKeyEvent(e);
            return;
        }
        Document document = this.getDocument();
        this.numTabs = 0;
        if (e.getID() == 401) {
            this.prevCaret = this.getCaretPosition();
            this.prevChar = '\u0000';
            this.nextChar = '\u0000';
            this.charAdded = '\u0000';
            this.charDeleted = '\u0000';
        }
        try {
            if (e.getID() == 401 && (e.getKeyCode() == 8 || e.getKeyCode() == 127)) {
                this.position = this.getCaretPosition();
                if (this.position > 1) {
                    document.getText(this.position - 2, 2, this.segment);
                    this.prevChar = this.segment.array[this.segment.offset];
                    this.charDeleted = this.segment.array[this.segment.offset + 1];
                } else if (this.position > 0) {
                    document.getText(this.position - 1, 1, this.segment);
                    this.charDeleted = this.segment.array[this.segment.offset];
                }
                if (this.position + 1 < document.getLength()) {
                    document.getText(this.position, 1, this.segment);
                    this.nextChar = this.segment.array[this.segment.offset];
                }
                super.processComponentKeyEvent(e);
                this.updateAutoTab();
                return;
            }
            if (e.getID() == 401 && e.getKeyCode() == 10) {
                this.position = this.getCaretPosition();
                if (this.position > 0) {
                    document.getText(this.position - 1, 1, this.segment);
                    this.prevChar = this.segment.array[this.segment.offset];
                }
                document.getText(this.position, 1, this.segment);
                this.nextChar = this.segment.array[this.segment.offset];
                this.charAdded = (char)10;
                this.numTabs = 0;
                document.getText(0, this.prevCaret, this.segment);
                if (this.segment.count - 1 > 0) {
                    this.n = this.segment.count - 1;
                    while (this.n > 0 && this.segment.array[this.segment.offset + this.n] != '\n') {
                        --this.n;
                    }
                    this.i = this.n;
                    while (this.i < this.prevCaret) {
                        if (this.segment.array[this.segment.offset + this.i] == '\t') {
                            ++this.numTabs;
                        }
                        if (this.segment.array[this.segment.offset + this.i] >= ' ') break;
                        ++this.i;
                    }
                }
                if (this.numTabs > 0) {
                    this.prevChar = (char)9;
                }
                this.lastReturn = this.getCaretPosition();
                final KeyEvent event = e;
                try {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                KTextPane.this.insertTabs(event, KTextPane.this.numTabs);
                                int caretPosition = KTextPane.this.getCaretPosition();
                                for (int n = 0; n < KTextPane.this.tabsListeners.size(); ++n) {
                                    KTabsListener l = (KTabsListener)KTextPane.this.tabsListeners.elementAt(n);
                                    if (l == null) continue;
                                    l.tabsAddedAt(KTextPane.this.position, KTextPane.this.numTabs, caretPosition);
                                }
                            }
                            catch (Exception exx) {
                                Cutter.setLog("    Error: KTextPane.processComponentKeyEvent() 1 in KTextPane - " + exx);
                            }
                        }
                    });
                }
                catch (Exception ex) {
                    Cutter.setLog("    Error: KTextPane.processComponentKeyEvent() 2 in KTextPane - cannot insert tabs");
                }
                return;
            }
            if (e.getID() == 401) {
                if (e.getKeyChar() == '\uffff') {
                    this.charAdded = '\u0000';
                    super.processComponentKeyEvent(e);
                    this.position = this.getCaretPosition();
                    if (this.position > 0) {
                        document.getText(this.position - 1, 1, this.segment);
                        this.prevChar = this.segment.array[this.segment.offset];
                    }
                    if (document.getLength() > 0) {
                        document.getText(this.position, 1, this.segment);
                        this.nextChar = this.segment.array[this.segment.offset];
                    }
                } else {
                    this.charAdded = e.getKeyChar();
                    this.position = this.getCaretPosition();
                    if (this.position > 0 && document.getLength() > 0) {
                        document.getText(this.position - 1, 1, this.segment);
                        this.prevChar = this.segment.array[this.segment.offset];
                    }
                    if (document.getLength() > 0) {
                        document.getText(this.position, 1, this.segment);
                        this.nextChar = this.segment.array[this.segment.offset];
                    }
                    super.processComponentKeyEvent(e);
                }
            }
        }
        catch (BadLocationException ex) {
            Cutter.setLog("    Error: KTextPane.processComponentKeyEvent() - bad location = " + ex);
            return;
        }
    }

    public String getSelection() {
        int selBegin = this.getSelectionStart();
        int selEnd = this.getSelectionEnd();
        int len = selEnd - selBegin;
        try {
            return this.getDocument().getText(selBegin, len);
        }
        catch (BadLocationException ex) {
            Cutter.setLog("    Exception:KTextPane.getSelection()\n       " + ex.toString());
            return null;
        }
    }

    public int getSelectionLength() {
        int selEnd;
        int selBegin = this.getSelectionStart();
        return selBegin == (selEnd = this.getSelectionEnd()) ? 0 : selEnd - selBegin;
    }

    @Override
    public void replaceSelection(String s) {
        this.wordHiliter.hiliterDeActivate();
        super.replaceSelection(s);
        this.wordHiliter.hiliterActivate();
    }

    public synchronized String getCharAt(int offset) {
        try {
            return this.getDocument().getText(offset, 1);
        }
        catch (BadLocationException ble) {
            return null;
        }
    }

    private synchronized void insertTabs(KeyEvent e, int num) {
        super.processComponentKeyEvent(e);
        try {
            this.rowBuf.setLength(0);
            for (int n = 0; n < this.numTabs; ++n) {
                this.rowBuf.append("\t");
            }
            this.getDocument().insertString(this.getCaretPosition(), this.rowBuf.toString(), null);
        }
        catch (BadLocationException ex) {
            Cutter.setLog("    Error: KTextPane.insertTabs() - " + ex.getMessage());
        }
    }

    public void prependText(String str) {
        try {
            this.getDocument().insertString(0, str, null);
        }
        catch (BadLocationException ex) {
            Cutter.setLog("    Error: KAbstractTextPane.prependText() - " + ex.getMessage());
        }
    }

    public void appendText(String str) {
        try {
            this.getDocument().insertString(this.getCaretPosition(), str, null);
        }
        catch (BadLocationException ex) {
            Cutter.setLog("    Error: KAbstractTextPane.appendText() - " + ex.getMessage());
        }
    }

    @Override
    public void setFont(Font f) {
        String fname = this.defaultFontName;
        int fstyle = f.getStyle();
        int fsize = f.getSize();
        Font font = new Font(fname, fstyle, fsize);
        if (this.styleContext == null) {
            super.setFont(font);
        } else {
            this.styleContext.setFont(font);
        }
    }

    public void setFontSize(int s) {
        if (this.styleContext != null) {
            this.styleContext.setFontSize(s);
            Font font = this.styleContext.getFont();
            this.setFont(font);
        }
    }

    public void setTabSize(int s) {
        if (this.styleContext != null) {
            this.styleContext.setTabSize(s);
            Font font = this.styleContext.getFont();
            this.setFont(font);
        }
    }

    public int getTabSize() {
        KAbstractTextWindow atw = this.getFrame();
        if (atw == null) {
            String txt = Preferences.get(Preferences.TEXT_TAB_SIZE);
            if (txt == null || txt.equals("")) {
                return 4;
            }
            return Integer.parseInt(txt);
        }
        return 4;
    }

    @Override
    public Font getFont() {
        if (this.styleContext == null) {
            return KStyleContext.defaultFont;
        }
        return this.styleContext.getFont();
    }

    public Dimension _getPreferredSize() {
        try {
            return super.getPreferredSize();
        }
        catch (Exception ex) {
            Dimension d;
            if (Cutter.input.debug) {
                // empty if block
            }
            try {
                d = this.getMinimumSize();
            }
            catch (Exception e) {
                if (Cutter.input.debug) {
                    // empty if block
                }
                d = new Dimension(this.getWidth(), this.getHeight());
            }
            return d;
        }
    }

    public Position[][] getLines() {
        return this.getLines(this.getSelectionStart(), this.getSelectionEnd());
    }

    public Position[][] getLines(int begin, int end) {
        int n;
        Vector<Position[]> listOfPositions = new Vector<Position[]>();
        Vector<Position[]> tempList = new Vector<Position[]>();
        Document document = this.getDocument();
        if (end - begin < 0) {
            Cutter.setLog("Error: KTextPane.getLines() has been given a negative text length");
            return null;
        }
        Segment segment = DocumentUtils.getSegment(document, begin, end - begin);
        if (segment == null) {
            return null;
        }
        boolean firstLine = false;
        for (n = 0; n < segment.count; ++n) {
            Position[] data;
            int[] offset;
            if (segment.array[segment.offset + n] != '\n' && n != segment.count - 1 || (offset = DocumentUtils.getElementOffsets(document, begin + n)) == null) continue;
            offset[2] = offset[2] - 1;
            Segment lineSegment = DocumentUtils.getSegment(document, offset[1], offset[2] - offset[1]);
            if (!firstLine) {
                if (lineSegment.count <= 1) continue;
                firstLine = true;
                try {
                    data = new Position[]{document.createPosition(offset[1]), document.createPosition(offset[2])};
                    listOfPositions.addElement(data);
                    continue;
                }
                catch (BadLocationException ex) {
                    Cutter.setLog("KText.getLines() error 1");
                    return null;
                }
            }
            if (lineSegment.count == 0) {
                try {
                    data = new Position[]{document.createPosition(offset[1]), document.createPosition(offset[2])};
                    tempList.addElement(data);
                    continue;
                }
                catch (BadLocationException ex) {
                    Cutter.setLog("KText.getLines() error 2");
                    return null;
                }
            }
            if (tempList.size() > 0) {
                for (int i = 0; i < tempList.size(); ++i) {
                    listOfPositions.addElement((Position[])tempList.elementAt(i));
                }
                tempList.clear();
            }
            try {
                data = new Position[]{document.createPosition(offset[1]), document.createPosition(offset[2])};
                listOfPositions.addElement(data);
                continue;
            }
            catch (BadLocationException ex) {
                Cutter.setLog("KText.getLines() error 2");
                return null;
            }
        }
        Position[][] out = new Position[listOfPositions.size()][2];
        for (n = 0; n < listOfPositions.size(); ++n) {
            Position[] data = (Position[])listOfPositions.elementAt(n);
            out[n][0] = data[0];
            out[n][1] = data[1];
        }
        return out;
    }

    public boolean replaceSpacesWithTabs() {
        if (this.replaceSpacesWithTabsOffered) {
            return this.doReplaceSpacesWithTabs;
        }
        int ds = BBxt.getDefaultTabSize();
        int response = JOptionPane.showConfirmDialog(Cutter.desktop, "Replace sequences of " + ds + " spaces with tabs?\nThis dialog will only be shown once for\nfor the current document.", "Replace " + ds + " Spaces with Tabs", 0);
        this.replaceSpacesWithTabsOffered = true;
        switch (response) {
            case 0: {
                this.doReplaceSpacesWithTabs = true;
                return true;
            }
            case 1: {
                return false;
            }
            case 2: {
                return false;
            }
            case -1: {
                return false;
            }
        }
        return false;
    }

    public void addComments() {
        this.syntaxListener.addComments();
    }

    public void removeComments() {
        this.syntaxListener.removeComments(false);
    }

    private boolean addDynamicEdit(Vector<DynamicEdit> v, int begin, int end) {
        try {
            v.addElement(new DynamicEdit(this.getFrame(), begin, end));
        }
        catch (BadLocationException e) {
            Cutter.setLog("    Error: KTextPane.addDynamicEdit() " + e);
            return false;
        }
        return true;
    }

    public String getCopyNoComments() {
        Position endMarker;
        Object copy = null;
        PlainDocument doc = new PlainDocument();
        SyntaxListener syntaxListener = this.getSyntaxListener();
        Comment[] cmnt = this.getComments();
        if (cmnt == null) {
            Cutter.setLog("    Error 1 : KTextPane.getCopyNoComments() - cannot find comments");
            return null;
        }
        try {
            doc.insertString(0, this.getText(), null);
            endMarker = doc.createPosition(doc.getLength());
        }
        catch (BadLocationException e) {
            Cutter.setLog("    Error 2 : KTextPane.getCopyNoComments() " + e);
            return null;
        }
        for (int n = 0; n < cmnt.length; ++n) {
            syntaxListener.removeComments(doc, cmnt[n], true, 0, endMarker.getOffset());
        }
        try {
            return doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            Cutter.setLog("    Error 3 : KTextPane.sendToPeer(String) " + e);
            return null;
        }
    }

    private void _initTextActions() {
        if (tableOfActions != null) {
            return;
        }
        tableOfActions = new Hashtable();
        Action[] actions = this.getEditorKit().getActions();
        for (int n = 0; n < actions.length; ++n) {
            String name = (String)actions[n].getValue("Name");
            tableOfActions.put(name, actions[n]);
        }
    }

    @Override
    public void requestFocus() {
        if (this.wordHiliter != null) {
            this.wordHiliter.initHiliteColor();
        }
        super.requestFocusInWindow();
    }

    public void _preDispose() {
    }

    static {
        try {
            Field[] fields = new Field[]{KTextPane.class.getDeclaredField("_helpTrigger"), KTextPane.class.getDeclaredField("_setCharacterAttributes"), KTextPane.class.getDeclaredField("_spanDetails"), KTextPane.class.getDeclaredField("_processComponentKeyEvent"), KTextPane.class.getDeclaredField("_finalize")};
            Cutter.addDebug(KTextPane.class, fields);
        }
        catch (NoSuchFieldException ex) {
            Cutter.setLog("Error: KTextPane.static - " + ex.toString());
        }
    }

    public class BackwardAction
    extends TextAction {
        private Action defaultAction;
        private static final String NAME = "caret-backward";

        public BackwardAction(JComponent component) {
            super(NAME);
            ActionMap actionMap = component.getActionMap();
            this.defaultAction = actionMap.get(NAME);
            actionMap.put(NAME, this);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int offset = KTextPane.this.getSelectionStart() == 0 ? KTextPane.this.getSelectionStart() : KTextPane.this.getSelectionStart() - 1;
            KTextPane.this.setSelectionStart(offset);
            KTextPane.this.setSelectionEnd(offset);
        }
    }

    public class ForwardAction
    extends TextAction {
        private Action defaultAction;
        private static final String NAME = "caret-forward";

        public ForwardAction(JComponent component) {
            super(NAME);
            ActionMap actionMap = component.getActionMap();
            this.defaultAction = actionMap.get(NAME);
            actionMap.put(NAME, this);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int offset = KTextPane.this.getSelectionEnd() == KTextPane.this.getDocument().getLength() ? KTextPane.this.getSelectionEnd() : KTextPane.this.getSelectionEnd() + 1;
            KTextPane.this.setSelectionStart(offset);
            KTextPane.this.setSelectionEnd(offset);
        }
    }
}

