/*
 * Decompiled with CFR 0.152.
 */
package UI_Text.KTextPane;

import UI_Desktop.Cutter;
import UI_Text.KTextPane.KDocument;
import UI_Text.KTextPane.KTextPane;
import java.awt.event.ActionEvent;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class KTextUndoManager
extends UndoManager
implements UndoableEditListener {
    private final int KEdit_INSERT = 1;
    private final int KEdit_REMOVE = -1;
    private final int KEdit_STYLE = 0;
    private final int KEdit_UNKNOWN = 0;
    private UndoManager undoManager;
    private KCompoundEdit compoundEdit;
    private KTextPane textpane;
    private UndoAction undoAction;
    private RedoAction redoAction;
    private StackOps stack = new StackOps();
    private int lastOffset;
    private int lastLength;
    private KDocument document;

    public KTextUndoManager(KTextPane textpane) {
        this.textpane = textpane;
        this.undoAction = new UndoAction();
        this.redoAction = new RedoAction();
    }

    public void setDocument(KDocument doc) {
        this.document = doc;
        this.undoManager = this;
    }

    @Override
    public boolean canUndo() {
        return this.stack.canUndo();
    }

    @Override
    public boolean canRedo() {
        return this.stack.canRedo();
    }

    @Override
    public KCompoundEdit editToBeUndone() {
        return this.stack.editToBeUndone();
    }

    @Override
    public KCompoundEdit editToBeRedone() {
        return this.stack.editToBeRedone();
    }

    @Override
    public void undo() {
        if (this.textpane.helper != null && this.textpane.helper.completer != null) {
            this.textpane.helper.completer.completionDeActivate();
            this.textpane.helper.completer.hidePopup();
        }
        KCompoundEdit edit = this.editToBeUndone();
        edit.applyAsUndo();
        if (this.textpane.helper != null && this.textpane.helper.completer != null) {
            this.textpane.helper.completer.completionActivate();
        }
    }

    @Override
    public void redo() {
        KCompoundEdit edit = this.editToBeRedone();
        if (this.textpane.helper != null && this.textpane.helper.completer != null) {
            this.textpane.helper.completer.completionDeActivate();
        }
        edit.applyAsRedo();
        if (this.textpane.helper != null && this.textpane.helper.completer != null) {
            this.textpane.helper.completer.completionActivate();
        }
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        int editType = 0;
        AbstractDocument.DefaultDocumentEvent event = null;
        try {
            event = (AbstractDocument.DefaultDocumentEvent)e.getEdit();
        }
        catch (Exception ex) {
            Cutter.setLog("   Exception:KTextUndoManager.undoableEditHappened - " + ex.toString());
            return;
        }
        if (event.getType().equals(DocumentEvent.EventType.INSERT)) {
            editType = 1;
        }
        if (event.getType().equals(DocumentEvent.EventType.REMOVE)) {
            editType = -1;
        }
        if (event.getType().equals(DocumentEvent.EventType.CHANGE)) {
            return;
        }
        int offsetChange = this.textpane.getCaretPosition() - this.lastOffset;
        int lengthChange = this.textpane.getDocument().getLength() - this.lastLength;
        int eventOffset = this.textpane.getCaretPosition();
        if (event.getType().equals(DocumentEvent.EventType.CHANGE)) {
            return;
        }
        if (this.compoundEdit == null) {
            this.compoundEdit = this.startCompoundEdit(e.getEdit(), editType);
            return;
        }
        if (editType == 1 && (this.document.stringInserted.equals("\n") || this.document.stringInserted.equals("\t") || this.document.stringInserted.equals(" "))) {
            this.compoundEdit.end();
            this.compoundEdit = this.startCompoundEdit(e.getEdit(), editType);
            return;
        }
        if (offsetChange == lengthChange && Math.abs(offsetChange) == 1) {
            if (editType != this.compoundEdit.type) {
                this.compoundEdit.end();
                this.compoundEdit = this.startCompoundEdit(e.getEdit(), editType);
                return;
            }
            this.compoundEdit._addEdit(e.getEdit(), editType);
            this.lastOffset = this.textpane.getCaretPosition();
            this.lastLength = this.textpane.getDocument().getLength();
            return;
        }
        this.compoundEdit.end();
        this.compoundEdit = this.startCompoundEdit(e.getEdit(), editType);
    }

    private KCompoundEdit startCompoundEdit(UndoableEdit anEdit, int editType) {
        this.lastOffset = this.textpane.getCaretPosition();
        this.lastLength = this.textpane.getDocument().getLength();
        this.compoundEdit = new KCompoundEdit(editType);
        this.compoundEdit._addEdit(anEdit, editType);
        this.addEdit(this.compoundEdit);
        this.undoAction.updateUndoState();
        this.redoAction.updateRedoState();
        return this.compoundEdit;
    }

    public Action getUndoAction() {
        return this.undoAction;
    }

    public Action getRedoAction() {
        return this.redoAction;
    }

    public void insertUpdate(DocumentEvent e) {
        int offset = e.getOffset() + e.getLength();
        offset = Math.min(offset, this.textpane.getDocument().getLength());
        this.textpane.setCaretPosition(offset);
    }

    public void removeUpdate(DocumentEvent e) {
        this.textpane.setCaretPosition(e.getOffset());
    }

    public void changedUpdate(DocumentEvent e) {
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                KTextUndoManager.this.undoManager.redo();
                KTextUndoManager.this.textpane.requestFocusInWindow();
            }
            catch (CannotRedoException cannotRedoException) {
                // empty catch block
            }
            KTextUndoManager.this.redoAction.updateRedoState();
            KTextUndoManager.this.undoAction.updateUndoState();
        }

        protected void updateRedoState() {
            this.setEnabled(KTextUndoManager.this.undoManager.canRedo());
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                KTextUndoManager.this.undoManager.undo();
                KTextUndoManager.this.textpane.requestFocusInWindow();
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
            KTextUndoManager.this.undoAction.updateUndoState();
            KTextUndoManager.this.redoAction.updateRedoState();
        }

        private void updateUndoState() {
            this.setEnabled(KTextUndoManager.this.undoManager.canUndo());
        }
    }

    class KCompoundEdit
    extends CompoundEdit {
        public int startOffset = -1;
        public int type = 0;
        public StringBuffer buf = new StringBuffer();
        public boolean isDead = false;

        public KCompoundEdit(int typeOfEdit) {
            this.startOffset = ((KTextUndoManager)KTextUndoManager.this).document.stringInsertedAt;
            this.type = typeOfEdit;
            KTextUndoManager.this.stack.addToUndo(this);
        }

        public boolean _addEdit(UndoableEdit edit, int typeOfEdit) {
            if (this.type != typeOfEdit) {
                Cutter.setLog("KCompoundEdit._addEdit() - different typeOfEdit.");
                Cutter.setLog("was " + this.type + " _addEdit() is " + typeOfEdit);
            }
            if (this.type == 1) {
                this.buf.append(((KTextUndoManager)KTextUndoManager.this).document.stringInserted);
            }
            if (this.type == -1) {
                this.buf.insert(0, ((KTextUndoManager)KTextUndoManager.this).document.stringRemoved);
                this.startOffset = ((KTextUndoManager)KTextUndoManager.this).document.stringRemovedAt;
            }
            return super.addEdit(edit);
        }

        public void applyAsRedo() {
            KTextUndoManager.this.document.undoManagerSuspendListening();
            try {
                if (this.type == 1) {
                    String text = this.buf.length() == 0 ? "woops" : this.buf.toString();
                    KTextUndoManager.this.document.insertString(this.startOffset, text, null);
                    KTextUndoManager.this.textpane.setCaretPosition(this.startOffset + this.buf.length());
                }
                if (this.type == -1) {
                    KTextUndoManager.this.document.remove(this.startOffset, this.buf.length());
                }
            }
            catch (BadLocationException ex) {
                Cutter.setLog("    Exception:KTextUndoManager.applyAsRedo() - " + ex.toString());
            }
            KTextUndoManager.this.document.undoManagerResumeListening();
        }

        public void applyAsUndo() {
            KTextUndoManager.this.document.undoManagerSuspendListening();
            try {
                if (this.type == -1) {
                    String text = this.buf.length() == 0 ? "woops" : this.buf.toString();
                    KTextUndoManager.this.document.insertString(this.startOffset, text, null);
                    KTextUndoManager.this.textpane.setCaretPosition(this.startOffset + this.buf.length());
                }
                if (this.type == 1) {
                    KTextUndoManager.this.document.remove(this.startOffset, this.buf.length());
                }
            }
            catch (BadLocationException ex) {
                Cutter.setLog("    Exception:KTextUndoManager.applyAsUndo() - " + ex.toString());
            }
            KTextUndoManager.this.document.undoManagerResumeListening();
        }

        @Override
        public String toString() {
            return "start: " + this.startOffset + " type: " + this.type + " isDead: " + this.isDead + " bufLen: " + this.buf.length();
        }

        @Override
        public void die() {
            this.isDead = true;
            super.die();
        }

        @Override
        public boolean isInProgress() {
            return false;
        }

        @Override
        public void undo() throws CannotUndoException {
            if (KTextUndoManager.this.compoundEdit != null) {
                KTextUndoManager.this.compoundEdit.end();
            }
            super.undo();
            KTextUndoManager.this.compoundEdit = null;
        }
    }

    private class StackOps {
        private Stack<KCompoundEdit> undoStack = new Stack();
        private Stack<KCompoundEdit> redoStack = new Stack();

        private StackOps() {
        }

        public void addToUndo(KCompoundEdit edit) {
            this.undoStack.add(edit);
        }

        public void addToRedo(KCompoundEdit edit) {
            this.redoStack.add(edit);
        }

        public KCompoundEdit editToBeUndone() {
            KCompoundEdit edit = this.undoStack.pop();
            this.addToRedo(edit);
            return edit;
        }

        public KCompoundEdit editToBeRedone() {
            KCompoundEdit edit = this.redoStack.pop();
            this.addToUndo(edit);
            return edit;
        }

        public boolean canUndo() {
            return !this.undoStack.empty();
        }

        public boolean canRedo() {
            return !this.redoStack.empty();
        }
    }
}

