/*
 * Decompiled with CFR 0.152.
 */
package UI_Text.KTextPane;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Text.KTextPane.KDocument;
import UI_Text.KTextPane.KTextPane;
import Utilities.DocumentUtils;
import Utilities.RibUtils;
import Utilities.TextUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import kernal.Tokenizers.Tokenizer;

public class KWordHiliter
extends StyleContext
implements MouseListener,
CaretListener,
DocumentListener {
    private Vector<ProxySelection> listOfProxies = new Vector();
    private Style proxyHiliteStyle = null;
    private KTextPane textpane = null;
    private KDocument doc = null;
    private Tokenizer tok;
    private boolean isTCL = false;
    private boolean isRIB = false;
    private Style paperStyle;
    private Style defaultStyle;
    private String primarySelection = "";
    private int primarySelectionOffset = -1;
    private static String PROXY_HILITE_STYLE_NAME = "ProxyHilite";
    private boolean isActive = true;

    public KWordHiliter(KTextPane tp, KDocument kdoc, Style plain) {
        this.textpane = tp;
        this.doc = kdoc;
        this.defaultStyle = this.doc.getStyle("default");
        this.proxyHiliteStyle = this.doc.addStyle(PROXY_HILITE_STYLE_NAME, this.defaultStyle);
        StyleConstants.setUnderline(this.proxyHiliteStyle, false);
        this.initHiliteColor();
        Color paperColor = Preferences.getColor(Preferences.DOCUMENT_BACKGROUND_COLOR);
        this.paperStyle = this.doc.addStyle("PaperStyle", this.defaultStyle);
        StyleConstants.setBackground(this.paperStyle, paperColor);
    }

    public void initTokenizer(Tokenizer t) {
        String clsname = t.getClass().getName();
        this.tok = Tokenizer.getInstanceByClassName(clsname);
        if (clsname.startsWith("UI_Script.PixarDev.") || clsname.startsWith("UI_Script.C.")) {
            this.tok.appendDelimitor("#");
        } else if (clsname.startsWith("UI_Script.Html.") || clsname.startsWith("UI_Script.Args.") || clsname.equals("kernal.Tokenizers.Tokenizer")) {
            this.tok = Tokenizer.getInstanceByClassName("UI_Script.C.CTokenizer");
            this.tok.appendDelimitor("#");
        } else if (clsname.startsWith("UI_Script.Tcl.")) {
            this.isTCL = true;
        } else if (clsname.startsWith("UI_Script.Rib.")) {
            this.isRIB = true;
        }
        this.tok.appendDelimitor("\" \t\r\n'");
        this.tok.appendDelimitor(".");
        this.tok.grabCSystemHeader = false;
        this.tok.grabComments = false;
    }

    public void initHiliteColor() {
        Color proxyHiliteColor = Preferences.getColor(Preferences.DOCUMENT_SECONDARY_SELECTIONS_COLOR);
        StyleConstants.setBackground(this.proxyHiliteStyle, proxyHiliteColor);
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
    }

    @Override
    public void removeUpdate(DocumentEvent evt) {
        if (evt.getOffset() == this.primarySelectionOffset) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    KWordHiliter.this.ClearHilites();
                }
            });
        }
    }

    @Override
    public void insertUpdate(DocumentEvent evt) {
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        String selection;
        String string = selection = BBxt.getSelection() == null ? "" : BBxt.getSelection();
        if (e.getDot() == e.getMark()) {
            return;
        }
        String[] parts = this.getSelection();
        if (parts == null) {
            this.ClearHilites();
            return;
        }
        if (this.primarySelection.equals(parts[0])) {
            return;
        }
        this.Hilite(parts[0]);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getClickCount() == 1) {
            if (this.textpane.getKCaret().isSecondClick) {
                if (this.primarySelection.length() > 0 && this.primarySelection.equals(BBxt.getSelection())) {
                    this.ClearHilites();
                    return;
                }
                return;
            }
            this.ClearHilites();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        String[] parts;
        int dot = BBxt.getSelectionEnd();
        int mark = BBxt.getSelectionStart();
        if (dot == 0 && mark == 0) {
            return;
        }
        if (e.getClickCount() == 2 && (parts = this.getSelection()) != null) {
            this.Hilite(parts[0]);
        }
    }

    private String[] getSelection() {
        int mark;
        int dot = BBxt.getSelectionEnd();
        if (dot == (mark = BBxt.getSelectionStart())) {
            return null;
        }
        int begin = dot < mark ? dot : mark;
        int end = mark > dot ? mark : dot;
        String preStr = this.textpane.getCharAt(begin - 1);
        if (preStr != null && preStr.length() > 0 && preStr.charAt(0) == '$') {
            --begin;
        }
        Segment seg = new Segment();
        try {
            this.doc.getText(begin, end - begin, seg);
        }
        catch (Exception ex) {
            return null;
        }
        String next = this.textpane.getCharAt(end);
        if (next == null) {
            return null;
        }
        String delims = this.tok.getDelimitors();
        if (TextUtils.contains(seg.toString(), delims) != null) {
            return null;
        }
        char nextChar = next.charAt(0);
        String[] out = new String[]{seg.toString(), next};
        if (TextUtils.contains(delims, nextChar)) {
            return out;
        }
        return null;
    }

    public void hiliterActivate() {
        this.isActive = true;
    }

    public boolean hiliterIsActive() {
        return this.isActive;
    }

    public void hiliterDeActivate() {
        this.ClearHilites();
        this.isActive = false;
    }

    private void ClearHilites() {
        if (!this.isActive) {
            return;
        }
        for (int n = 0; n < this.listOfProxies.size(); ++n) {
            this.listOfProxies.elementAt(n).removeHilite();
        }
        this.primarySelection = "";
        this.primarySelectionOffset = -1;
    }

    private void Hilite(String sel) {
        int begin;
        if (!this.isActive) {
            return;
        }
        if (this.primarySelection.equals(sel)) {
            return;
        }
        if (sel.length() < 3) {
            return;
        }
        int dot = BBxt.getSelectionEnd();
        int mark = BBxt.getSelectionStart();
        Font f = this.textpane.getFont();
        StyleConstants.setFontSize(this.proxyHiliteStyle, f.getSize());
        Vector<ProxySelection> toBeRemoved = new Vector<ProxySelection>();
        for (int n = 0; n < this.listOfProxies.size(); ++n) {
            if (this.listOfProxies.elementAt((int)n).active) continue;
            toBeRemoved.addElement(this.listOfProxies.elementAt(n));
        }
        this.listOfProxies.removeAll(toBeRemoved);
        this.primarySelection = sel;
        this.primarySelectionOffset = begin = dot < mark ? dot : mark;
        this.scanDocument(this.primarySelection, begin);
        if (this.isTCL) {
            if (sel.startsWith("$")) {
                this.scanDocument(this.primarySelection.substring(1), begin + 1);
            } else if (!sel.startsWith("$")) {
                this.scanDocument("$" + this.primarySelection, begin - 1);
            }
        } else if (this.isRIB) {
            int len = this.primarySelection.length();
            if (RibUtils.isBegin(this.primarySelection)) {
                this.scanDocument(this.primarySelection.substring(0, len - 5) + "End", begin);
            }
            if (RibUtils.isEnd(this.primarySelection)) {
                this.scanDocument(this.primarySelection.substring(0, len - 3) + "Begin", begin);
            }
        }
    }

    private boolean scanDocument(String target, int primarySelBegin) {
        Segment segment = DocumentUtils.getSegment((Document)this.doc, 0, this.doc.getLength());
        if (segment == null) {
            return false;
        }
        this.tok.setBuffer(segment);
        this.tok.setBufferIndex(0);
        int targetLen = target.length();
        String s = this.tok.getNextStr();
        while (!s.equals("")) {
            int end;
            int begin;
            if (!this.tok.isComment(s) && s.equals(target) && (begin = (end = this.tok.getBufferIndex()) - targetLen) != primarySelBegin) {
                this.listOfProxies.addElement(new ProxySelection(begin, end));
            }
            s = this.tok.getNextStr();
        }
        return false;
    }

    private boolean contains(Segment segment, char c) {
        for (int n = 0; n < segment.count; ++n) {
            if (segment.array[n + segment.offset] != c) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    private class ProxySelection {
        boolean active = true;
        private Position selBegin;
        private Position selEnd;
        public Vector<CharData> data = new Vector();

        public ProxySelection(int b, int e) {
            try {
                this.selBegin = KWordHiliter.this.doc.createPosition(b);
                this.selEnd = KWordHiliter.this.doc.createPosition(e);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (this.data.size() == 0) {
                for (int offset = b; offset < e; ++offset) {
                    this.data.addElement(new CharData(offset));
                }
            }
            this.addHilite();
        }

        private void addHilite() {
            if (!KWordHiliter.this.textpane.syntaxColorationIsActive()) {
                return;
            }
            int b = this.selBegin.getOffset();
            int e = this.selEnd.getOffset();
            String styleName = KWordHiliter.this.textpane.getStyleNameAtOffset(b);
            if (styleName.equals(PROXY_HILITE_STYLE_NAME)) {
                return;
            }
            this.active = true;
            KWordHiliter.this.doc.setCharacterAttributes(b, e - b, KWordHiliter.this.proxyHiliteStyle, false);
        }

        public void removeHilite() {
            if (!KWordHiliter.this.textpane.syntaxColorationIsActive()) {
                return;
            }
            if (!this.active) {
                return;
            }
            for (int n = 0; n < this.data.size(); ++n) {
                CharData cd = this.data.elementAt(n);
                Style style = KWordHiliter.this.doc.getStyle(cd.styleName);
                KWordHiliter.this.doc.setCharacterAttributes(cd.getOffset(), 1, style, true);
                String string = KWordHiliter.this.textpane.getStyleNameAtOffset(cd.getOffset());
            }
            this.active = false;
        }
    }

    private class CharData {
        public String styleName = null;
        private Position styleOffset;

        public CharData(int begin) {
            this.styleName = KWordHiliter.this.textpane.getStyleNameAtOffset(begin);
            try {
                this.styleOffset = KWordHiliter.this.doc.createPosition(begin);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public int getOffset() {
            return this.styleOffset.getOffset();
        }
    }
}

