/*
 * Decompiled with CFR 0.152.
 */
package UI_Text.KTextPane;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;

public class OutlineCaret
extends DefaultCaret {
    private OutlinePainter painter = new OutlinePainter(null);
    private boolean useOutline = false;
    private int lastDot = 0;
    private boolean hasReceivedSecondClick = false;
    private int prevSelectionBegin = 0;
    private int prevSelectionEnd = 0;
    private boolean selectionRestored = false;
    private boolean isFocused = false;
    private boolean drawnOutline = false;
    private boolean drawnSolid = false;

    @Override
    protected Highlighter.HighlightPainter getSelectionPainter() {
        return this.painter;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (!this.hasReceivedSecondClick && this.prevSelectionBegin != this.prevSelectionEnd) {
            this.setDot(this.prevSelectionEnd);
            this.moveDot(this.prevSelectionBegin);
        } else if (this.hasReceivedSecondClick && this.drawnSolid) {
            if (this.prevSelectionBegin == this.prevSelectionEnd) {
                super.paint(g);
            } else {
                this.prevSelectionBegin = this.prevSelectionEnd = this.getDot();
                this.setDot(this.getDot());
                super.paint(g);
            }
            return;
        }
        if (!this.isFocused && !this.drawnOutline) {
            super.paint(g);
            this.drawnOutline = true;
            return;
        }
        if (!this.isFocused && this.drawnOutline) {
            return;
        }
        if (this.isFocused && !this.drawnSolid && this.prevSelectionBegin != this.prevSelectionEnd) {
            super.paint(g);
            this.drawnSolid = true;
            return;
        }
        if (this.isFocused && this.drawnSolid) {
            return;
        }
        super.paint(g);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        if (!e.isShiftDown()) {
            this.lastDot = this.getDot();
        }
        this.setVisible(true);
        if (e.getID() == 506) {
            this.hasReceivedSecondClick = false;
            this.drawnSolid = false;
            return;
        }
        if (!this.hasReceivedSecondClick && e.getClickCount() != 2) {
            this.hasReceivedSecondClick = true;
            if (e.getID() != 506) {
                this.setDot(this.lastDot);
            }
        } else if (e.getClickCount() == 2) {
            this.hasReceivedSecondClick = false;
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        super.focusLost(e);
        this.useOutline = true;
        this.hasReceivedSecondClick = false;
        this.prevSelectionBegin = this.getDot();
        this.prevSelectionEnd = this.getMark();
        this.isFocused = false;
        this.drawnOutline = false;
        this.drawnSolid = false;
        this.setVisible(false);
    }

    @Override
    public void focusGained(FocusEvent e) {
        super.focusGained(e);
        this.useOutline = false;
        this.isFocused = true;
    }

    public class OutlinePainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        private Color color;

        public OutlinePainter(Color color) {
            super(color);
            this.color = color;
        }

        @Override
        public Shape paintLayer(Graphics g, int p0, int p1, Shape shape, JTextComponent comp, View view) {
            OutlineCaret.this.setVisible(true);
            Rectangle b = shape.getBounds();
            try {
                g.setColor(new Color(1.0f, 1.0f, 0.0f));
                Rectangle r1 = comp.modelToView(p0);
                Rectangle r2 = comp.modelToView(p1);
                if (OutlineCaret.this.useOutline) {
                    g.drawRect(r1.x, r1.y, r2.x - r1.x - 1, r1.height - 1);
                } else {
                    g.fillRect(r1.x, r1.y, r2.x - r1.x - 1, r1.height - 1);
                }
            }
            catch (BadLocationException e) {
                System.out.println("Error in OutlinePainter = " + e);
            }
            return b;
        }

        private Color getColor(JTextComponent comp) {
            return this.color != null ? this.color : comp.getSelectionColor();
        }
    }
}

