/*
 * Decompiled with CFR 0.152.
 */
package UI_Text.Style;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Text.KTextPane.KTextPane;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.UIManager;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;

public class KStyleContext
extends StyleContext {
    private static final String defaultFontName = Cutter.defaultTextPaneFontName;
    public static final boolean defaultFontStyle = false;
    public static final int defaultFontSize = 12;
    public static int defaultTabSize = 4;
    public static final int defaultLeftIndent = 10;
    private static final int TABCOUNT = 20000;
    public static Font defaultFont;
    public static final String KSTYLE = "KSTYLE";
    public static final String RIBSTYLE = "RIBSTYLE";
    public static final String SLSTYLE = "SLSTYLE";
    public static String name;
    public static final int UNDEFINED_ID = -1;
    public static final String PLAIN = "plain";
    public static final int PLAIN_ID = 0;
    public static final String COMMENT1 = "c1mnt";
    public static final int COMMENT1_ID = 1;
    public static final String COMMENT2 = "c2mnt";
    public static final int COMMENT2_ID = 2;
    public static final String COMMENT3 = "c3mnt";
    public static final int COMMENT3_ID = 3;
    public static final String KEYWORD1 = "1key";
    public static final int KEYWORD1_ID = 4;
    public static final String KEYWORD2 = "2key";
    public static final int KEYWORD2_ID = 5;
    public static final String KEYWORD3 = "3key";
    public static final int KEYWORD3_ID = 6;
    public static final String KEYWORD4 = "4key";
    public static final int KEYWORD4_ID = 7;
    public static final String KEYWORD5 = "5key";
    public static final int KEYWORD5_ID = 8;
    public static final String KEYWORD6 = "6key";
    public static final int KEYWORD6_ID = 9;
    public static final String STRING1 = "5str";
    public static final int STRING1_ID = 10;
    public static final String STRING2 = "6str";
    public static final int STRING2_ID = 11;
    public static final String STRING3 = "7str";
    public static final int STRING3_ID = 12;
    public static final String LANGUAGE = "lang";
    public static final int LANGUAGE_ID = 13;
    public static final String BOLD = "bold";
    public static final int BOLD_ID = 14;
    public static final int PARTIAL_COMMENT_ID = 15;
    public static final int ESCAPE_ID = 16;
    public static final int TAG_ID = 17;
    private static String[] lookup;
    protected int tabsize = BBxt.getDefaultTabSize();
    protected int leftIndent = 10;
    public Style defaultTextStyle;
    public Style plainStyle;
    public Style commentStyle1;
    public Style commentStyle2;
    public Style commentStyle3;
    public Style keywordStyle1;
    public Style keywordStyle2;
    public Style keywordStyle3;
    public Style keywordStyle4;
    public Style keywordStyle5;
    public Style keywordStyle6;
    public Style stringStyle1;
    public Style stringStyle2;
    public Style stringStyle3;
    public Style boldStyle;
    public Style languageStyle;

    public static String lookup(int id) {
        return id >= lookup.length || id < 0 ? "UNDEFINED" : lookup[id];
    }

    public static void setDefaultStyles(KTextPane textpane) {
    }

    public KStyleContext() {
        Style defaultStyle = this.getStyle("default");
        this.defaultTextStyle = this.addStyle("DefaultText", defaultStyle);
        int size = 12;
        try {
            String str = Preferences.get(Preferences.TEXT_FONT_SIZE);
            if (str != null && str.trim().length() > 0) {
                size = Integer.parseInt(str);
            }
        }
        catch (NumberFormatException e) {
            Cutter.setLog("    Error: KStyleContext.KStyleContext() - cannot get font size from prefs");
            size = 12;
        }
        this.addFontToStyle(this.defaultTextStyle, defaultFontName, false, size);
        StyleConstants.setUnderline(this.defaultTextStyle, false);
        this.plainStyle = this.addStyle(PLAIN, this.defaultTextStyle);
        this.commentStyle1 = this.addStyle(COMMENT1, this.defaultTextStyle);
        this.commentStyle2 = this.addStyle(COMMENT2, this.defaultTextStyle);
        this.commentStyle3 = this.addStyle(COMMENT3, this.defaultTextStyle);
        this.keywordStyle1 = this.addStyle(KEYWORD1, this.defaultTextStyle);
        this.keywordStyle2 = this.addStyle(KEYWORD2, this.defaultTextStyle);
        this.keywordStyle3 = this.addStyle(KEYWORD3, this.defaultTextStyle);
        this.keywordStyle4 = this.addStyle(KEYWORD4, this.defaultTextStyle);
        this.keywordStyle5 = this.addStyle(KEYWORD5, this.defaultTextStyle);
        this.keywordStyle6 = this.addStyle(KEYWORD6, this.defaultTextStyle);
        this.stringStyle1 = this.addStyle(STRING1, this.defaultTextStyle);
        this.stringStyle2 = this.addStyle(STRING2, this.defaultTextStyle);
        this.stringStyle3 = this.addStyle(STRING3, this.defaultTextStyle);
        this.languageStyle = this.addStyle(LANGUAGE, this.defaultTextStyle);
        this.boldStyle = this.addStyle(BOLD, this.defaultTextStyle);
        StyleConstants.setBold(this.boldStyle, true);
        this.setFont(defaultFont);
    }

    public void addFontToStyle(Style style, String fname, boolean fstyle, int fsize) {
        StyleConstants.setForeground(style, Color.black);
        FontMetrics fm = this.getFontMetrics(new Font(fname, !fstyle ? 0 : 1, fsize));
        StyleConstants.setTabSet(style, new TabSet(this.makeTabs(20000, fm.charWidth('W') * this.tabsize)));
        StyleConstants.setFontFamily(style, fname);
        StyleConstants.setFontSize(style, fsize);
        StyleConstants.setBold(style, fstyle);
        StyleConstants.setLeftIndent(style, this.leftIndent);
    }

    public void setFont(Font f) {
        Font currentFont = this.getFont();
        if (this.areSameFonts(this.getFont(), f)) {
            return;
        }
        StyleConstants.setFontFamily(this.defaultTextStyle, f.getName());
        StyleConstants.setFontSize(this.defaultTextStyle, f.getSize());
        StyleConstants.setBold(this.defaultTextStyle, f.getStyle() != 0);
        FontMetrics fm = this.getFontMetrics(f);
        StyleConstants.setTabSet(this.defaultTextStyle, new TabSet(this.makeTabs(128, fm.charWidth('W') * this.tabsize)));
    }

    private boolean areSameFonts(Font f1, Font f2) {
        return f1.getName().equals(f2.getName()) && f1.getSize() == f2.getSize() && f1.getStyle() == f2.getStyle();
    }

    public void setFontSize(int s) {
        StyleConstants.setFontSize(this.defaultTextStyle, s);
        Font font = this.getFont();
        FontMetrics fm = this.getFontMetrics(font);
        StyleConstants.setTabSet(this.defaultTextStyle, new TabSet(this.makeTabs(128, fm.charWidth('W') * this.tabsize)));
    }

    public void setTabSize(int s) {
        Font font = this.getFont();
        FontMetrics fm = this.getFontMetrics(font);
        StyleConstants.setTabSet(this.defaultTextStyle, new TabSet(this.makeTabs(128, fm.charWidth('W') * s)));
    }

    protected void applyLogicalStyle() {
    }

    public Font getFont() {
        return new Font(StyleConstants.getFontFamily(this.defaultTextStyle), StyleConstants.isBold(this.defaultTextStyle) ? 1 : 0, StyleConstants.getFontSize(this.defaultTextStyle));
    }

    public void updateTabs(int width) {
    }

    protected TabStop[] makeTabs(int num, int width) {
        TabStop[] tabs = new TabStop[num];
        for (int n = 0; n < num; ++n) {
            tabs[n] = new TabStop(n * width, 0, 0);
        }
        return tabs;
    }

    static {
        Font f = (Font)UIManager.get("TextArea.font");
        defaultFont = new Font(defaultFontName, 0, 12);
        String txt = Preferences.get(Preferences.TEXT_TAB_SIZE);
        if (txt.trim().length() > 0) {
            defaultTabSize = 4;
        }
        defaultTabSize = Integer.parseInt(txt);
        name = KSTYLE;
        lookup = new String[]{"PLAIN", "COMMENT1", "COMMENT2", "COMMENT3", "KEYWORD1", "KEYWORD2", "KEYWORD3", "KEYWORD4", "KEYWORD5", "KEYWORD6", "STRING", "STRING2", "STRING3", "LANGUAGE", "BOLD", "PARTIAL_COMMENT", "ESCAPE", "TAG"};
    }
}

