/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.AssetManagement.CatalogScriptsTool;

import UI_Desktop.Cutter;
import UI_Script.ScriptParser.ScriptParser;
import UI_Script.ScriptParser.ScriptStructure;
import UI_Tools.AssetManagement.CatalogScriptsTool.CatalogItem;
import UI_Tools.AssetManagement.HtmlWriter;
import Utilities.BrowserUtils;
import Utilities.DateTimeUtils;
import Utilities.FileUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Vector;
import kernal.Tokenizers.Tokenizer;
import kernal.Tokenizers.TokenizerRegistryItem;

public class ScriptCataloger {
    public static boolean _isOpenComment = false;
    public static boolean _isCloseComment = false;
    static final String defaultDescription = "Comments not available";
    private File targetDir;
    private String[] targets;

    public ScriptCataloger(File targetDir) {
        this.targetDir = targetDir;
    }

    public int source() {
        FileUtils fu = new FileUtils();
        fu.setSearch(10, this.targetDir, null);
        fu.doSearch();
        this.targets = fu.getSearchResults();
        Vector<String> v = new Vector<String>();
        for (int n = 0; n < this.targets.length; ++n) {
            File f = new File(this.targetDir, this.targets[n]);
            if (f.isDirectory()) continue;
            v.addElement(f.getPath());
        }
        this.targets = VectorUtils.toStringArray(v);
        return this.targets.length;
    }

    public int filter() {
        TokenizerRegistryItem[] member = Tokenizer.getAllMembers();
        if (member == null) {
            return 0;
        }
        Vector<String> v = new Vector<String>();
        for (int n = 0; n < member.length; ++n) {
            String[] ext = member[n].ext;
            if (ext == null) continue;
            for (int i = 0; i < ext.length; ++i) {
                v.addElement(ext[i]);
            }
        }
        String[] ext = VectorUtils.toStringArray(v);
        if (ext == null) {
            return 0;
        }
        v.clear();
        for (int n = 0; n < this.targets.length; ++n) {
            String ex = FileUtils.getExtension(this.targets[n]);
            if (ex == null || ex.length() < 2) continue;
            ex = ex.substring(1);
            for (int i = 0; i < ext.length; ++i) {
                if (!ex.equals(ext[i])) continue;
                v.addElement(this.targets[n]);
            }
        }
        this.targets = VectorUtils.toStringArray(v);
        return this.targets.length;
    }

    public boolean catalogAll() {
        if (this.targets == null || this.targets.length == 0) {
            return false;
        }
        File file = new File(FileUtils.getPWD(), "test.html");
        try {
            HtmlWriter.createHostDir(file);
            HtmlWriter writer = new HtmlWriter(file, null);
            writer.writeHeader(null);
            writer.writePageTitle();
            StringBuffer sb = writer.getOutputBuffer();
            for (int n = 0; n < this.targets.length; ++n) {
                String cmnt;
                ScriptParser parser;
                ScriptStructure struct;
                String ext;
                File f = new File(this.targets[n]);
                String text = FileUtils.read(f);
                if (text == null || text.length() == 0 || (ext = FileUtils.getExtension(f)) == null || ext.trim().length() < 2) continue;
                ext = ext.substring(1);
                TokenizerRegistryItem member = Tokenizer.getMemberWithExt(ext);
                Tokenizer tok = member.getTokenizer();
                if (member == null || tok == null || (struct = (parser = new ScriptParser(tok, text)).getStructure()) == null) continue;
                String[] comment = struct.getComments();
                CatalogItem item = new CatalogItem();
                item.name = f.getName();
                item.hostDirPath = f.getParent();
                item.modified = DateTimeUtils.getDateTime(f.lastModified());
                item.notation = comment == null || comment.length == 0 ? defaultDescription : ((cmnt = this.trimComment(comment[0])) == null || cmnt.length() == 0 ? defaultDescription : cmnt);
                item.toHtml(sb);
            }
            writer.writeTail();
            writer.writeSelf();
        }
        catch (IOException e) {
            Cutter.setLog("ScriptCataloger.catalogAll():\n" + e.toString());
            return false;
        }
        BrowserUtils.open(file);
        return true;
    }

    private String trimComment(String src) {
        String[] lines = TextUtils.tokenize(src, "\n");
        StringBuffer buff = new StringBuffer();
        for (int n = 0; n < lines.length && n < 10; ++n) {
            lines[n] = TextUtils.trim(lines[n], "*-!?=_/|");
            lines[n] = TextUtils.reverse(lines[n]);
            lines[n] = TextUtils.trim(lines[n], "*-!?=_/|");
            buff.append(TextUtils.reverse(lines[n])).append("\n");
        }
        return buff.toString().trim();
    }

    static {
        try {
            Field[] fields = new Field[]{ScriptCataloger.class.getDeclaredField("_isOpenComment"), ScriptCataloger.class.getDeclaredField("_isCloseComment")};
            Cutter.addDebug(ScriptCataloger.class, fields);
        }
        catch (NoSuchFieldException ex) {
            Cutter.setLog("Error: ScriptCataloger.static - " + ex.toString());
        }
    }
}

