/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.AssetManagement.CatalogScriptsTool;

import Preferences.Preferences;
import UI_Components.GBC;
import UI_Components.KTitledPanel;
import UI_Components.PrefsReadWriters.PrefTextField;
import UI_Desktop.Cutter;
import UI_Tools.AssetManagement.CatalogScriptsTool.ScriptCataloger;
import UI_Tools.KTools;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class ScriptCatalogerUI
extends KTools
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private DirPanel srcDirPanel = new DirPanel("Source Directory", "Path", Preferences.TOOL_SCRIPT_CATALOGER_SRC_DIR_PATH, Preferences.TOOL_SCRIPT_CATALOGER_RECURSE);
    private DirPanel dstDirPanel = new DirPanel("Catalog Directory", "Path", Preferences.TOOL_SCRIPT_CATALOGER_DST_DIR_PATH, -1);
    private KTitledPanel summaryPanel = new KTitledPanel(" Summary ");
    private JButton makeButton = new JButton("Make Catelog");
    private JCheckBox autoIE = new JCheckBox("Open in IE");
    private GBC gbc;
    private JTextField rawField = new JTextField(5);
    private JTextField netField = new JTextField(5);
    protected static ScriptCatalogerUI tool = null;

    public static ScriptCatalogerUI init(JMenuItem menuItem) {
        if (tool != null) {
            return tool;
        }
        tool = new ScriptCatalogerUI(menuItem);
        return tool;
    }

    private ScriptCatalogerUI(JMenuItem menuItem) {
        super("Script Cataloger Tool", menuItem, Preferences.TOOL_SCRIPT_CATALOGER);
        JLabel rawLabel = new JLabel("    Total");
        JLabel netLabel = new JLabel("Cataloged");
        JLabel filesLabel1 = new JLabel("files");
        JLabel filesLabel2 = new JLabel("files");
        this.summaryPanel.add(rawLabel, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, 0, 12, 2, new Insets(5, 5, 3, 5)));
        this.summaryPanel.add(this.rawField, new GBC(1, 0, 1, 1, 0.0, 0.0, 0, 0, 12, 2, new Insets(5, 5, 3, 5)));
        this.summaryPanel.add(filesLabel1, new GBC(2, 0, 1, 1, 0.0, 0.0, 0, 0, 12, 2, new Insets(5, 5, 3, 5)));
        this.summaryPanel.add(new JPanel(), new GBC(3, 0, 1, 1, 1.0, 0.0, 0, 0, 12, 2, new Insets(5, 5, 3, 5)));
        this.summaryPanel.add(netLabel, new GBC(0, 1, 1, 1, 0.0, 0.0, 0, 0, 12, 2, new Insets(5, 5, 3, 5)));
        this.summaryPanel.add(this.netField, new GBC(1, 1, 1, 1, 0.0, 0.0, 0, 0, 12, 2, new Insets(5, 5, 3, 5)));
        this.summaryPanel.add(filesLabel2, new GBC(2, 1, 1, 1, 0.0, 0.0, 0, 0, 12, 2, new Insets(5, 5, 3, 5)));
        this.summaryPanel.add(new JPanel(), new GBC(3, 1, 1, 1, 1.0, 1.0, 0, 0, 12, 2, new Insets(5, 5, 3, 5)));
        this.contentPane.add((Component)this.srcDirPanel, new GBC(0, 0, 4, 1, 1.0, 0.0, 0, 0, 12, 2, new Insets(5, 5, 3, 5)));
        this.contentPane.add((Component)this.dstDirPanel, new GBC(0, 1, 4, 1, 1.0, 0.0, 0, 0, 12, 2, new Insets(3, 5, 5, 5)));
        this.contentPane.add((Component)this.summaryPanel, new GBC(0, 2, 4, 1, 1.0, 0.0, 0, 0, 12, 2, new Insets(3, 5, 5, 5)));
        this.contentPane.add((Component)this.autoIE, new GBC(0, 3, 4, 1, 1.0, 1.0, 0, 0, 17, 0, new Insets(8, 2, 10, 7)));
        this.makeButton.addActionListener(this);
        this.contentPane.add((Component)this.makeButton, new GBC(1, 3, 1, 1, 1.0, 1.0, 0, 0, 13, 0, new Insets(5, 2, 10, 7)));
        this.setTitle(this.title);
        this.pack();
        this.setInitialPosition();
        this.setVisible(false);
    }

    @Override
    protected void toolSelectionHappened() {
    }

    @Override
    protected void toolDeSelectionHappened(JTextComponent compLostFocus) {
    }

    @Override
    protected void adjustUI(String docExt) {
    }

    @Override
    protected void adjustUI(int tabIndex) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String path = this.srcDirPanel.dirField.getTextFromField();
        if (path == null || path.trim().length() == 0) {
            Cutter.setLog("ScriptCataloger.actionPerformed() - no path in the input text field!");
            return;
        }
        File srcDir = new File(path);
        if (!srcDir.exists()) {
            Cutter.setLog("ScriptCataloger.actionPerformed() - srcDir path does not exist!");
            return;
        }
        ScriptCataloger cat = new ScriptCataloger(srcDir);
        int rawcount = cat.source();
        this.rawField.setText("" + rawcount);
        int netcount = cat.filter();
        this.netField.setText("" + netcount);
        cat.catalogAll();
    }

    @Override
    protected void saveSelf() {
        super.saveSelf();
        this.srcDirPanel.saveSelf();
        this.dstDirPanel.saveSelf();
    }

    @Override
    public JMenu getMenuWithName(String name) {
        return null;
    }

    private class DirPanel
    extends KTitledPanel {
        private static final long serialVersionUID = 1L;
        private int[] prefID;
        private String[] proxy;
        public PrefTextField dirField;
        private JRadioButton recurse;
        private int dirPathPrefID;
        private int prefsRecurseID;

        private DirPanel(String panelTitle, String dirFieldLabel, int dirPathPrefID, int prefsRecurseID) {
            super(" " + panelTitle + " ");
            this.prefID = new int[1];
            this.proxy = new String[]{"ignore"};
            this.recurse = new JRadioButton("recursive");
            this.dirPathPrefID = dirPathPrefID;
            this.prefsRecurseID = prefsRecurseID;
            this.prefID[0] = dirPathPrefID;
            this.dirField = new PrefTextField(dirFieldLabel, this.proxy, this.prefID, 12, 1, true);
            JPanel holder = new JPanel();
            this.dirField.addToParent(holder, 1, true);
            if (prefsRecurseID == -1) {
                this.add(holder, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(0, 5, 0, 5)));
            } else {
                this.add(holder, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(0, 5, 0, 5)));
                this.add(this.recurse, new GBC(0, 1, 1, 1, 1.0, 1.0, 0, 0, 12, 0, new Insets(0, 5, 0, 5)));
                String flag = Preferences.get(prefsRecurseID);
                if (flag != null && flag.equals("true")) {
                    this.recurse.setSelected(true);
                } else {
                    this.recurse.setSelected(false);
                }
            }
        }

        @Override
        public void setEnabled(boolean flag) {
            super.setEnabled(flag);
            this.dirField.setEnabled(flag);
            this.recurse.setEnabled(flag);
        }

        private String getTextFromField() {
            return this.dirField.getTextFromField();
        }

        private boolean doRecursiveSearch() {
            return this.recurse.isSelected();
        }

        private void saveSelf() {
            if (this.prefsRecurseID != -1) {
                if (this.recurse.isSelected()) {
                    Preferences.write(this.prefsRecurseID, "true");
                } else {
                    Preferences.write(this.prefsRecurseID, "false");
                }
            }
            this.dirField.writeToPrefs();
        }
    }
}

