/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.AssetManagement;

import UI_Desktop.Cutter;
import Utilities.EnvUtils;
import Utilities.FileUtils;
import Utilities.TextUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class HtmlWriter
extends FileWriter {
    protected StringBuffer buff = new StringBuffer();
    protected String hostDirName = "untitled";
    protected String looseHostDirName = "";
    protected String tightHostDirName = "";
    protected File hostDir = null;
    protected File srcImagesDir = null;
    protected File hostImagesDir = null;

    static String toLoose(String inStr) {
        StringBuffer temp = new StringBuffer();
        for (int n = 0; n < inStr.length(); ++n) {
            if (inStr.charAt(n) == ' ') {
                temp.append(" &nbsp;&nbsp; ");
                continue;
            }
            temp.append(inStr.charAt(n)).append(' ');
        }
        return temp.toString();
    }

    public static void createHostDir(File indexFile) {
        File _hostDir = indexFile.getParentFile();
        if (!_hostDir.exists()) {
            _hostDir.mkdir();
        }
    }

    public HtmlWriter(File indexFile, File srcImgsDir) throws IOException {
        super(indexFile);
        this.hostDir = indexFile.getParentFile();
        this.hostDirName = this.hostDir.getName();
        if (srcImgsDir != null) {
            this.srcImagesDir = srcImgsDir;
            this.hostImagesDir = new File(this.hostDir, "images");
            if (!this.hostImagesDir.exists()) {
                this.hostImagesDir.mkdir();
            }
        }
        if (this.hostDirName.startsWith("previs_")) {
            this.hostDirName = this.hostDirName.substring(7);
        }
        this.tightHostDirName = this.hostDirName;
        this.looseHostDirName = HtmlWriter.toLoose(this.tightHostDirName);
        if (srcImgsDir != null) {
            this.copyImagesToHostDir();
        }
    }

    private void copyImagesToHostDir() {
        String[] names = FileUtils.getListOfFileNames(this.srcImagesDir, ".png");
        for (int n = 0; n < names.length; ++n) {
            byte[] bytes = FileUtils.readAsBinary(new File(this.srcImagesDir, names[n]).getPath());
            if (bytes != null) {
                FileUtils.writeAsBinary(new File(this.hostImagesDir, names[n]), bytes);
                continue;
            }
            Cutter.setLog("    Error:HtmlWriter.copyImagesToHostDir() - failed to write to: \"" + new File(this.hostImagesDir, names[n]).getPath() + "\"");
        }
    }

    public StringBuffer getOutputBuffer() {
        return this.buff;
    }

    public void writeHeader() {
        this.writeHeader(null);
    }

    public void writeHeader(String pagetitle) {
        this.buff.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\n");
        this.buff.append("\t\t\t\"http://www.w3.org/TR/REC-html40/loose.dtd\">\n");
        this.buff.append("<!-- Auto page generation by Cutter. Software written by Malcolm Kesson -->\n");
        this.buff.append("<HTML>\n");
        this.buff.append("<HEAD>\n");
        if (pagetitle == null) {
            this.buff.append("<TITLE>Command Index</TITLE>\n");
        } else {
            this.buff.append("<TITLE>" + pagetitle + "</TITLE>\n");
        }
        this.buff.append("<STYLE type=\"text/css\"><!--\n");
        this.buff.append("A:link    { text-decoration: none;\n");
        this.buff.append("\t\t     color: #3D271A;\n");
        this.buff.append("\t\t   }\n");
        this.buff.append("A:visited { text-decoration: none;\n");
        this.buff.append("\t\t\t color: #3D271A;\n");
        this.buff.append("\t\t   }\n");
        this.buff.append("H3 {\tfont-family: Helvetica, sans-serif;\n");
        this.buff.append("\t\tfont-size: 12pt;\n");
        this.buff.append("\t\tline-height: 14pt;\n");
        this.buff.append("\t\tfont-weight: bold;\n");
        this.buff.append("\t\tmargin-left: 0pt;\n");
        this.buff.append("\t\tmargin-bottom: 0pt;\n");
        this.buff.append("\t}\n");
        this.buff.append("P {\tfont-family: Helvetica, sans-serif;\n");
        this.buff.append("\tfont-size: 11pt;\n");
        this.buff.append("   \tline-height: 15pt;\n");
        this.buff.append("   \tmargin-right: 0pt;\n");
        this.buff.append("\tmargin-left: 0pt;\n");
        this.buff.append("\tmargin-top: 0pt;\n");
        this.buff.append("\tmargin-bottom: 0pt;\n");
        this.buff.append("   \t}\n");
        this.buff.append(".p12 {\tfont-size: 12pt;\n");
        this.buff.append("   \t}\n");
        this.buff.append(".p10 {\n");
        this.buff.append("\tfont-size: 10pt;\n");
        this.buff.append("\tline-height: 13pt;\n");
        this.buff.append("   \t}\n");
        this.buff.append(".p9 {\tfont-size: 9pt;\n");
        this.buff.append("   \t}\n");
        this.buff.append(".gray66 { color: #666666; }\n");
        this.buff.append(".white { color: #ffffff; }\n");
        this.buff.append(".gold { color: #3D271A; }\n");
        this.buff.append(".yellow { color: #ffff88; }\n");
        this.buff.append(".darkgreen\t{ color: #253C4A; }\n");
        this.buff.append(".css { display: none }\n");
        this.buff.append("-->\n");
        this.buff.append("</STYLE>\n");
        this.buff.append("</HEAD>\n");
        this.buff.append("<BODY BGCOLOR=\"#ffffff\">\n");
    }

    public void writePageTitle() {
        this.buff.append("<TABLE BORDER=\"0\" CELLSPACING=\"0\">\n");
        this.buff.append("\t<TR>\n");
        this.buff.append("\t\t<TD WIDTH=\"20\" NOWRAP><!-- left hand margin --></TD>\n");
        this.buff.append("\t\t<TD ALIGN=\"LEFT\" NOWRAP COLSPAN=\"2\">\n");
        if (this.hostDirName == null) {
            this.buff.append("\t\t\t<H3 CLASS=\"gold\">" + this.looseHostDirName + "<BR>\n");
        } else {
            this.buff.append("\t\t\t<H3 CLASS=\"gold\">" + HtmlWriter.toLoose(this.hostDirName) + "<BR>\n");
        }
        this.buff.append("\t\t\t</H3>\n");
        this.buff.append("\t\t</TD>\n");
        this.buff.append("\t</TR>\n");
        this.buff.append("</TABLE>\n");
        this.buff.append("<BR>\n");
    }

    public void writeTable(String text, int width) {
        if (text == null) {
            return;
        }
        this.buff.append("<TABLE BORDER=\"0\" CELLSPACING=0 NOWRAP>\n");
        this.buff.append("\t<TR>\n");
        this.buff.append("\t\t<TD WIDTH=\"20\" NOWRAP><!-- left hand margin --></TD>\n");
        if (width <= 0) {
            this.buff.append("\t\t<TD VALIGN=\"TOP\" ALIGN=\"LEFT\" NOWRAP>\n");
        } else {
            this.buff.append("\t\t<TD WIDTH=" + width + " VALIGN=\"TOP\" ALIGN=\"LEFT\" NOWRAP>\n");
        }
        this.buff.append(text);
        this.buff.append("\n");
        this.buff.append("\t\t</TD\n");
        this.buff.append("\t</TR>\n");
        this.buff.append("</TABLE>\n");
    }

    public void writeTail() {
        this.buff.append("</BODY>\n");
        this.buff.append("</HTML>\n");
    }

    protected void writeTable(String title, int width, int columns, String basePath, String[] names) throws IOException {
        if (title == null || names == null || names.length == 0) {
            return;
        }
        if (EnvUtils.isWinEnvironment()) {
            basePath = TextUtils.trimLeadingChars(basePath, "//");
        }
        this.buff.append("<TABLE BORDER=\"0\" CELLSPACING=0>\n");
        this.buff.append("\t<TR>\n");
        this.buff.append("\t\t<TD WIDTH=\"20\" NOWRAP><!-- left hand margin --></TD>\n");
        if (!title.equals("")) {
            this.buff.append("\t\t<TD WIDTH=" + width + " COLSPAN=\"" + columns + "\" VALIGN=\"TOP\" ALIGN=\"CENTER\" NOWRAP bgcolor=\"#6e6d6d\"><SPAN CLASS=\"white\"><P><B>" + title + "</B></P></SPAN></TD>\n");
        }
        this.buff.append("\t</TR>\n");
        this.buff.append("\t<TR>\n");
        TD td0 = new TD(2, "left", "top", 20, "");
        td0.addItem("<!-- left hand margin -->");
        this.buff.append(td0.toString());
        TD[] td = new TD[columns];
        for (int n = 0; n < columns; ++n) {
            td[n] = new TD(2, "left", "top", width / columns, "");
        }
        int i = 0;
        int n = 0;
        while (i < names.length) {
            if (!names[i].equalsIgnoreCase(title + ".html")) {
                if (n == columns) {
                    n = 0;
                }
                if (basePath.equals("") && title.equals("")) {
                    td[n].addItem("<A HREF=\"" + names[i] + "\">" + TextUtils.removeExtension(names[i]) + "</A><BR>");
                } else if (basePath.equals("")) {
                    td[n].addItem("<A HREF=\"" + title + "/" + names[i] + "\">" + TextUtils.removeExtension(names[i]) + "</A><BR>");
                } else if (title.equals("")) {
                    td[n].addItem("<A HREF=\"" + basePath + "/" + names[i] + "\">" + TextUtils.removeExtension(names[i]) + "</A><BR>");
                } else {
                    td[n].addItem("<A HREF=\"" + basePath + "/" + title + "/" + names[i] + "\">" + TextUtils.removeExtension(names[i]) + "</A><BR>");
                }
                ++i;
                ++n;
                continue;
            }
            ++i;
        }
        for (n = 0; n < columns; ++n) {
            this.buff.append(td[n].toString()).append("\n");
        }
        this.buff.append("\t</TR>\n");
        this.buff.append("</TABLE>\n");
        this.buff.append("<BR>\n");
    }

    protected void writeTable(String title, int width, int columns, String urlPrefix, File[] files) throws IOException {
        if (title == null || files == null || files.length == 0) {
            return;
        }
        this.buff.append("<TABLE BORDER=\"0\" CELLSPACING=0>\n");
        this.buff.append("\t<TR>\n");
        this.buff.append("\t\t<TD WIDTH=\"20\" NOWRAP><!-- left hand margin --></TD>\n");
        if (!title.equals("")) {
            this.buff.append("\t\t<TD WIDTH=" + width + " COLSPAN=\"" + columns + "\" VALIGN=\"TOP\" ALIGN=\"CENTER\" NOWRAP bgcolor=\"#6e6d6d\"><SPAN CLASS=\"white\"><P><B>" + title + "</B></P></SPAN></TD>\n");
        }
        this.buff.append("\t</TR>\n");
        this.buff.append("\t<TR>\n");
        TD td0 = new TD(2, "left", "top", 20, "");
        td0.addItem("<!-- left hand margin -->");
        this.buff.append(td0.toString());
        TD[] td = new TD[columns];
        for (int n = 0; n < columns; ++n) {
            td[n] = new TD(2, "left", "top", width / columns, "");
        }
        int i = 0;
        int n = 0;
        while (i < files.length) {
            String name = TextUtils.removeExtension(files[i].getName());
            if (name.equalsIgnoreCase(title)) {
                ++i;
                continue;
            }
            if (n == columns) {
                n = 0;
            }
            if (EnvUtils.isWinEnvironment()) {
                td[n].addItem("<A HREF=\"" + files[i].getPath() + "\">" + name + "</A><BR>");
            } else {
                td[n].addItem("<A HREF=\"" + urlPrefix + "//" + files[i].getPath() + "\">" + name + "</A><BR>");
            }
            ++i;
            ++n;
        }
        for (n = 0; n < columns; ++n) {
            this.buff.append(td[n].toString()).append("\n");
        }
        this.buff.append("\t</TR>\n");
        this.buff.append("</TABLE>\n");
        this.buff.append("<BR>\n");
    }

    public void writeTableOfIcons(String iconDirName, String imgDirName, String[] iconNames) throws IOException {
        this.buff.append("<TABLE BORDER=\"0\" CELLSPACING=0>\n");
        this.buff.append("\t<TR>\n");
        this.buff.append("\t\t<TD WIDTH=\"20\" NOWRAP><!-- left hand margin --></TD>\n");
        this.buff.append("\t\t<TD VALIGN=\"TOP\" ALIGN=\"LEFT\" NOWRAP>\n");
        for (int n = 0; n < iconNames.length; ++n) {
            String iconURL = iconDirName + '/' + iconNames[n];
            String imageURL = imgDirName + '/' + iconNames[n];
            this.buff.append("\t\t<A HREF=\"").append(imageURL).append("\">");
            this.buff.append("<IMG SRC=\"").append(iconURL).append("\" ALT\"\"></A>&nbsp;\n");
            if (n <= 0 || (n + 1) % 6 != 0) continue;
            this.buff.append("\t\t<BR>\n");
        }
        this.buff.append("\t\t</TD>\n");
        this.buff.append("\t</TR>\n");
        this.buff.append("</TABLE>\n");
    }

    public void writeSelf() throws IOException {
        this.write(this.buff.toString());
        this.flush();
        this.close();
    }

    protected String removeExtension(String input) {
        int index = input.lastIndexOf(".");
        if (index != -1) {
            return input.substring(0, input.lastIndexOf("."));
        }
        return input;
    }

    protected class TD {
        private StringBuffer b = new StringBuffer();
        private String tabStr = "";

        public TD(int tabs, String align, String valign, int width, String extaHtml) {
            for (int n = 0; n < tabs; ++n) {
                this.tabStr = this.tabStr + "\t";
            }
            this.b.append(this.tabStr);
            this.b.append("<TD WIDTH=\"" + width + "\" ALIGN=\"" + align + "\" VALIGN=\"" + valign + "\" " + extaHtml + " NOWRAP>");
            this.b.append("\n");
            this.b.append(this.tabStr + "\t");
            this.b.append("<P>\n");
        }

        public void addItem(String item) {
            this.b.append(this.tabStr);
            this.b.append("\t").append(item).append("\n");
        }

        public String toString() {
            this.b.append(this.tabStr + "\t");
            this.b.append("</P>\n");
            this.b.append(this.tabStr);
            this.b.append("</TD>").append("\n");
            return this.b.toString();
        }
    }
}

