/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.AssetManagement;

import UI_Desktop.Cutter;
import UI_Tools.AssetManagement.HtmlWriter;
import Utilities.EnvUtils;
import Utilities.FileUtils;
import Utilities.VectorUtils;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JFileChooser;

public class HtmlWriterIndex
extends HtmlWriter {
    private static JFileChooser chooser = new JFileChooser();
    private static File prevFile = FileUtils.getPWDFile();
    static final int MIN_DOCS_FOR_TABULAR_LAYOUT = 20;

    public static void chooseDirectory() {
        chooser.setFileHidingEnabled(true);
        chooser.setFileSelectionMode(2);
        chooser.setApproveButtonText("Choose Directory");
        chooser.rescanCurrentDirectory();
        if (prevFile == null) {
            prevFile = FileUtils.getPWDFile();
        }
        chooser.setCurrentDirectory(prevFile);
        int response = chooser.showOpenDialog(Cutter.desktop);
        if (response == 1) {
            return;
        }
        File d = chooser.getSelectedFile();
        if (d == null) {
            return;
        }
        prevFile = d;
        try {
            File indexF = new File(FileUtils.getPWD(), "indextext.html");
            HtmlWriterIndex.createHostDir(indexF);
            HtmlWriterIndex indexer = new HtmlWriterIndex(indexF);
            String[] urls = indexer.makePage();
            Cutter.setLog(urls);
        }
        catch (IOException e) {
            Cutter.setLog("    Exception: HtmlWriterIndex.makePage()  >" + e.toString() + "<");
            return;
        }
    }

    public HtmlWriterIndex(File file) throws IOException {
        super(file, (File)null);
    }

    public String[] makePage() throws IOException {
        String[] subdirs = FileUtils.getListOfDirNames(this.hostDir);
        String[] arrayOfWebDocPaths = FileUtils.getListOfWebDocs(this.hostDir);
        String[] arrayOfDirectoryPaths = null;
        if (subdirs != null) {
            for (int n = 0; n < subdirs.length; ++n) {
                File sub = new File(this.hostDir, subdirs[n]);
                if (sub.getName() == null) continue;
                String name = sub.getName().trim();
                if (name.length() == 1 && (name.charAt(0) >= 'A' && name.charAt(0) <= 'Z' || name.charAt(0) >= 'a' && name.charAt(0) <= 'z')) {
                    String[] temp = FileUtils.getListOfWebDocs(sub);
                    arrayOfWebDocPaths = VectorUtils.toStringArray(arrayOfWebDocPaths, temp);
                    continue;
                }
                arrayOfDirectoryPaths = VectorUtils.toStringArray(arrayOfDirectoryPaths, sub.getPath());
            }
        }
        if (arrayOfDirectoryPaths != null && arrayOfDirectoryPaths.length > 0) {
            arrayOfDirectoryPaths = FileUtils.sortPathsByFileName(arrayOfDirectoryPaths);
            for (int n = 0; n < arrayOfDirectoryPaths.length; ++n) {
                File f = new File(arrayOfDirectoryPaths[n]);
                String[] docs = FileUtils.getListOfWebDocs(f);
                File[] files = FileUtils.toFileArray(docs);
                if (EnvUtils.isWinEnvironment()) {
                    this.writeTable(f.getName(), 500, 4, "", files);
                    continue;
                }
                this.writeTable(f.getName(), 500, 4, "file:", files);
            }
        }
        arrayOfWebDocPaths = FileUtils.sortPathsByFileName(arrayOfWebDocPaths);
        File[] files = FileUtils.toFileArray(arrayOfWebDocPaths);
        boolean isAlphabetasized = false;
        if (arrayOfWebDocPaths != null && arrayOfWebDocPaths.length > 20) {
            isAlphabetasized = true;
            int j = 0;
            char upper = 'A';
            char lower = 'a';
            while (upper <= 'Z') {
                Vector<File> v = new Vector<File>();
                while (j < files.length && (files[j].getName().charAt(0) == upper || files[j].getName().charAt(0) == lower)) {
                    v.addElement(files[j]);
                    ++j;
                }
                if (v.size() > 0) {
                    File[] f = FileUtils.toFileArray(v);
                    if (EnvUtils.isWinEnvironment()) {
                        this.writeTable(new String("" + upper), 500, 4, "", f);
                    } else {
                        this.writeTable(new String("" + upper), 500, 4, "file:", f);
                    }
                }
                upper = (char)(upper + 1);
                lower = (char)(lower + 1);
            }
        } else if (EnvUtils.isWinEnvironment()) {
            this.writeTable(this.hostDir.getName(), 500, 4, "", files);
        } else {
            this.writeTable(this.hostDir.getName(), 500, 4, "file:", files);
        }
        this.writeTail();
        this.writeSelf();
        return arrayOfWebDocPaths;
    }
}

