/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.CCompile;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Components.GBC;
import UI_Components.KTextField.KTextField;
import UI_Components.KTitledPanel;
import UI_Script.ProjectManagement.ProjectManager;
import UI_Tools.CCompile.KFilePathsPanel;
import UI_Tools.KTools;
import Utilities.VectorUtils;
import java.awt.Component;
import java.awt.Insets;
import java.io.File;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;

public class CCompileTool
extends KTools {
    private static char BACKSLASH = (char)92;
    protected static CCompileTool tool = null;
    private static final String TOOL_DESCRIPTION = "Use this tool to modify the compilation\nof C and CPP files. Save the settings in\nin your current C/CPP project directory";
    private ProjectPanel projectPanel = new ProjectPanel(" Project Directory ");
    private KFilePathsPanel includesPanel = new KFilePathsPanel(" Includes ");
    private KFilePathsPanel libraryPanel = new KFilePathsPanel(" Libraries ");
    private JTextArea label = new JTextArea("Use this tool to modify the compilation\nof C and CPP files. Save the settings in\nin your current C/CPP project directory");
    private boolean isDirty = false;

    public static CCompileTool init(JMenuItem menuItem) {
        if (tool != null) {
            return tool;
        }
        tool = new CCompileTool(menuItem);
        return tool;
    }

    protected CCompileTool(JMenuItem menuItem) {
        super("CC Options Tool", menuItem, Preferences.TOOL_CCOMPILER);
        this.label.setOpaque(false);
        this.label.setEditable(false);
        this.contentPane.add((Component)this.projectPanel, new GBC(0, 0, 2, 1, 1.0, 0.0, 0, 0, 18, 2, new Insets(5, 5, 2, 5)));
        this.contentPane.add((Component)this.includesPanel, new GBC(0, 1, 2, 1, 1.0, 0.0, 0, 0, 18, 1, new Insets(5, 5, 2, 5)));
        this.contentPane.add((Component)this.libraryPanel, new GBC(0, 2, 2, 1, 1.0, 1.0, 0, 0, 18, 1, new Insets(5, 5, 2, 5)));
        this.includesPanel.setFileSelectionMode(1);
        this.includesPanel.setApproveButtonText("Select Folder");
        this.libraryPanel.setFileSelectionMode(2);
        this.libraryPanel.setApproveButtonText("Select Library");
        this.setTitle(this.title);
        this.pack();
        this.setVisible(false);
        this.setInitialPosition();
        this.lastFocusedComponent = this.projectPanel.projDir;
        this.projectPanel.adjustUI();
    }

    private void updatePanelPaths() {
        File projdir = this.getProjectDirectory();
        if (projdir == null || !projdir.exists()) {
            return;
        }
        String[] includes = ProjectManager.getProjectCompilerOptions(projdir, "IncludesBegin", "IncludesEnd");
        String[] libs = ProjectManager.getProjectCompilerOptions(projdir, "LibrariesBegin", "LibrariesEnd");
        if (includes != null) {
            this.includesPanel.addPaths(includes);
        }
        if (libs != null) {
            this.libraryPanel.addPaths(libs);
        }
    }

    private File getProjectDirectory() {
        String dir = this.projectPanel.projDir.getText();
        if (dir == null || dir.trim().length() == 0) {
            return null;
        }
        File f = new File(dir);
        return f;
    }

    @Override
    public void saveSelf() {
        File dir = this.getProjectDirectory();
        if (dir == null) {
            return;
        }
        String[] includes = this.includesPanel.getPaths();
        Vector<String> v = new Vector<String>();
        if (includes != null) {
            for (int n = 0; n < includes.length; ++n) {
                String path = includes[n];
                if (!new File(path).exists()) continue;
                v.add(path);
            }
        }
        includes = VectorUtils.toStringArray(v);
        v.clear();
        String[] libs = this.libraryPanel.getPaths();
        if (libs != null) {
            for (int n = 0; n < libs.length; ++n) {
                String path = libs[n];
                if (!new File(path).exists()) continue;
                v.add(path);
            }
        }
        if ((libs = VectorUtils.toStringArray(v)) != null && libs.length > 0 || includes != null && includes.length > 0) {
            ProjectManager.saveCompilerOptions(dir, includes, libs);
        } else {
            ProjectManager.deleteCompilerOptionsFile(dir);
        }
        this.isDirty = false;
        super.saveSelf();
    }

    @Override
    public void showSelf() {
        super.showSelf();
    }

    @Override
    protected void toolSelectionHappened() {
        if (this.lastFocusedComponent != null) {
            this.lastFocusedComponent.requestFocus();
            this.lastFocusedComponent.selectAll();
        }
    }

    @Override
    protected void toolDeSelectionHappened(JTextComponent compLostFocus) {
        this.lastFocusedComponent = compLostFocus;
    }

    @Override
    protected void adjustUI(String docname) {
        this.projectPanel.adjustUI();
        this.updatePanelPaths();
    }

    @Override
    protected void adjustUI(int tabIndex) {
    }

    @Override
    public JMenu getMenuWithName(String name) {
        return null;
    }

    private class ProjectPanel
    extends KTitledPanel {
        KTextField projDir;

        public ProjectPanel(String title) {
            super(title);
            this.projDir = new KTextField("", 18);
            this.add(this.projDir, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(2, 4, 2, 2)));
            this.projDir.usesModelDialog = true;
        }

        public void adjustUI() {
            File f = BBxt.getWindowFile();
            CCompileTool.this.saveSelf();
            if (f != null) {
                this.projDir.setText(f.getParent());
            } else {
                this.projDir.setText("");
                CCompileTool.this.includesPanel.clearAllPaths();
                CCompileTool.this.libraryPanel.clearAllPaths();
            }
        }
    }
}

